topic "Informative Dialogs";
[2 $$0,0#00000000000000000000000000000000:Default]
[i448;a25;kKO9;2 $$1,0#37138531426314131252341829483380:class]
[l288;2 $$2,2#27521748481378242620020725143825:desc]
[0 $$3,0#96390100711032703541132217272105:end]
[H6;0 $$4,0#05600065144404261032431302351956:begin]
[i448;a25;kKO9;2 $$5,0#37138531426314131252341829483370:item]
[l288;a4;*@5;1 $$6,6#70004532496200323422659154056402:requirement]
[l288;i1121;b17;O9;~~~.1408;2 $$7,0#10431211400427159095818037425705:param]
[i448;b42;O9;2 $$8,8#61672508125594000341940100500538:tparam]
[b42;ph2 $$9,9#13035079074754324216151401829390:normal]
[b42;a42;ph2 $$10,10#E71D914572A169C91BE52E3FB27F810F:text]
[{_}%EN-US 
[ {{10000@(113.42.0) [s0; [*@7;4 Informative Dialogs]]}}&]
[s10; Sometimes programmer needs to display simply informative dialog 
with certain options like: OK, Cancel, Yes, No, Retry etc.. In 
U`+`+ the common way to do that is to use special functions provided 
by CtrlLib.&]
[s10; We distinguish three main families of informative functions:&]
[s10;l160;i150;O0; [* Prompt ]`- should be used to display common informations.&]
[s10;l160;i150;O0; [* Exclamation ](Warning) `- should be used to report 
not critical issue, but not everything is all right.&]
[s10;l160;i150;O0; [* Error] `- should be used to notify about critical 
error in the application.&]
[s10;l160;i150;O0; [* Custom] `- if everything above is not appropriate 
for your needs, you can compose your own dialog using build in 
functions. This functions is used to create all dialogs mentions 
in this reference.&]
[s10; The message to informative dialog is passed by QTF format. It 
means that you can for example embed hyper`-link. But, on the 
other hand it can leads to troubles in displaying text. For example 
we have symbols that are special for QTF `- this situation can 
happened while displaying directory path. In this case we need 
to deqtf our text.using [*^topic`:`/`/RichText`/src`/Utilities`$en`-us`#Upp`:`:DeQtf`(const char`*`)^ D
eQtf][*  ]function from RichText package. Below is the code that 
presenting how to solve such issue:&]
[s10;l160; [/@(28.42.150) PromptOK(DeQtf(`"C:`\Program Files`\Upp`\theide`"));]&]
[s10;%- &]
[ {{10000F(128)G(128)@1 [s0; [* Prompt family]]}}&]
[s10;%- Displays informative dialogs.&]
[s10;%- &]
[s0;=%- 
@@rawimage:1435&735
(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)
&]
[s10;%- &]
[s10;%- Code used to generate above dialog (Please notice that we 
used DeQtf functino to display U`+`+ appropriate):&]
[s10;l160;%- [/@(28.42.150) PromptOK(DeQtf(`"U`+`+ is a powerfull framework.`"));]&]
[s10;%- &]
[s4;%- &]
[s5;:Upp`:`:PromptOK`(const char`*`):%- [@(0.0.255) void]_[* PromptOK]([@(0.0.255) const]_[@(0.0.255) c
har]_`*[*@3 qtf])&]
[s2;%- The simplest variant with OK button.&]
[s7; [%-*@3 qtf]-|Message to display in QTF format.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:PromptOKCancel`(const char`*`):%- [@(0.0.255) int]_[* PromptOKCancel]([@(0.0.255) c
onst]_[@(0.0.255) char]_`*[*@3 qtf])&]
[s2;%- Variant with OK and Cancel buttons.&]
[s7; [%-*@3 qtf]-|Message to display in QTF format.&]
[s7; [*/ Return value]-|1 for OK; 0 when Cancel button was clicked;&]
[s3; &]
[s4; &]
[s5;:Upp`:`:PromptYesNo`(const char`*`):%- [@(0.0.255) int]_[* PromptYesNo]([@(0.0.255) con
st]_[@(0.0.255) char]_`*[*@3 qtf])&]
[s2;%- Variant with Yes and No buttons.&]
[s7; [%-*@3 qtf]-|Message to display in QTF format.&]
[s7; [*/ Return value]-|1 for Yes; 0 when No button was clicked;&]
[s3; &]
[s4; &]
[s5;:Upp`:`:PromptYesNoCancel`(const char`*`):%- [@(0.0.255) int]_[* PromptYesNoCancel]([@(0.0.255) c
onst]_[@(0.0.255) char]_`*[*@3 qtf])&]
[s2;%- Variant with Yes, No and Cancel buttons.&]
[s7; [%-*@3 qtf]-|Message to display in QTF format.&]
[s7; [*/ Return value]-|1 for Yes; 0 when No button was clicked; 1 for 
Yes; `-1 for Cancel;&]
[s3; &]
[s4; &]
[s5;:Upp`:`:PromptRetryCancel`(const char`*`):%- [@(0.0.255) int]_[* PromptRetryCancel]([@(0.0.255) c
onst]_[@(0.0.255) char]_`*[*@3 qtf])&]
[s2;%- Variant with Retry and Cancel buttons.&]
[s7; [%-*@3 qtf]-|Message to display in QTF format.&]
[s7; [*/ Return value]-|1 for Retry; 0 when Cancel button was clicked;&]
[s3; &]
[s4; &]
[s5;:Upp`:`:PromptAbortRetry`(const char`*`):%- [@(0.0.255) int]_[* PromptAbortRetry]([@(0.0.255) c
onst]_[@(0.0.255) char]_`*[*@3 qtf])&]
[s2;%- Variant with Abort and Retry buttons.&]
[s7; [%-*@3 qtf]-|Message to display in QTF format.&]
[s7; [*/ Return value]-|1 for Abort; 0 when Retry button was clicked;&]
[s3; &]
[s4; &]
[s5;:Upp`:`:PromptAbortRetryIgnore`(const char`*`):%- [@(0.0.255) int]_[* PromptAbortRetr
yIgnore]([@(0.0.255) const]_[@(0.0.255) char]_`*[*@3 qtf])&]
[s2;%- Variant with Abort, Retry and Ignore buttons.&]
[s7; [%-*@3 qtf]-|Message to display in QTF format.&]
[s7; [*/ Return value]-|1 for Abort; 0 when Retry button was clicked; 
`-1 for Ignore;&]
[s3; &]
[s4; &]
[s5;:Upp`:`:PromptSaveDontSaveCancel`(const char`*`):%- [@(0.0.255) int]_[* PromptSaveDon
tSaveCancel]([@(0.0.255) const]_[@(0.0.255) char]_`*[*@3 qtf])&]
[s2;%- Variant with Save, Don`'t Save and Cancel buttons.&]
[s7; [%-*@3 qtf]-|Message to display in QTF format.&]
[s7; [*/ Return value]-|1 for Save; 0 when Don`'t Save button was clicked; 
`-1 for Cancel;&]
[s3;%- &]
[ {{10000F(128)G(128)@1 [s0; [* Exclamation family]]}}&]
[s10;%- Displays dialogs with warning.&]
[s10;%- &]
[s0;=%- 
@@rawimage:1638&630
(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)
&]
[s10;%- &]
[s10;%- Code used to generate above dialog:&]
[s10;l160;%- [/@(28.42.150) Exclamation(`"We found that you are not 
on our donators list.`");]&]
[s10;%- &]
[s4;%- &]
[s5;:Upp`:`:Exclamation`(const char`*`):%- [@(0.0.255) void]_[* Exclamation]([@(0.0.255) co
nst]_[@(0.0.255) char]_`*[*@3 qtf])&]
[s2;%- Simply variant with OK button.&]
[s7; [%-*@3 qtf]-|Message to display in QTF format.&]
[s3; &]
[ {{10000F(128)G(128)@1 [s0; [* Error family]]}}&]
[s10;%- Displays dialogs with error.&]
[s10;%- &]
[s0;=%- 
@@rawimage:1395&735
(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)
&]
[s10;%- &]
[s10;%- Code used to generate above dialog:&]
[s10;l160;%- [/@(28.42.150) ErrorOK(`"Connectino to host was lost.`");]&]
[s10;%- &]
[s4;%- &]
[s5;:Upp`:`:ErrorOK`(const char`*`):%- [@(0.0.255) void]_[* ErrorOK]([@(0.0.255) const]_[@(0.0.255) c
har]_`*[*@3 qtf])&]
[s2;%- The simpliest variant with OK button. Should be used to notify 
about errors that cannot be avoided at certain point of program 
execution.&]
[s7; [%-*@3 qtf]-|Message to display in QTF format.&]
[s3; &]
[s4; &]
[s5;:Upp`:`:ErrorOKCancel`(const char`*`):%- [@(0.0.255) int]_[* ErrorOKCancel]([@(0.0.255) c
onst]_[@(0.0.255) char]_`*[*@3 qtf])&]
[s2;%- Variant with OK and Cancel buttons.&]
[s7; [%-*@3 qtf]-|Message to display in QTF format.&]
[s7; [*/ Return value]-|1 for OK; 0 when Cancel button was clicked;&]
[s3; &]
[s4; &]
[s5;:Upp`:`:ErrorYesNo`(const char`*`):%- [@(0.0.255) int]_[* ErrorYesNo]([@(0.0.255) const
]_[@(0.0.255) char]_`*[*@3 qtf])&]
[s2;%- Variant with Yes and No buttons.&]
[s7; [%-*@3 qtf]-|Message to display in QTF format.&]
[s7; [*/ Return value]-|1 for Yes; 0 when No button was clicked;&]
[s3; &]
[s4; &]
[s5;:Upp`:`:ErrorYesNoCancel`(const char`*`):%- [@(0.0.255) int]_[* ErrorYesNoCancel]([@(0.0.255) c
onst]_[@(0.0.255) char]_`*[*@3 qtf])&]
[s2;%- Variant with Yes, No and Cancel buttons.&]
[s7; [%-*@3 qtf]-|Message to display in QTF format.&]
[s7; [*/ Return value]-|1 for Yes; 0 when No button was clicked; 1 for 
Yes; `-1 for Cancel;&]
[s0; &]
[s4; &]
[s5;:Upp`:`:ErrorRetryCancel`(const char`*`):%- [@(0.0.255) int]_[* ErrorRetryCancel]([@(0.0.255) c
onst]_[@(0.0.255) char]_`*[*@3 qtf])&]
[s2;%- Variant with Retry and Cancel buttons.&]
[s7; [%-*@3 qtf]-|Message to display in QTF format.&]
[s7; [*/ Return value]-|1 for Retry; 0 when Cancel button was clicked;&]
[s3; &]
[s4; &]
[s5;:Upp`:`:ErrorAbortRetry`(const char`*`):%- [@(0.0.255) int]_[* ErrorAbortRetry]([@(0.0.255) c
onst]_[@(0.0.255) char]_`*[*@3 qtf])&]
[s2;%- Variant with Abort and Retry buttons.&]
[s7; [%-*@3 qtf]-|Message to display in QTF format.&]
[s7; [*/ Return value]-|1 for Abort; 0 when Retry button was clicked;&]
[s3; &]
[s4; &]
[s5;:Upp`:`:ErrorAbortRetryIgnore`(const char`*`):%- [@(0.0.255) int]_[* ErrorAbortRetryI
gnore]([@(0.0.255) const]_[@(0.0.255) char]_`*[*@3 qtf])&]
[s2;%- Variant with Abort, Retry and Ignore buttons.&]
[s7; [%-*@3 qtf]-|Message to display in QTF format.&]
[s7; [*/ Return value]-|1 for Abort; 0 when Retry button was clicked; 
`-1 for Ignore;&]
[s3;%- ]]