/* Desktop.c generated by valac 0.52.4, the Vala compiler
 * generated from Desktop.vala, do not modify */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <handy.h>
#include <libsoup/soup.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gobject/gvaluecollector.h>

#define TOOTLE_TYPE_DESKTOP (tootle_desktop_get_type ())
#define TOOTLE_DESKTOP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TOOTLE_TYPE_DESKTOP, TootleDesktop))
#define TOOTLE_DESKTOP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TOOTLE_TYPE_DESKTOP, TootleDesktopClass))
#define TOOTLE_IS_DESKTOP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TOOTLE_TYPE_DESKTOP))
#define TOOTLE_IS_DESKTOP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TOOTLE_TYPE_DESKTOP))
#define TOOTLE_DESKTOP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TOOTLE_TYPE_DESKTOP, TootleDesktopClass))

typedef struct _TootleDesktop TootleDesktop;
typedef struct _TootleDesktopClass TootleDesktopClass;
typedef struct _TootleDesktopPrivate TootleDesktopPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TOOTLE_TYPE_APPLICATION (tootle_application_get_type ())
#define TOOTLE_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TOOTLE_TYPE_APPLICATION, TootleApplication))
#define TOOTLE_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TOOTLE_TYPE_APPLICATION, TootleApplicationClass))
#define TOOTLE_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TOOTLE_TYPE_APPLICATION))
#define TOOTLE_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TOOTLE_TYPE_APPLICATION))
#define TOOTLE_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TOOTLE_TYPE_APPLICATION, TootleApplicationClass))

typedef struct _TootleApplication TootleApplication;
typedef struct _TootleApplicationClass TootleApplicationClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TOOTLE_DIALOGS_TYPE_MAIN_WINDOW (tootle_dialogs_main_window_get_type ())
#define TOOTLE_DIALOGS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TOOTLE_DIALOGS_TYPE_MAIN_WINDOW, TootleDialogsMainWindow))
#define TOOTLE_DIALOGS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TOOTLE_DIALOGS_TYPE_MAIN_WINDOW, TootleDialogsMainWindowClass))
#define TOOTLE_DIALOGS_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TOOTLE_DIALOGS_TYPE_MAIN_WINDOW))
#define TOOTLE_DIALOGS_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TOOTLE_DIALOGS_TYPE_MAIN_WINDOW))
#define TOOTLE_DIALOGS_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TOOTLE_DIALOGS_TYPE_MAIN_WINDOW, TootleDialogsMainWindowClass))

typedef struct _TootleDialogsMainWindow TootleDialogsMainWindow;
typedef struct _TootleDialogsMainWindowClass TootleDialogsMainWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TOOTLE_TYPE_REQUEST (tootle_request_get_type ())
#define TOOTLE_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TOOTLE_TYPE_REQUEST, TootleRequest))
#define TOOTLE_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TOOTLE_TYPE_REQUEST, TootleRequestClass))
#define TOOTLE_IS_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TOOTLE_TYPE_REQUEST))
#define TOOTLE_IS_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TOOTLE_TYPE_REQUEST))
#define TOOTLE_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TOOTLE_TYPE_REQUEST, TootleRequestClass))

typedef struct _TootleRequest TootleRequest;
typedef struct _TootleRequestClass TootleRequestClass;
typedef struct _TootleDesktopDownloadData TootleDesktopDownloadData;
typedef struct _TootleParamSpecDesktop TootleParamSpecDesktop;

struct _TootleDesktop {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TootleDesktopPrivate * priv;
};

struct _TootleDesktopClass {
	GTypeClass parent_class;
	void (*finalize) (TootleDesktop *self);
};

typedef enum  {
	TOOTLE_OOPSIE_USER,
	TOOTLE_OOPSIE_PARSING,
	TOOTLE_OOPSIE_INSTANCE,
	TOOTLE_OOPSIE_INTERNAL
} TootleOopsie;
#define TOOTLE_OOPSIE tootle_oopsie_quark ()
struct _TootleDesktopDownloadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* url;
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* file_name;
	gchar* _tmp3_;
	gchar* dir_name;
	gchar* _tmp4_;
	gchar* dir_path;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* file_path;
	const gchar* _tmp11_;
	GHashFunc _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GFile* dir;
	const gchar* _tmp21_;
	GFile* _tmp22_;
	GFile* _tmp23_;
	GFile* _tmp24_;
	GFile* file;
	const gchar* _tmp25_;
	GFile* _tmp26_;
	GFile* _tmp27_;
	TootleRequest* msg;
	TootleRequest* _tmp28_;
	TootleRequest* _tmp29_;
	TootleRequest* _tmp30_;
	TootleRequest* _tmp31_;
	guint8* data;
	TootleRequest* _tmp32_;
	SoupMessageBody* _tmp33_;
	guint8* _tmp34_;
	gint _tmp34__length1;
	guint8* _tmp35_;
	gint _tmp35__length1;
	gint data_length1;
	gint _data_size_;
	GFileOutputStream* stream;
	GFile* _tmp36_;
	GFileOutputStream* _tmp37_;
	GFileOutputStream* _tmp38_;
	guint8* _tmp39_;
	gint _tmp39__length1;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	GError* _inner_error0_;
};

struct _TootleParamSpecDesktop {
	GParamSpec parent_instance;
};

static gpointer tootle_desktop_parent_class = NULL;
extern TootleApplication* tootle_app;
extern TootleDialogsMainWindow* tootle_window;

gpointer tootle_desktop_ref (gpointer instance);
void tootle_desktop_unref (gpointer instance);
GParamSpec* tootle_param_spec_desktop (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void tootle_value_set_desktop (GValue* value,
                               gpointer v_object);
void tootle_value_take_desktop (GValue* value,
                                gpointer v_object);
gpointer tootle_value_get_desktop (const GValue* value);
GType tootle_desktop_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TootleDesktop, tootle_desktop_unref)
gboolean tootle_desktop_open_uri (const gchar* _uri);
GQuark tootle_oopsie_quark (void);
GType tootle_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TootleApplication, g_object_unref)
void tootle_desktop_copy (const gchar* str);
GType tootle_dialogs_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TootleDialogsMainWindow, g_object_unref)
gchar* tootle_widgets_rich_label_restore_entities (const gchar* content);
gchar* tootle_desktop_get_uri_host (const gchar* uri);
static void tootle_desktop_download_data_free (gpointer _data);
void tootle_desktop_download (const gchar* url,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_);
gchar* tootle_desktop_download_finish (GAsyncResult* _res_,
                                       GError** error);
static gboolean tootle_desktop_download_co (TootleDesktopDownloadData* _data_);
#define BUILD_NAME "Tootle"
GType tootle_request_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TootleRequest, g_object_unref)
TootleRequest* tootle_request_new_GET (const gchar* url);
TootleRequest* tootle_request_construct_GET (GType object_type,
                                             const gchar* url);
void tootle_request_await (TootleRequest* self,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_);
TootleRequest* tootle_request_await_finish (TootleRequest* self,
                                            GAsyncResult* _res_,
                                            GError** error);
static void tootle_desktop_download_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_);
static guint8* _vala_array_dup1 (guint8* self,
                          gint length);
gchar* tootle_desktop_fallback_icon (const gchar* normal,
                                     const gchar* fallback,
                                     const gchar* fallback2);
GdkPixbuf* tootle_desktop_icon_to_pixbuf (const gchar* name);
TootleDesktop* tootle_desktop_new (void);
TootleDesktop* tootle_desktop_construct (GType object_type);
static void tootle_desktop_finalize (TootleDesktop * obj);
static GType tootle_desktop_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gboolean
tootle_desktop_open_uri (const gchar* _uri)
{
	gchar* uri = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (_uri != NULL, FALSE);
	_tmp0_ = g_strdup (_uri);
	uri = _tmp0_;
	_tmp1_ = uri;
	if (!string_contains (_tmp1_, ":")) {
		gchar* _tmp2_;
		_tmp2_ = g_strconcat ("file://", _uri, NULL);
		_g_free0 (uri);
		uri = _tmp2_;
	}
	_tmp3_ = uri;
	_tmp4_ = string_to_string (_tmp3_);
	_tmp5_ = g_strconcat ("Opening URI: ", _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	g_message ("Desktop.vala:11: %s", _tmp6_);
	_g_free0 (_tmp6_);
	{
		gboolean success = FALSE;
		const gchar* _tmp7_;
		_tmp7_ = uri;
		success = g_app_info_launch_default_for_uri (_tmp7_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (!success) {
			GError* _tmp8_;
			_tmp8_ = g_error_new_literal (TOOTLE_OOPSIE, TOOTLE_OOPSIE_USER, _ ("launch_default_for_uri() failed"));
			_inner_error0_ = _tmp8_;
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		{
			gchar** spawn_args = NULL;
			gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar** _tmp12_;
			gint spawn_args_length1;
			gint _spawn_args_size_;
			gchar** _tmp13_;
			gint _tmp13__length1;
			_tmp9_ = g_strdup ("/usr/bin/xdg-open");
			_tmp10_ = uri;
			_tmp11_ = g_strdup (_tmp10_);
			_tmp12_ = g_new0 (gchar*, 2 + 1);
			_tmp12_[0] = _tmp9_;
			_tmp12_[1] = _tmp11_;
			spawn_args = _tmp12_;
			spawn_args_length1 = 2;
			_spawn_args_size_ = spawn_args_length1;
			_tmp13_ = spawn_args;
			_tmp13__length1 = spawn_args_length1;
			g_spawn_sync (NULL, _tmp13_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
				goto __catch1_g_error;
			}
			spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			TootleApplication* _tmp19_;
			const gchar* _tmp20_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp14_ = e;
			_tmp15_ = _tmp14_->message;
			_tmp16_ = string_to_string (_tmp15_);
			_tmp17_ = g_strconcat ("xdg-open failed too: ", _tmp16_, NULL);
			_tmp18_ = _tmp17_;
			g_warning ("Desktop.vala:23: %s", _tmp18_);
			_g_free0 (_tmp18_);
			_tmp19_ = tootle_app;
			_tmp20_ = uri;
			g_signal_emit_by_name (_tmp19_, "error", _ ("Open this URL in your browser"), _tmp20_);
			result = FALSE;
			_g_error_free0 (e);
			_g_free0 (uri);
			return result;
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp21_ = FALSE;
			_g_free0 (uri);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp21_;
		}
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp22_ = FALSE;
		_g_free0 (uri);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp22_;
	}
	result = TRUE;
	_g_free0 (uri);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
tootle_desktop_copy (const gchar* str)
{
	GdkDisplay* display = NULL;
	TootleDialogsMainWindow* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkDisplay* _tmp2_;
	GtkClipboard* clipboard = NULL;
	GtkClipboard* _tmp3_;
	GtkClipboard* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (str != NULL);
	_tmp0_ = tootle_window;
	_tmp1_ = gtk_widget_get_display ((GtkWidget*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	display = _tmp2_;
	_tmp3_ = gtk_clipboard_get_for_display (display, GDK_SELECTION_CLIPBOARD);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	clipboard = _tmp4_;
	_tmp5_ = tootle_widgets_rich_label_restore_entities (str);
	_tmp6_ = _tmp5_;
	gtk_clipboard_set_text (clipboard, _tmp6_, -1);
	_g_free0 (_tmp6_);
	_g_object_unref0 (clipboard);
	_g_object_unref0 (display);
}

gchar*
tootle_desktop_get_uri_host (const gchar* uri)
{
	gchar* p1 = NULL;
	gchar* _tmp0_;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* result = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = g_strdup (uri);
	p1 = _tmp0_;
	if (string_contains (uri, "//")) {
		gchar** _tmp1_;
		gchar** _tmp2_;
		gchar** _tmp3_;
		gint _tmp3__length1;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = _tmp1_ = g_strsplit (uri, "//", 0);
		_tmp3_ = _tmp2_;
		_tmp3__length1 = _vala_array_length (_tmp1_);
		_tmp4_ = _tmp3_[1];
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (p1);
		p1 = _tmp5_;
		_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp6_ = p1;
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "/", 0);
	_tmp9_ = _tmp8_;
	_tmp9__length1 = _vala_array_length (_tmp7_);
	_tmp10_ = _tmp9_[0];
	_tmp11_ = g_strdup (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
	result = _tmp12_;
	_g_free0 (p1);
	return result;
}

static void
tootle_desktop_download_data_free (gpointer _data)
{
	TootleDesktopDownloadData* _data_;
	_data_ = _data;
	_g_free0 (_data_->url);
	_g_free0 (_data_->result);
	g_slice_free (TootleDesktopDownloadData, _data_);
}

void
tootle_desktop_download (const gchar* url,
                         GAsyncReadyCallback _callback_,
                         gpointer _user_data_)
{
	TootleDesktopDownloadData* _data_;
	gchar* _tmp0_;
	g_return_if_fail (url != NULL);
	_data_ = g_slice_new0 (TootleDesktopDownloadData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tootle_desktop_download_data_free);
	_tmp0_ = g_strdup (url);
	_g_free0 (_data_->url);
	_data_->url = _tmp0_;
	tootle_desktop_download_co (_data_);
}

gchar*
tootle_desktop_download_finish (GAsyncResult* _res_,
                                GError** error)
{
	gchar* result;
	TootleDesktopDownloadData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
tootle_desktop_download_ready (GObject* source_object,
                               GAsyncResult* _res_,
                               gpointer _user_data_)
{
	TootleDesktopDownloadData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tootle_desktop_download_co (_data_);
}

static guint8*
_vala_array_dup1 (guint8* self,
                  gint length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static gboolean
tootle_desktop_download_co (TootleDesktopDownloadData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = string_to_string (_data_->url);
	_data_->_tmp1_ = g_strconcat ("Downloading file: ", _data_->_tmp0_, "...", NULL);
	_data_->_tmp2_ = _data_->_tmp1_;
	g_message ("Desktop.vala:48: %s", _data_->_tmp2_);
	_g_free0 (_data_->_tmp2_);
	_data_->_tmp3_ = g_path_get_basename (_data_->url);
	_data_->file_name = _data_->_tmp3_;
	_data_->_tmp4_ = g_path_get_dirname (_data_->url);
	_data_->dir_name = _data_->_tmp4_;
	_data_->_tmp5_ = g_get_user_special_dir (G_USER_DIRECTORY_DOWNLOAD);
	_data_->_tmp6_ = _data_->dir_name;
	_data_->_tmp7_ = tootle_desktop_get_uri_host (_data_->_tmp6_);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = g_build_path (G_DIR_SEPARATOR_S, _data_->_tmp5_, BUILD_NAME, _data_->_tmp8_, NULL);
	_data_->_tmp10_ = _data_->_tmp9_;
	_g_free0 (_data_->_tmp8_);
	_data_->dir_path = _data_->_tmp10_;
	_data_->_tmp11_ = _data_->dir_path;
	_data_->_tmp12_ = g_str_hash;
	_data_->_tmp13_ = _data_->dir_name;
	_data_->_tmp14_ = g_strdup_printf ("%u", _data_->_tmp12_ (_data_->_tmp13_));
	_data_->_tmp15_ = _data_->_tmp14_;
	_data_->_tmp16_ = _data_->file_name;
	_data_->_tmp17_ = g_strconcat (_data_->_tmp15_, _data_->_tmp16_, NULL);
	_data_->_tmp18_ = _data_->_tmp17_;
	_data_->_tmp19_ = g_build_path (G_DIR_SEPARATOR_S, _data_->_tmp11_, _data_->_tmp18_, NULL);
	_data_->_tmp20_ = _data_->_tmp19_;
	_g_free0 (_data_->_tmp18_);
	_g_free0 (_data_->_tmp15_);
	_data_->file_path = _data_->_tmp20_;
	_data_->_tmp21_ = _data_->dir_path;
	_data_->_tmp22_ = g_file_new_for_path (_data_->_tmp21_);
	_data_->dir = _data_->_tmp22_;
	_data_->_tmp23_ = _data_->dir;
	if (!g_file_query_exists (_data_->_tmp23_, NULL)) {
		_data_->_tmp24_ = _data_->dir;
		g_file_make_directory_with_parents (_data_->_tmp24_, NULL, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->dir);
			_g_free0 (_data_->file_path);
			_g_free0 (_data_->dir_path);
			_g_free0 (_data_->dir_name);
			_g_free0 (_data_->file_name);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp25_ = _data_->file_path;
	_data_->_tmp26_ = g_file_new_for_path (_data_->_tmp25_);
	_data_->file = _data_->_tmp26_;
	_data_->_tmp27_ = _data_->file;
	if (!g_file_query_exists (_data_->_tmp27_, NULL)) {
		_data_->_tmp28_ = tootle_request_new_GET (_data_->url);
		_data_->_tmp29_ = _data_->_tmp28_;
		_data_->_state_ = 1;
		tootle_request_await (_data_->_tmp29_, tootle_desktop_download_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp30_ = tootle_request_await_finish (_data_->_tmp29_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp31_ = _data_->_tmp30_;
		_g_object_unref0 (_data_->_tmp29_);
		_data_->msg = _data_->_tmp31_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->file);
			_g_object_unref0 (_data_->dir);
			_g_free0 (_data_->file_path);
			_g_free0 (_data_->dir_path);
			_g_free0 (_data_->dir_name);
			_g_free0 (_data_->file_name);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp32_ = _data_->msg;
		_data_->_tmp33_ = ((SoupMessage*) _data_->_tmp32_)->response_body;
		_data_->_tmp34_ = _data_->_tmp33_->data;
		_data_->_tmp34__length1 = _data_->_tmp33_->length;
		_data_->_tmp35_ = (_data_->_tmp34_ != NULL) ? _vala_array_dup1 (_data_->_tmp34_, _data_->_tmp34__length1) : _data_->_tmp34_;
		_data_->_tmp35__length1 = _data_->_tmp34__length1;
		_data_->data = _data_->_tmp35_;
		_data_->data_length1 = _data_->_tmp35__length1;
		_data_->_data_size_ = _data_->data_length1;
		_data_->_tmp36_ = _data_->file;
		_data_->_tmp37_ = g_file_create (_data_->_tmp36_, G_FILE_CREATE_PRIVATE, NULL, &_data_->_inner_error0_);
		_data_->stream = _data_->_tmp37_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_data_->data = (g_free (_data_->data), NULL);
			_g_object_unref0 (_data_->msg);
			_g_object_unref0 (_data_->file);
			_g_object_unref0 (_data_->dir);
			_g_free0 (_data_->file_path);
			_g_free0 (_data_->dir_path);
			_g_free0 (_data_->dir_name);
			_g_free0 (_data_->file_name);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp38_ = _data_->stream;
		_data_->_tmp39_ = _data_->data;
		_data_->_tmp39__length1 = _data_->data_length1;
		g_output_stream_write ((GOutputStream*) _data_->_tmp38_, _data_->_tmp39_, (gsize) _data_->_tmp39__length1, NULL, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->stream);
			_data_->data = (g_free (_data_->data), NULL);
			_g_object_unref0 (_data_->msg);
			_g_object_unref0 (_data_->file);
			_g_object_unref0 (_data_->dir);
			_g_free0 (_data_->file_path);
			_g_free0 (_data_->dir_path);
			_g_free0 (_data_->dir_name);
			_g_free0 (_data_->file_name);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp40_ = _data_->file_path;
		_data_->_tmp41_ = string_to_string (_data_->_tmp40_);
		_data_->_tmp42_ = g_strconcat ("OK: File written to: ", _data_->_tmp41_, NULL);
		_data_->_tmp43_ = _data_->_tmp42_;
		g_message ("Desktop.vala:78: %s", _data_->_tmp43_);
		_g_free0 (_data_->_tmp43_);
		_g_object_unref0 (_data_->stream);
		_data_->data = (g_free (_data_->data), NULL);
		_g_object_unref0 (_data_->msg);
	} else {
		g_message ("Desktop.vala:81: OK: File exists already");
	}
	_data_->result = _data_->file_path;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->dir);
	_g_free0 (_data_->dir_path);
	_g_free0 (_data_->dir_name);
	_g_free0 (_data_->file_name);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gchar*
tootle_desktop_fallback_icon (const gchar* normal,
                              const gchar* fallback,
                              const gchar* fallback2)
{
	GtkIconTheme* theme = NULL;
	GtkIconTheme* _tmp0_;
	GtkIconTheme* _tmp1_;
	GtkIconTheme* _tmp2_;
	gchar* result = NULL;
	g_return_val_if_fail (normal != NULL, NULL);
	g_return_val_if_fail (fallback != NULL, NULL);
	g_return_val_if_fail (fallback2 != NULL, NULL);
	_tmp0_ = gtk_icon_theme_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	theme = _tmp1_;
	_tmp2_ = theme;
	if (gtk_icon_theme_has_icon (_tmp2_, normal)) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (normal);
		result = _tmp3_;
		_g_object_unref0 (theme);
		return result;
	} else {
		const gchar* _tmp4_ = NULL;
		GtkIconTheme* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = theme;
		if (gtk_icon_theme_has_icon (_tmp5_, fallback)) {
			_tmp4_ = fallback;
		} else {
			_tmp4_ = fallback2;
		}
		_tmp6_ = g_strdup (_tmp4_);
		result = _tmp6_;
		_g_object_unref0 (theme);
		return result;
	}
}

GdkPixbuf*
tootle_desktop_icon_to_pixbuf (const gchar* name)
{
	GtkIconTheme* theme = NULL;
	GtkIconTheme* _tmp0_;
	GtkIconTheme* _tmp1_;
	GdkPixbuf* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = gtk_icon_theme_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	theme = _tmp1_;
	_tmp3_ = gtk_icon_theme_load_icon (theme, name, 32, GTK_ICON_LOOKUP_GENERIC_FALLBACK, &_inner_error0_);
	_tmp2_ = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (theme);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp4_ = _tmp2_;
	_tmp2_ = NULL;
	result = _tmp4_;
	_g_object_unref0 (_tmp2_);
	_g_object_unref0 (theme);
	return result;
}

TootleDesktop*
tootle_desktop_construct (GType object_type)
{
	TootleDesktop* self = NULL;
	self = (TootleDesktop*) g_type_create_instance (object_type);
	return self;
}

TootleDesktop*
tootle_desktop_new (void)
{
	return tootle_desktop_construct (TOOTLE_TYPE_DESKTOP);
}

static void
tootle_value_desktop_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
tootle_value_desktop_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		tootle_desktop_unref (value->data[0].v_pointer);
	}
}

static void
tootle_value_desktop_copy_value (const GValue* src_value,
                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tootle_desktop_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
tootle_value_desktop_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
tootle_value_desktop_collect_value (GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		TootleDesktop * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tootle_desktop_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
tootle_value_desktop_lcopy_value (const GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	TootleDesktop ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tootle_desktop_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
tootle_param_spec_desktop (const gchar* name,
                           const gchar* nick,
                           const gchar* blurb,
                           GType object_type,
                           GParamFlags flags)
{
	TootleParamSpecDesktop* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TOOTLE_TYPE_DESKTOP), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
tootle_value_get_desktop (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TOOTLE_TYPE_DESKTOP), NULL);
	return value->data[0].v_pointer;
}

void
tootle_value_set_desktop (GValue* value,
                          gpointer v_object)
{
	TootleDesktop * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TOOTLE_TYPE_DESKTOP));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TOOTLE_TYPE_DESKTOP));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tootle_desktop_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tootle_desktop_unref (old);
	}
}

void
tootle_value_take_desktop (GValue* value,
                           gpointer v_object)
{
	TootleDesktop * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TOOTLE_TYPE_DESKTOP));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TOOTLE_TYPE_DESKTOP));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tootle_desktop_unref (old);
	}
}

static void
tootle_desktop_class_init (TootleDesktopClass * klass,
                           gpointer klass_data)
{
	tootle_desktop_parent_class = g_type_class_peek_parent (klass);
	((TootleDesktopClass *) klass)->finalize = tootle_desktop_finalize;
}

static void
tootle_desktop_instance_init (TootleDesktop * self,
                              gpointer klass)
{
	self->ref_count = 1;
}

static void
tootle_desktop_finalize (TootleDesktop * obj)
{
	TootleDesktop * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TOOTLE_TYPE_DESKTOP, TootleDesktop);
	g_signal_handlers_destroy (self);
}

static GType
tootle_desktop_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { tootle_value_desktop_init, tootle_value_desktop_free_value, tootle_value_desktop_copy_value, tootle_value_desktop_peek_pointer, "p", tootle_value_desktop_collect_value, "p", tootle_value_desktop_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (TootleDesktopClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tootle_desktop_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TootleDesktop), 0, (GInstanceInitFunc) tootle_desktop_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType tootle_desktop_type_id;
	tootle_desktop_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TootleDesktop", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return tootle_desktop_type_id;
}

GType
tootle_desktop_get_type (void)
{
	static volatile gsize tootle_desktop_type_id__volatile = 0;
	if (g_once_init_enter (&tootle_desktop_type_id__volatile)) {
		GType tootle_desktop_type_id;
		tootle_desktop_type_id = tootle_desktop_get_type_once ();
		g_once_init_leave (&tootle_desktop_type_id__volatile, tootle_desktop_type_id);
	}
	return tootle_desktop_type_id__volatile;
}

gpointer
tootle_desktop_ref (gpointer instance)
{
	TootleDesktop * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
tootle_desktop_unref (gpointer instance)
{
	TootleDesktop * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TOOTLE_DESKTOP_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

