/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.migrator.helper;

public class Abbreviator {
    static final String FILLER = "...";
    final char folderSeparator;
    final int invariantPrefixLength;
    final int desiredLength;

    public Abbreviator(int n, int n2, char c) {
        this.invariantPrefixLength = n;
        this.desiredLength = n2;
        this.folderSeparator = c;
    }

    public String abbreviate(String string) {
        if (string.length() <= this.desiredLength) {
            return string;
        }
        int n = string.indexOf(this.folderSeparator, this.invariantPrefixLength);
        if (n == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(this.desiredLength);
        stringBuilder.append(string, 0, n + 1);
        stringBuilder.append(FILLER);
        int n2 = this.computeNextIndex(string, n);
        if (n2 == -1) {
            return string;
        }
        stringBuilder.append(string.substring(n2));
        if (stringBuilder.length() < string.length()) {
            return stringBuilder.toString();
        }
        return string;
    }

    int computeNextIndex(String string, int n) {
        int n2 = n + 1;
        int n3 = 0;
        int n4 = string.length() - this.desiredLength + FILLER.length();
        while (n2 < n + n4) {
            int n5 = string.indexOf(this.folderSeparator, n2 + 1);
            if (n5 == -1) {
                if (n3 == 0) {
                    return -1;
                }
                return n2;
            }
            ++n3;
            n2 = n5;
        }
        return n2;
    }
}

