/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tree;

import com.icl.saxon.KeyManager;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.om.AxisEnumeration;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.sort.LocalOrderComparer;
import com.icl.saxon.tree.AttributeCollection;
import com.icl.saxon.tree.ElementImpl;
import com.icl.saxon.tree.LineNumberMap;
import com.icl.saxon.tree.NodeFactory;
import com.icl.saxon.tree.NodeImpl;
import com.icl.saxon.tree.ParentNodeImpl;
import com.icl.saxon.tree.SystemIdMap;
import java.util.Hashtable;
import javax.xml.transform.TransformerException;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DocumentImpl
extends ParentNodeImpl
implements DocumentInfo,
Document {
    private ElementImpl documentElement;
    private Hashtable idTable = null;
    private Hashtable entityTable = null;
    private Hashtable elementList = null;
    private StringBuffer characterBuffer;
    private NamePool namePool;
    private NodeFactory nodeFactory;
    private LineNumberMap lineNumberMap;
    private SystemIdMap systemIdMap = new SystemIdMap();
    private Object[] index = new Object[30];
    private int indexEntriesUsed = 0;

    public DocumentImpl() {
        this.parent = null;
    }

    protected void setCharacterBuffer(StringBuffer stringBuffer) {
        this.characterBuffer = stringBuffer;
    }

    public final StringBuffer getCharacterBuffer() {
        return this.characterBuffer;
    }

    @Override
    public void setNamePool(NamePool namePool) {
        this.namePool = namePool;
    }

    @Override
    public NamePool getNamePool() {
        return this.namePool;
    }

    public void setNodeFactory(NodeFactory nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    public NodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    protected void setDocumentElement(ElementImpl elementImpl) {
        this.documentElement = elementImpl;
    }

    @Override
    public void setSystemId(String string) {
        if (string == null) {
            string = "";
        }
        this.systemIdMap.setSystemId(this.sequence, string);
    }

    @Override
    public String getSystemId() {
        return this.systemIdMap.getSystemId(this.sequence);
    }

    @Override
    public String getBaseURI() {
        return this.getSystemId();
    }

    protected void setSystemId(int n, String string) {
        if (string == null) {
            string = "";
        }
        this.systemIdMap.setSystemId(n, string);
    }

    protected String getSystemId(int n) {
        return this.systemIdMap.getSystemId(n);
    }

    public void setLineNumbering() {
        this.lineNumberMap = new LineNumberMap();
        this.lineNumberMap.setLineNumber(this.sequence, 0);
    }

    protected void setLineNumber(int n, int n2) {
        if (this.lineNumberMap != null) {
            this.lineNumberMap.setLineNumber(n, n2);
        }
    }

    protected int getLineNumber(int n) {
        if (this.lineNumberMap != null) {
            return this.lineNumberMap.getLineNumber(n);
        }
        return -1;
    }

    @Override
    public int getLineNumber() {
        return 0;
    }

    @Override
    public final short getNodeType() {
        return 9;
    }

    @Override
    public final Node getNextSibling() {
        return null;
    }

    @Override
    public final Node getPreviousSibling() {
        return null;
    }

    @Override
    public Element getDocumentElement() {
        return this.documentElement;
    }

    @Override
    public DocumentInfo getDocumentRoot() {
        return this;
    }

    @Override
    public String generateId() {
        return "";
    }

    protected AxisEnumeration getAllElements(int n) {
        NodeSetExtent nodeSetExtent;
        Integer n2 = new Integer(n);
        if (this.elementList == null) {
            this.elementList = new Hashtable();
        }
        if ((nodeSetExtent = (NodeSetExtent)this.elementList.get(n2)) == null) {
            nodeSetExtent = new NodeSetExtent(LocalOrderComparer.getInstance());
            nodeSetExtent.setSorted(true);
            for (NodeImpl nodeImpl = this.getNextInDocument(this); nodeImpl != null; nodeImpl = nodeImpl.getNextInDocument(this)) {
                if (nodeImpl.getNodeType() != 1 || nodeImpl.getFingerprint() != n) continue;
                nodeSetExtent.append(nodeImpl);
            }
            this.elementList.put(n2, nodeSetExtent);
        }
        return (AxisEnumeration)nodeSetExtent.enumerate();
    }

    private void indexIDs() {
        NodeImpl nodeImpl;
        if (this.idTable != null) {
            return;
        }
        this.idTable = new Hashtable();
        DocumentImpl documentImpl = nodeImpl = this;
        while (nodeImpl != null) {
            if (nodeImpl.getNodeType() == 1) {
                ElementImpl elementImpl = (ElementImpl)nodeImpl;
                AttributeCollection attributeCollection = elementImpl.getAttributeList();
                for (int i = 0; i < attributeCollection.getLength(); ++i) {
                    if (!"ID".equals(attributeCollection.getType(i))) continue;
                    this.registerID(elementImpl, attributeCollection.getValue(i));
                }
            }
            nodeImpl = nodeImpl.getNextInDocument(documentImpl);
        }
    }

    private void registerID(NodeInfo nodeInfo, String string) {
        Object v = this.idTable.get(string);
        if (v == null) {
            this.idTable.put(string, nodeInfo);
        }
    }

    @Override
    public NodeInfo selectID(String string) {
        if (this.idTable == null) {
            this.indexIDs();
        }
        return (NodeInfo)this.idTable.get(string);
    }

    @Override
    public synchronized Hashtable getKeyIndex(KeyManager keyManager, int n) {
        for (int i = 0; i < this.indexEntriesUsed; i += 3) {
            if ((KeyManager)this.index[i] != keyManager || (Integer)this.index[i + 1] != n) continue;
            Object object = this.index[i + 2];
            return (Hashtable)this.index[i + 2];
        }
        return null;
    }

    @Override
    public synchronized void setKeyIndex(KeyManager keyManager, int n, Hashtable hashtable) {
        for (int i = 0; i < this.indexEntriesUsed; i += 3) {
            if ((KeyManager)this.index[i] != keyManager || (Integer)this.index[i + 1] != n) continue;
            this.index[i + 2] = hashtable;
            return;
        }
        if (this.indexEntriesUsed + 3 >= this.index.length) {
            Object[] objectArray = new Object[this.indexEntriesUsed * 2];
            System.arraycopy(this.index, 0, objectArray, 0, this.indexEntriesUsed);
            this.index = objectArray;
        }
        this.index[this.indexEntriesUsed++] = keyManager;
        this.index[this.indexEntriesUsed++] = new Integer(n);
        this.index[this.indexEntriesUsed++] = hashtable;
    }

    protected void setUnparsedEntity(String string, String string2) {
        if (this.entityTable == null) {
            this.entityTable = new Hashtable();
        }
        this.entityTable.put(string, string2);
    }

    @Override
    public String getUnparsedEntity(String string) {
        if (this.entityTable == null) {
            return "";
        }
        String string2 = (String)this.entityTable.get(string);
        return string2 == null ? "" : string2;
    }

    @Override
    public void copy(Outputter outputter) throws TransformerException {
        for (NodeImpl nodeImpl = (NodeImpl)this.getFirstChild(); nodeImpl != null; nodeImpl = (NodeImpl)nodeImpl.getNextSibling()) {
            nodeImpl.copy(outputter);
        }
    }

    @Override
    public Node adoptNode(Node node) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    @Override
    public String getDocumentURI() {
        return this.getSystemId();
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return null;
    }

    @Override
    public String getInputEncoding() {
        return null;
    }

    @Override
    public boolean getStrictErrorChecking() {
        return true;
    }

    @Override
    public String getXmlEncoding() {
        return null;
    }

    @Override
    public boolean getXmlStandalone() {
        return false;
    }

    @Override
    public String getXmlVersion() {
        return "1.0";
    }

    @Override
    public void normalizeDocument() {
        this.disallowUpdate();
    }

    @Override
    public Node renameNode(Node node, String string, String string2) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    @Override
    public void setDocumentURI(String string) {
        this.setSystemId(string);
    }

    @Override
    public void setStrictErrorChecking(boolean bl) {
        throw new UnsupportedOperationException("setStrictErrorChecking() is not supported");
    }

    @Override
    public void setXmlStandalone(boolean bl) throws DOMException {
        this.disallowUpdate();
    }

    @Override
    public void setXmlVersion(String string) throws DOMException {
        this.disallowUpdate();
    }
}

