/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tinytree;

import com.icl.saxon.om.AbstractNode;
import com.icl.saxon.om.AxisEnumeration;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.EmptyEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.om.PrependIterator;
import com.icl.saxon.om.SingletonEnumeration;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.pattern.NameTest;
import com.icl.saxon.pattern.NodeTest;
import com.icl.saxon.tinytree.AncestorEnumeration;
import com.icl.saxon.tinytree.AttributeEnumeration;
import com.icl.saxon.tinytree.DescendantEnumeration;
import com.icl.saxon.tinytree.FollowingEnumeration;
import com.icl.saxon.tinytree.NamespaceEnumeration;
import com.icl.saxon.tinytree.PrecedingEnumeration;
import com.icl.saxon.tinytree.PrecedingSiblingEnumeration;
import com.icl.saxon.tinytree.SiblingEnumeration;
import com.icl.saxon.tinytree.TinyDocumentImpl;
import com.icl.saxon.tinytree.TinyElementImpl;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;

abstract class TinyNodeImpl
extends AbstractNode {
    protected TinyDocumentImpl document;
    protected int nodeNr;
    protected TinyNodeImpl parent = null;

    TinyNodeImpl() {
    }

    @Override
    public void setSystemId(String string) {
        short s = this.document.nodeType[this.nodeNr];
        if (s == 2 || s == 13) {
            ((TinyNodeImpl)this.getParent()).setSystemId(string);
        } else {
            this.document.setSystemId(this.nodeNr, string);
        }
    }

    protected void setParentNode(TinyNodeImpl tinyNodeImpl) {
        this.parent = tinyNodeImpl;
    }

    @Override
    public boolean isSameNodeInfo(NodeInfo nodeInfo) {
        if (this == nodeInfo) {
            return true;
        }
        if (!(nodeInfo instanceof TinyNodeImpl)) {
            return false;
        }
        if (this.getNodeType() != nodeInfo.getNodeType()) {
            return false;
        }
        return this.document == ((TinyNodeImpl)nodeInfo).document && this.nodeNr == ((TinyNodeImpl)nodeInfo).nodeNr;
    }

    @Override
    public String getSystemId() {
        return this.document.getSystemId(this.nodeNr);
    }

    @Override
    public String getBaseURI() {
        return this.getParent().getBaseURI();
    }

    @Override
    public Node getOriginatingNode() {
        return this;
    }

    public void setLineNumber(int n) {
        this.document.setLineNumber(this.nodeNr, n);
    }

    @Override
    public int getLineNumber() {
        return this.document.getLineNumber(this.nodeNr);
    }

    protected long getSequenceNumber() {
        return (long)this.nodeNr << 32;
    }

    @Override
    public final int compareOrder(NodeInfo nodeInfo) {
        long l;
        long l2 = this.getSequenceNumber();
        if (l2 < (l = ((TinyNodeImpl)nodeInfo).getSequenceNumber())) {
            return -1;
        }
        if (l2 > l) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getFingerprint() {
        int n = this.getNameCode();
        if (n == -1) {
            return -1;
        }
        return n & 0xFFFFF;
    }

    @Override
    public int getNameCode() {
        return this.document.nameCode[this.nodeNr];
    }

    @Override
    public String getPrefix() {
        int n = this.document.nameCode[this.nodeNr];
        if (n < 0) {
            return "";
        }
        if ((n >> 20 & 0xFF) == 0) {
            return "";
        }
        return this.document.getNamePool().getPrefix(n);
    }

    @Override
    public String getURI() {
        int n = this.document.nameCode[this.nodeNr];
        if (n < 0) {
            return "";
        }
        return this.document.getNamePool().getURI(n);
    }

    @Override
    public String getDisplayName() {
        int n = this.document.nameCode[this.nodeNr];
        if (n < 0) {
            return "";
        }
        return this.document.getNamePool().getDisplayName(n);
    }

    @Override
    public String getLocalName() {
        int n = this.document.nameCode[this.nodeNr];
        if (n < 0) {
            return "";
        }
        return this.document.getNamePool().getLocalName(n);
    }

    @Override
    public AxisEnumeration getEnumeration(byte by, NodeTest nodeTest) {
        short s = this.getNodeType();
        switch (by) {
            case 0: {
                if (s == 9) {
                    return EmptyEnumeration.getInstance();
                }
                return new AncestorEnumeration(this.document, this, nodeTest, false);
            }
            case 1: {
                if (s == 9) {
                    if (nodeTest.matches(this)) {
                        return new SingletonEnumeration(this);
                    }
                    return EmptyEnumeration.getInstance();
                }
                return new AncestorEnumeration(this.document, this, nodeTest, true);
            }
            case 2: {
                if (s != 1) {
                    return EmptyEnumeration.getInstance();
                }
                if (this.document.offset[this.nodeNr] < 0) {
                    return EmptyEnumeration.getInstance();
                }
                return new AttributeEnumeration(this.document, this.nodeNr, nodeTest);
            }
            case 3: {
                if (this.hasChildNodes()) {
                    return new SiblingEnumeration(this.document, this, nodeTest, true);
                }
                return EmptyEnumeration.getInstance();
            }
            case 4: {
                if (s == 9 && nodeTest instanceof NameTest && nodeTest.getNodeType() == 1) {
                    return ((TinyDocumentImpl)this).getAllElements(((NameTest)nodeTest).getFingerprint());
                }
                if (this.hasChildNodes()) {
                    return new DescendantEnumeration(this.document, this, nodeTest, false);
                }
                return EmptyEnumeration.getInstance();
            }
            case 5: {
                if (this.hasChildNodes()) {
                    return new DescendantEnumeration(this.document, this, nodeTest, true);
                }
                if (nodeTest.matches(this)) {
                    return new SingletonEnumeration(this);
                }
                return EmptyEnumeration.getInstance();
            }
            case 6: {
                if (s == 9) {
                    return EmptyEnumeration.getInstance();
                }
                if (s == 2 || s == 13) {
                    return new FollowingEnumeration(this.document, (TinyNodeImpl)this.getParent(), nodeTest, true);
                }
                return new FollowingEnumeration(this.document, this, nodeTest, false);
            }
            case 7: {
                if (s == 9 || s == 2 || s == 13) {
                    return EmptyEnumeration.getInstance();
                }
                return new SiblingEnumeration(this.document, this, nodeTest, false);
            }
            case 8: {
                if (s != 1) {
                    return EmptyEnumeration.getInstance();
                }
                return new NamespaceEnumeration((TinyElementImpl)this, nodeTest);
            }
            case 9: {
                NodeInfo nodeInfo = this.getParent();
                if (nodeInfo == null) {
                    return EmptyEnumeration.getInstance();
                }
                if (nodeTest.matches(nodeInfo)) {
                    return new SingletonEnumeration(nodeInfo);
                }
                return EmptyEnumeration.getInstance();
            }
            case 10: {
                if (s == 9) {
                    return EmptyEnumeration.getInstance();
                }
                if (s == 2 || s == 13) {
                    return new PrecedingEnumeration(this.document, (TinyNodeImpl)this.getParent(), nodeTest, false);
                }
                return new PrecedingEnumeration(this.document, this, nodeTest, false);
            }
            case 11: {
                if (s == 9 || s == 2 || s == 13) {
                    return EmptyEnumeration.getInstance();
                }
                return new PrecedingSiblingEnumeration(this.document, this, nodeTest);
            }
            case 12: {
                if (nodeTest.matches(this)) {
                    return new SingletonEnumeration(this);
                }
                return EmptyEnumeration.getInstance();
            }
            case 13: {
                if (s == 9) {
                    return EmptyEnumeration.getInstance();
                }
                if (s == 2 || s == 13) {
                    TinyNodeImpl tinyNodeImpl = (TinyNodeImpl)this.getParent();
                    return new PrependIterator(tinyNodeImpl, new PrecedingEnumeration(this.document, tinyNodeImpl, nodeTest, true));
                }
                return new PrecedingEnumeration(this.document, this, nodeTest, true);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + by);
    }

    @Override
    public NodeInfo getParent() {
        if (this.parent != null) {
            return this.parent;
        }
        for (int i = this.nodeNr - 1; i >= 0; --i) {
            if (this.document.depth[i] >= this.document.depth[this.nodeNr]) continue;
            this.parent = this.document.getNode(i);
            return this.parent;
        }
        this.parent = this.document;
        return this.parent;
    }

    @Override
    public boolean hasChildNodes() {
        return false;
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    @Override
    public String getAttributeValue(String string, String string2) {
        return null;
    }

    @Override
    public String getAttributeValue(int n) {
        return null;
    }

    @Override
    public DocumentInfo getDocumentRoot() {
        return this.document;
    }

    @Override
    public void outputNamespaceNodes(Outputter outputter, boolean bl) throws TransformerException {
    }

    @Override
    public String generateId() {
        return this.document.generateId() + NODE_LETTER[this.getNodeType()] + this.nodeNr;
    }
}

