/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Bindery;
import com.icl.saxon.Binding;
import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.ParameterSet;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.FragmentValue;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.expr.NodeSetIntent;
import com.icl.saxon.expr.SingletonNodeSet;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.TextFragmentValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NamespaceException;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.sort.NodeOrderComparer;
import com.icl.saxon.style.Procedure;
import com.icl.saxon.style.SAXONFunction;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.XSLAttributeSet;
import com.icl.saxon.style.XSLStyleSheet;
import com.icl.saxon.style.XSLTemplate;
import com.icl.saxon.tree.AttributeCollection;
import com.icl.saxon.tree.NodeImpl;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public abstract class XSLGeneralVariable
extends StyleElement {
    protected int variableFingerprint = -1;
    protected Expression select = null;
    protected String simpleText = null;
    protected boolean global;
    protected Procedure procedure = null;
    protected boolean assignable = false;
    protected boolean redundant = false;

    @Override
    public boolean mayContainTemplateBody() {
        return true;
    }

    public boolean isGlobal() {
        return this.getParentNode() instanceof XSLStyleSheet;
    }

    public boolean isAssignable() {
        return this.assignable;
    }

    public Procedure getOwningProcedure() throws TransformerConfigurationException {
        NodeInfo nodeInfo = this;
        while (true) {
            NodeInfo nodeInfo2;
            if ((nodeInfo2 = nodeInfo.getParent()) instanceof XSLStyleSheet) {
                if (nodeInfo instanceof XSLTemplate) {
                    return ((XSLTemplate)nodeInfo).getProcedure();
                }
                if (nodeInfo instanceof XSLGeneralVariable) {
                    return ((XSLGeneralVariable)nodeInfo).getProcedure();
                }
                if (nodeInfo instanceof SAXONFunction) {
                    return ((SAXONFunction)nodeInfo).getProcedure();
                }
                if (nodeInfo instanceof XSLAttributeSet) {
                    return ((XSLAttributeSet)nodeInfo).getProcedure();
                }
                this.compileError("Local variable must be declared within a template");
                return new Procedure();
            }
            nodeInfo = nodeInfo2;
        }
    }

    @Override
    public void preprocess() throws TransformerConfigurationException {
        if (this.global) {
            this.getPrincipalStyleSheet().allocateLocalSlots(this.procedure.getNumberOfVariables());
        }
    }

    public String getVariableName() {
        return this.getAttributeValue("", "name");
    }

    public int getVariableFingerprint() {
        if (this.variableFingerprint == -1) {
            StandardNames standardNames = this.getStandardNames();
            String string = this.getAttributeValue(standardNames.NAME & 0xFFFFF);
            if (string == null) {
                return -1;
            }
            try {
                this.variableFingerprint = this.makeNameCode(string, false) & 0xFFFFF;
            }
            catch (NamespaceException namespaceException) {
                this.variableFingerprint = -1;
            }
        }
        return this.variableFingerprint;
    }

    @Override
    public void prepareAttributes() throws TransformerConfigurationException {
        this.getVariableFingerprint();
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            int n2 = n & 0xFFFFF;
            if (n2 == standardNames.NAME) {
                string3 = attributeCollection.getValue(i);
                continue;
            }
            if (n2 == standardNames.SELECT) {
                string = attributeCollection.getValue(i);
                continue;
            }
            if (n2 == standardNames.SAXON_ASSIGNABLE) {
                string2 = attributeCollection.getValue(i);
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (string3 == null) {
            this.reportAbsence("name");
        } else if (!Name.isQName(string3)) {
            this.compileError("Variable name must be a valid QName");
        }
        if (string != null) {
            this.select = this.makeExpression(string);
        }
        if (string2 != null && string2.equals("yes")) {
            this.assignable = true;
        }
    }

    @Override
    public void validate() throws TransformerConfigurationException {
        this.global = this.getParentNode() instanceof XSLStyleSheet;
        if (this.global) {
            this.procedure = new Procedure();
        }
        if (this.select != null && this.getFirstChild() != null) {
            this.compileError("An " + this.getDisplayName() + " element with a select attribute must be empty");
        }
        if (this.select == null) {
            NodeImpl nodeImpl = (NodeImpl)this.getFirstChild();
            if (nodeImpl == null) {
                this.select = new StringValue("");
            } else {
                NodeImpl nodeImpl2 = (NodeImpl)nodeImpl.getNextSibling();
                if (nodeImpl2 == null && nodeImpl.getNodeType() == 3) {
                    this.simpleText = nodeImpl.getStringValue();
                }
            }
        }
    }

    public void checkDuplicateDeclaration() throws TransformerConfigurationException {
        Binding binding = this.getVariableBinding(this.getVariableFingerprint());
        int n = this.getPrecedence();
        if (binding != null) {
            if (this.global) {
                int n2 = ((XSLGeneralVariable)((Object)binding)).getPrecedence();
                if (n == n2) {
                    this.compileError("Duplicate global variable declaration");
                } else if (n < n2) {
                    this.redundant = true;
                } else {
                    ((XSLGeneralVariable)((Object)binding)).redundant = true;
                }
            } else if (!binding.isGlobal()) {
                this.compileError("Variable is already declared in this template");
            }
        }
    }

    protected Value getSelectValue(Context context) throws TransformerException {
        if (this.select == null) {
            SingletonNodeSet singletonNodeSet;
            if (this.simpleText != null) {
                singletonNodeSet = new TextFragmentValue(this.simpleText, this.getSystemId(), context.getController());
            } else {
                Controller controller = context.getController();
                FragmentValue fragmentValue = new FragmentValue(controller);
                Outputter outputter = controller.getOutputter();
                controller.changeOutputDestination(null, fragmentValue.getEmitter());
                if (this.global && this.procedure.getNumberOfVariables() > 0) {
                    Bindery bindery = context.getBindery();
                    bindery.openStackFrame(new ParameterSet());
                    this.processChildren(context);
                    bindery.closeStackFrame();
                } else {
                    this.processChildren(context);
                }
                controller.resetOutputDestination(outputter);
                fragmentValue.setBaseURI(this.getSystemId());
                singletonNodeSet = fragmentValue;
            }
            if (this.forwardsCompatibleModeIsEnabled()) {
                singletonNodeSet.allowGeneralUse();
            }
            return singletonNodeSet;
        }
        context.setStaticContext(this.staticContext);
        Value value = this.select.evaluate(context);
        if (this.assignable && value instanceof NodeSetIntent) {
            value = new NodeSetExtent(((NodeSetIntent)value).enumerate(), (NodeOrderComparer)context.getController());
        }
        return value;
    }

    public Procedure getProcedure() {
        return this.procedure;
    }
}

