/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.Mode;
import com.icl.saxon.ParameterSet;
import com.icl.saxon.expr.ContextNodeExpression;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.PathExpression;
import com.icl.saxon.expr.Step;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NamespaceException;
import com.icl.saxon.om.Navigator;
import com.icl.saxon.pattern.AnyNodeTest;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.XSLSort;
import com.icl.saxon.style.XSLWithParam;
import com.icl.saxon.tree.AttributeCollection;
import com.icl.saxon.tree.NodeImpl;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;

public class XSLApplyTemplates
extends StyleElement {
    private Expression select;
    private boolean usesParams;
    private int modeNameCode = -1;
    private Mode mode;
    private String modeAttribute;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public void prepareAttributes() throws TransformerConfigurationException {
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            int n2 = n & 0xFFFFF;
            if (n2 == standardNames.MODE) {
                this.modeAttribute = attributeCollection.getValue(i);
                continue;
            }
            if (n2 == standardNames.SELECT) {
                string = attributeCollection.getValue(i);
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (this.modeAttribute != null) {
            if (Name.isQName(this.modeAttribute)) {
                try {
                    this.modeNameCode = this.makeNameCode(this.modeAttribute, false);
                }
                catch (NamespaceException namespaceException) {
                    this.compileError(namespaceException.getMessage());
                }
            } else if (this.forwardsCompatibleModeIsEnabled()) {
                this.modeAttribute = null;
            } else {
                this.compileError("Mode name is not a valid QName");
            }
        }
        if (string != null) {
            this.select = this.makeExpression(string);
        }
    }

    @Override
    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        this.mode = this.getPrincipalStyleSheet().getRuleManager().getMode(this.modeNameCode);
        boolean bl = false;
        for (NodeImpl nodeImpl = (NodeImpl)this.getFirstChild(); nodeImpl != null; nodeImpl = (NodeImpl)nodeImpl.getNextSibling()) {
            if (nodeImpl instanceof XSLSort) {
                bl = true;
                continue;
            }
            if (nodeImpl instanceof XSLWithParam) {
                this.usesParams = true;
                continue;
            }
            if (nodeImpl.getNodeType() == 3) {
                if (Navigator.isWhite(nodeImpl.getStringValue())) continue;
                this.compileError("No character data allowed within xsl:apply-templates");
                continue;
            }
            this.compileError("Invalid element within xsl:apply-templates: ");
        }
        if (this.select == null && bl) {
            this.select = new PathExpression(new ContextNodeExpression(), new Step(3, AnyNodeTest.getInstance()));
        }
        if (this.select != null) {
            this.select = this.handleSortKeys(this.select);
        }
    }

    @Override
    public void process(Context context) throws TransformerException {
        ParameterSet parameterSet = null;
        if (this.usesParams) {
            parameterSet = new ParameterSet();
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof XSLWithParam)) continue;
                XSLWithParam xSLWithParam = (XSLWithParam)node;
                parameterSet.put(xSLWithParam.getVariableFingerprint(), xSLWithParam.getParamValue(context));
            }
        }
        try {
            context.getController().applyTemplates(context, this.select, this.mode, parameterSet);
        }
        catch (StackOverflowError stackOverflowError) {
            throw new XPathException("Too many nested apply-templates calls");
        }
    }
}

