/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.pattern;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.KeyManager;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.Pattern;

public final class KeyPattern
extends Pattern {
    private int keyfingerprint;
    private String keyvalue;

    public KeyPattern(int n, String string) {
        this.keyfingerprint = n & 0xFFFFF;
        this.keyvalue = string;
    }

    @Override
    public boolean matches(NodeInfo nodeInfo, Context context) throws XPathException {
        DocumentInfo documentInfo = nodeInfo.getDocumentRoot();
        Controller controller = context.getController();
        KeyManager keyManager = controller.getKeyManager();
        NodeEnumeration nodeEnumeration = keyManager.selectByKey(this.keyfingerprint, documentInfo, this.keyvalue, controller);
        while (nodeEnumeration.hasMoreElements()) {
            if (!nodeEnumeration.nextElement().isSameNodeInfo(nodeInfo)) continue;
            return true;
        }
        return false;
    }
}

