/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.om;

import com.icl.saxon.Context;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.AxisEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.AnyNodeTest;
import com.icl.saxon.pattern.NameTest;
import com.icl.saxon.pattern.NodeTest;
import com.icl.saxon.pattern.NodeTypeTest;
import com.icl.saxon.pattern.Pattern;
import java.util.Vector;

public class Navigator {
    public static boolean isWhite(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c <= ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isAncestor(NodeInfo nodeInfo, NodeInfo nodeInfo2) {
        NodeInfo nodeInfo3 = nodeInfo2.getParent();
        if (nodeInfo3 == null) {
            return false;
        }
        if (nodeInfo3.isSameNodeInfo(nodeInfo)) {
            return true;
        }
        return Navigator.isAncestor(nodeInfo, nodeInfo3);
    }

    public static String getPath(NodeInfo nodeInfo) {
        switch (nodeInfo.getNodeType()) {
            case 9: {
                return "/";
            }
            case 1: {
                String string = Navigator.getPath(nodeInfo.getParent());
                return (string.equals("/") ? "" : string) + "/" + nodeInfo.getDisplayName() + "[" + Navigator.getNumberSimple(nodeInfo) + "]";
            }
            case 2: {
                return Navigator.getPath(nodeInfo.getParent()) + "/@" + nodeInfo.getDisplayName();
            }
            case 3: {
                String string = Navigator.getPath(nodeInfo.getParent());
                return (string.equals("/") ? "" : string) + "/text()[" + Navigator.getNumberSimple(nodeInfo) + "]";
            }
            case 8: {
                String string = Navigator.getPath(nodeInfo.getParent());
                return (string.equals("/") ? "" : string) + "/comment()[" + Navigator.getNumberSimple(nodeInfo) + "]";
            }
            case 7: {
                String string = Navigator.getPath(nodeInfo.getParent());
                return (string.equals("/") ? "" : string) + "/processing-instruction()[" + Navigator.getNumberSimple(nodeInfo) + "]";
            }
            case 13: {
                return Navigator.getPath(nodeInfo.getParent()) + "/namespace::" + nodeInfo.getLocalName();
            }
        }
        return "";
    }

    public static int getNumberSimple(NodeInfo nodeInfo, Context context) throws XPathException {
        int n = nodeInfo.getFingerprint();
        NodeTest nodeTest = n == -1 ? new NodeTypeTest(nodeInfo.getNodeType()) : new NameTest(nodeInfo);
        AxisEnumeration axisEnumeration = nodeInfo.getEnumeration((byte)11, nodeTest);
        int n2 = 1;
        while (axisEnumeration.hasMoreElements()) {
            NodeInfo nodeInfo2 = axisEnumeration.nextElement();
            int n3 = context.getRememberedNumber(nodeInfo2);
            if (n3 > 0) {
                context.setRememberedNumber(nodeInfo, n3 += n2);
                return n3;
            }
            ++n2;
        }
        context.setRememberedNumber(nodeInfo, n2);
        return n2;
    }

    public static int getNumberSimple(NodeInfo nodeInfo) {
        try {
            int n = nodeInfo.getFingerprint();
            NodeTest nodeTest = n == -1 ? new NodeTypeTest(nodeInfo.getNodeType()) : new NameTest(nodeInfo);
            AxisEnumeration axisEnumeration = nodeInfo.getEnumeration((byte)11, nodeTest);
            int n2 = 1;
            while (axisEnumeration.hasMoreElements()) {
                NodeInfo nodeInfo2 = axisEnumeration.nextElement();
                ++n2;
            }
            return n2;
        }
        catch (XPathException xPathException) {
            return 1;
        }
    }

    public static int getNumberSingle(NodeInfo nodeInfo, Pattern pattern, Pattern pattern2, Context context) throws XPathException {
        if (pattern == null && pattern2 == null) {
            return Navigator.getNumberSimple(nodeInfo, context);
        }
        boolean bl = false;
        if (pattern == null) {
            pattern = nodeInfo.getFingerprint() == -1 ? new NodeTypeTest(nodeInfo.getNodeType()) : new NameTest(nodeInfo);
            bl = true;
        }
        NodeInfo nodeInfo2 = nodeInfo;
        while (!bl && !pattern.matches(nodeInfo2, context)) {
            if ((nodeInfo2 = nodeInfo2.getParent()) == null) {
                return 0;
            }
            if (pattern2 == null || !pattern2.matches(nodeInfo2, context)) continue;
            return 0;
        }
        AxisEnumeration axisEnumeration = nodeInfo2.getEnumeration((byte)11, AnyNodeTest.getInstance());
        int n = 1;
        while (axisEnumeration.hasMoreElements()) {
            NodeInfo nodeInfo3 = axisEnumeration.nextElement();
            if (!pattern.matches(nodeInfo3, context)) continue;
            ++n;
        }
        return n;
    }

    public static int getNumberAny(NodeInfo nodeInfo, Pattern pattern, Pattern pattern2, Context context) throws XPathException {
        int n = 0;
        if (pattern == null) {
            pattern = nodeInfo.getFingerprint() == -1 ? new NodeTypeTest(nodeInfo.getNodeType()) : new NameTest(nodeInfo);
            n = 1;
        } else if (pattern.matches(nodeInfo, context)) {
            n = 1;
        }
        AxisEnumeration axisEnumeration = nodeInfo.getEnumeration((byte)13, AnyNodeTest.getInstance());
        while (axisEnumeration.hasMoreElements()) {
            NodeInfo nodeInfo2 = axisEnumeration.nextElement();
            if (pattern2 != null && pattern2.matches(nodeInfo2, context)) {
                return n;
            }
            if (!pattern.matches(nodeInfo2, context)) continue;
            ++n;
        }
        return n;
    }

    public static Vector getNumberMulti(NodeInfo nodeInfo, Pattern pattern, Pattern pattern2, Context context) throws XPathException {
        Vector<Integer> vector = new Vector<Integer>();
        if (pattern == null) {
            pattern = nodeInfo.getFingerprint() == -1 ? new NodeTypeTest(nodeInfo.getNodeType()) : new NameTest(nodeInfo);
        }
        NodeInfo nodeInfo2 = nodeInfo;
        do {
            if (!pattern.matches(nodeInfo2, context)) continue;
            int n = Navigator.getNumberSingle(nodeInfo2, pattern, null, context);
            vector.insertElementAt(new Integer(n), 0);
        } while ((nodeInfo2 = nodeInfo2.getParent()) != null && (pattern2 == null || !pattern2.matches(nodeInfo2, context)));
        return vector;
    }
}

