/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.NodeEnumeration;

public class LocalName
extends Function {
    @Override
    public String getName() {
        return "local-name";
    }

    @Override
    public int getDataType() {
        return 3;
    }

    @Override
    public Expression simplify() throws XPathException {
        int n = this.checkArgumentCount(0, 1);
        if (n == 1) {
            this.argument[0] = this.argument[0].simplify();
        }
        return this;
    }

    @Override
    public String evaluateAsString(Context context) throws XPathException {
        if (this.getNumberOfArguments() == 1) {
            NodeEnumeration nodeEnumeration = this.argument[0].enumerate(context, true);
            if (nodeEnumeration.hasMoreElements()) {
                return nodeEnumeration.nextElement().getLocalName();
            }
            return "";
        }
        return context.getContextNodeInfo().getLocalName();
    }

    @Override
    public Value evaluate(Context context) throws XPathException {
        return new StringValue(this.evaluateAsString(context));
    }

    @Override
    public int getDependencies() {
        if (this.getNumberOfArguments() == 1) {
            return this.argument[0].getDependencies();
        }
        return 8;
    }

    @Override
    public Expression reduce(int n, Context context) throws XPathException {
        if (this.getNumberOfArguments() == 1) {
            LocalName localName = new LocalName();
            localName.addArgument(this.argument[0].reduce(n, context));
            localName.setStaticContext(this.getStaticContext());
            return localName.simplify();
        }
        if ((n & 8) != 0) {
            return this.evaluate(context);
        }
        return this;
    }
}

