/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import com.icl.saxon.Controller;
import com.icl.saxon.output.ContentHandlerProxy;
import java.io.IOException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class Filter
implements XMLFilter {
    Controller controller;
    XMLReader parser;
    ContentHandler contentHandler;
    LexicalHandler lexicalHandler;

    protected Filter(Controller controller) {
        this.controller = controller;
    }

    @Override
    public void setParent(XMLReader xMLReader) {
        this.parser = xMLReader;
    }

    @Override
    public XMLReader getParent() {
        return this.parser;
    }

    @Override
    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/features/namespaces")) {
            return true;
        }
        if (string.equals("http://xml.org/sax/features/namespace-prefixes")) {
            return false;
        }
        throw new SAXNotRecognizedException(string);
    }

    @Override
    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/features/namespaces")) {
            if (!bl) {
                throw new SAXNotSupportedException(string);
            }
        } else if (string.equals("http://xml.org/sax/features/namespace-prefixes")) {
            if (bl) {
                throw new SAXNotSupportedException(string);
            }
        } else {
            throw new SAXNotRecognizedException(string);
        }
    }

    @Override
    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/properties/lexical-handler")) {
            return this.lexicalHandler;
        }
        throw new SAXNotRecognizedException(string);
    }

    @Override
    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/properties/lexical-handler")) {
            if (!(object instanceof LexicalHandler)) {
                throw new SAXNotSupportedException("Lexical Handler must be instance of org.xml.sax.ext.LexicalHandler");
            }
        } else {
            throw new SAXNotRecognizedException(string);
        }
        this.lexicalHandler = (LexicalHandler)object;
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
        if (contentHandler instanceof LexicalHandler && this.lexicalHandler == null) {
            this.lexicalHandler = (LexicalHandler)((Object)contentHandler);
        }
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public void setDTDHandler(DTDHandler dTDHandler) {
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    @Override
    public void parse(InputSource inputSource) throws IOException, SAXException {
        if (this.parser == null) {
            try {
                this.parser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            }
            catch (Exception exception) {
                throw new SAXException(exception);
            }
        }
        SAXSource sAXSource = new SAXSource();
        sAXSource.setInputSource(inputSource);
        sAXSource.setXMLReader(this.parser);
        ContentHandlerProxy contentHandlerProxy = new ContentHandlerProxy();
        contentHandlerProxy.setUnderlyingContentHandler(this.contentHandler);
        if (this.lexicalHandler != null) {
            contentHandlerProxy.setLexicalHandler(this.lexicalHandler);
        }
        try {
            this.controller.transform(sAXSource, contentHandlerProxy);
        }
        catch (TransformerException transformerException) {
            Throwable throwable = transformerException.getException();
            if (throwable != null && throwable instanceof SAXException) {
                throw (SAXException)throwable;
            }
            if (throwable != null && throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new SAXException(transformerException);
        }
    }

    @Override
    public void parse(String string) throws IOException, SAXException {
        InputSource inputSource = new InputSource(string);
        this.parse(inputSource);
    }
}

