/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.measurement;

import java.util.Hashtable;

public class Unit {
    private static final long UNITY = Unit.createType(0, 0, 0, 0, 0, 0, 0, 0, 0);
    private static final long ZERO = 64L;
    private static final long MASK = 127L;
    private static final int m_SHIFT = 0;
    private static final int s_SHIFT = 7;
    private static final int kg_SHIFT = 14;
    private static final int K_SHIFT = 21;
    private static final int A_SHIFT = 28;
    private static final int mol_SHIFT = 35;
    private static final int cd_SHIFT = 42;
    private static final int rad_SHIFT = 49;
    private static final int x_SHIFT = 56;
    private static final long x_MASK = 0x7F00000000000000L;
    public static final Unit unity = new Unit("", UNITY);
    public static final Unit m = new Unit("m", Unit.createType(0, 0, 0, 0, 0, 0, 0, 0, 1));
    public static final Unit s = new Unit("s", Unit.createType(0, 0, 0, 0, 0, 0, 0, 1, 0));
    public static final Unit kg = new Unit("kg", Unit.createType(0, 0, 0, 0, 0, 0, 1, 0, 0));
    public static final Unit K = new Unit("K", Unit.createType(0, 0, 0, 0, 0, 1, 0, 0, 0));
    public static final Unit A = new Unit("A", Unit.createType(0, 0, 0, 0, 1, 0, 0, 0, 0));
    public static final Unit mol = new Unit("mol", Unit.createType(0, 0, 0, 1, 0, 0, 0, 0, 0));
    public static final Unit cd = new Unit("cd", Unit.createType(0, 0, 1, 0, 0, 0, 0, 0, 0));
    public static final Unit m_s = new Unit("m/s", Unit.createType(0, 0, 0, 0, 0, 0, 0, -1, 1));
    public static final Unit m_s2 = new Unit("m/s2", Unit.createType(0, 0, 0, 0, 0, 0, 0, -2, 1));
    public static final Unit m2 = new Unit("m2", Unit.createType(0, 0, 0, 0, 0, 0, 0, 0, 2));
    public static final Unit m3 = new Unit("m3", Unit.createType(0, 0, 0, 0, 0, 0, 0, 0, 3));
    public static final Unit Hz = new Unit("Hz", Unit.createType(0, 0, 0, 0, 0, 0, 0, -1, 0));
    public static final Unit N = new Unit("N", Unit.createType(0, 0, 0, 0, 0, 0, 1, -2, 1));
    public static final Unit Pa = new Unit("Pa", Unit.createType(0, 0, 0, 0, 0, 0, 1, -2, -1));
    public static final Unit J = new Unit("J", Unit.createType(0, 0, 0, 0, 0, 0, 1, -2, 2));
    public static final Unit W = new Unit("W", Unit.createType(0, 0, 0, 0, 0, 0, 1, -3, 2));
    public static final Unit C = new Unit("C", Unit.createType(0, 0, 0, 0, 1, 0, 0, 1, 0));
    public static final Unit V = new Unit("V", Unit.createType(0, 0, 0, 0, -1, 0, 1, -3, 2));
    public static final Unit F = new Unit("F", Unit.createType(0, 0, 0, 0, 2, 0, -1, 4, -2));
    public static final Unit Ohm = new Unit("Ohm", Unit.createType(0, 0, 0, 0, -2, 0, 1, -3, 2));
    public static final Unit S = new Unit("S", Unit.createType(0, 0, 0, 0, 2, 0, -1, 3, -2));
    public static final Unit Wb = new Unit("Wb", Unit.createType(0, 0, 0, 0, -1, 0, 1, -2, 2));
    public static final Unit T = new Unit("T", Unit.createType(0, 0, 0, 0, -1, 0, 1, -2, 0));
    public static final Unit lx = new Unit("lx", Unit.createType(0, 0, 1, 0, 0, 0, 0, 0, -2));
    public static final Unit Gy = new Unit("Gy", Unit.createType(0, 0, 0, 0, 0, 0, 0, -2, 2));
    public static final Unit kat = new Unit("kat", Unit.createType(0, 0, 0, 1, 0, 0, 0, -1, 0));
    public static final Unit rad = new Unit("rad", Unit.createType(0, 1, 0, 0, 0, 0, 0, 0, 0));
    private static final Unit[] allUnits = new Unit[]{m, s, kg, K, A, mol, cd, rad, m_s, m_s2, m2, m3, Hz, N, Pa, J, W, C, V, F, Ohm, S, Wb, T, lx, Gy, kat, unity};
    private static Hashtable base;
    private final String name;
    private final long type;

    private Unit(String string, long l) {
        if (string == null) {
            string = Unit.computeName(l);
        }
        this.name = string;
        this.type = l;
    }

    private static long createType(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return (64L + (long)n9 & 0x7FL) << 0 | (64L + (long)n8 & 0x7FL) << 7 | (64L + (long)n7 & 0x7FL) << 14 | (64L + (long)n6 & 0x7FL) << 21 | (64L + (long)n5 & 0x7FL) << 28 | (64L + (long)n4 & 0x7FL) << 35 | (64L + (long)n3 & 0x7FL) << 42 | (64L + (long)n2 & 0x7FL) << 49 | (long)n << 56;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Unit)) {
            return false;
        }
        return ((Unit)object).type == this.type;
    }

    public int hashCode() {
        return 527 + (int)(this.type ^ this.type >>> 32);
    }

    Unit mul(Unit unit) {
        if (this.isSpecial() && unit.isSpecial()) {
            throw new ArithmeticException("Cannot multiply " + this + " with " + unit);
        }
        return Unit.find(this.type - UNITY + unit.type);
    }

    Unit div(Unit unit) {
        if (this.isSpecial() && unit.isSpecial()) {
            if (this.type == unit.type) {
                return unity;
            }
            throw new ArithmeticException("Cannot divide " + this + " by " + unit);
        }
        return Unit.find(this.type - unit.type + UNITY);
    }

    Unit add(Unit unit) {
        if (!this.equals(unit)) {
            throw new ArithmeticException("Cannot add " + this + " to " + unit);
        }
        return this;
    }

    Unit sub(Unit unit) {
        if (!this.equals(unit)) {
            throw new ArithmeticException("Cannot subtract " + unit + " from " + this);
        }
        return this;
    }

    static synchronized Unit find(long l) {
        Unit unit;
        Unit unit2;
        if (base == null) {
            int n = allUnits.length;
            base = new Hashtable(n << 1);
            for (int i = 0; i < n; ++i) {
                base.put(allUnits[i], allUnits[i]);
            }
        }
        if ((unit2 = (Unit)base.get(unit = new Unit(null, l))) == null) {
            base.put(unit, unit);
            unit2 = unit;
        }
        return unit2;
    }

    public String toString() {
        return this.name;
    }

    private static String computeName(long l) {
        int n = (int)((l >> 0 & 0x7FL) - 64L);
        int n2 = (int)((l >> 7 & 0x7FL) - 64L);
        int n3 = (int)((l >> 14 & 0x7FL) - 64L);
        int n4 = (int)((l >> 21 & 0x7FL) - 64L);
        int n5 = (int)((l >> 28 & 0x7FL) - 64L);
        int n6 = (int)((l >> 35 & 0x7FL) - 64L);
        int n7 = (int)((l >> 42 & 0x7FL) - 64L);
        int n8 = (int)((l >> 49 & 0x7FL) - 64L);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        Unit.addSIname(n, "m", stringBuffer, stringBuffer2);
        Unit.addSIname(n2, "s", stringBuffer, stringBuffer2);
        Unit.addSIname(n3, "kg", stringBuffer, stringBuffer2);
        Unit.addSIname(n4, "K", stringBuffer, stringBuffer2);
        Unit.addSIname(n5, "A", stringBuffer, stringBuffer2);
        Unit.addSIname(n6, "mol", stringBuffer, stringBuffer2);
        Unit.addSIname(n7, "cd", stringBuffer, stringBuffer2);
        Unit.addSIname(n8, "rad", stringBuffer, stringBuffer2);
        if (stringBuffer2.length() > 0) {
            if (stringBuffer.length() == 0) {
                stringBuffer.append("1");
            }
            stringBuffer.append("/");
            stringBuffer.append(stringBuffer2.toString());
        }
        return stringBuffer.toString();
    }

    private static void addSIname(int n, String string, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        if (n != 0) {
            StringBuffer stringBuffer3;
            StringBuffer stringBuffer4 = stringBuffer3 = n > 0 ? stringBuffer : stringBuffer2;
            if (stringBuffer3.length() > 0) {
                stringBuffer3.append("*");
            }
            stringBuffer3.append(string);
            int n2 = Math.abs(n);
            if (n2 > 1) {
                stringBuffer3.append("^");
                stringBuffer3.append(n2);
            }
        }
    }

    private boolean isSpecial() {
        return (this.type & 0x7F00000000000000L) != 0L;
    }
}

