/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.remoteserviceadmin;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.remoteserviceadmin.EndpointPermission;

final class EndpointPermissionCollection
extends PermissionCollection {
    static final long serialVersionUID = 662615640374640621L;
    private Map<String, EndpointPermission> permissions = new HashMap<String, EndpointPermission>();
    private boolean all_allowed = false;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", HashMap.class), new ObjectStreamField("all_allowed", Boolean.TYPE)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Permission permission) {
        if (!(permission instanceof EndpointPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        EndpointPermission endpointPermission = (EndpointPermission)permission;
        if (endpointPermission.endpoint != null) {
            throw new IllegalArgumentException("cannot add to collection: " + endpointPermission);
        }
        String string = endpointPermission.getName();
        EndpointPermissionCollection endpointPermissionCollection = this;
        synchronized (endpointPermissionCollection) {
            Map<String, EndpointPermission> map = this.permissions;
            EndpointPermission endpointPermission2 = map.get(string);
            if (endpointPermission2 != null) {
                int n = endpointPermission2.action_mask;
                int n2 = endpointPermission.action_mask;
                if (n != n2) {
                    map.put(string, new EndpointPermission(string, n | n2));
                }
            } else {
                map.put(string, endpointPermission);
            }
            if (!this.all_allowed && string.equals("*")) {
                this.all_allowed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(Permission permission) {
        Collection<EndpointPermission> collection;
        if (!(permission instanceof EndpointPermission)) {
            return false;
        }
        EndpointPermission endpointPermission = (EndpointPermission)permission;
        if (endpointPermission.filter != null) {
            return false;
        }
        int n = 0;
        Object object = this;
        synchronized (object) {
            EndpointPermission endpointPermission2;
            int n2 = endpointPermission.action_mask;
            if (this.all_allowed && (endpointPermission2 = this.permissions.get("*")) != null && ((n |= endpointPermission2.action_mask) & n2) == n2) {
                return true;
            }
            collection = this.permissions.values();
        }
        object = collection.iterator();
        while (object.hasNext()) {
            if (!((EndpointPermission)object.next()).implies0(endpointPermission, n)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized Enumeration<Permission> elements() {
        ArrayList<EndpointPermission> arrayList = new ArrayList<EndpointPermission>(this.permissions.values());
        return Collections.enumeration(arrayList);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("permissions", this.permissions);
        putField.put("all_allowed", this.all_allowed);
        objectOutputStream.writeFields();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        HashMap hashMap;
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.permissions = hashMap = (HashMap)getField.get("permissions", new HashMap());
        this.all_allowed = getField.get("all_allowed", false);
    }
}

