/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification;

import org.mockito.exceptions.base.MockitoAssertionError;
import org.mockito.exceptions.verification.junit.ArgumentsAreDifferent;
import org.mockito.internal.util.Timer;
import org.mockito.internal.verification.AtMost;
import org.mockito.internal.verification.NoMoreInteractions;
import org.mockito.internal.verification.api.VerificationData;
import org.mockito.verification.VerificationMode;

public class VerificationOverTimeImpl
implements VerificationMode {
    private final long pollingPeriodMillis;
    private final long durationMillis;
    private final VerificationMode delegate;
    private final boolean returnOnSuccess;
    private final Timer timer;

    public VerificationOverTimeImpl(long l, long l2, VerificationMode verificationMode, boolean bl) {
        this.pollingPeriodMillis = l;
        this.durationMillis = l2;
        this.delegate = verificationMode;
        this.returnOnSuccess = bl;
        this.timer = new Timer(l2);
    }

    public VerificationOverTimeImpl(long l, long l2, VerificationMode verificationMode, boolean bl, Timer timer) {
        this.pollingPeriodMillis = l;
        this.durationMillis = l2;
        this.delegate = verificationMode;
        this.returnOnSuccess = bl;
        this.timer = timer;
    }

    @Override
    public void verify(VerificationData verificationData) {
        AssertionError assertionError = null;
        this.timer.start();
        while (this.timer.isCounting()) {
            try {
                this.delegate.verify(verificationData);
                if (this.returnOnSuccess) {
                    return;
                }
                assertionError = null;
            }
            catch (MockitoAssertionError mockitoAssertionError) {
                assertionError = this.handleVerifyException(mockitoAssertionError);
            }
            catch (ArgumentsAreDifferent argumentsAreDifferent) {
                assertionError = this.handleVerifyException((AssertionError)((Object)argumentsAreDifferent));
            }
        }
        if (assertionError != null) {
            throw assertionError;
        }
    }

    private AssertionError handleVerifyException(AssertionError assertionError) {
        if (this.canRecoverFromFailure(this.delegate)) {
            this.sleep(this.pollingPeriodMillis);
            return assertionError;
        }
        throw assertionError;
    }

    protected boolean canRecoverFromFailure(VerificationMode verificationMode) {
        return !(verificationMode instanceof AtMost) && !(verificationMode instanceof NoMoreInteractions);
    }

    private void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public long getPollingPeriod() {
        return this.pollingPeriodMillis;
    }

    public long getDuration() {
        return this.durationMillis;
    }

    public VerificationMode getDelegate() {
        return this.delegate;
    }
}

