/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util.io;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.LinkedList;
import org.mockito.exceptions.base.MockitoException;

public class IOUtil {
    public static void writeText(String string, File file) {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(file));
            printWriter.write(string);
        }
        catch (Exception exception) {
            try {
                throw new MockitoException("Problems writing text to file: " + file, exception);
            }
            catch (Throwable throwable) {
                IOUtil.close(printWriter);
                throw throwable;
            }
        }
        IOUtil.close(printWriter);
    }

    public static Collection<String> readLines(InputStream inputStream) {
        LinkedList<String> linkedList = new LinkedList<String>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                linkedList.add(string);
            }
        }
        catch (IOException iOException) {
            throw new MockitoException("Problems reading from: " + inputStream, iOException);
        }
        return linkedList;
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            IOUtil.close(closeable);
        }
        catch (MockitoException mockitoException) {
            // empty catch block
        }
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                throw new MockitoException("Problems closing stream: " + closeable, iOException);
            }
        }
    }
}

