/*
 * Decompiled with CFR 0.152.
 */
package tightvnc;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.zip.Inflater;
import tightvnc.InStream;
import tightvnc.MemInStream;
import tightvnc.RfbProto;
import tightvnc.VncViewer;
import tightvnc.ZlibInStream;

class VncCanvas
extends Canvas
implements KeyListener,
MouseListener,
MouseMotionListener {
    VncViewer viewer;
    RfbProto rfb;
    ColorModel cm8;
    ColorModel cm24;
    Color[] colors;
    int bytesPixel;
    int maxWidth = 0;
    int maxHeight = 0;
    int scalingFactor;
    int scaledWidth;
    int scaledHeight;
    Image memImage;
    Graphics memGraphics;
    Image rawPixelsImage;
    MemoryImageSource pixelsSource;
    byte[] pixels8;
    int[] pixels24;
    long statStartTime;
    int statNumUpdates;
    int statNumTotalRects;
    int statNumPixelRects;
    int statNumRectsTight;
    int statNumRectsTightJPEG;
    int statNumRectsZRLE;
    int statNumRectsHextile;
    int statNumRectsRaw;
    int statNumRectsCopy;
    int statNumBytesEncoded;
    int statNumBytesDecoded;
    byte[] zrleBuf;
    int zrleBufLen = 0;
    byte[] zrleTilePixels8;
    int[] zrleTilePixels24;
    ZlibInStream zrleInStream;
    boolean zrleRecWarningShown = false;
    byte[] zlibBuf;
    int zlibBufLen = 0;
    Inflater zlibInflater;
    static final int tightZlibBufferSize = 512;
    Inflater[] tightInflaters;
    Rectangle jpegRect;
    boolean inputEnabled;
    private Color hextile_bg;
    private Color hextile_fg;
    boolean showSoftCursor = false;
    MemoryImageSource softCursorSource;
    Image softCursor;
    int cursorX = 0;
    int cursorY = 0;
    int cursorWidth;
    int cursorHeight;
    int origCursorWidth;
    int origCursorHeight;
    int hotX;
    int hotY;
    int origHotX;
    int origHotY;

    public VncCanvas(VncViewer v, int maxWidth_, int maxHeight_) throws IOException {
        this.viewer = v;
        this.maxWidth = maxWidth_;
        this.maxHeight = maxHeight_;
        this.rfb = this.viewer.rfb;
        this.scalingFactor = this.viewer.options.scalingFactor;
        this.tightInflaters = new Inflater[4];
        this.cm8 = new DirectColorModel(8, 7, 56, 192);
        this.cm24 = new DirectColorModel(24, 0xFF0000, 65280, 255);
        this.colors = new Color[256];
        for (int i = 0; i < 256; ++i) {
            this.colors[i] = new Color(this.cm8.getRGB(i));
        }
        this.setPixelFormat();
        this.inputEnabled = false;
        if (!this.viewer.options.viewOnly) {
            this.enableInput(true);
        }
        this.addKeyListener(this);
    }

    public VncCanvas(VncViewer v) throws IOException {
        this(v, 0, 0);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.scaledWidth, this.scaledHeight);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.scaledWidth, this.scaledHeight);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(this.scaledWidth, this.scaledHeight);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        int y0;
        int x0;
        Rectangle r;
        Image image = this.memImage;
        synchronized (image) {
            if (this.rfb.framebufferWidth == this.scaledWidth) {
                g.drawImage(this.memImage, 0, 0, null);
            } else {
                this.paintScaledFrameBuffer(g);
            }
        }
        if (this.showSoftCursor && (r = new Rectangle(x0 = this.cursorX - this.hotX, y0 = this.cursorY - this.hotY, this.cursorWidth, this.cursorHeight)).intersects(g.getClipBounds())) {
            g.drawImage(this.softCursor, x0, y0, null);
        }
    }

    public void paintScaledFrameBuffer(Graphics g) {
        g.drawImage(this.memImage, 0, 0, this.scaledWidth, this.scaledHeight, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 0xA0) == 0) {
            return true;
        }
        if ((infoflags & 0x20) != 0 && this.jpegRect != null) {
            Rectangle rectangle = this.jpegRect;
            synchronized (rectangle) {
                this.memGraphics.drawImage(img, this.jpegRect.x, this.jpegRect.y, null);
                this.scheduleRepaint(this.jpegRect.x, this.jpegRect.y, this.jpegRect.width, this.jpegRect.height);
                this.jpegRect.notify();
            }
        }
        return false;
    }

    public synchronized void enableInput(boolean enable) {
        if (enable && !this.inputEnabled) {
            this.inputEnabled = true;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            if (this.viewer.showControls) {
                this.viewer.buttonPanel.enableRemoteAccessControls(true);
            }
            this.createSoftCursor();
        } else if (!enable && this.inputEnabled) {
            this.inputEnabled = false;
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this);
            if (this.viewer.showControls) {
                this.viewer.buttonPanel.enableRemoteAccessControls(false);
            }
            this.createSoftCursor();
        }
    }

    public void setPixelFormat() throws IOException {
        if (this.viewer.options.eightBitColors) {
            this.rfb.writeSetPixelFormat(8, 8, false, true, 7, 7, 3, 0, 3, 6);
            this.bytesPixel = 1;
        } else {
            this.rfb.writeSetPixelFormat(32, 24, false, true, 255, 255, 255, 16, 8, 0);
            this.bytesPixel = 4;
        }
        this.updateFramebufferSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateFramebufferSize() {
        int fbWidth = this.rfb.framebufferWidth;
        int fbHeight = this.rfb.framebufferHeight;
        if (this.maxWidth > 0 && this.maxHeight > 0) {
            int f1 = this.maxWidth * 100 / fbWidth;
            int f2 = this.maxHeight * 100 / fbHeight;
            this.scalingFactor = Math.min(f1, f2);
            if (this.scalingFactor > 100) {
                this.scalingFactor = 100;
            }
            System.out.println("Scaling desktop at " + this.scalingFactor + "%");
        }
        this.scaledWidth = (fbWidth * this.scalingFactor + 50) / 100;
        this.scaledHeight = (fbHeight * this.scalingFactor + 50) / 100;
        if (this.memImage == null) {
            this.memImage = this.viewer.vncContainer.createImage(fbWidth, fbHeight);
            this.memGraphics = this.memImage.getGraphics();
        } else if (this.memImage.getWidth(null) != fbWidth || this.memImage.getHeight(null) != fbHeight) {
            Image image = this.memImage;
            synchronized (image) {
                this.memImage = this.viewer.vncContainer.createImage(fbWidth, fbHeight);
                this.memGraphics = this.memImage.getGraphics();
            }
        }
        if (this.bytesPixel == 1) {
            this.pixels24 = null;
            this.pixels8 = new byte[fbWidth * fbHeight];
            this.pixelsSource = new MemoryImageSource(fbWidth, fbHeight, this.cm8, this.pixels8, 0, fbWidth);
            this.zrleTilePixels24 = null;
            this.zrleTilePixels8 = new byte[4096];
        } else {
            this.pixels8 = null;
            this.pixels24 = new int[fbWidth * fbHeight];
            this.pixelsSource = new MemoryImageSource(fbWidth, fbHeight, this.cm24, this.pixels24, 0, fbWidth);
            this.zrleTilePixels8 = null;
            this.zrleTilePixels24 = new int[4096];
        }
        this.pixelsSource.setAnimated(true);
        this.rawPixelsImage = Toolkit.getDefaultToolkit().createImage(this.pixelsSource);
        if (this.viewer.inSeparateFrame) {
            if (this.viewer.desktopScrollPane != null) {
                this.resizeDesktopFrame();
            }
        } else {
            this.setSize(this.scaledWidth, this.scaledHeight);
        }
        this.viewer.moveFocusToDesktop();
    }

    void resizeDesktopFrame() {
        Dimension frameSize;
        this.setSize(this.scaledWidth, this.scaledHeight);
        Insets insets = this.viewer.desktopScrollPane.getInsets();
        this.viewer.desktopScrollPane.setSize(this.scaledWidth + 2 * Math.min(insets.left, insets.right), this.scaledHeight + 2 * Math.min(insets.top, insets.bottom));
        this.viewer.vncFrame.pack();
        Dimension screenSize = this.viewer.vncFrame.getToolkit().getScreenSize();
        Dimension newSize = frameSize = this.viewer.vncFrame.getSize();
        screenSize.height -= 30;
        screenSize.width -= 30;
        boolean needToResizeFrame = false;
        if (frameSize.height > screenSize.height) {
            newSize.height = screenSize.height;
            needToResizeFrame = true;
        }
        if (frameSize.width > screenSize.width) {
            newSize.width = screenSize.width;
            needToResizeFrame = true;
        }
        if (needToResizeFrame) {
            this.viewer.vncFrame.setSize(newSize);
        }
        this.viewer.desktopScrollPane.doLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void processNormalProtocol() throws Exception {
        this.viewer.checkRecordingStatus();
        this.rfb.writeFramebufferUpdateRequest(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight, false);
        this.resetStats();
        statsRestarted = false;
        block21: while (true) {
            msgType = this.rfb.readServerMessageType();
            switch (msgType) {
                case 0: {
                    if (this.statNumUpdates == this.viewer.debugStatsExcludeUpdates && !statsRestarted) {
                        this.resetStats();
                        statsRestarted = true;
                    } else if (this.statNumUpdates == this.viewer.debugStatsMeasureUpdates && statsRestarted) {
                        this.viewer.disconnect();
                    }
                    this.rfb.readFramebufferUpdate();
                    ++this.statNumUpdates;
                    cursorPosReceived = false;
                    for (i = 0; i < this.rfb.updateNRects; ++i) {
                        this.rfb.readFramebufferUpdateRectHdr();
                        ++this.statNumTotalRects;
                        rx = this.rfb.updateRectX;
                        ry = this.rfb.updateRectY;
                        rw = this.rfb.updateRectW;
                        rh = this.rfb.updateRectH;
                        if (this.rfb.updateRectEncoding == -224) break;
                        if (this.rfb.updateRectEncoding == -223) {
                            this.rfb.setFramebufferSize(rw, rh);
                            this.updateFramebufferSize();
                            break;
                        }
                        if (this.rfb.updateRectEncoding == -240) ** GOTO lbl36
                        if (this.rfb.updateRectEncoding != -239) ** GOTO lbl38
lbl36:
                        // 2 sources

                        this.handleCursorShapeUpdate(this.rfb.updateRectEncoding, rx, ry, rw, rh);
                        continue;
lbl38:
                        // 1 sources

                        if (this.rfb.updateRectEncoding == -232) {
                            this.softCursorMove(rx, ry);
                            cursorPosReceived = true;
                            continue;
                        }
                        numBytesReadBefore = this.rfb.getNumBytesRead();
                        this.rfb.startTiming();
                        switch (this.rfb.updateRectEncoding) {
                            case 0: {
                                ++this.statNumRectsRaw;
                                this.handleRawRect(rx, ry, rw, rh);
                                break;
                            }
                            case 1: {
                                ++this.statNumRectsCopy;
                                this.handleCopyRect(rx, ry, rw, rh);
                                break;
                            }
                            case 2: {
                                this.handleRRERect(rx, ry, rw, rh);
                                break;
                            }
                            case 4: {
                                this.handleCoRRERect(rx, ry, rw, rh);
                                break;
                            }
                            case 5: {
                                ++this.statNumRectsHextile;
                                this.handleHextileRect(rx, ry, rw, rh);
                                break;
                            }
                            case 16: {
                                ++this.statNumRectsZRLE;
                                this.handleZRLERect(rx, ry, rw, rh);
                                break;
                            }
                            case 6: {
                                this.handleZlibRect(rx, ry, rw, rh);
                                break;
                            }
                            case 7: {
                                ++this.statNumRectsTight;
                                this.handleTightRect(rx, ry, rw, rh);
                                break;
                            }
                            default: {
                                throw new Exception("Unknown RFB rectangle encoding " + this.rfb.updateRectEncoding);
                            }
                        }
                        this.rfb.stopTiming();
                        ++this.statNumPixelRects;
                        this.statNumBytesDecoded += rw * rh * this.bytesPixel;
                        this.statNumBytesEncoded += (int)(this.rfb.getNumBytesRead() - numBytesReadBefore);
                    }
                    fullUpdateNeeded = false;
                    if (this.viewer.checkRecordingStatus()) {
                        fullUpdateNeeded = true;
                    }
                    if (this.viewer.deferUpdateRequests > 0 && this.rfb.available() == 0 && !cursorPosReceived) {
                        rx = this.rfb;
                        synchronized (rx) {
                            try {
                                this.rfb.wait(this.viewer.deferUpdateRequests);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        }
                    }
                    this.viewer.autoSelectEncodings();
                    if (this.viewer.options.eightBitColors != (this.bytesPixel == 1)) {
                        this.setPixelFormat();
                        fullUpdateNeeded = true;
                    }
                    w = this.rfb.framebufferWidth;
                    h = this.rfb.framebufferHeight;
                    this.rfb.writeFramebufferUpdateRequest(0, 0, w, h, fullUpdateNeeded == false);
                    continue block21;
                }
                case 1: {
                    throw new Exception("Can't handle SetColourMapEntries message");
                }
                case 2: {
                    Toolkit.getDefaultToolkit().beep();
                    continue block21;
                }
                case 3: {
                    s = this.rfb.readServerCutText();
                    this.viewer.clipboard.setCutText(s);
                    continue block21;
                }
            }
            break;
        }
        throw new Exception("Unknown RFB message type " + msgType);
    }

    void handleRawRect(int x, int y, int w, int h) throws IOException {
        this.handleRawRect(x, y, w, h, true);
    }

    void handleRawRect(int x, int y, int w, int h, boolean paint) throws IOException {
        if (this.bytesPixel == 1) {
            for (int dy = y; dy < y + h; ++dy) {
                this.rfb.readFully(this.pixels8, dy * this.rfb.framebufferWidth + x, w);
                if (this.rfb.rec == null) continue;
                this.rfb.rec.write(this.pixels8, dy * this.rfb.framebufferWidth + x, w);
            }
        } else {
            byte[] buf = new byte[w * 4];
            for (int dy = y; dy < y + h; ++dy) {
                this.rfb.readFully(buf);
                if (this.rfb.rec != null) {
                    this.rfb.rec.write(buf);
                }
                int offset = dy * this.rfb.framebufferWidth + x;
                for (int i = 0; i < w; ++i) {
                    this.pixels24[offset + i] = (buf[i * 4 + 2] & 0xFF) << 16 | (buf[i * 4 + 1] & 0xFF) << 8 | buf[i * 4] & 0xFF;
                }
            }
        }
        this.handleUpdatedPixels(x, y, w, h);
        if (paint) {
            this.scheduleRepaint(x, y, w, h);
        }
    }

    void handleCopyRect(int x, int y, int w, int h) throws IOException {
        this.rfb.readCopyRect();
        this.memGraphics.copyArea(this.rfb.copyRectSrcX, this.rfb.copyRectSrcY, w, h, x - this.rfb.copyRectSrcX, y - this.rfb.copyRectSrcY);
        this.scheduleRepaint(x, y, w, h);
    }

    void handleRRERect(int x, int y, int w, int h) throws IOException {
        int nSubrects = this.rfb.readU32();
        byte[] bg_buf = new byte[this.bytesPixel];
        this.rfb.readFully(bg_buf);
        Color pixel = this.bytesPixel == 1 ? this.colors[bg_buf[0] & 0xFF] : new Color(bg_buf[2] & 0xFF, bg_buf[1] & 0xFF, bg_buf[0] & 0xFF);
        this.memGraphics.setColor(pixel);
        this.memGraphics.fillRect(x, y, w, h);
        byte[] buf = new byte[nSubrects * (this.bytesPixel + 8)];
        this.rfb.readFully(buf);
        DataInputStream ds = new DataInputStream(new ByteArrayInputStream(buf));
        if (this.rfb.rec != null) {
            this.rfb.rec.writeIntBE(nSubrects);
            this.rfb.rec.write(bg_buf);
            this.rfb.rec.write(buf);
        }
        for (int j = 0; j < nSubrects; ++j) {
            if (this.bytesPixel == 1) {
                pixel = this.colors[ds.readUnsignedByte()];
            } else {
                ds.skip(4L);
                pixel = new Color(buf[j * 12 + 2] & 0xFF, buf[j * 12 + 1] & 0xFF, buf[j * 12] & 0xFF);
            }
            int sx = x + ds.readUnsignedShort();
            int sy = y + ds.readUnsignedShort();
            int sw = ds.readUnsignedShort();
            int sh = ds.readUnsignedShort();
            this.memGraphics.setColor(pixel);
            this.memGraphics.fillRect(sx, sy, sw, sh);
        }
        this.scheduleRepaint(x, y, w, h);
    }

    void handleCoRRERect(int x, int y, int w, int h) throws IOException {
        int nSubrects = this.rfb.readU32();
        byte[] bg_buf = new byte[this.bytesPixel];
        this.rfb.readFully(bg_buf);
        Color pixel = this.bytesPixel == 1 ? this.colors[bg_buf[0] & 0xFF] : new Color(bg_buf[2] & 0xFF, bg_buf[1] & 0xFF, bg_buf[0] & 0xFF);
        this.memGraphics.setColor(pixel);
        this.memGraphics.fillRect(x, y, w, h);
        byte[] buf = new byte[nSubrects * (this.bytesPixel + 4)];
        this.rfb.readFully(buf);
        if (this.rfb.rec != null) {
            this.rfb.rec.writeIntBE(nSubrects);
            this.rfb.rec.write(bg_buf);
            this.rfb.rec.write(buf);
        }
        int i = 0;
        for (int j = 0; j < nSubrects; ++j) {
            if (this.bytesPixel == 1) {
                pixel = this.colors[buf[i++] & 0xFF];
            } else {
                pixel = new Color(buf[i + 2] & 0xFF, buf[i + 1] & 0xFF, buf[i] & 0xFF);
                i += 4;
            }
            int sx = x + (buf[i++] & 0xFF);
            int sy = y + (buf[i++] & 0xFF);
            int sw = buf[i++] & 0xFF;
            int sh = buf[i++] & 0xFF;
            this.memGraphics.setColor(pixel);
            this.memGraphics.fillRect(sx, sy, sw, sh);
        }
        this.scheduleRepaint(x, y, w, h);
    }

    void handleHextileRect(int x, int y, int w, int h) throws IOException {
        this.hextile_bg = new Color(0);
        this.hextile_fg = new Color(0);
        for (int ty = y; ty < y + h; ty += 16) {
            int th = 16;
            if (y + h - ty < 16) {
                th = y + h - ty;
            }
            for (int tx = x; tx < x + w; tx += 16) {
                int tw = 16;
                if (x + w - tx < 16) {
                    tw = x + w - tx;
                }
                this.handleHextileSubrect(tx, ty, tw, th);
            }
            this.scheduleRepaint(x, y, w, h);
        }
    }

    void handleHextileSubrect(int tx, int ty, int tw, int th) throws IOException {
        int subencoding = this.rfb.readU8();
        if (this.rfb.rec != null) {
            this.rfb.rec.writeByte(subencoding);
        }
        if ((subencoding & 1) != 0) {
            this.handleRawRect(tx, ty, tw, th, false);
            return;
        }
        byte[] cbuf = new byte[this.bytesPixel];
        if ((subencoding & 2) != 0) {
            this.rfb.readFully(cbuf);
            this.hextile_bg = this.bytesPixel == 1 ? this.colors[cbuf[0] & 0xFF] : new Color(cbuf[2] & 0xFF, cbuf[1] & 0xFF, cbuf[0] & 0xFF);
            if (this.rfb.rec != null) {
                this.rfb.rec.write(cbuf);
            }
        }
        this.memGraphics.setColor(this.hextile_bg);
        this.memGraphics.fillRect(tx, ty, tw, th);
        if ((subencoding & 4) != 0) {
            this.rfb.readFully(cbuf);
            this.hextile_fg = this.bytesPixel == 1 ? this.colors[cbuf[0] & 0xFF] : new Color(cbuf[2] & 0xFF, cbuf[1] & 0xFF, cbuf[0] & 0xFF);
            if (this.rfb.rec != null) {
                this.rfb.rec.write(cbuf);
            }
        }
        if ((subencoding & 8) == 0) {
            return;
        }
        int nSubrects = this.rfb.readU8();
        int bufsize = nSubrects * 2;
        if ((subencoding & 0x10) != 0) {
            bufsize += nSubrects * this.bytesPixel;
        }
        byte[] buf = new byte[bufsize];
        this.rfb.readFully(buf);
        if (this.rfb.rec != null) {
            this.rfb.rec.writeByte(nSubrects);
            this.rfb.rec.write(buf);
        }
        int i = 0;
        if ((subencoding & 0x10) == 0) {
            this.memGraphics.setColor(this.hextile_fg);
            for (int j = 0; j < nSubrects; ++j) {
                int b1 = buf[i++] & 0xFF;
                int b2 = buf[i++] & 0xFF;
                int sx = tx + (b1 >> 4);
                int sy = ty + (b1 & 0xF);
                int sw = (b2 >> 4) + 1;
                int sh = (b2 & 0xF) + 1;
                this.memGraphics.fillRect(sx, sy, sw, sh);
            }
        } else if (this.bytesPixel == 1) {
            for (int j = 0; j < nSubrects; ++j) {
                this.hextile_fg = this.colors[buf[i++] & 0xFF];
                int b1 = buf[i++] & 0xFF;
                int b2 = buf[i++] & 0xFF;
                int sx = tx + (b1 >> 4);
                int sy = ty + (b1 & 0xF);
                int sw = (b2 >> 4) + 1;
                int sh = (b2 & 0xF) + 1;
                this.memGraphics.setColor(this.hextile_fg);
                this.memGraphics.fillRect(sx, sy, sw, sh);
            }
        } else {
            for (int j = 0; j < nSubrects; ++j) {
                this.hextile_fg = new Color(buf[i + 2] & 0xFF, buf[i + 1] & 0xFF, buf[i] & 0xFF);
                i += 4;
                int b1 = buf[i++] & 0xFF;
                int b2 = buf[i++] & 0xFF;
                int sx = tx + (b1 >> 4);
                int sy = ty + (b1 & 0xF);
                int sw = (b2 >> 4) + 1;
                int sh = (b2 & 0xF) + 1;
                this.memGraphics.setColor(this.hextile_fg);
                this.memGraphics.fillRect(sx, sy, sw, sh);
            }
        }
    }

    void handleZRLERect(int x, int y, int w, int h) throws Exception {
        int nBytes;
        if (this.zrleInStream == null) {
            this.zrleInStream = new ZlibInStream();
        }
        if ((nBytes = this.rfb.readU32()) > 0x4000000) {
            throw new Exception("ZRLE decoder: illegal compressed data size");
        }
        if (this.zrleBuf == null || this.zrleBufLen < nBytes) {
            this.zrleBufLen = nBytes + 4096;
            this.zrleBuf = new byte[this.zrleBufLen];
        }
        this.rfb.readFully(this.zrleBuf, 0, nBytes);
        if (this.rfb.rec != null) {
            if (this.rfb.recordFromBeginning) {
                this.rfb.rec.writeIntBE(nBytes);
                this.rfb.rec.write(this.zrleBuf, 0, nBytes);
            } else if (!this.zrleRecWarningShown) {
                System.out.println("Warning: ZRLE session can be recorded only from the beginning");
                System.out.println("Warning: Recorded file may be corrupted");
                this.zrleRecWarningShown = true;
            }
        }
        this.zrleInStream.setUnderlying(new MemInStream(this.zrleBuf, 0, nBytes), nBytes);
        for (int ty = y; ty < y + h; ty += 64) {
            int th = Math.min(y + h - ty, 64);
            for (int tx = x; tx < x + w; tx += 64) {
                int tw = Math.min(x + w - tx, 64);
                int mode = this.zrleInStream.readU8();
                boolean rle = (mode & 0x80) != 0;
                int palSize = mode & 0x7F;
                int[] palette = new int[128];
                this.readZrlePalette(palette, palSize);
                if (palSize == 1) {
                    int pix = palette[0];
                    Color c = this.bytesPixel == 1 ? this.colors[pix] : new Color(0xFF000000 | pix);
                    this.memGraphics.setColor(c);
                    this.memGraphics.fillRect(tx, ty, tw, th);
                    continue;
                }
                if (!rle) {
                    if (palSize == 0) {
                        this.readZrleRawPixels(tw, th);
                    } else {
                        this.readZrlePackedPixels(tw, th, palette, palSize);
                    }
                } else if (palSize == 0) {
                    this.readZrlePlainRLEPixels(tw, th);
                } else {
                    this.readZrlePackedRLEPixels(tw, th, palette);
                }
                this.handleUpdatedZrleTile(tx, ty, tw, th);
            }
        }
        this.zrleInStream.reset();
        this.scheduleRepaint(x, y, w, h);
    }

    int readPixel(InStream is) throws Exception {
        int pix;
        if (this.bytesPixel == 1) {
            pix = is.readU8();
        } else {
            int p1 = is.readU8();
            int p2 = is.readU8();
            int p3 = is.readU8();
            pix = (p3 & 0xFF) << 16 | (p2 & 0xFF) << 8 | p1 & 0xFF;
        }
        return pix;
    }

    void readPixels(InStream is, int[] dst, int count) throws Exception {
        if (this.bytesPixel == 1) {
            byte[] buf = new byte[count];
            is.readBytes(buf, 0, count);
            for (int i = 0; i < count; ++i) {
                dst[i] = buf[i] & 0xFF;
            }
        } else {
            byte[] buf = new byte[count * 3];
            is.readBytes(buf, 0, count * 3);
            for (int i = 0; i < count; ++i) {
                dst[i] = (buf[i * 3 + 2] & 0xFF) << 16 | (buf[i * 3 + 1] & 0xFF) << 8 | buf[i * 3] & 0xFF;
            }
        }
    }

    void readZrlePalette(int[] palette, int palSize) throws Exception {
        this.readPixels(this.zrleInStream, palette, palSize);
    }

    void readZrleRawPixels(int tw, int th) throws Exception {
        if (this.bytesPixel == 1) {
            this.zrleInStream.readBytes(this.zrleTilePixels8, 0, tw * th);
        } else {
            this.readPixels(this.zrleInStream, this.zrleTilePixels24, tw * th);
        }
    }

    void readZrlePackedPixels(int tw, int th, int[] palette, int palSize) throws Exception {
        int bppp = palSize > 16 ? 8 : (palSize > 4 ? 4 : (palSize > 2 ? 2 : 1));
        int ptr = 0;
        for (int i = 0; i < th; ++i) {
            int eol = ptr + tw;
            int b = 0;
            int nbits = 0;
            while (ptr < eol) {
                if (nbits == 0) {
                    b = this.zrleInStream.readU8();
                    nbits = 8;
                }
                int index = b >> (nbits -= bppp) & (1 << bppp) - 1 & 0x7F;
                if (this.bytesPixel == 1) {
                    this.zrleTilePixels8[ptr++] = (byte)palette[index];
                    continue;
                }
                this.zrleTilePixels24[ptr++] = palette[index];
            }
        }
    }

    void readZrlePlainRLEPixels(int tw, int th) throws Exception {
        int ptr = 0;
        int end = ptr + tw * th;
        while (ptr < end) {
            int b;
            int pix = this.readPixel(this.zrleInStream);
            int len = 1;
            do {
                b = this.zrleInStream.readU8();
                len += b;
            } while (b == 255);
            if (len > end - ptr) {
                throw new Exception("ZRLE decoder: assertion failed (len <= end-ptr)");
            }
            if (this.bytesPixel == 1) {
                while (len-- > 0) {
                    this.zrleTilePixels8[ptr++] = (byte)pix;
                }
                continue;
            }
            while (len-- > 0) {
                this.zrleTilePixels24[ptr++] = pix;
            }
        }
    }

    void readZrlePackedRLEPixels(int tw, int th, int[] palette) throws Exception {
        int ptr = 0;
        int end = ptr + tw * th;
        while (ptr < end) {
            int index = this.zrleInStream.readU8();
            int len = 1;
            if ((index & 0x80) != 0) {
                int b;
                do {
                    b = this.zrleInStream.readU8();
                    len += b;
                } while (b == 255);
                if (len > end - ptr) {
                    throw new Exception("ZRLE decoder: assertion failed (len <= end - ptr)");
                }
            }
            int pix = palette[index &= 0x7F];
            if (this.bytesPixel == 1) {
                while (len-- > 0) {
                    this.zrleTilePixels8[ptr++] = (byte)pix;
                }
                continue;
            }
            while (len-- > 0) {
                this.zrleTilePixels24[ptr++] = pix;
            }
        }
    }

    void handleUpdatedZrleTile(int x, int y, int w, int h) {
        Object[] dst;
        Object[] src;
        if (this.bytesPixel == 1) {
            src = this.zrleTilePixels8;
            dst = this.pixels8;
        } else {
            src = this.zrleTilePixels24;
            dst = this.pixels24;
        }
        int offsetSrc = 0;
        int offsetDst = y * this.rfb.framebufferWidth + x;
        for (int j = 0; j < h; ++j) {
            System.arraycopy(src, offsetSrc, dst, offsetDst, w);
            offsetSrc += w;
            offsetDst += this.rfb.framebufferWidth;
        }
        this.handleUpdatedPixels(x, y, w, h);
    }

    void handleZlibRect(int x, int y, int w, int h) throws Exception {
        int nBytes = this.rfb.readU32();
        if (this.zlibBuf == null || this.zlibBufLen < nBytes) {
            this.zlibBufLen = nBytes * 2;
            this.zlibBuf = new byte[this.zlibBufLen];
        }
        this.rfb.readFully(this.zlibBuf, 0, nBytes);
        if (this.rfb.rec != null && this.rfb.recordFromBeginning) {
            this.rfb.rec.writeIntBE(nBytes);
            this.rfb.rec.write(this.zlibBuf, 0, nBytes);
        }
        if (this.zlibInflater == null) {
            this.zlibInflater = new Inflater();
        }
        this.zlibInflater.setInput(this.zlibBuf, 0, nBytes);
        if (this.bytesPixel == 1) {
            for (int dy = y; dy < y + h; ++dy) {
                this.zlibInflater.inflate(this.pixels8, dy * this.rfb.framebufferWidth + x, w);
                if (this.rfb.rec == null || this.rfb.recordFromBeginning) continue;
                this.rfb.rec.write(this.pixels8, dy * this.rfb.framebufferWidth + x, w);
            }
        } else {
            byte[] buf = new byte[w * 4];
            for (int dy = y; dy < y + h; ++dy) {
                this.zlibInflater.inflate(buf);
                int offset = dy * this.rfb.framebufferWidth + x;
                for (int i = 0; i < w; ++i) {
                    this.pixels24[offset + i] = (buf[i * 4 + 2] & 0xFF) << 16 | (buf[i * 4 + 1] & 0xFF) << 8 | buf[i * 4] & 0xFF;
                }
                if (this.rfb.rec == null || this.rfb.recordFromBeginning) continue;
                this.rfb.rec.write(buf);
            }
        }
        this.handleUpdatedPixels(x, y, w, h);
        this.scheduleRepaint(x, y, w, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void handleTightRect(int x, int y, int w, int h) throws Exception {
        block72: {
            comp_ctl = this.rfb.readU8();
            if (this.rfb.rec == null) break block72;
            if (this.rfb.recordFromBeginning) ** GOTO lbl-1000
            if (comp_ctl == 8 << 4) ** GOTO lbl-1000
            if (comp_ctl == 9 << 4) lbl-1000:
            // 3 sources

            {
                this.rfb.rec.writeByte(comp_ctl);
            } else {
                this.rfb.rec.writeByte(comp_ctl | 15);
            }
        }
        for (stream_id = 0; stream_id < 4; ++stream_id) {
            if ((comp_ctl & 1) != 0 && this.tightInflaters[stream_id] != null) {
                this.tightInflaters[stream_id] = null;
            }
            comp_ctl >>= 1;
        }
        if (comp_ctl > 9) {
            throw new Exception("Incorrect tight subencoding: " + comp_ctl);
        }
        if (comp_ctl == 8) {
            if (this.bytesPixel == 1) {
                idx = this.rfb.readU8();
                this.memGraphics.setColor(this.colors[idx]);
                if (this.rfb.rec != null) {
                    this.rfb.rec.writeByte(idx);
                }
            } else {
                buf = new byte[3];
                this.rfb.readFully(buf);
                if (this.rfb.rec != null) {
                    this.rfb.rec.write(buf);
                }
                bg = new Color(-16777216 | (buf[0] & 255) << 16 | (buf[1] & 255) << 8 | buf[2] & 255);
                this.memGraphics.setColor(bg);
            }
            this.memGraphics.fillRect(x, y, w, h);
            this.scheduleRepaint(x, y, w, h);
            return;
        }
        if (comp_ctl == 9) {
            ++this.statNumRectsTightJPEG;
            jpegData = new byte[this.rfb.readCompactLen()];
            this.rfb.readFully(jpegData);
            if (this.rfb.rec != null) {
                if (!this.rfb.recordFromBeginning) {
                    this.rfb.recordCompactLen(jpegData.length);
                }
                this.rfb.rec.write(jpegData);
            }
            jpegImage = Toolkit.getDefaultToolkit().createImage(jpegData);
            var8_12 = this.jpegRect = new Rectangle(x, y, w, h);
            synchronized (var8_12) {
                Toolkit.getDefaultToolkit().prepareImage(jpegImage, -1, -1, this);
                try {
                    this.jpegRect.wait(3000L);
                }
                catch (InterruptedException e) {
                    throw new Exception("Interrupted while decoding JPEG image");
                }
            }
            this.jpegRect = null;
            return;
        }
        numColors = 0;
        rowSize = w;
        palette8 = new byte[2];
        palette24 = new int[256];
        useGradient = false;
        if ((comp_ctl & 4) != 0) {
            filter_id = this.rfb.readU8();
            if (this.rfb.rec != null) {
                this.rfb.rec.writeByte(filter_id);
            }
            if (filter_id == 1) {
                numColors = this.rfb.readU8() + 1;
                if (this.rfb.rec != null) {
                    this.rfb.rec.writeByte(numColors - 1);
                }
                if (this.bytesPixel == 1) {
                    if (numColors != 2) {
                        throw new Exception("Incorrect tight palette size: " + numColors);
                    }
                    this.rfb.readFully(palette8);
                    if (this.rfb.rec != null) {
                        this.rfb.rec.write(palette8);
                    }
                } else {
                    buf = new byte[numColors * 3];
                    this.rfb.readFully(buf);
                    if (this.rfb.rec != null) {
                        this.rfb.rec.write(buf);
                    }
                    for (i = 0; i < numColors; ++i) {
                        palette24[i] = (buf[i * 3] & 255) << 16 | (buf[i * 3 + 1] & 255) << 8 | buf[i * 3 + 2] & 255;
                    }
                }
                if (numColors == 2) {
                    rowSize = (w + 7) / 8;
                }
            } else if (filter_id == 2) {
                useGradient = true;
            } else if (filter_id != 0) {
                throw new Exception("Incorrect tight filter id: " + filter_id);
            }
        }
        if (numColors == 0 && this.bytesPixel == 4) {
            rowSize *= 3;
        }
        dataSize = h * rowSize;
        if (dataSize < 12) {
            if (numColors != 0) {
                indexedData = new byte[dataSize];
                this.rfb.readFully(indexedData);
                if (this.rfb.rec != null) {
                    this.rfb.rec.write(indexedData);
                }
                if (numColors == 2) {
                    if (this.bytesPixel == 1) {
                        this.decodeMonoData(x, y, w, h, indexedData, palette8);
                    } else {
                        this.decodeMonoData(x, y, w, h, indexedData, palette24);
                    }
                } else {
                    i = 0;
                    for (dy = y; dy < y + h; ++dy) {
                        for (dx = x; dx < x + w; ++dx) {
                            this.pixels24[dy * this.rfb.framebufferWidth + dx] = palette24[indexedData[i++] & 255];
                        }
                    }
                }
            } else if (useGradient) {
                buf = new byte[w * h * 3];
                this.rfb.readFully(buf);
                if (this.rfb.rec != null) {
                    this.rfb.rec.write(buf);
                }
                this.decodeGradientData(x, y, w, h, buf);
            } else if (this.bytesPixel == 1) {
                for (dy = y; dy < y + h; ++dy) {
                    this.rfb.readFully(this.pixels8, dy * this.rfb.framebufferWidth + x, w);
                    if (this.rfb.rec == null) continue;
                    this.rfb.rec.write(this.pixels8, dy * this.rfb.framebufferWidth + x, w);
                }
            } else {
                buf = new byte[w * 3];
                for (dy = y; dy < y + h; ++dy) {
                    this.rfb.readFully(buf);
                    if (this.rfb.rec != null) {
                        this.rfb.rec.write(buf);
                    }
                    offset = dy * this.rfb.framebufferWidth + x;
                    for (i = 0; i < w; ++i) {
                        this.pixels24[offset + i] = (buf[i * 3] & 255) << 16 | (buf[i * 3 + 1] & 255) << 8 | buf[i * 3 + 2] & 255;
                    }
                }
            }
        } else {
            zlibDataLen = this.rfb.readCompactLen();
            zlibData = new byte[zlibDataLen];
            this.rfb.readFully(zlibData);
            if (this.rfb.rec != null && this.rfb.recordFromBeginning) {
                this.rfb.rec.write(zlibData);
            }
            if (this.tightInflaters[stream_id = comp_ctl & 3] == null) {
                this.tightInflaters[stream_id] = new Inflater();
            }
            myInflater = this.tightInflaters[stream_id];
            myInflater.setInput(zlibData);
            buf = new byte[dataSize];
            myInflater.inflate(buf);
            if (this.rfb.rec != null && !this.rfb.recordFromBeginning) {
                this.rfb.recordCompressedData(buf);
            }
            if (numColors != 0) {
                if (numColors == 2) {
                    if (this.bytesPixel == 1) {
                        this.decodeMonoData(x, y, w, h, buf, palette8);
                    } else {
                        this.decodeMonoData(x, y, w, h, buf, palette24);
                    }
                } else {
                    i = 0;
                    for (dy = y; dy < y + h; ++dy) {
                        for (dx = x; dx < x + w; ++dx) {
                            this.pixels24[dy * this.rfb.framebufferWidth + dx] = palette24[buf[i++] & 255];
                        }
                    }
                }
            } else if (useGradient) {
                this.decodeGradientData(x, y, w, h, buf);
            } else if (this.bytesPixel == 1) {
                destOffset = y * this.rfb.framebufferWidth + x;
                for (dy = 0; dy < h; ++dy) {
                    System.arraycopy(buf, dy * w, this.pixels8, destOffset, w);
                    destOffset += this.rfb.framebufferWidth;
                }
            } else {
                srcOffset = 0;
                for (dy = 0; dy < h; ++dy) {
                    myInflater.inflate(buf);
                    destOffset = (y + dy) * this.rfb.framebufferWidth + x;
                    for (i = 0; i < w; ++i) {
                        this.pixels24[destOffset + i] = (buf[srcOffset] & 255) << 16 | (buf[srcOffset + 1] & 255) << 8 | buf[srcOffset + 2] & 255;
                        srcOffset += 3;
                    }
                }
            }
        }
        this.handleUpdatedPixels(x, y, w, h);
        this.scheduleRepaint(x, y, w, h);
    }

    void decodeMonoData(int x, int y, int w, int h, byte[] src, byte[] palette) {
        int i = y * this.rfb.framebufferWidth + x;
        int rowBytes = (w + 7) / 8;
        for (int dy = 0; dy < h; ++dy) {
            int n;
            int dx;
            for (dx = 0; dx < w / 8; ++dx) {
                byte b = src[dy * rowBytes + dx];
                for (n = 7; n >= 0; --n) {
                    this.pixels8[i++] = palette[b >> n & 1];
                }
            }
            for (n = 7; n >= 8 - w % 8; --n) {
                this.pixels8[i++] = palette[src[dy * rowBytes + dx] >> n & 1];
            }
            i += this.rfb.framebufferWidth - w;
        }
    }

    void decodeMonoData(int x, int y, int w, int h, byte[] src, int[] palette) {
        int i = y * this.rfb.framebufferWidth + x;
        int rowBytes = (w + 7) / 8;
        for (int dy = 0; dy < h; ++dy) {
            int n;
            int dx;
            for (dx = 0; dx < w / 8; ++dx) {
                byte b = src[dy * rowBytes + dx];
                for (n = 7; n >= 0; --n) {
                    this.pixels24[i++] = palette[b >> n & 1];
                }
            }
            for (n = 7; n >= 8 - w % 8; --n) {
                this.pixels24[i++] = palette[src[dy * rowBytes + dx] >> n & 1];
            }
            i += this.rfb.framebufferWidth - w;
        }
    }

    void decodeGradientData(int x, int y, int w, int h, byte[] buf) {
        byte[] prevRow = new byte[w * 3];
        byte[] thisRow = new byte[w * 3];
        byte[] pix = new byte[3];
        int[] est = new int[3];
        int offset = y * this.rfb.framebufferWidth + x;
        for (int dy = 0; dy < h; ++dy) {
            int c;
            for (c = 0; c < 3; ++c) {
                pix[c] = (byte)(prevRow[c] + buf[dy * w * 3 + c]);
                thisRow[c] = pix[c];
            }
            this.pixels24[offset++] = (pix[0] & 0xFF) << 16 | (pix[1] & 0xFF) << 8 | pix[2] & 0xFF;
            for (int dx = 1; dx < w; ++dx) {
                for (c = 0; c < 3; ++c) {
                    est[c] = (prevRow[dx * 3 + c] & 0xFF) + (pix[c] & 0xFF) - (prevRow[(dx - 1) * 3 + c] & 0xFF);
                    if (est[c] > 255) {
                        est[c] = 255;
                    } else if (est[c] < 0) {
                        est[c] = 0;
                    }
                    pix[c] = (byte)(est[c] + buf[(dy * w + dx) * 3 + c]);
                    thisRow[dx * 3 + c] = pix[c];
                }
                this.pixels24[offset++] = (pix[0] & 0xFF) << 16 | (pix[1] & 0xFF) << 8 | pix[2] & 0xFF;
            }
            System.arraycopy(thisRow, 0, prevRow, 0, w * 3);
            offset += this.rfb.framebufferWidth - w;
        }
    }

    void handleUpdatedPixels(int x, int y, int w, int h) {
        this.pixelsSource.newPixels(x, y, w, h);
        this.memGraphics.setClip(x, y, w, h);
        this.memGraphics.drawImage(this.rawPixelsImage, 0, 0, null);
        this.memGraphics.setClip(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight);
    }

    void scheduleRepaint(int x, int y, int w, int h) {
        if (this.rfb.framebufferWidth == this.scaledWidth) {
            this.repaint(this.viewer.deferScreenUpdates, x, y, w, h);
        } else {
            int sx = x * this.scalingFactor / 100;
            int sy = y * this.scalingFactor / 100;
            int sw = ((x + w) * this.scalingFactor + 49) / 100 - sx + 1;
            int sh = ((y + h) * this.scalingFactor + 49) / 100 - sy + 1;
            this.repaint(this.viewer.deferScreenUpdates, sx, sy, sw, sh);
        }
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        this.processLocalKeyEvent(evt);
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        this.processLocalKeyEvent(evt);
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        evt.consume();
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.processLocalMouseEvent(evt, false);
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.processLocalMouseEvent(evt, false);
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        this.processLocalMouseEvent(evt, true);
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        this.processLocalMouseEvent(evt, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLocalKeyEvent(KeyEvent evt) {
        if (this.viewer.rfb != null && this.rfb.inNormalProtocol) {
            if (!this.inputEnabled) {
                if ((evt.getKeyChar() == 'r' || evt.getKeyChar() == 'R') && evt.getID() == 401) {
                    try {
                        this.rfb.writeFramebufferUpdateRequest(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight, false);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                RfbProto rfbProto = this.rfb;
                synchronized (rfbProto) {
                    try {
                        this.rfb.writeKeyEvent(evt);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.rfb.notify();
                }
            }
        }
        evt.consume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLocalMouseEvent(MouseEvent evt, boolean moved) {
        if (this.viewer.rfb != null && this.rfb.inNormalProtocol) {
            if (moved) {
                this.softCursorMove(evt.getX(), evt.getY());
            }
            if (this.rfb.framebufferWidth != this.scaledWidth) {
                int sx = (evt.getX() * 100 + this.scalingFactor / 2) / this.scalingFactor;
                int sy = (evt.getY() * 100 + this.scalingFactor / 2) / this.scalingFactor;
                evt.translatePoint(sx - evt.getX(), sy - evt.getY());
            }
            RfbProto rfbProto = this.rfb;
            synchronized (rfbProto) {
                try {
                    this.rfb.writePointerEvent(evt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.rfb.notify();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    void resetStats() {
        this.statStartTime = System.currentTimeMillis();
        this.statNumUpdates = 0;
        this.statNumTotalRects = 0;
        this.statNumPixelRects = 0;
        this.statNumRectsTight = 0;
        this.statNumRectsTightJPEG = 0;
        this.statNumRectsZRLE = 0;
        this.statNumRectsHextile = 0;
        this.statNumRectsRaw = 0;
        this.statNumRectsCopy = 0;
        this.statNumBytesEncoded = 0;
        this.statNumBytesDecoded = 0;
    }

    synchronized void handleCursorShapeUpdate(int encodingType, int xhot, int yhot, int width, int height) throws IOException {
        this.softCursorFree();
        if (width * height == 0) {
            return;
        }
        if (this.viewer.options.ignoreCursorUpdates) {
            int bytesPerRow = (width + 7) / 8;
            int bytesMaskData = bytesPerRow * height;
            if (encodingType == -240) {
                this.rfb.skipBytes(6 + bytesMaskData * 2);
            } else {
                this.rfb.skipBytes(width * height * this.bytesPixel + bytesMaskData);
            }
            return;
        }
        this.softCursorSource = this.decodeCursorShape(encodingType, width, height);
        this.origCursorWidth = width;
        this.origCursorHeight = height;
        this.origHotX = xhot;
        this.origHotY = yhot;
        this.createSoftCursor();
        this.showSoftCursor = true;
        this.repaint(this.viewer.deferCursorUpdates, this.cursorX - this.hotX, this.cursorY - this.hotY, this.cursorWidth, this.cursorHeight);
    }

    synchronized MemoryImageSource decodeCursorShape(int encodingType, int width, int height) throws IOException {
        int bytesPerRow = (width + 7) / 8;
        int bytesMaskData = bytesPerRow * height;
        int[] softCursorPixels = new int[width * height];
        if (encodingType == -240) {
            byte[] rgb = new byte[6];
            this.rfb.readFully(rgb);
            int[] colors = new int[]{0xFF000000 | (rgb[3] & 0xFF) << 16 | (rgb[4] & 0xFF) << 8 | rgb[5] & 0xFF, 0xFF000000 | (rgb[0] & 0xFF) << 16 | (rgb[1] & 0xFF) << 8 | rgb[2] & 0xFF};
            byte[] pixBuf = new byte[bytesMaskData];
            this.rfb.readFully(pixBuf);
            byte[] maskBuf = new byte[bytesMaskData];
            this.rfb.readFully(maskBuf);
            int i = 0;
            for (int y = 0; y < height; ++y) {
                int result;
                int n;
                int x;
                for (x = 0; x < width / 8; ++x) {
                    byte pixByte = pixBuf[y * bytesPerRow + x];
                    byte maskByte = maskBuf[y * bytesPerRow + x];
                    for (n = 7; n >= 0; --n) {
                        result = (maskByte >> n & 1) != 0 ? colors[pixByte >> n & 1] : 0;
                        softCursorPixels[i++] = result;
                    }
                }
                for (n = 7; n >= 8 - width % 8; --n) {
                    result = (maskBuf[y * bytesPerRow + x] >> n & 1) != 0 ? colors[pixBuf[y * bytesPerRow + x] >> n & 1] : 0;
                    softCursorPixels[i++] = result;
                }
            }
        } else {
            byte[] pixBuf = new byte[width * height * this.bytesPixel];
            this.rfb.readFully(pixBuf);
            byte[] maskBuf = new byte[bytesMaskData];
            this.rfb.readFully(maskBuf);
            int i = 0;
            for (int y = 0; y < height; ++y) {
                int result;
                int n;
                int x;
                for (x = 0; x < width / 8; ++x) {
                    byte maskByte = maskBuf[y * bytesPerRow + x];
                    for (n = 7; n >= 0; --n) {
                        result = (maskByte >> n & 1) != 0 ? (this.bytesPixel == 1 ? this.cm8.getRGB(pixBuf[i]) : 0xFF000000 | (pixBuf[i * 4 + 2] & 0xFF) << 16 | (pixBuf[i * 4 + 1] & 0xFF) << 8 | pixBuf[i * 4] & 0xFF) : 0;
                        softCursorPixels[i++] = result;
                    }
                }
                for (n = 7; n >= 8 - width % 8; --n) {
                    result = (maskBuf[y * bytesPerRow + x] >> n & 1) != 0 ? (this.bytesPixel == 1 ? this.cm8.getRGB(pixBuf[i]) : 0xFF000000 | (pixBuf[i * 4 + 2] & 0xFF) << 16 | (pixBuf[i * 4 + 1] & 0xFF) << 8 | pixBuf[i * 4] & 0xFF) : 0;
                    softCursorPixels[i++] = result;
                }
            }
        }
        return new MemoryImageSource(width, height, softCursorPixels, 0, width);
    }

    synchronized void createSoftCursor() {
        if (this.softCursorSource == null) {
            return;
        }
        int scaleCursor = this.viewer.options.scaleCursor;
        if (scaleCursor == 0 || !this.inputEnabled) {
            scaleCursor = 100;
        }
        int x = this.cursorX - this.hotX;
        int y = this.cursorY - this.hotY;
        int w = this.cursorWidth;
        int h = this.cursorHeight;
        this.cursorWidth = (this.origCursorWidth * scaleCursor + 50) / 100;
        this.cursorHeight = (this.origCursorHeight * scaleCursor + 50) / 100;
        this.hotX = (this.origHotX * scaleCursor + 50) / 100;
        this.hotY = (this.origHotY * scaleCursor + 50) / 100;
        this.softCursor = Toolkit.getDefaultToolkit().createImage(this.softCursorSource);
        if (scaleCursor != 100) {
            this.softCursor = this.softCursor.getScaledInstance(this.cursorWidth, this.cursorHeight, 4);
        }
        if (this.showSoftCursor) {
            x = Math.min(x, this.cursorX - this.hotX);
            y = Math.min(y, this.cursorY - this.hotY);
            w = Math.max(w, this.cursorWidth);
            h = Math.max(h, this.cursorHeight);
            this.repaint(this.viewer.deferCursorUpdates, x, y, w, h);
        }
    }

    synchronized void softCursorMove(int x, int y) {
        int oldX = this.cursorX;
        int oldY = this.cursorY;
        this.cursorX = x;
        this.cursorY = y;
        if (this.showSoftCursor) {
            this.repaint(this.viewer.deferCursorUpdates, oldX - this.hotX, oldY - this.hotY, this.cursorWidth, this.cursorHeight);
            this.repaint(this.viewer.deferCursorUpdates, this.cursorX - this.hotX, this.cursorY - this.hotY, this.cursorWidth, this.cursorHeight);
        }
    }

    synchronized void softCursorFree() {
        if (this.showSoftCursor) {
            this.showSoftCursor = false;
            this.softCursor = null;
            this.softCursorSource = null;
            this.repaint(this.viewer.deferCursorUpdates, this.cursorX - this.hotX, this.cursorY - this.hotY, this.cursorWidth, this.cursorHeight);
        }
    }
}

