/*
 * Decompiled with CFR 0.152.
 */
package rfb;

import rdr.InStream;
import rdr.ZlibInStream;
import rfb.CMsgHandler;
import rfb.CMsgReader;
import rfb.Decoder;
import rfb.Exception;

public class ZRLEDecoder
extends Decoder {
    static final int BPP = 8;
    CMsgReader reader;
    ZlibInStream zis;

    public ZRLEDecoder(CMsgReader reader_) {
        this.reader = reader_;
        this.zis = new ZlibInStream();
    }

    static final int readPixel(InStream is) {
        return is.readU8();
    }

    @Override
    public void readRect(int x, int y, int w, int h, CMsgHandler handler) {
        InStream is = this.reader.getInStream();
        byte[] buf = this.reader.getImageBuf(16384, 0);
        int length = is.readU32();
        this.zis.setUnderlying(is, length);
        for (int ty = y; ty < y + h; ty += 64) {
            int th = Math.min(y + h - ty, 64);
            for (int tx = x; tx < x + w; tx += 64) {
                int len;
                int end;
                int ptr;
                int b;
                int tw = Math.min(x + w - tx, 64);
                int mode = this.zis.readU8();
                boolean rle = (mode & 0x80) != 0;
                int palSize = mode & 0x7F;
                int[] palette = new int[128];
                for (int i = 0; i < palSize; ++i) {
                    palette[i] = ZRLEDecoder.readPixel(this.zis);
                }
                if (palSize == 1) {
                    int pix = palette[0];
                    handler.fillRect(tx, ty, tw, th, pix);
                    continue;
                }
                if (!rle) {
                    if (palSize == 0) {
                        this.zis.readBytes(buf, 0, tw * th * 1);
                    } else {
                        int bppp = palSize > 16 ? 8 : (palSize > 4 ? 4 : (palSize > 2 ? 2 : 1));
                        int ptr2 = 0;
                        for (int i = 0; i < th; ++i) {
                            int eol = ptr2 + tw;
                            b = 0;
                            int nbits = 0;
                            while (ptr2 < eol) {
                                if (nbits == 0) {
                                    b = this.zis.readU8();
                                    nbits = 8;
                                }
                                int index = b >> (nbits -= bppp) & (1 << bppp) - 1 & 0x7F;
                                buf[ptr2++] = (byte)palette[index];
                            }
                        }
                    }
                } else if (palSize == 0) {
                    ptr = 0;
                    end = ptr + tw * th;
                    while (ptr < end) {
                        int pix = ZRLEDecoder.readPixel(this.zis);
                        len = 1;
                        do {
                            b = this.zis.readU8();
                            len += b;
                        } while (b == 255);
                        if (len > end - ptr) {
                            throw new Exception("ZRLEDecoder: assertion (len <= end - ptr) failed");
                        }
                        while (len-- > 0) {
                            buf[ptr++] = (byte)pix;
                        }
                    }
                } else {
                    ptr = 0;
                    end = ptr + tw * th;
                    while (ptr < end) {
                        int index = this.zis.readU8();
                        len = 1;
                        if ((index & 0x80) != 0) {
                            do {
                                b = this.zis.readU8();
                                len += b;
                            } while (b == 255);
                            if (len > end - ptr) {
                                throw new Exception("ZRLEDecoder: assertion (len <= end - ptr) failed");
                            }
                        }
                        int pix = palette[index &= 0x7F];
                        while (len-- > 0) {
                            buf[ptr++] = (byte)pix;
                        }
                    }
                }
                handler.imageRect(tx, ty, tw, th, buf, 0);
            }
        }
        this.zis.reset();
    }
}

