/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.set;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections15.iterators.AbstractIteratorDecorator;
import org.apache.commons.collections15.list.UnmodifiableList;
import org.apache.commons.collections15.set.AbstractSerializableSetDecorator;

public class ListOrderedSet<E>
extends AbstractSerializableSetDecorator<E>
implements Set<E> {
    private static final long serialVersionUID = -228664372470420141L;
    protected final List<E> setOrder;

    public static <E> ListOrderedSet<E> decorate(Set<E> set, List<E> list) {
        if (set == null) {
            throw new IllegalArgumentException("Set must not be null");
        }
        if (list == null) {
            throw new IllegalArgumentException("List must not be null");
        }
        if (set.size() > 0 || list.size() > 0) {
            throw new IllegalArgumentException("Set and List must be empty");
        }
        return new ListOrderedSet<E>(set, list);
    }

    public static <E> ListOrderedSet<E> decorate(Set<E> set) {
        return new ListOrderedSet<E>(set);
    }

    public static <E> ListOrderedSet<E> decorate(List<E> list) {
        if (list == null) {
            throw new IllegalArgumentException("List must not be null");
        }
        HashSet<E> set = new HashSet<E>(list);
        list.retainAll(set);
        return new ListOrderedSet<E>(set, list);
    }

    public ListOrderedSet() {
        super(new HashSet());
        this.setOrder = new ArrayList();
    }

    protected ListOrderedSet(Set<E> set) {
        super(set);
        this.setOrder = new ArrayList<E>(set);
    }

    protected ListOrderedSet(Set<E> set, List<E> list) {
        super(set);
        if (list == null) {
            throw new IllegalArgumentException("List must not be null");
        }
        this.setOrder = list;
    }

    public List<E> asList() {
        return UnmodifiableList.decorate(this.setOrder);
    }

    @Override
    public void clear() {
        this.collection.clear();
        this.setOrder.clear();
    }

    @Override
    public Iterator<E> iterator() {
        return new OrderedSetIterator(this.setOrder.iterator(), this.collection);
    }

    @Override
    public boolean add(E object) {
        if (this.collection.contains(object)) {
            return this.collection.add(object);
        }
        boolean result = this.collection.add(object);
        this.setOrder.add(object);
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends E> coll) {
        boolean result = false;
        for (E object : coll) {
            result |= this.add(object);
        }
        return result;
    }

    @Override
    public boolean remove(Object object) {
        boolean result = this.collection.remove(object);
        this.setOrder.remove(object);
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        boolean result = false;
        for (Object object : coll) {
            result |= this.remove(object);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        boolean result = this.collection.retainAll(coll);
        if (!result) {
            return false;
        }
        if (this.collection.size() == 0) {
            this.setOrder.clear();
        } else {
            Iterator<E> it = this.setOrder.iterator();
            while (it.hasNext()) {
                E object = it.next();
                if (this.collection.contains(object)) continue;
                it.remove();
            }
        }
        return result;
    }

    @Override
    public Object[] toArray() {
        return this.setOrder.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.setOrder.toArray(a);
    }

    public E get(int index) {
        return this.setOrder.get(index);
    }

    public int indexOf(E object) {
        return this.setOrder.indexOf(object);
    }

    public void add(int index, E object) {
        if (!this.contains(object)) {
            this.collection.add(object);
            this.setOrder.add(index, object);
        }
    }

    public boolean addAll(int index, Collection<? extends E> coll) {
        boolean changed = false;
        for (E object : coll) {
            if (this.contains(object)) continue;
            this.collection.add(object);
            this.setOrder.add(index, object);
            ++index;
            changed = true;
        }
        return changed;
    }

    public E remove(int index) {
        E obj = this.setOrder.remove(index);
        this.remove(obj);
        return obj;
    }

    @Override
    public String toString() {
        return this.setOrder.toString();
    }

    static class OrderedSetIterator<E>
    extends AbstractIteratorDecorator<E> {
        protected final Collection<E> set;
        protected E last;

        private OrderedSetIterator(Iterator<E> iterator, Collection<E> set) {
            super(iterator);
            this.set = set;
        }

        @Override
        public E next() {
            this.last = this.iterator.next();
            return this.last;
        }

        @Override
        public void remove() {
            this.set.remove(this.last);
            this.iterator.remove();
            this.last = null;
        }
    }
}

