/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class FastArrayList<E>
extends ArrayList<E> {
    protected ArrayList<E> list = null;
    protected boolean fast = false;

    public FastArrayList() {
        this.list = new ArrayList();
    }

    public FastArrayList(int capacity) {
        this.list = new ArrayList(capacity);
    }

    public FastArrayList(Collection<E> collection) {
        this.list = new ArrayList<E>(collection);
    }

    public boolean getFast() {
        return this.fast;
    }

    public void setFast(boolean fast) {
        this.fast = fast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E element) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList temp = (ArrayList)this.list.clone();
                boolean result = temp.add(element);
                this.list = temp;
                return result;
            }
        }
        ArrayList<E> arrayList = this.list;
        synchronized (arrayList) {
            return this.list.add(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, E element) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList temp = (ArrayList)this.list.clone();
                temp.add(index, element);
                this.list = temp;
            }
        }
        ArrayList<E> arrayList = this.list;
        synchronized (arrayList) {
            this.list.add(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList temp = (ArrayList)this.list.clone();
                boolean result = temp.addAll(collection);
                this.list = temp;
                return result;
            }
        }
        ArrayList<E> arrayList = this.list;
        synchronized (arrayList) {
            return this.list.addAll(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends E> collection) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList temp = (ArrayList)this.list.clone();
                boolean result = temp.addAll(index, collection);
                this.list = temp;
                return result;
            }
        }
        ArrayList<E> arrayList = this.list;
        synchronized (arrayList) {
            return this.list.addAll(index, collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList temp = (ArrayList)this.list.clone();
                temp.clear();
                this.list = temp;
            }
        }
        ArrayList<E> arrayList = this.list;
        synchronized (arrayList) {
            this.list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object clone() {
        FastArrayList<E> results = null;
        if (this.fast) {
            results = new FastArrayList<E>(this.list);
        } else {
            ArrayList<E> arrayList = this.list;
            synchronized (arrayList) {
                results = new FastArrayList<E>(this.list);
            }
        }
        results.setFast(this.getFast());
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object element) {
        if (this.fast) {
            return this.list.contains(element);
        }
        ArrayList<E> arrayList = this.list;
        synchronized (arrayList) {
            return this.list.contains(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> collection) {
        if (this.fast) {
            return this.list.containsAll(collection);
        }
        ArrayList<E> arrayList = this.list;
        synchronized (arrayList) {
            return this.list.containsAll(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ensureCapacity(int capacity) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList temp = (ArrayList)this.list.clone();
                temp.ensureCapacity(capacity);
                this.list = temp;
            }
        }
        ArrayList<E> arrayList = this.list;
        synchronized (arrayList) {
            this.list.ensureCapacity(capacity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List lo = (List)o;
        if (this.fast) {
            ListIterator<E> li1 = this.list.listIterator();
            ListIterator li2 = lo.listIterator();
            while (li1.hasNext() && li2.hasNext()) {
                E o1 = li1.next();
                Object o2 = li2.next();
                if (o1 != null ? o1.equals(o2) : o2 == null) continue;
                return false;
            }
            return !li1.hasNext() && !li2.hasNext();
        }
        ArrayList<E> arrayList = this.list;
        synchronized (arrayList) {
            ListIterator<E> li1 = this.list.listIterator();
            ListIterator li2 = lo.listIterator();
            while (li1.hasNext() && li2.hasNext()) {
                E o1 = li1.next();
                Object o2 = li2.next();
                if (o1 != null ? o1.equals(o2) : o2 == null) continue;
                return false;
            }
            return !li1.hasNext() && !li2.hasNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(int index) {
        if (this.fast) {
            return this.list.get(index);
        }
        ArrayList<E> arrayList = this.list;
        synchronized (arrayList) {
            return this.list.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        if (this.fast) {
            int hashCode = 1;
            for (E o : this.list) {
                hashCode = 31 * hashCode + (o == null ? 0 : o.hashCode());
            }
            return hashCode;
        }
        ArrayList<E> arrayList = this.list;
        synchronized (arrayList) {
            int hashCode = 1;
            for (E o : this.list) {
                hashCode = 31 * hashCode + (o == null ? 0 : o.hashCode());
            }
            return hashCode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(Object element) {
        if (this.fast) {
            return this.list.indexOf(element);
        }
        ArrayList<E> arrayList = this.list;
        synchronized (arrayList) {
            return this.list.indexOf(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        if (this.fast) {
            return this.list.isEmpty();
        }
        ArrayList<E> arrayList = this.list;
        synchronized (arrayList) {
            return this.list.isEmpty();
        }
    }

    @Override
    public Iterator<E> iterator() {
        if (this.fast) {
            return new ListIter(0);
        }
        return this.list.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lastIndexOf(Object element) {
        if (this.fast) {
            return this.list.lastIndexOf(element);
        }
        ArrayList<E> arrayList = this.list;
        synchronized (arrayList) {
            return this.list.lastIndexOf(element);
        }
    }

    @Override
    public ListIterator<E> listIterator() {
        if (this.fast) {
            return new ListIter(0);
        }
        return this.list.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (this.fast) {
            return new ListIter(index);
        }
        return this.list.listIterator(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int index) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList temp = (ArrayList)this.list.clone();
                Object result = temp.remove(index);
                this.list = temp;
                return result;
            }
        }
        ArrayList<E> arrayList = this.list;
        synchronized (arrayList) {
            return this.list.remove(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object element) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList temp = (ArrayList)this.list.clone();
                boolean result = temp.remove(element);
                this.list = temp;
                return result;
            }
        }
        ArrayList<E> arrayList = this.list;
        synchronized (arrayList) {
            return this.list.remove(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> collection) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList temp = (ArrayList)this.list.clone();
                boolean result = temp.removeAll(collection);
                this.list = temp;
                return result;
            }
        }
        ArrayList<E> arrayList = this.list;
        synchronized (arrayList) {
            return this.list.removeAll(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> collection) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList temp = (ArrayList)this.list.clone();
                boolean result = temp.retainAll(collection);
                this.list = temp;
                return result;
            }
        }
        ArrayList<E> arrayList = this.list;
        synchronized (arrayList) {
            return this.list.retainAll(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int index, E element) {
        if (this.fast) {
            return this.list.set(index, element);
        }
        ArrayList<E> arrayList = this.list;
        synchronized (arrayList) {
            return this.list.set(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        if (this.fast) {
            return this.list.size();
        }
        ArrayList<E> arrayList = this.list;
        synchronized (arrayList) {
            return this.list.size();
        }
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        if (this.fast) {
            return new SubList(fromIndex, toIndex);
        }
        return this.list.subList(fromIndex, toIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        if (this.fast) {
            return this.list.toArray();
        }
        ArrayList<E> arrayList = this.list;
        synchronized (arrayList) {
            return this.list.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] array) {
        if (this.fast) {
            return this.list.toArray(array);
        }
        ArrayList<E> arrayList = this.list;
        synchronized (arrayList) {
            return this.list.toArray(array);
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("FastArrayList[");
        sb.append(this.list.toString());
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void trimToSize() {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList temp = (ArrayList)this.list.clone();
                temp.trimToSize();
                this.list = temp;
            }
        }
        ArrayList<E> arrayList = this.list;
        synchronized (arrayList) {
            this.list.trimToSize();
        }
    }

    private class ListIter
    implements ListIterator<E> {
        private List<E> expected;
        private ListIterator<E> iter;
        private int lastReturnedIndex = -1;

        public ListIter(int i) {
            this.expected = FastArrayList.this.list;
            this.iter = this.get().listIterator(i);
        }

        private void checkMod() {
            if (FastArrayList.this.list != this.expected) {
                throw new ConcurrentModificationException();
            }
        }

        List get() {
            return this.expected;
        }

        @Override
        public boolean hasNext() {
            this.checkMod();
            return this.iter.hasNext();
        }

        @Override
        public E next() {
            this.checkMod();
            this.lastReturnedIndex = this.iter.nextIndex();
            return this.iter.next();
        }

        @Override
        public boolean hasPrevious() {
            this.checkMod();
            return this.iter.hasPrevious();
        }

        @Override
        public E previous() {
            this.checkMod();
            this.lastReturnedIndex = this.iter.previousIndex();
            return this.iter.previous();
        }

        @Override
        public int previousIndex() {
            this.checkMod();
            return this.iter.previousIndex();
        }

        @Override
        public int nextIndex() {
            this.checkMod();
            return this.iter.nextIndex();
        }

        @Override
        public void remove() {
            this.checkMod();
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException();
            }
            this.get().remove(this.lastReturnedIndex);
            this.expected = FastArrayList.this.list;
            this.iter = this.get().listIterator(this.previousIndex());
            this.lastReturnedIndex = -1;
        }

        @Override
        public void set(E o) {
            this.checkMod();
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException();
            }
            this.get().set(this.lastReturnedIndex, o);
            this.expected = FastArrayList.this.list;
            this.iter = this.get().listIterator(this.previousIndex() + 1);
        }

        @Override
        public void add(E o) {
            this.checkMod();
            int i = this.nextIndex();
            this.get().add(i, o);
            this.iter = this.get().listIterator(i + 1);
            this.lastReturnedIndex = -1;
        }
    }

    private class SubList
    implements List<E> {
        private int first;
        private int last;
        private List<E> expected;

        public SubList(int first, int last) {
            this.first = first;
            this.last = last;
            this.expected = FastArrayList.this.list;
        }

        private List<E> get(List<E> l) {
            if (FastArrayList.this.list != this.expected) {
                throw new ConcurrentModificationException();
            }
            return l.subList(this.first, this.last);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList temp = (ArrayList)FastArrayList.this.list.clone();
                    this.get(temp).clear();
                    this.last = this.first;
                    FastArrayList.this.list = temp;
                    this.expected = temp;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                this.get(this.expected).clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList temp = (ArrayList)FastArrayList.this.list.clone();
                    boolean r = this.get(temp).remove(o);
                    if (r) {
                        --this.last;
                    }
                    FastArrayList.this.list = temp;
                    this.expected = temp;
                    return r;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).remove(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> o) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList temp = (ArrayList)FastArrayList.this.list.clone();
                    List sub = this.get(temp);
                    boolean r = sub.removeAll(o);
                    if (r) {
                        this.last = this.first + sub.size();
                    }
                    FastArrayList.this.list = temp;
                    this.expected = temp;
                    return r;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).removeAll(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> o) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList temp = (ArrayList)FastArrayList.this.list.clone();
                    List sub = this.get(temp);
                    boolean r = sub.retainAll(o);
                    if (r) {
                        this.last = this.first + sub.size();
                    }
                    FastArrayList.this.list = temp;
                    this.expected = temp;
                    return r;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).retainAll(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).size();
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).isEmpty();
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object o) {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).contains(o);
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).contains(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> o) {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).containsAll(o);
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).containsAll(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] o) {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).toArray(o);
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).toArray(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).toArray();
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (FastArrayList.this.fast) {
                return this.get(this.expected).equals(o);
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).hashCode();
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(E o) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList temp = (ArrayList)FastArrayList.this.list.clone();
                    boolean r = this.get(temp).add(o);
                    if (r) {
                        ++this.last;
                    }
                    FastArrayList.this.list = temp;
                    this.expected = temp;
                    return r;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).add(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends E> o) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList temp = (ArrayList)FastArrayList.this.list.clone();
                    boolean r = this.get(temp).addAll(o);
                    if (r) {
                        this.last += o.size();
                    }
                    FastArrayList.this.list = temp;
                    this.expected = temp;
                    return r;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).addAll(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int i, E o) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList temp = (ArrayList)FastArrayList.this.list.clone();
                    this.get(temp).add(i, o);
                    ++this.last;
                    FastArrayList.this.list = temp;
                    this.expected = temp;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                this.get(this.expected).add(i, o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int i, Collection<? extends E> o) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList temp = (ArrayList)FastArrayList.this.list.clone();
                    boolean r = this.get(temp).addAll(i, o);
                    FastArrayList.this.list = temp;
                    if (r) {
                        this.last += o.size();
                    }
                    this.expected = temp;
                    return r;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).addAll(i, o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E remove(int i) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList temp = (ArrayList)FastArrayList.this.list.clone();
                    Object o = this.get(temp).remove(i);
                    --this.last;
                    FastArrayList.this.list = temp;
                    this.expected = temp;
                    return o;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).remove(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E set(int i, E a) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList temp = (ArrayList)FastArrayList.this.list.clone();
                    Object o = this.get(temp).set(i, a);
                    FastArrayList.this.list = temp;
                    this.expected = temp;
                    return o;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).set(i, a);
            }
        }

        @Override
        public Iterator<E> iterator() {
            return new SubListIter(0);
        }

        @Override
        public ListIterator<E> listIterator() {
            return new SubListIter(0);
        }

        @Override
        public ListIterator<E> listIterator(int i) {
            return new SubListIter(i);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E get(int i) {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).get(i);
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).get(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object o) {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).indexOf(o);
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).indexOf(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object o) {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).lastIndexOf(o);
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                return this.get(this.expected).lastIndexOf(o);
            }
        }

        @Override
        public List<E> subList(int f, int l) {
            if (FastArrayList.this.list != this.expected) {
                throw new ConcurrentModificationException();
            }
            return new SubList(this.first + f, f + l);
        }

        private class SubListIter
        implements ListIterator<E> {
            private List<E> expected;
            private ListIterator<E> iter;
            private int lastReturnedIndex = -1;

            public SubListIter(int i) {
                this.expected = FastArrayList.this.list;
                this.iter = SubList.this.get(this.expected).listIterator(i);
            }

            private void checkMod() {
                if (FastArrayList.this.list != this.expected) {
                    throw new ConcurrentModificationException();
                }
            }

            List<E> get() {
                return SubList.this.get(this.expected);
            }

            @Override
            public boolean hasNext() {
                this.checkMod();
                return this.iter.hasNext();
            }

            @Override
            public E next() {
                this.checkMod();
                this.lastReturnedIndex = this.iter.nextIndex();
                return this.iter.next();
            }

            @Override
            public boolean hasPrevious() {
                this.checkMod();
                return this.iter.hasPrevious();
            }

            @Override
            public E previous() {
                this.checkMod();
                this.lastReturnedIndex = this.iter.previousIndex();
                return this.iter.previous();
            }

            @Override
            public int previousIndex() {
                this.checkMod();
                return this.iter.previousIndex();
            }

            @Override
            public int nextIndex() {
                this.checkMod();
                return this.iter.nextIndex();
            }

            @Override
            public void remove() {
                this.checkMod();
                if (this.lastReturnedIndex < 0) {
                    throw new IllegalStateException();
                }
                this.get().remove(this.lastReturnedIndex);
                SubList.this.last--;
                this.expected = FastArrayList.this.list;
                this.iter = this.get().listIterator(this.previousIndex());
                this.lastReturnedIndex = -1;
            }

            @Override
            public void set(E o) {
                this.checkMod();
                if (this.lastReturnedIndex < 0) {
                    throw new IllegalStateException();
                }
                this.get().set(this.lastReturnedIndex, o);
                this.expected = FastArrayList.this.list;
                this.iter = this.get().listIterator(this.previousIndex() + 1);
            }

            @Override
            public void add(E o) {
                this.checkMod();
                int i = this.nextIndex();
                this.get().add(i, o);
                SubList.this.last++;
                this.iter = this.get().listIterator(i + 1);
                this.lastReturnedIndex = 1;
            }
        }
    }
}

