/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.ClassPath;
import org.apache.bcel.util.Repository;

public class SyntheticRepository
implements Repository {
    private static final String DEFAULT_PATH = ClassPath.getClassPath();
    private static Map _instances = new HashMap();
    private ClassPath _path = null;
    private Map _loadedClasses = new HashMap();

    private SyntheticRepository(ClassPath path) {
        this._path = path;
    }

    public static SyntheticRepository getInstance() {
        return SyntheticRepository.getInstance(ClassPath.SYSTEM_CLASS_PATH);
    }

    public static SyntheticRepository getInstance(ClassPath classPath) {
        SyntheticRepository rep = (SyntheticRepository)_instances.get(classPath);
        if (rep == null) {
            rep = new SyntheticRepository(classPath);
            _instances.put(classPath, rep);
        }
        return rep;
    }

    @Override
    public void storeClass(JavaClass clazz) {
        this._loadedClasses.put(clazz.getClassName(), new SoftReference<JavaClass>(clazz));
        clazz.setRepository(this);
    }

    @Override
    public void removeClass(JavaClass clazz) {
        this._loadedClasses.remove(clazz.getClassName());
    }

    @Override
    public JavaClass findClass(String className) {
        SoftReference ref = (SoftReference)this._loadedClasses.get(className);
        if (ref == null) {
            return null;
        }
        return (JavaClass)ref.get();
    }

    @Override
    public JavaClass loadClass(String className) throws ClassNotFoundException {
        if (className == null || className.equals("")) {
            throw new IllegalArgumentException("Invalid class name " + className);
        }
        JavaClass clazz = this.findClass(className = className.replace('/', '.'));
        if (clazz != null) {
            return clazz;
        }
        try {
            return this.loadClass(this._path.getInputStream(className), className);
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Exception while looking for class " + className + ": " + e.toString());
        }
    }

    @Override
    public JavaClass loadClass(Class clazz) throws ClassNotFoundException {
        String className = clazz.getName();
        JavaClass repositoryClass = this.findClass(className);
        if (repositoryClass != null) {
            return repositoryClass;
        }
        String name = className;
        int i = name.lastIndexOf(46);
        if (i > 0) {
            name = name.substring(i + 1);
        }
        return this.loadClass(clazz.getResourceAsStream(name + ".class"), className);
    }

    private JavaClass loadClass(InputStream is, String className) throws ClassNotFoundException {
        try {
            if (is != null) {
                ClassParser parser2 = new ClassParser(is, className);
                JavaClass clazz = parser2.parse();
                this.storeClass(clazz);
                return clazz;
            }
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Exception while looking for class " + className + ": " + e.toString());
        }
        throw new ClassNotFoundException("SyntheticRepository could not load " + className);
    }

    @Override
    public ClassPath getClassPath() {
        return this._path;
    }

    @Override
    public void clear() {
        this._loadedClasses.clear();
    }
}

