/*
 * Decompiled with CFR 0.152.
 */
package lcmc.utilities;

import lcmc.data.Host;
import lcmc.utilities.ConvertCmdCallback;
import lcmc.utilities.Tools;

public final class Openais {
    private static final String AIS_CONF_DIR = "/etc/ais/";
    private static final String AIS_CONF_NAME = "openais.conf";
    private static final String AIS_CONF_PERMS = "0600";
    private static final String AUTHKEYS_CONF_NAME = "authkey";
    private static final String AUTHKEYS_CONF_PERMS = "0400";

    private Openais() {
    }

    private static void execCommand(Host host, String command, boolean outputVisible) {
        Tools.execCommandProgressIndicator(host, command, null, outputVisible, Tools.getString("Openais.ExecutingCommand"), 180000);
    }

    public static void switchToOpenais(Host host) {
        String command = host.getDistCommand("Heartbeat.deleteFromRc;;;Openais.addToRc;;;Openais.startOpenais", (ConvertCmdCallback)null);
        Openais.execCommand(host, command, true);
    }

    public static void startOpenais(Host host) {
        String command = host.getDistCommand("Openais.startOpenais", (ConvertCmdCallback)null);
        Openais.execCommand(host, command, true);
    }

    public static void stopOpenais(Host host) {
        String command = host.getDistCommand("Openais.stopOpenais", (ConvertCmdCallback)null);
        Openais.execCommand(host, command, true);
    }

    public static void startOpenaisRc(Host host) {
        String command = host.getDistCommand("Openais.startOpenais;;;Openais.addToRc", (ConvertCmdCallback)null);
        Openais.execCommand(host, command, true);
    }

    public static void addOpenaisToRc(Host host) {
        String command = host.getDistCommand("Openais.addToRc", (ConvertCmdCallback)null);
        Openais.execCommand(host, command, true);
    }

    public static void reloadOpenais(Host host) {
        String command = host.getDistCommand("Openais.reloadOpenais", (ConvertCmdCallback)null);
        Openais.execCommand(host, command, true);
    }

    public static void createAISConfig(Host[] hosts, StringBuilder config) {
        Tools.createConfigOnAllHosts(hosts, config.toString(), AIS_CONF_NAME, AIS_CONF_DIR, AIS_CONF_PERMS, true);
        StringBuilder authkeys = new StringBuilder(Tools.getRandomSecret(128));
        Tools.createConfigOnAllHosts(hosts, authkeys.toString(), AUTHKEYS_CONF_NAME, AIS_CONF_DIR, AUTHKEYS_CONF_PERMS, true);
    }

    public static void reloadOpenaises(Host[] hosts) {
        for (Host host : hosts) {
            Openais.reloadOpenais(host);
        }
    }
}

