/*
 * Decompiled with CFR 0.152.
 */
package lcmc.utilities;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import lcmc.data.CRMXML;
import lcmc.data.Host;
import lcmc.data.HostLocation;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;

public final class CRM {
    private static volatile String ptestOutput = null;
    private static final ReadWriteLock M_PTEST_LOCK = new ReentrantReadWriteLock();
    private static final Lock M_PTEST_READLOCK = M_PTEST_LOCK.readLock();
    private static final Lock M_PTEST_WRITELOCK = M_PTEST_LOCK.writeLock();
    public static final String PTEST_END_DELIM = "--- PTEST END ---";
    public static final String LCMC_TEST_FILE = "/tmp/lcmc-test-" + UUID.randomUUID() + ".xml";
    public static final boolean TESTONLY = true;
    public static final boolean LIVE = false;

    private CRM() {
    }

    public static String getCibCommand(String command, String objType, String xml) {
        StringBuilder cmd = new StringBuilder(300);
        cmd.append("@DMCSUDO@/usr/sbin/cibadmin --obj_type ");
        cmd.append(objType);
        cmd.append(' ');
        cmd.append(command);
        cmd.append(" -X ");
        cmd.append(xml);
        return cmd.toString();
    }

    private static SSH.SSHOutput execCommand(Host host, String command, boolean outputVisible, boolean testOnly) {
        M_PTEST_WRITELOCK.lock();
        ptestOutput = null;
        M_PTEST_WRITELOCK.unlock();
        if (testOnly) {
            String testCmd = "if [ ! -e " + LCMC_TEST_FILE + " ]; " + "then " + "@DMCSUDO@" + "/usr/sbin/cibadmin -Ql > " + LCMC_TEST_FILE + ";fi;" + "export CIB_file=" + LCMC_TEST_FILE + ";";
            SSH.SSHOutput out = Tools.execCommand(host, testCmd + command, null, false, SSH.DEFAULT_COMMAND_TIMEOUT);
            return out;
        }
        Tools.debug(null, "CRM.java: crm command: " + command, 1);
        return Tools.execCommandProgressIndicator(host, command, null, outputVisible, Tools.getString("CIB.ExecutingCommand"), SSH.DEFAULT_COMMAND_TIMEOUT);
    }

    public static String getPtest(Host host) {
        M_PTEST_READLOCK.lock();
        if (ptestOutput != null) {
            String po = ptestOutput;
            M_PTEST_READLOCK.unlock();
            return po;
        }
        M_PTEST_READLOCK.unlock();
        String command = "export PROG=/usr/sbin/crm_simulate;if [ -e /usr/sbin/ptest ]; then export PROG=/usr/sbin/ptest; fi;@DMCSUDO@$PROG -VVVVV -S -x " + LCMC_TEST_FILE + " 2>&1;echo '" + PTEST_END_DELIM + "';cat " + LCMC_TEST_FILE + " 2>/dev/null;" + "mv -f " + LCMC_TEST_FILE + "{,.last} 2>/dev/null";
        SSH.SSHOutput output = Tools.execCommand(host, command, null, false, SSH.DEFAULT_COMMAND_TIMEOUT);
        M_PTEST_WRITELOCK.lock();
        String po = output.getOutput();
        if (ptestOutput == null) {
            ptestOutput = po;
        }
        M_PTEST_WRITELOCK.unlock();
        return po;
    }

    private static String getPrimitiveXML(Host host, String resId, Map<String, String> pacemakerResAttrs, Map<String, String> pacemakerResArgs, Map<String, String> pacemakerMetaArgs, String instanceAttrId, Map<String, String> nvpairIdsHash, Map<String, Map<String, String>> pacemakerOps, String operationsId, String metaAttrsRefId, String operationsRefId, boolean stonith, boolean testOnly) {
        StringBuilder xml = new StringBuilder(360);
        if (resId != null) {
            String value;
            if (instanceAttrId == null) {
                instanceAttrId = resId + "-instance_attributes";
            }
            StringBuilder attrsString = new StringBuilder(100);
            for (String attrName : pacemakerResAttrs.keySet()) {
                value = pacemakerResAttrs.get(attrName);
                attrsString.append(attrName);
                attrsString.append("=\"");
                attrsString.append(value);
                attrsString.append("\" ");
            }
            xml.append("<primitive ");
            xml.append((CharSequence)attrsString);
            xml.append('>');
            if (!pacemakerResArgs.isEmpty()) {
                xml.append("<instance_attributes id=\"");
                xml.append(instanceAttrId);
                xml.append("\">");
                if (Tools.versionBeforePacemaker(host)) {
                    xml.append("<attributes>");
                }
                for (String paramName : pacemakerResArgs.keySet()) {
                    value = pacemakerResArgs.get(paramName);
                    String nvpairId = null;
                    if (nvpairIdsHash != null) {
                        nvpairId = nvpairIdsHash.get(paramName);
                    }
                    String newParamName = stonith && "stonith-priority".equals(paramName) ? "priority" : paramName;
                    if (nvpairId == null) {
                        nvpairId = "nvpair-" + resId + "-" + newParamName;
                    }
                    xml.append("<nvpair id=\"");
                    xml.append(nvpairId);
                    xml.append("\" name=\"");
                    xml.append(newParamName);
                    xml.append("\" value=\"");
                    xml.append(value);
                    xml.append("\"/>");
                }
                if (Tools.versionBeforePacemaker(host)) {
                    xml.append("</attributes>");
                }
                xml.append("</instance_attributes>");
            }
        }
        if (operationsRefId != null) {
            xml.append("<operations id-ref=\"");
            xml.append(operationsRefId);
            xml.append("\"/>");
        } else if (pacemakerOps != null && !pacemakerOps.isEmpty()) {
            if (Tools.versionBeforePacemaker(host)) {
                xml.append("<operations>");
            } else {
                if (operationsId == null) {
                    operationsId = resId + "-operations";
                }
                xml.append("<operations id=\"");
                xml.append(operationsId);
                xml.append("\">");
            }
            for (String op : pacemakerOps.keySet()) {
                Map<String, String> opHash = pacemakerOps.get(op);
                xml.append("<op");
                boolean checkLevel = false;
                for (String name : opHash.keySet()) {
                    if ("OCF_CHECK_LEVEL".equals(name)) {
                        checkLevel = true;
                        continue;
                    }
                    String value = opHash.get(name);
                    xml.append(' ');
                    xml.append(name);
                    xml.append("=\"");
                    xml.append(value);
                    xml.append('\"');
                }
                if (checkLevel) {
                    xml.append(">");
                    String iaId = resId + "-monitor-instance_attributes";
                    xml.append("<instance_attributes id=\"");
                    xml.append(iaId);
                    xml.append("\"><nvpair id=\"");
                    xml.append(iaId);
                    xml.append('-');
                    xml.append("OCF_CHECK_LEVEL");
                    xml.append("\" name=\"");
                    xml.append("OCF_CHECK_LEVEL");
                    xml.append("\" value=\"");
                    xml.append(opHash.get("OCF_CHECK_LEVEL"));
                    xml.append("\"/></instance_attributes></op>");
                    continue;
                }
                xml.append("/>");
            }
            xml.append("</operations>");
        }
        if (resId != null) {
            xml.append(CRM.getMetaAttributes(host, resId, pacemakerMetaArgs, metaAttrsRefId));
            xml.append("</primitive>");
        }
        return xml.toString();
    }

    public static boolean setParameters(Host host, String command, String resId, String cloneId, boolean master, Map<String, String> cloneMetaArgs, Map<String, String> groupMetaArgs, String groupId, Map<String, String> pacemakerResAttrs, Map<String, String> pacemakerResArgs, Map<String, String> pacemakerMetaArgs, String instanceAttrId, Map<String, String> nvpairIdsHash, Map<String, Map<String, String>> pacemakerOps, String operationsId, String metaAttrsRefId, String cloneMetaAttrsRefId, String groupMetaAttrsRefId, String operationsRefId, boolean stonith, boolean testOnly) {
        StringBuilder xml = new StringBuilder(360);
        xml.append('\'');
        if (cloneId != null) {
            if (master) {
                if (Tools.versionBeforePacemaker(host)) {
                    xml.append("<master_slave id=\"");
                } else {
                    xml.append("<master id=\"");
                }
            } else {
                xml.append("<clone id=\"");
            }
            xml.append(cloneId);
            xml.append("\">");
            xml.append(CRM.getMetaAttributes(host, cloneId, cloneMetaArgs, cloneMetaAttrsRefId));
        }
        if (groupId != null) {
            if (resId != null) {
                xml.append("<group id=\"");
                xml.append(groupId);
                xml.append("\">");
            }
            xml.append(CRM.getMetaAttributes(host, groupId, groupMetaArgs, groupMetaAttrsRefId));
        }
        xml.append(CRM.getPrimitiveXML(host, resId, pacemakerResAttrs, pacemakerResArgs, pacemakerMetaArgs, instanceAttrId, nvpairIdsHash, pacemakerOps, operationsId, metaAttrsRefId, operationsRefId, stonith, testOnly));
        if (groupId != null && resId != null) {
            xml.append("</group>");
        }
        if (cloneId != null) {
            if (master) {
                if (Tools.versionBeforePacemaker(host)) {
                    xml.append("</master_slave>");
                } else {
                    xml.append("</master>");
                }
            } else {
                xml.append("</clone>");
            }
        }
        xml.append('\'');
        SSH.SSHOutput ret = CRM.execCommand(host, CRM.getCibCommand(command, "resources", xml.toString()), true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean replaceGroup(boolean createGroup, Host host, String cloneId, boolean master, Map<String, String> cloneMetaArgs, String cloneMetaAttrsRefId, List<String> resourceIds, Map<String, String> groupMetaArgs, String groupId, Map<String, Map<String, String>> pacemakerResAttrs, Map<String, Map<String, String>> pacemakerResArgs, Map<String, Map<String, String>> pacemakerMetaArgs, Map<String, String> instanceAttrId, Map<String, Map<String, String>> nvpairIdsHash, Map<String, Map<String, Map<String, String>>> pacemakerOps, Map<String, String> operationsId, Map<String, String> metaAttrsRefId, String groupMetaAttrsRefId, Map<String, String> operationsRefId, Map<String, Boolean> stonith, boolean testOnly) {
        StringBuilder xml = new StringBuilder(720);
        xml.append('\'');
        if (cloneId != null) {
            if (master) {
                if (Tools.versionBeforePacemaker(host)) {
                    xml.append("<master_slave id=\"");
                } else {
                    xml.append("<master id=\"");
                }
            } else {
                xml.append("<clone id=\"");
            }
            xml.append(cloneId);
            xml.append("\">");
            xml.append(CRM.getMetaAttributes(host, cloneId, cloneMetaArgs, cloneMetaAttrsRefId));
        }
        xml.append("<group id=\"");
        xml.append(groupId);
        xml.append("\">");
        xml.append(CRM.getMetaAttributes(host, groupId, groupMetaArgs, groupMetaAttrsRefId));
        for (String resId : resourceIds) {
            xml.append(CRM.getPrimitiveXML(host, resId, pacemakerResAttrs.get(resId), pacemakerResArgs.get(resId), pacemakerMetaArgs.get(resId), instanceAttrId.get(resId), nvpairIdsHash.get(resId), pacemakerOps.get(resId), operationsId.get(resId), metaAttrsRefId.get(resId), operationsRefId.get(resId), stonith.get(resId), testOnly));
        }
        xml.append("</group>");
        if (cloneId != null) {
            if (master) {
                if (Tools.versionBeforePacemaker(host)) {
                    xml.append("</master_slave>");
                } else {
                    xml.append("</master>");
                }
            } else {
                xml.append("</clone>");
            }
        }
        xml.append('\'');
        String cibadminOpt = createGroup ? "-C" : "-R";
        SSH.SSHOutput ret = CRM.execCommand(host, CRM.getCibCommand(cibadminOpt, "resources", xml.toString()), true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static void addGroup(Host host, String args) {
        if (args == null) {
            return;
        }
    }

    public static void setOrderAndColocation(Host host, String resId, String[] parents, List<Map<String, String>> colAttrsList, List<Map<String, String>> ordAttrsList, boolean testOnly) {
        for (int i = 0; i < parents.length; ++i) {
            if (colAttrsList.get(i) != null) {
                CRM.addColocation(host, null, resId, parents[i], colAttrsList.get(i), testOnly);
            }
            if (ordAttrsList.get(i) == null) continue;
            CRM.addOrder(host, null, parents[i], resId, ordAttrsList.get(i), testOnly);
        }
    }

    private static String getOneRscSet(String rscSetId, CRMXML.RscSet rscSet, Map<String, String> attrs) {
        StringBuilder xml = new StringBuilder(120);
        xml.append("<resource_set id=\"");
        xml.append(rscSetId);
        if (attrs == null) {
            String requireAll;
            String sequential;
            String orderAction;
            attrs = new LinkedHashMap<String, String>();
            String colocationRole = rscSet.getColocationRole();
            if (colocationRole != null) {
                attrs.put("role", colocationRole);
            }
            if ((orderAction = rscSet.getOrderAction()) != null) {
                attrs.put("action", orderAction);
            }
            if ((sequential = rscSet.getSequential()) != null) {
                attrs.put("sequential", sequential);
            }
            if ((requireAll = rscSet.getRequireAll()) != null && !requireAll.equals("true")) {
                attrs.put("require-all", requireAll);
            }
        }
        for (String attr : attrs.keySet()) {
            String value = attrs.get(attr);
            if ("".equals(value)) continue;
            xml.append("\" " + attr + "=\"");
            xml.append(value);
        }
        xml.append("\">");
        for (String rscId : rscSet.getRscIds()) {
            xml.append("<resource_ref id=\"");
            xml.append(rscId);
            xml.append("\"/>");
        }
        xml.append("</resource_set>");
        return xml.toString();
    }

    public static boolean setRscSet(Host host, String colId, boolean createCol, String ordId, boolean createOrd, Map<CRMXML.RscSet, Map<String, String>> rscSetsColAttrs, Map<CRMXML.RscSet, Map<String, String>> rscSetsOrdAttrs, Map<String, String> attrs, boolean testOnly) {
        String cibadminOpt;
        if (colId != null) {
            if (rscSetsColAttrs.isEmpty()) {
                return CRM.removeColocation(host, colId, testOnly);
            }
            cibadminOpt = createCol ? "-C" : "-R";
            boolean ret = CRM.setRscSetConstraint(host, "rsc_colocation", colId, rscSetsColAttrs, attrs, cibadminOpt, testOnly);
            if (!ret) {
                return false;
            }
        }
        if (ordId != null) {
            if (rscSetsOrdAttrs.isEmpty()) {
                return CRM.removeOrder(host, ordId, testOnly);
            }
            cibadminOpt = createOrd ? "-C" : "-R";
            return CRM.setRscSetConstraint(host, "rsc_order", ordId, rscSetsOrdAttrs, attrs, cibadminOpt, testOnly);
        }
        return true;
    }

    private static boolean setRscSetConstraint(Host host, String tag, String constraintId, Map<CRMXML.RscSet, Map<String, String>> rscSetsAttrs, Map<String, String> attrs, String cibadminOpt, boolean testOnly) {
        StringBuilder xml = new StringBuilder(360);
        xml.append("'<");
        xml.append(tag);
        xml.append(" id=\"");
        xml.append(constraintId);
        if (attrs != null) {
            for (String attr : attrs.keySet()) {
                String value = attrs.get(attr);
                if (value == null || "".equals(value)) continue;
                xml.append("\" " + attr + "=\"");
                xml.append(value);
            }
        }
        xml.append("\">");
        int rsId = 0;
        for (CRMXML.RscSet rscSet : rscSetsAttrs.keySet()) {
            if (rscSet == null) continue;
            xml.append(CRM.getOneRscSet(constraintId + "-" + rsId, rscSet, rscSetsAttrs.get(rscSet)));
            ++rsId;
        }
        xml.append("</");
        xml.append(tag);
        xml.append(">'");
        String command = CRM.getCibCommand(cibadminOpt, "constraints", xml.toString());
        SSH.SSHOutput ret = CRM.execCommand(host, command, true, testOnly);
        return ret.getExitCode() == 0;
    }

    private static String getLocationXML(String resId, String onHost, String attribute, String score, String scoreAttribute, String op, String role, String locationId) {
        StringBuilder xml = new StringBuilder(360);
        xml.append("'<rsc_location id=\"");
        xml.append(locationId);
        xml.append("\" rsc=\"");
        xml.append(resId);
        if (op == null || "eq".equals(op) && !"pingd".equals(attribute) && role == null) {
            if (onHost != null) {
                xml.append("\" node=\"");
                xml.append(onHost);
            }
            if (score != null) {
                xml.append("\" score=\"");
                xml.append(score);
            }
            xml.append("\"/>'");
        } else {
            xml.append("\"><rule id=\"");
            xml.append(locationId);
            xml.append("-rule\"");
            if (score != null) {
                xml.append(" score=\"");
                xml.append(score);
                xml.append('\"');
            }
            if (role != null) {
                xml.append(" role=\"");
                xml.append(role);
                xml.append('\"');
            }
            if (scoreAttribute != null) {
                xml.append(" score-attribute=\"");
                xml.append(scoreAttribute);
                xml.append('\"');
            }
            if (attribute != null) {
                xml.append("><expression attribute=\"");
                xml.append(attribute);
                xml.append("\" id=\"");
                xml.append(locationId);
                xml.append("-expression\" operation=\"");
                xml.append(op);
                if (onHost != null) {
                    xml.append("\" value=\"");
                    xml.append(onHost);
                }
                xml.append("\"/");
            }
            xml.append("></rule></rsc_location>'");
        }
        return xml.toString();
    }

    public static boolean setLocation(Host host, String resId, String onHost, HostLocation hostLocation, String locationId, boolean testOnly) {
        String xml;
        SSH.SSHOutput ret;
        String command = "-U";
        if (locationId == null) {
            locationId = "loc_" + resId + "_" + onHost;
            command = "-C";
        } else if ("migration".equals(locationId)) {
            locationId = "cli-standby-" + resId;
            command = "-C";
        } else if ("remigration".equals(locationId)) {
            locationId = "cli-standby-" + resId;
            command = "-U";
        }
        String score = null;
        String op = null;
        String role = null;
        if (hostLocation != null) {
            score = hostLocation.getScore();
            op = hostLocation.getOperation();
            role = hostLocation.getRole();
        }
        return (ret = CRM.execCommand(host, CRM.getCibCommand(command, "constraints", xml = CRM.getLocationXML(resId, onHost, "#uname", score, null, op, role, locationId)), true, testOnly)).getExitCode() == 0;
    }

    public static boolean setPingLocation(Host host, String resId, String ruleType, String locationId, boolean testOnly) {
        String xml;
        SSH.SSHOutput ret;
        String command = "-U";
        String op = null;
        String value = null;
        String score = null;
        String scoreAttribute = null;
        String attribute = "pingd";
        String idPart = "";
        if ("defined".equals(ruleType)) {
            scoreAttribute = "pingd";
            op = "defined";
            idPart = "prefer";
        } else if ("eq0".equals(ruleType)) {
            score = "-INFINITY";
            op = "eq";
            value = "0";
            idPart = "exclude";
        }
        if (locationId == null) {
            locationId = "loc_" + resId + "-ping-" + idPart;
            command = "-C";
        }
        return (ret = CRM.execCommand(host, CRM.getCibCommand(command, "constraints", xml = CRM.getLocationXML(resId, value, "pingd", score, scoreAttribute, op, null, locationId)), true, testOnly)).getExitCode() == 0;
    }

    public static boolean removeLocation(Host host, String locationId, String resId, boolean testOnly) {
        String xml = CRM.getLocationXML(resId, null, null, null, null, null, null, locationId);
        String command = CRM.getCibCommand("-D", "constraints", xml);
        SSH.SSHOutput ret = CRM.execCommand(host, command, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean removeResource(Host host, String resId, String groupId, String cloneId, boolean master, boolean testOnly) {
        StringBuilder xml = new StringBuilder(360);
        xml.append('\'');
        if (cloneId != null) {
            if (master) {
                if (Tools.versionBeforePacemaker(host)) {
                    xml.append("<master_slave id=\"");
                } else {
                    xml.append("<master id=\"");
                }
            } else {
                xml.append("<clone id=\"");
            }
            xml.append(cloneId);
            xml.append("\">");
        }
        if (groupId != null) {
            xml.append("<group id=\"");
            xml.append(groupId);
            xml.append("\">");
        }
        if (resId != null) {
            xml.append("<primitive id=\"");
            xml.append(resId);
            xml.append("\"></primitive>");
        }
        if (groupId != null) {
            xml.append("</group>");
        }
        if (cloneId != null) {
            if (master) {
                if (Tools.versionBeforePacemaker(host)) {
                    xml.append("</master_slave>");
                } else {
                    xml.append("</master>");
                }
            } else {
                xml.append("</clone>");
            }
        }
        xml.append('\'');
        String command = CRM.getCibCommand("-D", "resources", xml.toString());
        SSH.SSHOutput ret = CRM.execCommand(host, command, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean cleanupResource(Host host, String resId, Host[] clusterHosts, boolean testOnly) {
        if (testOnly) {
            return true;
        }
        HashMap<String, String> replaceHash = new HashMap<String, String>();
        replaceHash.put("@ID@", resId);
        int exitCode = 0;
        for (Host clusterHost : clusterHosts) {
            replaceHash.put("@HOST@", clusterHost.getName());
            String command = host.getDistCommand("CRM.cleanupResource", replaceHash);
            SSH.SSHOutput ret = CRM.execCommand(host, command, true, testOnly);
            exitCode = ret.getExitCode();
        }
        return true;
    }

    public static boolean startResource(Host host, String resId, boolean testOnly) {
        String cmd = "CRM.startResource";
        if (Tools.versionBeforePacemaker(host)) {
            cmd = "CRM.2.1.4.startResource";
        }
        HashMap<String, String> replaceHash = new HashMap<String, String>();
        replaceHash.put("@ID@", resId);
        String command = host.getDistCommand(cmd, replaceHash);
        SSH.SSHOutput ret = CRM.execCommand(host, command, true, testOnly);
        return ret.getExitCode() == 0;
    }

    private static String getMetaAttributes(Host host, String resId, Map<String, String> attrs, String metaAttrsRefId) {
        StringBuilder xml = new StringBuilder(360);
        String idPostfix = "-meta_attributes";
        if (Tools.versionBeforePacemaker(host)) {
            idPostfix = "-meta-options";
        }
        if (metaAttrsRefId == null) {
            xml.append("<meta_attributes id=\"");
            xml.append(resId);
            xml.append(idPostfix);
            xml.append("\">");
            if (Tools.versionBeforePacemaker(host)) {
                xml.append("<attributes>");
            }
            for (String attr : attrs.keySet()) {
                xml.append("<nvpair id=\"");
                xml.append(resId);
                xml.append(idPostfix);
                xml.append('-');
                xml.append(attr);
                xml.append("\" name=\"");
                xml.append(attr);
                xml.append("\" value=\"");
                xml.append(attrs.get(attr));
                xml.append("\"/>");
            }
            if (Tools.versionBeforePacemaker(host)) {
                xml.append("</attributes>");
            }
            xml.append("</meta_attributes>");
        } else {
            xml.append("<meta_attributes id-ref=\"");
            xml.append(metaAttrsRefId);
            xml.append("\"/>");
        }
        return xml.toString();
    }

    public static boolean setManaged(Host host, String resId, boolean isManaged, boolean testOnly) {
        String string = isManaged ? ".isManagedOn" : ".isManagedOff";
        String cmd = "CRM" + string;
        if (Tools.versionBeforePacemaker(host)) {
            cmd = "CRM.2.1.4" + string;
        }
        HashMap<String, String> replaceHash = new HashMap<String, String>();
        replaceHash.put("@ID@", resId);
        String command = host.getDistCommand(cmd, replaceHash);
        SSH.SSHOutput ret = CRM.execCommand(host, command, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean stopResource(Host host, String resId, boolean testOnly) {
        if (resId == null) {
            return false;
        }
        String cmd = "CRM.stopResource";
        if (Tools.versionBeforePacemaker(host)) {
            cmd = "CRM.2.1.4.stopResource";
        }
        HashMap<String, String> replaceHash = new HashMap<String, String>();
        replaceHash.put("@ID@", resId);
        String command = host.getDistCommand(cmd, replaceHash);
        SSH.SSHOutput ret = CRM.execCommand(host, command, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean migrateResource(Host host, String resId, String onHost, boolean testOnly) {
        HashMap<String, String> replaceHash = new HashMap<String, String>();
        replaceHash.put("@ID@", resId);
        replaceHash.put("@HOST@", onHost);
        String command = host.getDistCommand("CRM.migrateResource", replaceHash);
        SSH.SSHOutput ret = CRM.execCommand(host, command, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean migrateFromResource(Host host, String resId, boolean testOnly) {
        HashMap<String, String> replaceHash = new HashMap<String, String>();
        replaceHash.put("@ID@", resId);
        String command = host.getDistCommand("CRM.migrateFromResource", replaceHash);
        SSH.SSHOutput ret = CRM.execCommand(host, command, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean forceMigrateResource(Host host, String resId, String onHost, boolean testOnly) {
        HashMap<String, String> replaceHash = new HashMap<String, String>();
        replaceHash.put("@ID@", resId);
        replaceHash.put("@HOST@", onHost);
        String command = host.getDistCommand("CRM.forceMigrateResource", replaceHash);
        SSH.SSHOutput ret = CRM.execCommand(host, command, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean unmigrateResource(Host host, String resId, boolean testOnly) {
        HashMap<String, String> replaceHash = new HashMap<String, String>();
        replaceHash.put("@ID@", resId);
        String command = host.getDistCommand("CRM.unmigrateResource", replaceHash);
        SSH.SSHOutput ret = CRM.execCommand(host, command, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean setGlobalParameters(Host host, Map<String, String> args, Map<String, String> rdiMetaArgs, String rscDefaultsId, boolean testOnly) {
        SSH.SSHOutput ret;
        StringBuilder xml = new StringBuilder(360);
        xml.append("'<crm_config><cluster_property_set id=\"cib-bootstrap-options\">");
        if (Tools.versionBeforePacemaker(host)) {
            xml.append("<attributes>");
        }
        for (String arg : args.keySet()) {
            String id = "cib-bootstrap-options-" + arg;
            xml.append("<nvpair id=\"");
            xml.append(id);
            xml.append("\" name=\"");
            xml.append(arg);
            xml.append("\" value=\"");
            xml.append(args.get(arg));
            xml.append("\"/>");
        }
        if (Tools.versionBeforePacemaker(host)) {
            xml.append("</attributes>");
        }
        xml.append("</cluster_property_set></crm_config>'");
        StringBuilder command = new StringBuilder(CRM.getCibCommand("-R", "crm_config", xml.toString()));
        if (rdiMetaArgs != null && !Tools.versionBeforePacemaker(host)) {
            String updateOrReplace = "-R";
            if (rscDefaultsId == null) {
                rscDefaultsId = "rsc-options";
                updateOrReplace = "-U";
            }
            StringBuilder rscdXML = new StringBuilder(360);
            rscdXML.append("'<rsc_defaults><meta_attributes id=\"");
            rscdXML.append(rscDefaultsId);
            rscdXML.append("\">");
            for (String arg : rdiMetaArgs.keySet()) {
                String id = "rsc-options-" + arg;
                rscdXML.append("<nvpair id=\"");
                rscdXML.append(id);
                rscdXML.append("\" name=\"");
                rscdXML.append(arg);
                rscdXML.append("\" value=\"");
                rscdXML.append(rdiMetaArgs.get(arg));
                rscdXML.append("\"/>");
            }
            rscdXML.append("</meta_attributes></rsc_defaults>'");
            command.append(';');
            command.append(CRM.getCibCommand(updateOrReplace, "rsc_defaults", rscdXML.toString()));
        }
        return (ret = CRM.execCommand(host, command.toString(), true, testOnly)).getExitCode() == 0;
    }

    public static boolean removeColocation(Host host, String colocationId, boolean testOnly) {
        StringBuilder xml = new StringBuilder(360);
        xml.append("'<rsc_colocation id=\"");
        xml.append(colocationId);
        xml.append("\"/>'");
        String command = CRM.getCibCommand("-D", "constraints", xml.toString());
        SSH.SSHOutput ret = CRM.execCommand(host, command, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean addColocation(Host host, String colId, String resId, String parentHbId, Map<String, String> attrs, boolean testOnly) {
        String colocationId;
        String cibadminOpt;
        if (parentHbId == null) {
            return false;
        }
        if (colId == null) {
            cibadminOpt = "-C";
            colocationId = parentHbId.compareTo(resId) < 0 ? "col_" + resId + "_" + parentHbId : "col_" + parentHbId + "_" + resId;
        } else {
            cibadminOpt = "-R";
            colocationId = colId;
        }
        if (attrs == null) {
            attrs = new LinkedHashMap<String, String>();
        }
        attrs.put("rsc", resId);
        attrs.put("with-rsc", parentHbId);
        StringBuilder xml = new StringBuilder(360);
        xml.append("'<rsc_colocation id=\"");
        xml.append(colocationId);
        HashMap<String, String> convertHash = new HashMap<String, String>();
        if (Tools.versionBeforePacemaker(host)) {
            convertHash.put("rsc", "from");
            convertHash.put("with-rsc", "to");
            convertHash.put("rsc-role", "from_role");
            convertHash.put("with-rsc-role", "to_role");
        }
        for (String attr : attrs.keySet()) {
            String value = attrs.get(attr);
            if ("".equals(value)) continue;
            if (convertHash.containsKey(attr)) {
                attr = (String)convertHash.get(attr);
            }
            xml.append("\" " + attr + "=\"");
            xml.append(value);
        }
        xml.append("\"/>'");
        String command = CRM.getCibCommand(cibadminOpt, "constraints", xml.toString());
        SSH.SSHOutput ret = CRM.execCommand(host, command, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean removeOrder(Host host, String orderId, boolean testOnly) {
        StringBuilder xml = new StringBuilder(360);
        xml.append("'<rsc_order id=\"");
        xml.append(orderId);
        xml.append("\"/>'");
        String command = CRM.getCibCommand("-D", "constraints", xml.toString());
        SSH.SSHOutput ret = CRM.execCommand(host, command, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean addOrder(Host host, String ordId, String parentHbId, String resId, Map<String, String> attrs, boolean testOnly) {
        String orderId;
        String cibadminOpt;
        if (ordId == null) {
            cibadminOpt = "-C";
            orderId = "ord_" + parentHbId + "_" + resId;
        } else {
            cibadminOpt = "-R";
            orderId = ordId;
        }
        if (attrs == null) {
            attrs = new LinkedHashMap<String, String>();
        }
        StringBuilder xml = new StringBuilder(360);
        xml.append("'<rsc_order id=\"");
        xml.append(orderId);
        attrs.put("first", parentHbId);
        attrs.put("then", resId);
        HashMap<String, String> convertHash = new HashMap<String, String>();
        if (Tools.versionBeforePacemaker(host)) {
            convertHash.put("first", "to");
            convertHash.put("then", "from");
            convertHash.put("first-action", "action");
            convertHash.put("then-action", "to_action");
        }
        for (String attr : attrs.keySet()) {
            String value = attrs.get(attr);
            if ("".equals(value)) continue;
            if (convertHash.containsKey(attr)) {
                attr = (String)convertHash.get(attr);
            }
            xml.append("\" " + attr + "=\"");
            xml.append(value);
        }
        xml.append("\"/>'");
        String command = CRM.getCibCommand(cibadminOpt, "constraints", xml.toString());
        SSH.SSHOutput ret = CRM.execCommand(host, command, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean standByOn(Host host, Host standByHost, boolean testOnly) {
        String cmd = "CRM.standByOn";
        if (Tools.versionBeforePacemaker(host)) {
            cmd = "CRM.2.1.4.standByOn";
        }
        HashMap<String, String> replaceHash = new HashMap<String, String>();
        replaceHash.put("@HOST@", standByHost.getName());
        String command = host.getDistCommand(cmd, replaceHash);
        SSH.SSHOutput ret = CRM.execCommand(host, command, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean standByOff(Host host, Host standByHost, boolean testOnly) {
        HashMap<String, String> replaceHash = new HashMap<String, String>();
        String cmd = "CRM.standByOff";
        if (Tools.versionBeforePacemaker(host)) {
            cmd = "CRM.2.1.4.standByOff";
        }
        replaceHash.put("@HOST@", standByHost.getName());
        String command = host.getDistCommand(cmd, replaceHash);
        SSH.SSHOutput ret = CRM.execCommand(host, command, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static boolean erase(Host host, boolean testOnly) {
        Map<String, String> replaceHash = Collections.emptyMap();
        String command = host.getDistCommand("CRM.erase", replaceHash);
        SSH.SSHOutput ret = CRM.execCommand(host, command, true, testOnly);
        return ret.getExitCode() == 0;
    }

    public static String crmConfigureCommit(Host host, String config, boolean testOnly) {
        HashMap<String, String> replaceHash = new HashMap<String, String>();
        replaceHash.put("@CONFIG@", Tools.escapeQuotes(Matcher.quoteReplacement(config), 1));
        String command = host.getDistCommand("CRM.configureCommit", replaceHash);
        SSH.SSHOutput ret = CRM.execCommand(host, command, true, testOnly);
        if (ret.getExitCode() == 0) {
            return ret.getOutput();
        }
        return "error";
    }
}

