/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import lcmc.AddVMConfigDialog;
import lcmc.data.AccessMode;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.data.VMSXML;
import lcmc.gui.Browser;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.HostBrowser;
import lcmc.gui.resources.CategoryInfo;
import lcmc.gui.resources.Info;
import lcmc.gui.resources.VMSVirtualDomainInfo;
import lcmc.utilities.MyButton;
import lcmc.utilities.MyMenuItem;
import lcmc.utilities.Tools;
import lcmc.utilities.UpdatableItem;

public final class VMSInfo
extends CategoryInfo {
    private volatile Map<String, VMSVirtualDomainInfo> domainToInfo = new HashMap<String, VMSVirtualDomainInfo>();
    private volatile Map<String, Color> domainToColor = new HashMap<String, Color>();
    private static final Map<Integer, Integer> DEFAULT_WIDTHS = new HashMap<Integer, Integer>();

    public VMSInfo(String name, Browser browser) {
        super(name, browser);
    }

    @Override
    protected ClusterBrowser getBrowser() {
        return (ClusterBrowser)super.getBrowser();
    }

    @Override
    protected String[] getColumnNames(String tableName) {
        return new String[]{"Name", "Defined on", "Status", "Memory", ""};
    }

    @Override
    protected Object[][] getTableData(String tableName) {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        TreeSet<String> domainNames = new TreeSet<String>();
        for (Host host : this.getBrowser().getClusterHosts()) {
            VMSXML vxml = this.getBrowser().getVMSXML(host);
            if (vxml == null) continue;
            domainNames.addAll(vxml.getDomainNames());
        }
        HashMap<String, VMSVirtualDomainInfo> dti = new HashMap<String, VMSVirtualDomainInfo>();
        HashMap<String, Color> dtc = new HashMap<String, Color>();
        for (String domainName : domainNames) {
            VMSVirtualDomainInfo vmsvdi;
            ImageIcon hostIcon = HostBrowser.HOST_OFF_ICON_LARGE;
            for (Host host : this.getBrowser().getClusterHosts()) {
                VMSXML vxml = this.getBrowser().getVMSXML(host);
                if (vxml == null || !vxml.isRunning(domainName)) continue;
                Color bgColor = host.getPmColors()[0];
                dtc.put(domainName, bgColor);
                if (vxml.isSuspended(domainName)) {
                    hostIcon = VMSVirtualDomainInfo.PAUSE_ICON;
                    break;
                }
                hostIcon = HostBrowser.HOST_ON_ICON_LARGE;
                break;
            }
            if ((vmsvdi = this.getBrowser().findVMSVirtualDomainInfo(domainName)) == null) continue;
            dti.put(domainName, vmsvdi);
            MyButton domainNameLabel = new MyButton(domainName, hostIcon);
            MyButton removeDomain = new MyButton("Remove", ClusterBrowser.REMOVE_ICON_SMALL, "Remove " + domainName + " domain");
            removeDomain.miniButton();
            rows.add(new Object[]{domainNameLabel, vmsvdi.getDefinedOnString(), vmsvdi.getRunningOnString(), vmsvdi.getResource().getValue("memory"), removeDomain});
        }
        this.domainToInfo = dti;
        this.domainToColor = dtc;
        return (Object[][])rows.toArray((T[])new Object[rows.size()][]);
    }

    @Override
    protected Info getTableInfo(String tableName, String key) {
        return this.domainToInfo.get(key);
    }

    @Override
    protected void rowClicked(String tableName, String key, final int column) {
        final VMSVirtualDomainInfo vmsvdi = this.domainToInfo.get(key);
        if (vmsvdi != null) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (DEFAULT_WIDTHS.containsKey(column)) {
                        vmsvdi.removeMyself(false);
                    } else {
                        vmsvdi.selectMyself();
                    }
                }
            });
            t.start();
        }
    }

    @Override
    protected int getTableColumnAlignment(String tableName, int column) {
        if (column == 3) {
            return 4;
        }
        return 2;
    }

    @Override
    public void selectMyself() {
        super.selectMyself();
        this.getBrowser().nodeChanged(this.getNode());
    }

    @Override
    protected Comparator<Object> getColComparator(String tableName, int col) {
        if (col == 0) {
            Comparator<Object> c = new Comparator<Object>(){

                @Override
                public int compare(Object l1, Object l2) {
                    return ((MyButton)l1).getText().compareToIgnoreCase(((MyButton)l2).getText());
                }
            };
            return c;
        }
        if (col == 3) {
            Comparator<Object> c = new Comparator<Object>(){

                @Override
                public int compare(Object s1, Object s2) {
                    long i2;
                    long i1 = Tools.convertToKilobytes((String)s1);
                    if (i1 < (i2 = Tools.convertToKilobytes((String)s2))) {
                        return -1;
                    }
                    if (i1 > i2) {
                        return 1;
                    }
                    return 0;
                }
            };
            return c;
        }
        return null;
    }

    @Override
    protected Color getTableRowColor(String tableName, String key) {
        Color c = this.domainToColor.get(key);
        if (c == null) {
            return Browser.PANEL_BACKGROUND;
        }
        return c;
    }

    @Override
    protected JComponent getNewButton() {
        MyButton newButton = new MyButton(Tools.getString("VMSInfo.AddNewDomain"));
        newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        VMSInfo.this.addDomainPanel();
                    }
                });
                t.start();
            }
        });
        JPanel bp = new JPanel(new FlowLayout(0, 0, 0));
        bp.setBackground(ClusterBrowser.BUTTON_PANEL_BACKGROUND);
        bp.add(newButton);
        Dimension d = bp.getPreferredSize();
        bp.setMaximumSize(new Dimension(Short.MAX_VALUE, (int)d.getHeight()));
        return bp;
    }

    public void addDomainPanel() {
        final VMSVirtualDomainInfo vmsdi = new VMSVirtualDomainInfo(null, this.getBrowser());
        vmsdi.getResource().setNew(true);
        DefaultMutableTreeNode resource = new DefaultMutableTreeNode(vmsdi);
        this.getBrowser().setNode(resource);
        this.getNode().add(resource);
        this.getBrowser().reload(this.getNode(), true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                vmsdi.getInfoPanel();
                vmsdi.selectMyself();
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        AddVMConfigDialog avmcd = new AddVMConfigDialog(vmsdi);
                        avmcd.showDialogs();
                    }
                });
                t.start();
            }
        });
    }

    @Override
    public List<UpdatableItem> createPopup() {
        ArrayList<UpdatableItem> items = new ArrayList<UpdatableItem>();
        MyMenuItem newDomainMenuItem = new MyMenuItem(Tools.getString("VMSInfo.AddNewDomain"), HostBrowser.HOST_OFF_ICON_LARGE, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public void action() {
                VMSInfo.this.hidePopup();
                VMSInfo.this.addDomainPanel();
            }
        };
        items.add(newDomainMenuItem);
        return items;
    }

    @Override
    protected Map<Integer, Integer> getDefaultWidths(String tableName) {
        return DEFAULT_WIDTHS;
    }

    @Override
    protected boolean isControlButton(String tableName, int column) {
        return DEFAULT_WIDTHS.containsKey(column);
    }

    @Override
    protected String getTableToolTip(String tableName, String key, Object object, int raw, int column) {
        if (DEFAULT_WIDTHS.containsKey(column)) {
            return "Remove domain " + key + ".";
        }
        return super.getTableToolTip(tableName, key, object, raw, column);
    }

    static {
        DEFAULT_WIDTHS.put(4, 80);
    }
}

