/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import lcmc.data.CRMXML;
import lcmc.data.ClusterStatus;
import lcmc.data.ConfigData;
import lcmc.data.resources.Resource;
import lcmc.gui.Browser;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.resources.EditableInfo;
import lcmc.gui.resources.ServicesInfo;
import lcmc.gui.widget.Widget;
import lcmc.utilities.Tools;

public final class RscDefaultsInfo
extends EditableInfo {
    public RscDefaultsInfo(String name, Browser browser) {
        super(name, browser);
        this.setResource(new Resource(name));
    }

    @Override
    protected ClusterBrowser getBrowser() {
        return (ClusterBrowser)super.getBrowser();
    }

    public void setParameters(Map<String, String> resourceNode) {
        if (resourceNode == null) {
            return;
        }
        CRMXML crmXML = this.getBrowser().getCRMXML();
        if (crmXML == null) {
            Tools.appError("crmXML is null");
            return;
        }
        String[] params = this.getParametersFromXML();
        ClusterStatus cs = this.getBrowser().getClusterStatus();
        if (params != null) {
            for (String param : params) {
                boolean haveChanged;
                String value = resourceNode.get(param);
                String defaultValue = this.getParamDefault(param);
                if (value == null) {
                    value = defaultValue;
                }
                if (value == null) {
                    value = "";
                }
                String oldValue = this.getParamSaved(param);
                Widget wi = this.getWidget(param, null);
                boolean bl = haveChanged = !Tools.areEqual(value, oldValue) || !Tools.areEqual(defaultValue, this.getResource().getDefaultValue(param));
                if (!haveChanged) continue;
                this.getResource().setValue(param, value);
                this.getResource().setDefaultValue(param, defaultValue);
                if (wi == null) continue;
                wi.setValue(value);
            }
        }
    }

    @Override
    public String[] getParametersFromXML() {
        CRMXML crmXML = this.getBrowser().getCRMXML();
        if (crmXML == null) {
            return null;
        }
        Set<String> params = crmXML.getRscDefaultsParameters().keySet();
        return params.toArray(new String[params.size()]);
    }

    @Override
    protected boolean checkParam(String param, String newValue) {
        CRMXML crmXML = this.getBrowser().getCRMXML();
        return crmXML.checkMetaAttrParam(param, newValue);
    }

    @Override
    protected String getParamDefault(String param) {
        if ("resource-stickiness".equals(param)) {
            return this.getBrowser().getServicesInfo().getResource().getValue("default-resource-stickiness");
        }
        CRMXML crmXML = this.getBrowser().getCRMXML();
        return crmXML.getRscDefaultsDefault(param);
    }

    @Override
    protected String getParamSaved(String param) {
        ClusterStatus clStatus = this.getBrowser().getClusterStatus();
        String value = super.getParamSaved(param);
        if (value == null && (value = clStatus.getRscDefaultsParameter(param, false)) == null && (value = this.getParamPreferred(param)) == null) {
            return this.getParamDefault(param);
        }
        return value;
    }

    @Override
    protected String getParamPreferred(String param) {
        CRMXML crmXML = this.getBrowser().getCRMXML();
        return crmXML.getRscDefaultsPreferred(param);
    }

    @Override
    protected Object[] getParamPossibleChoices(String param) {
        CRMXML crmXML = this.getBrowser().getCRMXML();
        if (this.isCheckBox(param)) {
            return crmXML.getRscDefaultsCheckBoxChoices(param);
        }
        return crmXML.getRscDefaultsPossibleChoices(param);
    }

    @Override
    protected String getParamShortDesc(String param) {
        CRMXML crmXML = this.getBrowser().getCRMXML();
        return crmXML.getRscDefaultsShortDesc(param);
    }

    @Override
    protected String getParamLongDesc(String param) {
        CRMXML crmXML = this.getBrowser().getCRMXML();
        return crmXML.getRscDefaultsLongDesc(param);
    }

    @Override
    protected String getSection(String param) {
        CRMXML crmXML = this.getBrowser().getCRMXML();
        return crmXML.getRscDefaultsSection(param);
    }

    @Override
    protected boolean isAdvanced(String param) {
        if (!Tools.areEqual(this.getParamDefault(param), this.getParamSaved(param))) {
            return false;
        }
        CRMXML crmXML = this.getBrowser().getCRMXML();
        return crmXML.isRscDefaultsAdvanced(param);
    }

    @Override
    protected ConfigData.AccessType getAccessType(String param) {
        return this.getBrowser().getCRMXML().getRscDefaultsAccessType(param);
    }

    @Override
    protected String isEnabled(String param) {
        return null;
    }

    @Override
    protected boolean isEnabledOnlyInAdvancedMode(String param) {
        return false;
    }

    @Override
    protected boolean isRequired(String param) {
        CRMXML crmXML = this.getBrowser().getCRMXML();
        return crmXML.isRscDefaultsRequired(param);
    }

    protected boolean isMetaAttr(String param) {
        return true;
    }

    @Override
    protected boolean isInteger(String param) {
        CRMXML crmXML = this.getBrowser().getCRMXML();
        return crmXML.isRscDefaultsInteger(param);
    }

    @Override
    protected boolean isLabel(String param) {
        CRMXML crmXML = this.getBrowser().getCRMXML();
        return crmXML.isRscDefaultsLabel(param);
    }

    @Override
    protected boolean isTimeType(String param) {
        CRMXML crmXML = this.getBrowser().getCRMXML();
        return crmXML.isRscDefaultsTimeType(param);
    }

    @Override
    protected boolean isCheckBox(String param) {
        CRMXML crmXML = this.getBrowser().getCRMXML();
        return crmXML.isRscDefaultsBoolean(param);
    }

    @Override
    protected String getParamType(String param) {
        CRMXML crmXML = this.getBrowser().getCRMXML();
        return crmXML.getRscDefaultsType(param);
    }

    @Override
    public JPanel getGraphicalView() {
        return this.getBrowser().getCRMGraph().getGraphPanel();
    }

    @Override
    boolean checkResourceFieldsChanged(String param, String[] params) {
        return this.checkResourceFieldsChanged(param, params, false);
    }

    boolean checkResourceFieldsChanged(String param, String[] params, boolean fromServicesInfo) {
        if (fromServicesInfo) {
            return super.checkResourceFieldsChanged(param, params);
        }
        ServicesInfo ssi = this.getBrowser().getServicesInfo();
        return ssi.checkResourceFieldsChanged(param, ssi.getParametersFromXML());
    }

    @Override
    boolean checkResourceFieldsCorrect(String param, String[] params) {
        return this.checkResourceFieldsCorrect(param, params, false);
    }

    boolean checkResourceFieldsCorrect(String param, String[] params, boolean fromServicesInfo) {
        if (fromServicesInfo) {
            return super.checkResourceFieldsCorrect(param, params);
        }
        ServicesInfo ssi = this.getBrowser().getServicesInfo();
        return ssi.checkResourceFieldsCorrect(param, ssi.getParametersFromXML());
    }
}

