/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.util.Map;
import lcmc.data.AccessMode;
import lcmc.data.ResourceAgent;
import lcmc.gui.Browser;
import lcmc.gui.resources.ServiceInfo;
import lcmc.gui.resources.StringInfo;
import lcmc.gui.widget.Widget;
import lcmc.gui.widget.WidgetFactory;
import lcmc.utilities.Tools;

final class IPaddrInfo
extends ServiceInfo {
    IPaddrInfo(String name, ResourceAgent ra, Browser browser) {
        super(name, ra, browser);
    }

    IPaddrInfo(String name, ResourceAgent ra, String hbId, Map<String, String> resourceNode, Browser browser) {
        super(name, ra, hbId, resourceNode, browser);
    }

    @Override
    boolean checkResourceFieldsCorrect(String param, String[] params) {
        String ip;
        Widget wi;
        boolean ret = super.checkResourceFieldsCorrect(param, params);
        if (this.getResourceAgent().isHeartbeatClass()) {
            wi = this.getWidget("1", null);
        } else if (this.getResourceAgent().isOCFClass()) {
            wi = this.getWidget("ip", null);
        } else {
            return true;
        }
        if (wi == null) {
            return false;
        }
        wi.setEditable(true);
        wi.selectSubnet();
        if (ret && !Tools.isIp(ip = wi.getStringValue())) {
            ret = false;
        }
        return ret;
    }

    @Override
    protected Widget createWidget(String param, String prefix, int width) {
        Widget paramWi;
        if ("ip".equals(param)) {
            String ip = this.getPreviouslySelected(param, prefix);
            if (ip == null) {
                ip = this.getParamSaved(param);
            }
            StringInfo defaultValue = ip == null || "".equals(ip) ? new StringInfo(Tools.getString("ClusterBrowser.SelectNetInterface"), ip, this.getBrowser()) : new StringInfo(ip, ip, this.getBrowser());
            Object[] networks = this.enumToInfoArray(defaultValue, this.getName(), this.getBrowser().getNetworksNode().children());
            String regexp = "^[\\d.*]*|Select\\.\\.\\.$";
            paramWi = WidgetFactory.createInstance(Widget.Type.COMBOBOX, ip, networks, "^[\\d.*]*|Select\\.\\.\\.$", width, Widget.NO_ABBRV, new AccessMode(this.getAccessType(param), this.isEnabledOnlyInAdvancedMode(param)), Widget.NO_BUTTON);
            paramWi.setAlwaysEditable(true);
            this.widgetAdd(param, prefix, paramWi);
        } else {
            paramWi = super.createWidget(param, prefix, width);
        }
        return paramWi;
    }

    @Override
    public String toString() {
        String id = this.getService().getId();
        if (id == null) {
            return super.toString();
        }
        StringBuilder s = new StringBuilder(this.getName());
        String inside = id + " / ";
        String ip = this.getParamSaved("ip");
        if (ip == null || "".equals(ip)) {
            ip = Tools.getString("ClusterBrowser.Ip.Unconfigured");
        }
        s.append(" (");
        s.append(inside);
        s.append(ip);
        s.append(')');
        return s.toString();
    }
}

