/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SpringLayout;
import lcmc.AddDrbdUpgradeDialog;
import lcmc.EditHostDialog;
import lcmc.ProxyHostWizard;
import lcmc.data.AccessMode;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.data.Subtext;
import lcmc.data.resources.BlockDevice;
import lcmc.gui.Browser;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.DrbdGraph;
import lcmc.gui.HostBrowser;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.drbd.DrbdsLog;
import lcmc.gui.dialog.lvm.LVCreate;
import lcmc.gui.dialog.lvm.VGCreate;
import lcmc.gui.resources.Info;
import lcmc.utilities.DRBD;
import lcmc.utilities.ExecCallback;
import lcmc.utilities.MyButton;
import lcmc.utilities.MyMenu;
import lcmc.utilities.MyMenuItem;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;
import lcmc.utilities.UpdatableItem;

public final class HostDrbdInfo
extends Info {
    private final Host host;
    static final String NO_DRBD_STATUS_STRING = "drbd status is not available";
    private static final String LVM_MENU = "LVM";
    private static final String VG_CREATE_MENU_ITEM = "Create VG";
    private static final String VG_CREATE_MENU_DESCRIPTION = "Create a volume group.";
    private static final String LV_CREATE_MENU_ITEM = "Create LV in VG ";
    private static final String LV_CREATE_MENU_DESCRIPTION = "Create a logical volume.";

    public HostDrbdInfo(Host host, Browser browser) {
        super(host.getName(), browser);
        this.host = host;
    }

    @Override
    protected HostBrowser getBrowser() {
        return (HostBrowser)super.getBrowser();
    }

    @Override
    public ImageIcon getMenuIcon(boolean testOnly) {
        return HostBrowser.HOST_ICON;
    }

    @Override
    public String getId() {
        return this.host.getName();
    }

    @Override
    public ImageIcon getCategoryIcon(boolean testOnly) {
        return HostBrowser.HOST_ICON;
    }

    void upgradeDrbd() {
        AddDrbdUpgradeDialog adud = new AddDrbdUpgradeDialog(this);
        adud.showDialogs();
    }

    @Override
    public String getToolTipForGraph(boolean testOnly) {
        return this.getBrowser().getHostToolTip(this.host);
    }

    @Override
    public JComponent getInfoPanel() {
        Font f = new Font("Monospaced", 0, Tools.getConfigData().scaled(12));
        final JTextArea ta = new JTextArea();
        ta.setFont(f);
        final String stacktrace = Tools.getStackTrace();
        final ExecCallback execCallback = new ExecCallback(){

            @Override
            public void done(String ans) {
                ta.setText(ans);
            }

            @Override
            public void doneError(String ans, int exitCode) {
                ta.setText("error");
                Tools.sshError(HostDrbdInfo.this.host, "", ans, stacktrace, exitCode);
            }
        };
        MyButton procDrbdButton = new MyButton("/proc/drbd");
        procDrbdButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HostDrbdInfo.this.host.execCommand("DRBD.getProcDrbd", execCallback, null, false, SSH.DEFAULT_COMMAND_TIMEOUT);
            }
        });
        this.host.registerEnableOnConnect(procDrbdButton);
        MyButton drbdProcsButton = new MyButton("DRBD Processes");
        drbdProcsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HostDrbdInfo.this.host.execCommand("DRBD.getProcesses", execCallback, null, false, SSH.DEFAULT_COMMAND_TIMEOUT);
            }
        });
        this.host.registerEnableOnConnect(drbdProcsButton);
        JPanel mainPanel = new JPanel();
        mainPanel.setBackground(HostBrowser.PANEL_BACKGROUND);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setBackground(HostBrowser.BUTTON_PANEL_BACKGROUND);
        buttonPanel.setMinimumSize(new Dimension(0, Tools.getConfigData().scaled(50)));
        buttonPanel.setPreferredSize(new Dimension(0, Tools.getConfigData().scaled(50)));
        buttonPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, Tools.getConfigData().scaled(50)));
        mainPanel.add(buttonPanel);
        buttonPanel.add((Component)this.getActionsButton(), "East");
        JPanel p = new JPanel(new SpringLayout());
        p.setBackground(HostBrowser.BUTTON_PANEL_BACKGROUND);
        p.add(procDrbdButton);
        p.add(drbdProcsButton);
        SpringUtilities.makeCompactGrid(p, 2, 1, 1, 1, 1, 1);
        mainPanel.setMinimumSize(new Dimension(Tools.getDefaultSize("HostBrowser.ResourceInfoArea.Width"), Tools.getDefaultSize("HostBrowser.ResourceInfoArea.Height")));
        mainPanel.setPreferredSize(new Dimension(Tools.getDefaultSize("HostBrowser.ResourceInfoArea.Width"), Tools.getDefaultSize("HostBrowser.ResourceInfoArea.Height")));
        buttonPanel.add(p);
        mainPanel.add(new JScrollPane(ta));
        this.host.execCommand("DRBD.getProcDrbd", execCallback, null, false, SSH.DEFAULT_COMMAND_TIMEOUT);
        return mainPanel;
    }

    public Host getHost() {
        return this.host;
    }

    boolean equals(HostDrbdInfo otherHI) {
        if (otherHI == null) {
            return false;
        }
        return otherHI.toString().equals(this.host.getName());
    }

    @Override
    public String toString() {
        return this.host.getName();
    }

    @Override
    public String getName() {
        return this.host.getName();
    }

    @Override
    public List<UpdatableItem> createPopup() {
        ArrayList<UpdatableItem> items = new ArrayList<UpdatableItem>();
        MyMenuItem hostWizardItem = new MyMenuItem(Tools.getString("HostBrowser.HostWizard"), HostBrowser.HOST_ICON_LARGE, Tools.getString("HostBrowser.HostWizard"), new AccessMode(ConfigData.AccessType.RO, false), new AccessMode(ConfigData.AccessType.RO, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                return null;
            }

            @Override
            public void action() {
                EditHostDialog dialog = new EditHostDialog(HostDrbdInfo.this.host);
                dialog.showDialogs();
            }
        };
        items.add(hostWizardItem);
        Tools.getGUIData().registerAddHostButton(hostWizardItem);
        MyMenuItem proxyHostWizardItem = new MyMenuItem(Tools.getString("HostBrowser.ProxyHostWizard"), HostBrowser.HOST_ICON_LARGE, Tools.getString("HostBrowser.ProxyHostWizard"), new AccessMode(ConfigData.AccessType.RO, false), new AccessMode(ConfigData.AccessType.RO, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                return null;
            }

            @Override
            public void action() {
                ProxyHostWizard dialog = new ProxyHostWizard(HostDrbdInfo.this.host, null);
                dialog.showDialogs();
            }
        };
        items.add(proxyHostWizardItem);
        Tools.getGUIData().registerAddHostButton(proxyHostWizardItem);
        boolean testOnly = false;
        MyMenuItem loadItem = new MyMenuItem(Tools.getString("HostBrowser.Drbd.LoadDrbd"), null, Tools.getString("HostBrowser.Drbd.LoadDrbd"), new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (HostDrbdInfo.this.getHost().isConnected()) {
                    if (HostDrbdInfo.this.getHost().isDrbdLoaded()) {
                        return "already loaded";
                    }
                    return null;
                }
                return "not connected to the host";
            }

            @Override
            public void action() {
                DRBD.load(HostDrbdInfo.this.getHost(), false);
                HostDrbdInfo.this.getBrowser().getClusterBrowser().updateHWInfo(HostDrbdInfo.this.host);
            }
        };
        items.add(loadItem);
        MyMenuItem proxyItem = new MyMenuItem(Tools.getString("HostDrbdInfo.Drbd.StopProxy"), null, this.getMenuToolTip("DRBD.stopProxy", ""), Tools.getString("HostDrbdInfo.Drbd.StartProxy"), null, this.getMenuToolTip("DRBD.startProxy", ""), new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean predicate() {
                return HostDrbdInfo.this.getHost().isDrbdProxyRunning();
            }

            @Override
            public void action() {
                if (HostDrbdInfo.this.getHost().isDrbdProxyRunning()) {
                    DRBD.stopProxy(HostDrbdInfo.this.getHost(), false);
                } else {
                    DRBD.startProxy(HostDrbdInfo.this.getHost(), false);
                }
                HostDrbdInfo.this.getBrowser().getClusterBrowser().updateHWInfo(HostDrbdInfo.this.host);
            }
        };
        items.add(proxyItem);
        MyMenuItem allProxyUpItem = new MyMenuItem(Tools.getString("HostDrbdInfo.Drbd.AllProxyUp"), null, this.getMenuToolTip("DRBD.proxyUp", "all"), new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                if (!HostDrbdInfo.this.host.isConnected()) {
                    return false;
                }
                return HostDrbdInfo.this.host.isDrbdProxyRunning();
            }

            @Override
            public String enablePredicate() {
                return null;
            }

            @Override
            public void action() {
                DRBD.proxyUp(HostDrbdInfo.this.host, "all", null, false);
                HostDrbdInfo.this.getBrowser().getClusterBrowser().updateHWInfo(HostDrbdInfo.this.host);
            }
        };
        items.add(allProxyUpItem);
        MyMenuItem allProxyDownItem = new MyMenuItem(Tools.getString("HostDrbdInfo.Drbd.AllProxyDown"), null, this.getMenuToolTip("DRBD.proxyDown", "all"), new AccessMode(ConfigData.AccessType.ADMIN, true), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                if (!HostDrbdInfo.this.host.isConnected()) {
                    return false;
                }
                return HostDrbdInfo.this.host.isDrbdProxyRunning();
            }

            @Override
            public String enablePredicate() {
                return null;
            }

            @Override
            public void action() {
                DRBD.proxyDown(HostDrbdInfo.this.host, "all", null, false);
                HostDrbdInfo.this.getBrowser().getClusterBrowser().updateHWInfo(HostDrbdInfo.this.host);
            }
        };
        items.add(allProxyDownItem);
        MyMenuItem adjustAllItem = new MyMenuItem(Tools.getString("HostBrowser.Drbd.AdjustAllDrbd"), null, Tools.getString("HostBrowser.Drbd.AdjustAllDrbd.ToolTip"), new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (HostDrbdInfo.this.getHost().isConnected()) {
                    return null;
                }
                return "not connected to the host";
            }

            @Override
            public void action() {
                DRBD.adjust(HostDrbdInfo.this.getHost(), "all", null, false);
                HostDrbdInfo.this.getBrowser().getClusterBrowser().updateHWInfo(HostDrbdInfo.this.host);
            }
        };
        items.add(adjustAllItem);
        ClusterBrowser cb = this.getBrowser().getClusterBrowser();
        if (cb != null) {
            ClusterBrowser clusterBrowser = cb;
            clusterBrowser.getClass();
            ClusterBrowser.DRBDMenuItemCallback adjustAllItemCallback = new ClusterBrowser.DRBDMenuItemCallback(clusterBrowser, adjustAllItem, this.getHost()){
                {
                    ClusterBrowser clusterBrowser = x0;
                    clusterBrowser.getClass();
                    super(x1, x2);
                }

                @Override
                public void action(Host host) {
                    DRBD.adjust(HostDrbdInfo.this.getHost(), "all", null, true);
                }
            };
            this.addMouseOverListener(adjustAllItem, adjustAllItemCallback);
        }
        MyMenuItem upAllItem = new MyMenuItem(Tools.getString("HostBrowser.Drbd.UpAll"), null, Tools.getString("HostBrowser.Drbd.UpAll"), new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.ADMIN, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (!HostDrbdInfo.this.getHost().isDrbdStatus()) {
                    return HostDrbdInfo.NO_DRBD_STATUS_STRING;
                }
                return null;
            }

            @Override
            public void action() {
                DRBD.up(HostDrbdInfo.this.getHost(), "all", null, false);
            }
        };
        items.add(upAllItem);
        if (cb != null) {
            ClusterBrowser clusterBrowser = cb;
            clusterBrowser.getClass();
            ClusterBrowser.DRBDMenuItemCallback upAllItemCallback = new ClusterBrowser.DRBDMenuItemCallback(clusterBrowser, upAllItem, this.getHost()){
                {
                    ClusterBrowser clusterBrowser = x0;
                    clusterBrowser.getClass();
                    super(x1, x2);
                }

                @Override
                public void action(Host host) {
                    DRBD.up(HostDrbdInfo.this.getHost(), "all", null, true);
                }
            };
            this.addMouseOverListener(upAllItem, upAllItemCallback);
        }
        MyMenuItem upgradeDrbdItem = new MyMenuItem(Tools.getString("HostBrowser.Drbd.UpgradeDrbd"), null, Tools.getString("HostBrowser.Drbd.UpgradeDrbd"), new AccessMode(ConfigData.AccessType.GOD, false), new AccessMode(ConfigData.AccessType.ADMIN, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (!HostDrbdInfo.this.getHost().isConnected()) {
                    return "not connected to the host";
                }
                return null;
            }

            @Override
            public void action() {
                HostDrbdInfo.this.upgradeDrbd();
            }
        };
        items.add(upgradeDrbdItem);
        MyMenuItem changeHostColorItem = new MyMenuItem(Tools.getString("HostBrowser.Drbd.ChangeHostColor"), null, Tools.getString("HostBrowser.Drbd.ChangeHostColor"), new AccessMode(ConfigData.AccessType.RO, false), new AccessMode(ConfigData.AccessType.RO, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                return null;
            }

            @Override
            public void action() {
                Color newColor = JColorChooser.showDialog(Tools.getGUIData().getMainFrame(), "Choose " + HostDrbdInfo.this.host.getName() + " color", HostDrbdInfo.this.host.getPmColors()[0]);
                if (newColor != null) {
                    HostDrbdInfo.this.host.setSavedColor(newColor);
                }
            }
        };
        items.add(changeHostColorItem);
        MyMenuItem viewLogsItem = new MyMenuItem(Tools.getString("HostBrowser.Drbd.ViewLogs"), LOGFILE_ICON, Tools.getString("HostBrowser.Drbd.ViewLogs"), new AccessMode(ConfigData.AccessType.RO, false), new AccessMode(ConfigData.AccessType.RO, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (!HostDrbdInfo.this.getHost().isConnected()) {
                    return "not connected to the host";
                }
                return null;
            }

            @Override
            public void action() {
                DrbdsLog l = new DrbdsLog(HostDrbdInfo.this.host);
                l.showDialog();
            }
        };
        items.add(viewLogsItem);
        MyMenuItem connectAllItem = new MyMenuItem(Tools.getString("HostBrowser.Drbd.ConnectAll"), null, Tools.getString("HostBrowser.Drbd.ConnectAll"), new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (HostDrbdInfo.this.getHost().isDrbdStatus()) {
                    return null;
                }
                return HostDrbdInfo.NO_DRBD_STATUS_STRING;
            }

            @Override
            public void action() {
                DRBD.connect(HostDrbdInfo.this.getHost(), "all", null, true);
            }
        };
        items.add(connectAllItem);
        if (cb != null) {
            ClusterBrowser clusterBrowser = cb;
            clusterBrowser.getClass();
            ClusterBrowser.DRBDMenuItemCallback connectAllItemCallback = new ClusterBrowser.DRBDMenuItemCallback(clusterBrowser, connectAllItem, this.getHost()){
                {
                    ClusterBrowser clusterBrowser = x0;
                    clusterBrowser.getClass();
                    super(x1, x2);
                }

                @Override
                public void action(Host host) {
                    DRBD.connect(HostDrbdInfo.this.getHost(), "all", null, true);
                }
            };
            this.addMouseOverListener(connectAllItem, connectAllItemCallback);
        }
        MyMenuItem disconnectAllItem = new MyMenuItem(Tools.getString("HostBrowser.Drbd.DisconnectAll"), null, Tools.getString("HostBrowser.Drbd.DisconnectAll"), new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (HostDrbdInfo.this.getHost().isDrbdStatus()) {
                    return null;
                }
                return HostDrbdInfo.NO_DRBD_STATUS_STRING;
            }

            @Override
            public void action() {
                DRBD.disconnect(HostDrbdInfo.this.getHost(), "all", null, false);
            }
        };
        items.add(disconnectAllItem);
        if (cb != null) {
            ClusterBrowser clusterBrowser = cb;
            clusterBrowser.getClass();
            ClusterBrowser.DRBDMenuItemCallback disconnectAllItemCallback = new ClusterBrowser.DRBDMenuItemCallback(clusterBrowser, disconnectAllItem, this.getHost()){
                {
                    ClusterBrowser clusterBrowser = x0;
                    clusterBrowser.getClass();
                    super(x1, x2);
                }

                @Override
                public void action(Host host) {
                    DRBD.disconnect(HostDrbdInfo.this.getHost(), "all", null, true);
                }
            };
            this.addMouseOverListener(disconnectAllItem, disconnectAllItemCallback);
        }
        MyMenuItem attachAllItem = new MyMenuItem(Tools.getString("HostBrowser.Drbd.AttachAll"), null, Tools.getString("HostBrowser.Drbd.AttachAll"), new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (HostDrbdInfo.this.getHost().isDrbdStatus()) {
                    return null;
                }
                return HostDrbdInfo.NO_DRBD_STATUS_STRING;
            }

            @Override
            public void action() {
                DRBD.attach(HostDrbdInfo.this.getHost(), "all", null, false);
            }
        };
        items.add(attachAllItem);
        if (cb != null) {
            ClusterBrowser clusterBrowser = cb;
            clusterBrowser.getClass();
            ClusterBrowser.DRBDMenuItemCallback attachAllItemCallback = new ClusterBrowser.DRBDMenuItemCallback(clusterBrowser, attachAllItem, this.getHost()){
                {
                    ClusterBrowser clusterBrowser = x0;
                    clusterBrowser.getClass();
                    super(x1, x2);
                }

                @Override
                public void action(Host host) {
                    DRBD.attach(HostDrbdInfo.this.getHost(), "all", null, true);
                }
            };
            this.addMouseOverListener(attachAllItem, attachAllItemCallback);
        }
        MyMenuItem detachAllItem = new MyMenuItem(Tools.getString("HostBrowser.Drbd.DetachAll"), null, Tools.getString("HostBrowser.Drbd.DetachAll"), new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (HostDrbdInfo.this.getHost().isDrbdStatus()) {
                    return null;
                }
                return HostDrbdInfo.NO_DRBD_STATUS_STRING;
            }

            @Override
            public void action() {
                DRBD.detach(HostDrbdInfo.this.getHost(), "all", null, false);
            }
        };
        items.add(detachAllItem);
        if (cb != null) {
            ClusterBrowser clusterBrowser = cb;
            clusterBrowser.getClass();
            ClusterBrowser.DRBDMenuItemCallback detachAllItemCallback = new ClusterBrowser.DRBDMenuItemCallback(clusterBrowser, detachAllItem, this.getHost()){
                {
                    ClusterBrowser clusterBrowser = x0;
                    clusterBrowser.getClass();
                    super(x1, x2);
                }

                @Override
                public void action(Host host) {
                    DRBD.detach(HostDrbdInfo.this.getHost(), "all", null, true);
                }
            };
            this.addMouseOverListener(detachAllItem, detachAllItemCallback);
        }
        MyMenuItem setAllPrimaryItem = new MyMenuItem(Tools.getString("HostBrowser.Drbd.SetAllPrimary"), null, Tools.getString("HostBrowser.Drbd.SetAllPrimary"), new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (HostDrbdInfo.this.getHost().isDrbdStatus()) {
                    return null;
                }
                return HostDrbdInfo.NO_DRBD_STATUS_STRING;
            }

            @Override
            public void action() {
                DRBD.setPrimary(HostDrbdInfo.this.getHost(), "all", null, false);
            }
        };
        items.add(setAllPrimaryItem);
        if (cb != null) {
            ClusterBrowser clusterBrowser = cb;
            clusterBrowser.getClass();
            ClusterBrowser.DRBDMenuItemCallback setAllPrimaryItemCallback = new ClusterBrowser.DRBDMenuItemCallback(clusterBrowser, setAllPrimaryItem, this.getHost()){
                {
                    ClusterBrowser clusterBrowser = x0;
                    clusterBrowser.getClass();
                    super(x1, x2);
                }

                @Override
                public void action(Host host) {
                    DRBD.setPrimary(HostDrbdInfo.this.getHost(), "all", null, true);
                }
            };
            this.addMouseOverListener(setAllPrimaryItem, setAllPrimaryItemCallback);
        }
        MyMenuItem setAllSecondaryItem = new MyMenuItem(Tools.getString("HostBrowser.Drbd.SetAllSecondary"), null, Tools.getString("HostBrowser.Drbd.SetAllSecondary"), new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.ADMIN, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (HostDrbdInfo.this.getHost().isDrbdStatus()) {
                    return null;
                }
                return HostDrbdInfo.NO_DRBD_STATUS_STRING;
            }

            @Override
            public void action() {
                DRBD.setSecondary(HostDrbdInfo.this.getHost(), "all", null, false);
            }
        };
        items.add(setAllSecondaryItem);
        if (cb != null) {
            ClusterBrowser clusterBrowser = cb;
            clusterBrowser.getClass();
            ClusterBrowser.DRBDMenuItemCallback setAllSecondaryItemCallback = new ClusterBrowser.DRBDMenuItemCallback(clusterBrowser, setAllSecondaryItem, this.getHost()){
                {
                    ClusterBrowser clusterBrowser = x0;
                    clusterBrowser.getClass();
                    super(x1, x2);
                }

                @Override
                public void action(Host host) {
                    DRBD.setSecondary(HostDrbdInfo.this.getHost(), "all", null, true);
                }
            };
            this.addMouseOverListener(setAllSecondaryItem, setAllSecondaryItemCallback);
        }
        MyMenuItem removeHostItem = new MyMenuItem(Tools.getString("HostBrowser.RemoveHost"), HostBrowser.HOST_REMOVE_ICON, Tools.getString("HostBrowser.RemoveHost"), new AccessMode(ConfigData.AccessType.RO, false), new AccessMode(ConfigData.AccessType.RO, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (HostDrbdInfo.this.getHost().getCluster() != null) {
                    return "it is a member of a cluster";
                }
                return null;
            }

            @Override
            public void action() {
                HostDrbdInfo.this.getHost().disconnect();
                Tools.getConfigData().removeHostFromHosts(HostDrbdInfo.this.getHost());
                Tools.getGUIData().allHostsUpdate();
            }
        };
        items.add(removeHostItem);
        MyMenu hostAdvancedSubmenu = new MyMenu(Tools.getString("HostBrowser.AdvancedSubmenu"), new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (!HostDrbdInfo.this.host.isConnected()) {
                    return "not connected to the host";
                }
                return null;
            }

            @Override
            public void update() {
                super.update();
                HostDrbdInfo.this.getBrowser().addAdvancedMenu(this);
            }
        };
        items.add(hostAdvancedSubmenu);
        items.add(this.getLVMMenu());
        return items;
    }

    private MyMenu getLVMMenu() {
        return new MyMenu(LVM_MENU, new AccessMode(ConfigData.AccessType.OP, true), new AccessMode(ConfigData.AccessType.OP, true)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                return null;
            }

            @Override
            public void update() {
                super.update();
                HostDrbdInfo.this.addLVMMenu(this);
            }
        };
    }

    public void addLVMMenu(MyMenu submenu) {
        submenu.removeAll();
        submenu.add(this.getVGCreateItem());
        for (BlockDevice bd : this.getHost().getBlockDevices()) {
            BlockDevice drbdBD = bd.getDrbdBlockDevice();
            String vg = drbdBD == null ? bd.getVolumeGroupOnPhysicalVolume() : drbdBD.getVolumeGroupOnPhysicalVolume();
            if (vg == null) continue;
            submenu.add(this.getLVMCreateItem(vg, bd));
        }
    }

    private MyMenuItem getVGCreateItem() {
        MyMenuItem mi = new MyMenuItem(VG_CREATE_MENU_ITEM, null, VG_CREATE_MENU_DESCRIPTION, new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                return true;
            }

            @Override
            public String enablePredicate() {
                return null;
            }

            @Override
            public void action() {
                VGCreate vgCreate = new VGCreate(HostDrbdInfo.this.getHost(), null);
                do {
                    vgCreate.showDialog();
                    if (!vgCreate.isPressedCancelButton()) continue;
                    vgCreate.cancelDialog();
                    return;
                } while (!vgCreate.isPressedFinishButton());
            }
        };
        mi.setToolTipText(VG_CREATE_MENU_DESCRIPTION);
        return mi;
    }

    private MyMenuItem getLVMCreateItem(final String volumeGroup, final BlockDevice blockDevice) {
        String name = LV_CREATE_MENU_ITEM + volumeGroup;
        MyMenuItem mi = new MyMenuItem(name, null, LV_CREATE_MENU_DESCRIPTION, new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                return !"".equals(volumeGroup) && HostDrbdInfo.this.getHost().getVolumeGroupNames().contains(volumeGroup);
            }

            @Override
            public String enablePredicate() {
                return null;
            }

            @Override
            public void action() {
                LVCreate lvCreate = new LVCreate(HostDrbdInfo.this.getHost(), volumeGroup, blockDevice);
                do {
                    lvCreate.showDialog();
                    if (!lvCreate.isPressedCancelButton()) continue;
                    lvCreate.cancelDialog();
                    return;
                } while (!lvCreate.isPressedFinishButton());
            }

            @Override
            public void update() {
                this.setText1(HostDrbdInfo.LV_CREATE_MENU_ITEM + volumeGroup);
                super.update();
            }
        };
        mi.setToolTipText(LV_CREATE_MENU_DESCRIPTION);
        return mi;
    }

    @Override
    public JPanel getGraphicalView() {
        DrbdGraph dg = this.getBrowser().getDrbdGraph();
        if (dg == null) {
            return null;
        }
        dg.getDrbdInfo().setSelectedNode(null);
        return dg.getDrbdInfo().getGraphicalView();
    }

    public int getUsed() {
        return -1;
    }

    Subtext[] getSubtextsForGraph() {
        ArrayList<Subtext> texts = new ArrayList<Subtext>();
        if (this.getHost().isConnected()) {
            if (!this.getHost().isClStatus()) {
                texts.add(new Subtext("waiting for DRBD...", null, Color.BLACK));
            }
        } else {
            texts.add(new Subtext("connecting...", null, Color.BLACK));
        }
        return texts.toArray(new Subtext[texts.size()]);
    }

    public Subtext[] getSubtextsForDrbdGraph(boolean testOnly) {
        ArrayList<Subtext> texts = new ArrayList<Subtext>();
        if (this.getHost().isConnected()) {
            if (!this.getHost().isDrbdLoaded()) {
                texts.add(new Subtext("DRBD not loaded", null, Color.BLACK));
            } else if (!this.getHost().isDrbdStatus()) {
                texts.add(new Subtext("waiting...", null, Color.BLACK));
            }
        } else {
            texts.add(new Subtext("connecting...", null, Color.BLACK));
        }
        return texts.toArray(new Subtext[texts.size()]);
    }

    public String getIconTextForDrbdGraph(boolean testOnly) {
        if (!this.getHost().isConnected()) {
            return Tools.getString("HostBrowser.Drbd.NoInfoAvailable");
        }
        return null;
    }

    public Subtext getRightCornerTextForDrbdGraph(boolean testOnly) {
        return null;
    }

    private String getMenuToolTip(String cmd, String res) {
        return this.getHost().getDistString(cmd).replaceAll("@RES-VOL@", res).replaceAll("@.*?@", "");
    }
}

