/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.lvm;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import lcmc.data.Cluster;
import lcmc.data.Host;
import lcmc.data.resources.BlockDevice;
import lcmc.gui.Browser;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.lvm.LV;
import lcmc.gui.resources.BlockDevInfo;
import lcmc.utilities.LVM;
import lcmc.utilities.MyButton;
import lcmc.utilities.Tools;

public final class VGRemove
extends LV {
    private static final long serialVersionUID = 1L;
    private static final int REMOVE_TIMEOUT = 5000;
    private final MyButton removeButton = new MyButton("Remove VG");
    private final BlockDevInfo blockDevInfo;
    private Map<Host, JCheckBox> hostCheckBoxes = null;
    private static final String VG_REMOVE_DESCRIPTION = "Remove a volume group.";

    public VGRemove(BlockDevInfo blockDevInfo) {
        super(null);
        this.blockDevInfo = blockDevInfo;
    }

    @Override
    protected void finishDialog() {
    }

    @Override
    protected String getDialogTitle() {
        return "Remove VG";
    }

    @Override
    protected String getDescription() {
        return VG_REMOVE_DESCRIPTION;
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        this.enableComponentsLater(new JComponent[0]);
    }

    @Override
    protected void initDialogAfterVisible() {
        this.enableComponents();
        this.makeDefaultAndRequestFocus(this.removeButton);
    }

    protected void checkButtons() {
        SwingUtilities.invokeLater(new EnableRemoveRunnable(true));
    }

    @Override
    protected JComponent getInputPane() {
        this.removeButton.setEnabled(false);
        JPanel pane = new JPanel(new SpringLayout());
        JPanel inputPane = new JPanel(new SpringLayout());
        inputPane.setBackground(Browser.BUTTON_PANEL_BACKGROUND);
        inputPane.add(new JLabel("Volume Group: "));
        String vgName = this.blockDevInfo.getBlockDevice().isDrbd() ? this.blockDevInfo.getBlockDevice().getDrbdBlockDevice().getVolumeGroupOnPhysicalVolume() : this.blockDevInfo.getBlockDevice().getVolumeGroupOnPhysicalVolume();
        inputPane.add(new JLabel(vgName));
        this.removeButton.addActionListener(new RemoveActionListener());
        inputPane.add(this.removeButton);
        SpringUtilities.makeCompactGrid(inputPane, 1, 3, 1, 1, 1, 1);
        pane.add(inputPane);
        JPanel bdPane = new JPanel(new FlowLayout(0));
        bdPane.add(new JLabel("Block Devices: "));
        ArrayList<String> bds = new ArrayList<String>();
        for (BlockDevice bd : this.blockDevInfo.getHost().getBlockDevices()) {
            String thisVG = bd.getVolumeGroupOnPhysicalVolume();
            if (!vgName.equals(thisVG)) continue;
            bds.add(bd.getName());
        }
        if (this.blockDevInfo.getBlockDevice().isDrbd()) {
            for (BlockDevice bd : this.blockDevInfo.getHost().getDrbdBlockDevices()) {
                String thisVG = bd.getVolumeGroupOnPhysicalVolume();
                if (!vgName.equals(thisVG)) continue;
                bds.add(bd.getName());
            }
        }
        bdPane.add(new JLabel(Tools.join(", ", bds)));
        pane.add(bdPane);
        JPanel hostsPane = new JPanel(new FlowLayout(0));
        Cluster cluster = this.blockDevInfo.getHost().getCluster();
        this.hostCheckBoxes = Tools.getHostCheckBoxes(cluster);
        hostsPane.add(new JLabel("Select Hosts: "));
        for (Host h : this.hostCheckBoxes.keySet()) {
            this.hostCheckBoxes.get(h).addItemListener(new ItemChangeListener(true));
            Set<String> vgs = h.getVolumeGroupNames();
            if (this.blockDevInfo.getHost() == h) {
                this.hostCheckBoxes.get(h).setEnabled(false);
                this.hostCheckBoxes.get(h).setSelected(true);
            } else if (this.blockDevInfo.getBlockDevice().isDrbd() || !vgs.contains(vgName)) {
                this.hostCheckBoxes.get(h).setEnabled(false);
                this.hostCheckBoxes.get(h).setSelected(false);
            } else {
                this.hostCheckBoxes.get(h).setEnabled(true);
                this.hostCheckBoxes.get(h).setSelected(false);
            }
            hostsPane.add(this.hostCheckBoxes.get(h));
        }
        JScrollPane sp = new JScrollPane(hostsPane);
        sp.setPreferredSize(new Dimension(0, 45));
        pane.add(sp);
        pane.add(this.getProgressBarPane(null));
        pane.add(this.getAnswerPane(""));
        SpringUtilities.makeCompactGrid(pane, 5, 1, 0, 0, 0, 0);
        this.checkButtons();
        return pane;
    }

    private boolean vgRemove(Host host, String vgName) {
        boolean ret = LVM.vgRemove(host, vgName, false);
        if (ret) {
            this.answerPaneAddText("Volume group " + vgName + " was successfully removed " + " on " + host.getName() + ".");
        } else {
            this.answerPaneAddTextError("Removing volume group " + vgName + " on " + host.getName() + " failed.");
        }
        return ret;
    }

    private class ItemChangeListener
    implements ItemListener {
        private final boolean onDeselect;

        public ItemChangeListener(boolean onDeselect) {
            this.onDeselect = onDeselect;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1 || this.onDeselect) {
                VGRemove.this.checkButtons();
            }
        }
    }

    private class RemoveActionListener
    implements ActionListener {
        private RemoveActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    Tools.invokeAndWait(new EnableRemoveRunnable(false));
                    VGRemove.this.disableComponents();
                    VGRemove.this.getProgressBar().start(5000 * VGRemove.this.hostCheckBoxes.size());
                    String vgName = VGRemove.this.blockDevInfo.getBlockDevice().isDrbd() ? VGRemove.this.blockDevInfo.getBlockDevice().getDrbdBlockDevice().getVolumeGroupOnPhysicalVolume() : VGRemove.this.blockDevInfo.getBlockDevice().getVolumeGroupOnPhysicalVolume();
                    boolean oneFailed = false;
                    for (Host h : VGRemove.this.hostCheckBoxes.keySet()) {
                        boolean ret;
                        if (!((JCheckBox)VGRemove.this.hostCheckBoxes.get(h)).isSelected() || (ret = VGRemove.this.vgRemove(h, vgName))) continue;
                        oneFailed = true;
                    }
                    for (Host h : VGRemove.this.hostCheckBoxes.keySet()) {
                        h.getBrowser().getClusterBrowser().updateHWInfo(h);
                    }
                    VGRemove.this.enableComponents();
                    if (oneFailed) {
                        VGRemove.this.checkButtons();
                        VGRemove.this.progressBarDoneError();
                    } else {
                        VGRemove.this.progressBarDone();
                        VGRemove.this.disposeDialog();
                    }
                }
            });
            thread.start();
        }
    }

    private class EnableRemoveRunnable
    implements Runnable {
        private final boolean enable;

        public EnableRemoveRunnable(boolean enable) {
            this.enable = enable;
        }

        @Override
        public void run() {
            boolean e = this.enable;
            VGRemove.this.removeButton.setEnabled(e);
        }
    }
}

