/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.drbdUpgrade;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import lcmc.data.Host;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.drbdUpgrade.LinbitLogin;
import lcmc.gui.dialog.host.DialogHost;
import lcmc.utilities.ExecCallback;
import lcmc.utilities.MyButton;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;

final class CheckInstallation
extends DialogHost {
    private static final long serialVersionUID = 1L;
    private WizardDialog nextDialogObject = null;
    private static final JLabel DRBD_LABEL = new JLabel(": " + Tools.getString("Dialog.Host.CheckInstallation.CheckingDrbd"));
    private static final MyButton DRBD_BUTTON = new MyButton(Tools.getString("Dialog.Host.CheckInstallation.DrbdInstallButton"));
    private static final ImageIcon CHECKING_ICON = Tools.createImageIcon(Tools.getDefault("Dialog.Host.CheckInstallation.CheckingIcon"));
    private static final ImageIcon NOT_INSTALLED_ICON = Tools.createImageIcon(Tools.getDefault("Dialog.Host.CheckInstallation.NotInstalledIcon"));
    private static final ImageIcon INSTALLED_ICON = Tools.createImageIcon(Tools.getDefault("Dialog.Host.CheckInstallation.InstalledIcon"));
    private static final ImageIcon UPGR_AVAIL_ICON = Tools.createImageIcon(Tools.getDefault("Dialog.Host.CheckInstallation.UpgrAvailIcon"));
    private static final JLabel DRBD_ICON = new JLabel(CHECKING_ICON);
    private boolean drbdOk = false;

    CheckInstallation(WizardDialog previousDialog, Host host) {
        super(previousDialog, host);
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        this.drbdOk = false;
        final CheckInstallation thisClass = this;
        DRBD_BUTTON.setEnabled(false);
        DRBD_BUTTON.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CheckInstallation.this.drbdOk) {
                    CheckInstallation.this.getHost().setDrbdWillBeUpgraded(true);
                }
                CheckInstallation.this.nextDialogObject = new LinbitLogin(thisClass, CheckInstallation.this.getHost());
                CheckInstallation.this.buttonClass(CheckInstallation.this.nextButton()).pressButton();
            }
        });
        this.enableComponentsLater(new JComponent[]{this.buttonClass(this.finishButton())});
    }

    @Override
    protected void initDialogAfterVisible() {
        this.getHost().execCommand("DrbdCheck.version", this.getProgressBar(), new ExecCallback(){

            @Override
            public void done(String ans) {
                CheckInstallation.this.checkDrbd(ans);
            }

            @Override
            public void doneError(String ans, int exitCode) {
                CheckInstallation.this.checkDrbd("");
            }
        }, null, false, SSH.DEFAULT_COMMAND_TIMEOUT);
    }

    void checkDrbd(String ans) {
        if ("".equals(ans) || "\n".equals(ans)) {
            DRBD_LABEL.setText(": " + Tools.getString("Dialog.Host.CheckInstallation.DrbdNotInstalled"));
            DRBD_ICON.setIcon(NOT_INSTALLED_ICON);
            DRBD_BUTTON.setEnabled(true);
        } else {
            DRBD_LABEL.setText(": " + ans.trim());
            this.drbdOk = true;
            if (this.getHost().isDrbdUpgradeAvailable(ans.trim())) {
                DRBD_ICON.setIcon(UPGR_AVAIL_ICON);
                DRBD_BUTTON.setText(Tools.getString("Dialog.Host.CheckInstallation.DrbdUpgradeButton"));
                DRBD_BUTTON.setEnabled(true);
            } else {
                DRBD_ICON.setIcon(INSTALLED_ICON);
            }
        }
        if (this.drbdOk) {
            this.answerPaneSetText(Tools.getString("Dialog.Host.CheckInstallation.AllOk"));
            this.enableComponents();
            this.progressBarDone();
        } else {
            this.progressBarDoneError();
            this.printErrorAndRetry(Tools.getString("Dialog.Host.CheckInstallation.SomeFailed"));
        }
    }

    @Override
    public WizardDialog nextDialog() {
        return this.nextDialogObject;
    }

    @Override
    protected String getHostDialogTitle() {
        return Tools.getString("Dialog.Host.CheckInstallation.Title");
    }

    @Override
    protected String getDescription() {
        return Tools.getString("Dialog.Host.CheckInstallation.Description");
    }

    private JPanel getInstallationPane() {
        JPanel pane = new JPanel(new SpringLayout());
        pane.add(new JLabel("Drbd"));
        pane.add(DRBD_LABEL);
        pane.add(DRBD_BUTTON);
        pane.add(DRBD_ICON);
        SpringUtilities.makeCompactGrid(pane, 1, 4, 1, 1, 1, 1);
        return pane;
    }

    @Override
    protected JPanel getInputPane() {
        JPanel pane = new JPanel(new SpringLayout());
        pane.add(this.getInstallationPane());
        pane.add(this.getProgressBarPane());
        pane.add(this.getAnswerPane(Tools.getString("Dialog.Host.CheckInstallation.Checking")));
        SpringUtilities.makeCompactGrid(pane, 3, 1, 1, 1, 1, 1);
        return pane;
    }
}

