/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.drbdConfig;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import lcmc.data.AccessMode;
import lcmc.data.ConfigData;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.drbdConfig.CreateFS;
import lcmc.gui.dialog.drbdConfig.DrbdConfig;
import lcmc.gui.resources.BlockDevInfo;
import lcmc.gui.resources.DrbdVolumeInfo;
import lcmc.gui.widget.Widget;
import lcmc.gui.widget.WidgetFactory;
import lcmc.utilities.DRBD;
import lcmc.utilities.ExecCallback;
import lcmc.utilities.MyButton;
import lcmc.utilities.Tools;
import lcmc.utilities.WidgetListener;

final class CreateMD
extends DrbdConfig {
    private static final long serialVersionUID = 1L;
    private Widget metadataWi;
    private final MyButton makeMDButton = new MyButton();
    private static final int COMBOBOX_WIDTH = 250;
    private static final int CREATE_MD_FS_ALREADY_THERE_RC = 40;

    CreateMD(WizardDialog previousDialog, DrbdVolumeInfo dvi) {
        super(previousDialog, dvi);
    }

    private void createMetadata(final boolean destroyData) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CreateMD.this.makeMDButton.setEnabled(false);
            }
        });
        Thread[] thread = new Thread[2];
        final String[] answer = new String[2];
        final Integer[] returnCode = new Integer[2];
        final BlockDevInfo[] bdis = new BlockDevInfo[]{this.getDrbdVolumeInfo().getFirstBlockDevInfo(), this.getDrbdVolumeInfo().getSecondBlockDevInfo()};
        for (int i = 0; i < 2; ++i) {
            final int index = i;
            returnCode[index] = -1;
            thread[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    ExecCallback execCallback = new ExecCallback(){

                        @Override
                        public void done(String ans) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    CreateMD.this.makeMDButton.setEnabled(false);
                                }
                            });
                            answer[index] = ans;
                            returnCode[index] = 0;
                        }

                        @Override
                        public void doneError(String ans, int exitCode) {
                            answer[index] = ans;
                            returnCode[index] = exitCode;
                        }
                    };
                    String drbdMetaDisk = CreateMD.this.getDrbdVolumeInfo().getMetaDiskForHost(bdis[index].getHost());
                    if ("internal".equals(drbdMetaDisk)) {
                        drbdMetaDisk = bdis[index].getName();
                    }
                    boolean testOnly = false;
                    if (destroyData) {
                        DRBD.createMDDestroyData(bdis[index].getHost(), CreateMD.this.getDrbdVolumeInfo().getDrbdResourceInfo().getName(), CreateMD.this.getDrbdVolumeInfo().getName(), drbdMetaDisk, execCallback, false);
                    } else {
                        DRBD.createMD(bdis[index].getHost(), CreateMD.this.getDrbdVolumeInfo().getDrbdResourceInfo().getName(), CreateMD.this.getDrbdVolumeInfo().getName(), drbdMetaDisk, execCallback, false);
                    }
                }
            });
            thread[i].start();
        }
        boolean error = false;
        for (int i = 0; i < 2; ++i) {
            try {
                thread[i].join(0L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (returnCode[i] == 40) {
                answer[i] = Tools.getString("Dialog.DrbdConfig.CreateMD.CreateMD.Failed.40");
                error = true;
            } else if (returnCode[i] > 0) {
                answer[i] = Tools.getString("Dialog.DrbdConfig.CreateMD.CreateMD.Failed") + answer[i];
                error = true;
            } else {
                answer[i] = Tools.getString("Dialog.DrbdConfig.CreateMD.CreateMD.Done");
            }
            answer[i] = answer[i].replaceAll("@HOST@", Matcher.quoteReplacement(bdis[i].getHost().getName()));
        }
        if (error) {
            this.answerPaneSetTextError(Tools.join("\n", answer));
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CreateMD.this.makeMDButton.setEnabled(false);
                    CreateMD.this.buttonClass(CreateMD.this.nextButton()).setEnabled(true);
                    if (Tools.getConfigData().getAutoOptionGlobal("autodrbd") != null) {
                        CreateMD.this.pressNextButton();
                    }
                }
            });
            this.answerPaneSetText(Tools.join("\n", answer));
        }
    }

    @Override
    public WizardDialog nextDialog() {
        BlockDevInfo bdi1 = this.getDrbdVolumeInfo().getFirstBlockDevInfo();
        BlockDevInfo bdi2 = this.getDrbdVolumeInfo().getSecondBlockDevInfo();
        boolean testOnly = false;
        String clusterName = bdi1.getHost().getCluster().getName();
        Tools.startProgressIndicator(clusterName, "scanning block devices...");
        if (this.getDrbdVolumeInfo().getDrbdResourceInfo().isProxy(bdi1.getHost())) {
            DRBD.proxyUp(bdi1.getHost(), this.getDrbdVolumeInfo().getDrbdResourceInfo().getName(), null, false);
        }
        if (this.getDrbdVolumeInfo().getDrbdResourceInfo().isProxy(bdi2.getHost())) {
            DRBD.proxyUp(bdi2.getHost(), this.getDrbdVolumeInfo().getDrbdResourceInfo().getName(), null, false);
        }
        DRBD.adjust(bdi1.getHost(), this.getDrbdVolumeInfo().getDrbdResourceInfo().getName(), this.getDrbdVolumeInfo().getName(), false);
        DRBD.adjust(bdi2.getHost(), this.getDrbdVolumeInfo().getDrbdResourceInfo().getName(), this.getDrbdVolumeInfo().getName(), false);
        String device = this.getDrbdVolumeInfo().getDevice();
        ClusterBrowser browser = this.getDrbdVolumeInfo().getDrbdResourceInfo().getBrowser();
        browser.updateHWInfo(bdi1.getHost());
        browser.updateHWInfo(bdi2.getHost());
        bdi1.getBlockDevice().setDrbdBlockDevice(bdi1.getHost().getDrbdBlockDevice(device));
        bdi2.getBlockDevice().setDrbdBlockDevice(bdi2.getHost().getDrbdBlockDevice(device));
        Tools.stopProgressIndicator(clusterName, "scanning block devices...");
        return new CreateFS(this, this.getDrbdVolumeInfo());
    }

    @Override
    protected String getDialogTitle() {
        return Tools.getString("Dialog.DrbdConfig.CreateMD.Title");
    }

    @Override
    protected String getDescription() {
        return Tools.getString("Dialog.DrbdConfig.CreateMD.Description");
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        this.makeMDButton.setBackgroundColor(Tools.getDefaultColor("ConfigDialog.Button"));
        if (this.getDrbdVolumeInfo().getDrbdResourceInfo().isHaveToCreateMD()) {
            this.enableComponentsLater(new JComponent[0]);
        } else {
            this.enableComponentsLater(new JComponent[]{this.buttonClass(this.nextButton())});
        }
    }

    @Override
    protected void initDialogAfterVisible() {
        this.enableComponents();
        if (Tools.getConfigData().getAutoOptionGlobal("autodrbd") != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CreateMD.this.makeMDButton.pressButton();
                }
            });
        }
    }

    @Override
    protected JComponent getInputPane() {
        JPanel pane = new JPanel(new SpringLayout());
        JPanel inputPane = new JPanel(new SpringLayout());
        JLabel metadataLabel = new JLabel(Tools.getString("Dialog.DrbdConfig.CreateMD.Metadata"));
        final String useExistingMetadata = Tools.getString("Dialog.DrbdConfig.CreateMD.UseExistingMetadata");
        String createNewMetadata = Tools.getString("Dialog.DrbdConfig.CreateMD.CreateNewMetadata");
        final String createNewMetadataDestroyData = Tools.getString("Dialog.DrbdConfig.CreateMD.CreateNewMetadataDestroyData");
        if (this.getDrbdVolumeInfo().getDrbdResourceInfo().isHaveToCreateMD()) {
            Object[] choices = new String[]{createNewMetadata, createNewMetadataDestroyData};
            this.makeMDButton.setEnabled(true);
            this.makeMDButton.setText(Tools.getString("Dialog.DrbdConfig.CreateMD.CreateMDButton"));
            String metadataDefault = createNewMetadata;
            this.metadataWi = WidgetFactory.createInstance(Widget.Type.COMBOBOX, metadataDefault, choices, Widget.NO_REGEXP, 250, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.RO, false), Widget.NO_BUTTON);
        } else {
            Object[] choices = new String[]{useExistingMetadata, createNewMetadata, createNewMetadataDestroyData};
            this.makeMDButton.setEnabled(false);
            this.makeMDButton.setText(Tools.getString("Dialog.DrbdConfig.CreateMD.OverwriteMDButton"));
            String metadataDefault = useExistingMetadata;
            if (Tools.getConfigData().getAutoOptionGlobal("autodrbd") != null) {
                metadataDefault = createNewMetadata;
                this.makeMDButton.setEnabled(true);
            }
            this.metadataWi = WidgetFactory.createInstance(Widget.Type.COMBOBOX, metadataDefault, choices, Widget.NO_REGEXP, 250, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.RO, false), Widget.NO_BUTTON);
        }
        inputPane.add(metadataLabel);
        inputPane.add(this.metadataWi);
        this.metadataWi.addListeners(new WidgetListener(){

            @Override
            public void check(Object value) {
                if (CreateMD.this.metadataWi.getStringValue().equals(useExistingMetadata)) {
                    CreateMD.this.makeMDButton.setEnabled(false);
                    CreateMD.this.buttonClass(CreateMD.this.nextButton()).setEnabled(true);
                } else {
                    CreateMD.this.buttonClass(CreateMD.this.nextButton()).setEnabled(false);
                    CreateMD.this.makeMDButton.setEnabled(true);
                }
            }
        });
        this.makeMDButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        CreateMD.this.getProgressBar().start(10000);
                        if (CreateMD.this.metadataWi.getStringValue().equals(createNewMetadataDestroyData)) {
                            CreateMD.this.createMetadata(true);
                        } else {
                            CreateMD.this.createMetadata(false);
                        }
                        CreateMD.this.progressBarDone();
                    }
                });
                thread.start();
            }
        });
        inputPane.add(this.makeMDButton);
        SpringUtilities.makeCompactGrid(inputPane, 1, 3, 1, 1, 1, 1);
        pane.add(inputPane);
        pane.add(this.getProgressBarPane(null));
        pane.add(this.getAnswerPane(""));
        SpringUtilities.makeCompactGrid(pane, 3, 1, 0, 0, 0, 0);
        return pane;
    }
}

