/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.drbd;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import lcmc.data.AccessMode;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.drbdConfig.DrbdConfig;
import lcmc.gui.resources.DrbdVolumeInfo;
import lcmc.gui.widget.Widget;
import lcmc.gui.widget.WidgetFactory;
import lcmc.utilities.DRBD;
import lcmc.utilities.MyButton;
import lcmc.utilities.Tools;

public final class SplitBrain
extends DrbdConfig {
    private static final long serialVersionUID = 1L;
    private Widget hostWi;
    private final MyButton resolveButton = new MyButton(Tools.getString("Dialog.Drbd.SplitBrain.ResolveButton"));
    private static final int COMBOBOX_WIDTH = 160;

    public SplitBrain(WizardDialog previousDialog, DrbdVolumeInfo dvi) {
        super(previousDialog, dvi);
    }

    protected void resolve() {
        final Host h1 = this.getDrbdVolumeInfo().getFirstBlockDevInfo().getHost();
        final Host h2 = this.getDrbdVolumeInfo().getSecondBlockDevInfo().getHost();
        final String h = this.hostWi.getStringValue();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Host hostSec;
                Host hostPri;
                if (h.equals(h1.getName())) {
                    hostPri = h1;
                    hostSec = h2;
                } else if (h.equals(h2.getName())) {
                    hostPri = h2;
                    hostSec = h1;
                } else {
                    Tools.appError("unknown host: " + h);
                    return;
                }
                SplitBrain.this.buttonClass(SplitBrain.this.finishButton()).setEnabled(false);
                SplitBrain.this.resolveButton.setEnabled(false);
                boolean testOnly = false;
                String resName = SplitBrain.this.getDrbdVolumeInfo().getDrbdResourceInfo().getName();
                DRBD.setSecondary(hostSec, resName, SplitBrain.this.getDrbdVolumeInfo().getName(), false);
                DRBD.disconnect(hostSec, resName, SplitBrain.this.getDrbdVolumeInfo().getName(), false);
                DRBD.discardData(hostSec, resName, null, false);
                SplitBrain.this.getDrbdVolumeInfo().connect(hostPri, false);
                SplitBrain.this.buttonClass(SplitBrain.this.finishButton()).setEnabled(true);
                SplitBrain.this.buttonClass(SplitBrain.this.cancelButton()).setEnabled(false);
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    @Override
    public WizardDialog nextDialog() {
        return null;
    }

    @Override
    protected String getDialogTitle() {
        return Tools.getString("Dialog.Drbd.SplitBrain.Title");
    }

    @Override
    protected String getDescription() {
        return Tools.getString("Dialog.Drbd.SplitBrain.Description");
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        this.resolveButton.setBackgroundColor(Tools.getDefaultColor("ConfigDialog.Button"));
    }

    @Override
    protected void initDialogAfterVisible() {
        this.enableComponents();
    }

    @Override
    protected JComponent getInputPane() {
        JPanel inputPane = new JPanel(new SpringLayout());
        Set<Host> hosts = this.getDrbdVolumeInfo().getHosts();
        JLabel hostLabel = new JLabel(Tools.getString("Dialog.Drbd.SplitBrain.ChooseHost"));
        this.hostWi = WidgetFactory.createInstance(Widget.Type.COMBOBOX, Widget.NO_DEFAULT, hosts.toArray(new Host[hosts.size()]), Widget.NO_REGEXP, 160, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.RO, false), Widget.NO_BUTTON);
        inputPane.add(hostLabel);
        inputPane.add(this.hostWi);
        this.resolveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SplitBrain.this.resolve();
            }
        });
        inputPane.add(this.resolveButton);
        SpringUtilities.makeCompactGrid(inputPane, 1, 3, 1, 1, 1, 1);
        return inputPane;
    }
}

