/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui;

import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.picking.PickedState;
import edu.uci.ics.jung.visualization.util.VertexShapeFactory;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import lcmc.data.AccessMode;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.data.Subtext;
import lcmc.gui.Browser;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.HostBrowser;
import lcmc.gui.ResourceGraph;
import lcmc.gui.resources.ConstraintPHInfo;
import lcmc.gui.resources.GroupInfo;
import lcmc.gui.resources.HbConnectionInfo;
import lcmc.gui.resources.HostInfo;
import lcmc.gui.resources.Info;
import lcmc.gui.resources.PcmkMultiSelectionInfo;
import lcmc.gui.resources.ServiceInfo;
import lcmc.utilities.MyMenuItem;
import lcmc.utilities.Tools;

public final class CRMGraph
extends ResourceGraph {
    private final Set<ResourceGraph.Edge> edgeIsOrderList = new HashSet<ResourceGraph.Edge>();
    private final Set<ResourceGraph.Edge> keepEdgeIsOrderList = new HashSet<ResourceGraph.Edge>();
    private final Set<ResourceGraph.Edge> edgeIsColocationList = new HashSet<ResourceGraph.Edge>();
    private final Set<ResourceGraph.Edge> keepEdgeIsColocationList = new HashSet<ResourceGraph.Edge>();
    private final Lock mVertexIsPresentListLock = new ReentrantLock();
    private Set<ResourceGraph.Vertex> vertexIsPresentList = new HashSet<ResourceGraph.Vertex>();
    private final Map<ResourceGraph.Vertex, JMenu> vertexToAddServiceMap = new HashMap<ResourceGraph.Vertex, JMenu>();
    private final Map<ResourceGraph.Vertex, JMenu> vertexToAddExistingServiceMap = new HashMap<ResourceGraph.Vertex, JMenu>();
    private final Map<ResourceGraph.Edge, HbConnectionInfo> edgeToHbconnectionMap = new LinkedHashMap<ResourceGraph.Edge, HbConnectionInfo>();
    private final Map<HbConnectionInfo, ResourceGraph.Edge> hbconnectionToEdgeMap = new LinkedHashMap<HbConnectionInfo, ResourceGraph.Edge>();
    private final ReadWriteLock mHbConnectionLock = new ReentrantReadWriteLock();
    private final Lock mHbConnectionReadLock = this.mHbConnectionLock.readLock();
    private final Lock mHbConnectionWriteLock = this.mHbConnectionLock.writeLock();
    private final Map<ResourceGraph.Vertex, HostInfo> vertexToHostMap = new LinkedHashMap<ResourceGraph.Vertex, HostInfo>();
    private final Map<Info, ResourceGraph.Vertex> hostToVertexMap = new LinkedHashMap<Info, ResourceGraph.Vertex>();
    private final Map<ResourceGraph.Vertex, ConstraintPHInfo> vertexToConstraintPHMap = new HashMap<ResourceGraph.Vertex, ConstraintPHInfo>();
    private final Map<Info, ResourceGraph.Vertex> constraintPHToVertexMap = new HashMap<Info, ResourceGraph.Vertex>();
    private int hostDefaultXPos = 10;
    private Info multiSelectionInfo = null;
    private static final int BD_X_POS = 15;
    private static final int HOST_Y_POS = 40;
    private static final int HOST_STEP_X = 230;
    private static final int MIN_Y_POS = 20;
    private static final int MAX_X_POS = 2600;
    private static final int MAX_Y_POS = 2600;
    private static final int VERTEX_HEIGHT = 50;
    private static final ImageIcon HOST_STANDBY_ICON = Tools.createImageIcon(Tools.getDefault("CRMGraph.HostStandbyIcon"));
    private static final ImageIcon SERVICE_RUNNING_ICON = Tools.createImageIcon(Tools.getDefault("CRMGraph.ServiceRunningIcon"));
    private static final ImageIcon SERVICE_RUNNING_FAILED_ICON = Tools.createImageIcon(Tools.getDefault("CRMGraph.ServiceRunningFailedIcon"));
    private static final ImageIcon SERVICE_STARTED_ICON = Tools.createImageIcon(Tools.getDefault("CRMGraph.ServiceStartedIcon"));
    private static final ImageIcon SERVICE_STOPPING_ICON = Tools.createImageIcon(Tools.getDefault("CRMGraph.ServiceStoppingIcon"));
    private static final ImageIcon SERVICE_STOPPED_ICON = Tools.createImageIcon(Tools.getDefault("CRMGraph.ServiceStoppedIcon"));
    private static final ImageIcon SERVICE_STOPPED_FAILED_ICON = Tools.createImageIcon(Tools.getDefault("CRMGraph.ServiceStoppedFailedIcon"));
    private static final ImageIcon SERVICE_UNMANAGED_ICON = Tools.createImageIcon(Tools.getDefault("CRMGraph.ServiceUnmanagedIcon"));
    private static final ImageIcon SERVICE_MIGRATED_ICON = Tools.createImageIcon(Tools.getDefault("CRMGraph.ServiceMigratedIcon"));

    CRMGraph(ClusterBrowser clusterBrowser) {
        super(clusterBrowser);
    }

    @Override
    protected void initGraph() {
        super.initGraph(new DirectedSparseGraph<ResourceGraph.Vertex, ResourceGraph.Edge>());
    }

    private boolean isAncestor(ResourceGraph.Vertex v, ResourceGraph.Vertex p, List<ResourceGraph.Vertex> list) {
        if (p.equals(v)) {
            return true;
        }
        for (ResourceGraph.Vertex pre : this.getGraph().getPredecessors(p)) {
            if (list.contains(pre)) {
                return false;
            }
            list.add(pre);
            if (!this.isAncestor(v, pre, list)) continue;
            return true;
        }
        return false;
    }

    boolean existsInThePath(ServiceInfo si, ServiceInfo parent) {
        if (parent == null) {
            return true;
        }
        if (si.equals(parent)) {
            return true;
        }
        this.lockGraph();
        ResourceGraph.Vertex v = this.getVertex(si);
        if (v == null) {
            this.unlockGraph();
            return false;
        }
        ResourceGraph.Vertex pv = this.getVertex(parent);
        if (pv == null) {
            this.unlockGraph();
            return false;
        }
        if (this.getGraph().isSuccessor(pv, v) || this.isAncestor(v, pv, new ArrayList<ResourceGraph.Vertex>())) {
            this.unlockGraph();
            return true;
        }
        this.unlockGraph();
        return false;
    }

    String[] getColocationNeighbours(ServiceInfo si) {
        ArrayList<String> parentsHbIds = new ArrayList<String>();
        ResourceGraph.Vertex v = this.getVertex(si);
        if (v != null) {
            this.lockGraph();
            for (ResourceGraph.Vertex pV : this.getGraph().getPredecessors(v)) {
                ServiceInfo psi = (ServiceInfo)this.getInfo(pV);
                if (psi == null) continue;
                parentsHbIds.add(psi.getService().getHeartbeatId());
            }
            this.unlockGraph();
        }
        return parentsHbIds.toArray(new String[parentsHbIds.size()]);
    }

    public Set<ServiceInfo> getParents(ServiceInfo si) {
        TreeSet<ServiceInfo> parents = new TreeSet<ServiceInfo>();
        ResourceGraph.Vertex v = this.getVertex(si);
        if (v != null) {
            this.lockGraph();
            for (ResourceGraph.Vertex pV : this.getGraph().getPredecessors(v)) {
                ServiceInfo psi = (ServiceInfo)this.getInfo(pV);
                if (psi == null) continue;
                parents.add(psi);
            }
            this.unlockGraph();
        }
        return parents;
    }

    public Set<ServiceInfo> getChildren(ServiceInfo si) {
        TreeSet<ServiceInfo> children = new TreeSet<ServiceInfo>();
        ResourceGraph.Vertex v = this.getVertex(si);
        if (v != null) {
            this.lockGraph();
            for (ResourceGraph.Vertex pV : this.getGraph().getSuccessors(v)) {
                ServiceInfo psi = (ServiceInfo)this.getInfo(pV);
                if (psi == null) continue;
                children.add(psi);
            }
            this.unlockGraph();
        }
        return children;
    }

    public Set<ServiceInfo> getChildrenAndParents(ServiceInfo si) {
        TreeSet<ServiceInfo> chAndP = new TreeSet<ServiceInfo>();
        chAndP.addAll(this.getChildren(si));
        chAndP.addAll(this.getParents(si));
        return chAndP;
    }

    public HbConnectionInfo[] getHbConnections(ServiceInfo si) {
        ArrayList<HbConnectionInfo> infos = new ArrayList<HbConnectionInfo>();
        ResourceGraph.Vertex v = this.getVertex(si);
        if (v != null) {
            HbConnectionInfo hbci;
            ResourceGraph.Edge edge;
            this.mHbConnectionReadLock.lock();
            this.lockGraph();
            for (ResourceGraph.Vertex pV : this.getGraph().getPredecessors(v)) {
                edge = (ResourceGraph.Edge)this.getGraph().findEdge(pV, v);
                if (edge == null) {
                    edge = (ResourceGraph.Edge)this.getGraph().findEdge(v, pV);
                }
                if (edge == null || (hbci = this.edgeToHbconnectionMap.get(edge)) == null) continue;
                infos.add(hbci);
            }
            for (ResourceGraph.Vertex sV : this.getGraph().getSuccessors(v)) {
                edge = (ResourceGraph.Edge)this.getGraph().findEdge(v, sV);
                if (edge == null) {
                    edge = (ResourceGraph.Edge)this.getGraph().findEdge(sV, v);
                }
                if (edge == null || (hbci = this.edgeToHbconnectionMap.get(edge)) == null) continue;
                infos.add(hbci);
            }
            this.unlockGraph();
            this.mHbConnectionReadLock.unlock();
        }
        return infos.toArray(new HbConnectionInfo[infos.size()]);
    }

    @Override
    protected String getId(Info i) {
        String id = i.getId();
        if (id == null) {
            return null;
        }
        return "hb=" + i.getId();
    }

    public void exchangeObjectInTheVertex(ServiceInfo newSI, ServiceInfo oldSI) {
        ResourceGraph.Vertex v = this.getVertex(oldSI);
        this.removeVertex(oldSI);
        this.putInfoToVertex(newSI, v);
        this.putVertexToInfo(v, newSI);
        this.somethingChanged();
    }

    public boolean addResource(ServiceInfo serviceInfo, ServiceInfo parent, Point2D pos, boolean colocation, boolean order, boolean testOnly) {
        boolean vertexExists = true;
        ResourceGraph.Vertex v = this.getVertex(serviceInfo);
        if (v == null) {
            v = new ResourceGraph.Vertex();
            if (pos == null) {
                Point2D newPos = this.getSavedPosition(serviceInfo);
                if (newPos == null) {
                    Point2D max = this.getLastPosition();
                    float maxYPos = (float)max.getY();
                    this.getVertexLocations().put(v, new Point2D.Float(15.0f, maxYPos + 40.0f));
                    this.putVertexLocations();
                } else {
                    this.getVertexLocations().put(v, newPos);
                    this.putVertexLocations();
                }
            } else {
                Point2D p = this.getVisualizationViewer().getRenderContext().getMultiLayerTransformer().inverseTransform(Layer.VIEW, pos);
                this.getVertexLocations().put(v, this.posWithScrollbar(p));
                this.putVertexLocations();
            }
            this.lockGraph();
            this.getGraph().addVertex(v);
            this.unlockGraph();
            this.somethingChanged();
            this.putInfoToVertex(serviceInfo, v);
            this.putVertexToInfo(v, serviceInfo);
            vertexExists = false;
        } else if (testOnly) {
            this.addTestEdge(this.getVertex(parent), this.getVertex(serviceInfo));
        }
        if (parent != null && !testOnly) {
            if (colocation) {
                this.addColocation(null, serviceInfo, parent);
            }
            if (order) {
                this.addOrder(null, parent, serviceInfo);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CRMGraph.this.repaint();
            }
        });
        return vertexExists;
    }

    public void addOrder(final String ordId, final ServiceInfo parent, final ServiceInfo serviceInfo) {
        ResourceGraph.Vertex v;
        if (parent == null || serviceInfo == null) {
            return;
        }
        ResourceGraph.Vertex vP = this.getVertex(parent);
        if (vP == (v = this.getVertex(serviceInfo))) {
            return;
        }
        if (parent.isConstraintPH() || serviceInfo.isConstraintPH()) {
            ServiceInfo si;
            ConstraintPHInfo cphi;
            if (parent.isConstraintPH()) {
                cphi = (ConstraintPHInfo)parent;
                si = cphi.prevInSequence(serviceInfo, false);
                if (si != null) {
                    vP = this.getVertex(si);
                }
            } else {
                cphi = (ConstraintPHInfo)serviceInfo;
                si = cphi.nextInSequence(parent, false);
                if (si != null) {
                    v = this.getVertex(si);
                }
            }
        }
        if (v == null || vP == null) {
            return;
        }
        final ResourceGraph.Vertex vP0 = vP;
        final ResourceGraph.Vertex v0 = v;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HbConnectionInfo hbci;
                CRMGraph.this.mHbConnectionWriteLock.lock();
                ResourceGraph.Edge edge = null;
                try {
                    CRMGraph.this.lockGraph();
                    edge = (ResourceGraph.Edge)CRMGraph.this.getGraph().findEdge(vP0, v0);
                    if (edge == null) {
                        edge = (ResourceGraph.Edge)CRMGraph.this.getGraph().findEdge(v0, vP0);
                        CRMGraph.this.unlockGraph();
                        if (edge != null) {
                            edge.reverse();
                            if (CRMGraph.this.edgeIsOrderList.contains(edge)) {
                                edge.setWrongColocation(true);
                            } else {
                                edge.setWrongColocation(false);
                            }
                        }
                    } else {
                        if (!CRMGraph.this.edgeIsOrderList.contains(edge)) {
                            edge.setWrongColocation(false);
                        }
                        CRMGraph.this.unlockGraph();
                    }
                }
                catch (Exception e) {
                    CRMGraph.this.unlockGraph();
                }
                if (edge == null) {
                    hbci = CRMGraph.this.getClusterBrowser().getNewHbConnectionInfo();
                    edge = new ResourceGraph.Edge(CRMGraph.this, vP0, v0);
                    CRMGraph.this.lockGraph();
                    CRMGraph.this.getGraph().addEdge(edge, vP0, v0);
                    CRMGraph.this.unlockGraph();
                    CRMGraph.this.edgeToHbconnectionMap.put(edge, hbci);
                    CRMGraph.this.hbconnectionToEdgeMap.put(hbci, edge);
                } else {
                    hbci = (HbConnectionInfo)CRMGraph.this.edgeToHbconnectionMap.get(edge);
                }
                CRMGraph.this.mHbConnectionWriteLock.unlock();
                if (hbci != null) {
                    hbci.addOrder(ordId, parent, serviceInfo);
                    CRMGraph.this.edgeIsOrderList.add(edge);
                    CRMGraph.this.keepEdgeIsOrderList.add(edge);
                }
            }
        });
    }

    void reverse(HbConnectionInfo hbConnectionInfo) {
        this.mHbConnectionReadLock.lock();
        ResourceGraph.Edge e = this.hbconnectionToEdgeMap.get(hbConnectionInfo);
        this.mHbConnectionReadLock.unlock();
        if (e != null && this.edgeIsColocationList.contains(e)) {
            e.reverse();
        }
    }

    public boolean isColocation(ServiceInfo parent, ServiceInfo serviceInfo) {
        ResourceGraph.Vertex vP = this.getVertex(parent);
        ResourceGraph.Vertex v = this.getVertex(serviceInfo);
        if (vP == null || v == null) {
            return false;
        }
        this.lockGraph();
        ResourceGraph.Edge edge = (ResourceGraph.Edge)this.getGraph().findEdge(vP, v);
        if (edge == null) {
            edge = (ResourceGraph.Edge)this.getGraph().findEdge(v, vP);
        }
        this.unlockGraph();
        return edge != null && this.edgeIsColocationList.contains(edge);
    }

    public boolean isOrder(ServiceInfo parent, ServiceInfo serviceInfo) {
        ResourceGraph.Vertex vP = this.getVertex(parent);
        ResourceGraph.Vertex v = this.getVertex(serviceInfo);
        if (vP == null || v == null) {
            return false;
        }
        this.lockGraph();
        ResourceGraph.Edge edge = (ResourceGraph.Edge)this.getGraph().findEdge(vP, v);
        if (edge == null) {
            edge = (ResourceGraph.Edge)this.getGraph().findEdge(v, vP);
        }
        this.unlockGraph();
        return edge != null && this.edgeIsOrderList.contains(edge);
    }

    public void addColocation(final String colId, final ServiceInfo rsc, ServiceInfo withRsc) {
        ResourceGraph.Vertex vWithRsc;
        if (rsc == null || withRsc == null) {
            return;
        }
        ResourceGraph.Vertex vRsc = this.getVertex(rsc);
        if (vRsc == (vWithRsc = this.getVertex(withRsc))) {
            return;
        }
        if (rsc.isConstraintPH() || withRsc.isConstraintPH()) {
            ServiceInfo si;
            ConstraintPHInfo cphi;
            if (rsc.isConstraintPH()) {
                cphi = (ConstraintPHInfo)rsc;
                si = cphi.nextInSequence(withRsc, true);
                if (si != null) {
                    vRsc = this.getVertex(si);
                }
            } else {
                cphi = (ConstraintPHInfo)withRsc;
                si = cphi.prevInSequence(rsc, true);
                if (si != null) {
                    vWithRsc = this.getVertex(si);
                }
            }
        }
        if (vWithRsc == null || vRsc == null) {
            return;
        }
        final ResourceGraph.Vertex vWithRsc0 = vWithRsc;
        final ResourceGraph.Vertex vRsc0 = vRsc;
        final ServiceInfo withRsc0 = withRsc;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HbConnectionInfo hbci;
                CRMGraph.this.mHbConnectionWriteLock.lock();
                ResourceGraph.Edge edge = null;
                try {
                    CRMGraph.this.lockGraph();
                    edge = (ResourceGraph.Edge)CRMGraph.this.getGraph().findEdge(vWithRsc0, vRsc0);
                    if (edge == null) {
                        edge = (ResourceGraph.Edge)CRMGraph.this.getGraph().findEdge(vRsc0, vWithRsc0);
                        if (edge != null) {
                            edge.setWrongColocation(true);
                        }
                    } else {
                        edge.setWrongColocation(false);
                    }
                    CRMGraph.this.unlockGraph();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (edge == null) {
                    hbci = CRMGraph.this.getClusterBrowser().getNewHbConnectionInfo();
                    edge = new ResourceGraph.Edge(CRMGraph.this, vWithRsc0, vRsc0);
                    CRMGraph.this.lockGraph();
                    CRMGraph.this.getGraph().addEdge(edge, vWithRsc0, vRsc0);
                    CRMGraph.this.unlockGraph();
                    CRMGraph.this.edgeToHbconnectionMap.put(edge, hbci);
                    CRMGraph.this.hbconnectionToEdgeMap.put(hbci, edge);
                } else {
                    hbci = (HbConnectionInfo)CRMGraph.this.edgeToHbconnectionMap.get(edge);
                }
                CRMGraph.this.mHbConnectionWriteLock.unlock();
                if (hbci != null) {
                    hbci.addColocation(colId, rsc, withRsc0);
                    CRMGraph.this.edgeIsColocationList.add(edge);
                    CRMGraph.this.keepEdgeIsColocationList.add(edge);
                }
            }
        });
    }

    public void clearKeepOrderList() {
        this.mHbConnectionReadLock.lock();
        this.lockGraph();
        for (ResourceGraph.Edge edge : this.getGraph().getEdges()) {
            HbConnectionInfo hbci = this.edgeToHbconnectionMap.get(edge);
            if (hbci == null || hbci.isNew()) continue;
            this.keepEdgeIsOrderList.remove(edge);
        }
        this.unlockGraph();
        this.mHbConnectionReadLock.unlock();
    }

    public void clearKeepColocationList() {
        this.mHbConnectionReadLock.lock();
        this.lockGraph();
        for (ResourceGraph.Edge edge : this.getGraph().getEdges()) {
            HbConnectionInfo hbci = this.edgeToHbconnectionMap.get(edge);
            if (hbci == null || hbci.isNew()) continue;
            this.keepEdgeIsColocationList.remove(edge);
        }
        this.unlockGraph();
        this.mHbConnectionReadLock.unlock();
    }

    @Override
    protected String getMainText(ResourceGraph.Vertex v, boolean testOnly) {
        String str;
        if (this.vertexToHostMap.containsKey(v)) {
            str = this.vertexToHostMap.get(v).toString();
        } else if (this.vertexToConstraintPHMap.containsKey(v)) {
            str = this.vertexToConstraintPHMap.get(v).getMainTextForGraph();
        } else {
            ServiceInfo si = (ServiceInfo)this.getInfo(v);
            if (si == null) {
                return "";
            }
            Set<ResourceGraph.Vertex> vipl = this.getVertexIsPresentList();
            this.putVertexIsPresentList();
            str = si.getService().isRemoved() ? Tools.getString("CRMGraph.Removing") : (vipl.contains(v) ? si.getMainTextForGraph() : (si.getService().isNew() ? si.getMainTextForGraph() : Tools.getString("CRMGraph.Unconfigured")));
        }
        return str;
    }

    @Override
    protected Shape getVertexShape(ResourceGraph.Vertex v, VertexShapeFactory<ResourceGraph.Vertex> factory) {
        if (this.vertexToHostMap.containsKey(v)) {
            return factory.getRectangle(v);
        }
        if (this.vertexToConstraintPHMap.containsKey(v)) {
            return factory.getEllipse(v);
        }
        RoundRectangle2D r = factory.getRoundRectangle(v);
        return new RoundRectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight(), 20.0, 20.0);
    }

    @Override
    public void pickInfo(Info i) {
        GroupInfo groupInfo = ((ServiceInfo)i).getGroupInfo();
        if (groupInfo == null) {
            super.pickInfo(i);
        } else {
            ResourceGraph.Vertex v = this.getVertex(groupInfo);
            PickedState psEdge = this.getVisualizationViewer().getRenderContext().getPickedEdgeState();
            PickedState psVertex = this.getVisualizationViewer().getRenderContext().getPickedVertexState();
            psEdge.clear();
            psVertex.clear();
            psVertex.pick(v, true);
        }
    }

    @Override
    protected JPopupMenu handlePopupVertex(ResourceGraph.Vertex v, List<ResourceGraph.Vertex> pickedV, Point2D p) {
        Info msi;
        if (pickedV.size() > 1 && (msi = this.multiSelectionInfo) != null) {
            return msi.getPopup();
        }
        if (this.vertexToHostMap.containsKey(v)) {
            HostInfo hi = (HostInfo)this.getInfo(v);
            if (hi == null) {
                return null;
            }
            return hi.getPopup(p);
        }
        if (this.vertexToConstraintPHMap.containsKey(v)) {
            ConstraintPHInfo cphi = this.vertexToConstraintPHMap.get(v);
            if (cphi == null) {
                return null;
            }
            return cphi.getPopup(p);
        }
        ServiceInfo si = (ServiceInfo)this.getInfo(v);
        if (si == null) {
            return null;
        }
        return si.getPopup(p);
    }

    private void reloadAddExistingServicePopup(JMenu addServiceMenuItem, ResourceGraph.Vertex v) {
        if (addServiceMenuItem == null) {
            return;
        }
        final ServiceInfo si = (ServiceInfo)this.getInfo(v);
        addServiceMenuItem.removeAll();
        if (si == null) {
            return;
        }
        boolean separatorAdded = false;
        final boolean tOnly = this.isTestOnly();
        for (final ServiceInfo asi : this.getClusterBrowser().getExistingServiceList(si)) {
            MyMenuItem mmi = new MyMenuItem(asi.toString(), null, null, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
                private static final long serialVersionUID = 1L;

                @Override
                public void action() {
                    si.addServicePanel(asi, null, false, false, true, CRMGraph.this.getClusterBrowser().getDCHost(), tOnly);
                    this.repaint();
                }
            };
            if (asi.getInternalValue().equals("Filesystem") || asi.getInternalValue().equals("IPaddr2")) {
                mmi.setSpecialFont();
                addServiceMenuItem.add(mmi);
                continue;
            }
            if (!separatorAdded) {
                addServiceMenuItem.addSeparator();
                separatorAdded = true;
            }
            addServiceMenuItem.add(mmi);
        }
    }

    @Override
    protected JPopupMenu handlePopupEdge(ResourceGraph.Edge edge) {
        this.mHbConnectionReadLock.lock();
        HbConnectionInfo hbci = this.edgeToHbconnectionMap.get(edge);
        this.mHbConnectionReadLock.unlock();
        if (hbci == null) {
            return null;
        }
        return hbci.getPopup();
    }

    @Override
    protected JPopupMenu handlePopupBackground(Point2D pos) {
        return this.getClusterBrowser().getServicesInfo().getPopup(pos);
    }

    @Override
    protected void vertexReleased(ResourceGraph.Vertex v, Point2D pos) {
        double x = pos.getX();
        double y = pos.getY();
        double minPos = (this.getVertexWidth(v) - this.getDefaultVertexWidth(v)) / 2;
        x = x < minPos ? minPos : x;
        x = x > 2600.0 ? 2600.0 : x;
        y = y < 20.0 ? 20.0 : y;
        y = y > 2600.0 ? 2600.0 : y;
        pos.setLocation(x, y);
        this.getVertexLocations().put(v, pos);
        this.putVertexLocations();
        this.getLayout().setLocation(v, pos);
    }

    @Override
    protected void oneVertexPressed(ResourceGraph.Vertex v) {
        this.pickVertex(v);
        if (this.vertexToHostMap.containsKey(v)) {
            HostInfo hi = this.vertexToHostMap.get(v);
            if (hi != null) {
                Tools.getGUIData().setTerminalPanel(hi.getHost().getTerminalPanel());
                this.getClusterBrowser().setRightComponentInView(hi);
            }
        } else if (this.vertexToConstraintPHMap.containsKey(v)) {
            ConstraintPHInfo cphi = this.vertexToConstraintPHMap.get(v);
            if (cphi != null) {
                this.getClusterBrowser().setRightComponentInView(cphi);
            }
        } else {
            ServiceInfo si = (ServiceInfo)this.getInfo(v);
            if (si != null) {
                si.selectMyself();
            }
        }
    }

    @Override
    protected void backgroundClicked() {
        this.getClusterBrowser().getServicesInfo().selectMyself();
    }

    @Override
    String getVertexToolTip(ResourceGraph.Vertex v) {
        boolean tOnly = this.isTestOnly();
        if (this.vertexToHostMap.containsKey(v)) {
            return this.vertexToHostMap.get(v).getToolTipForGraph(tOnly);
        }
        if (this.vertexToConstraintPHMap.containsKey(v)) {
            return this.vertexToConstraintPHMap.get(v).getToolTipForGraph(tOnly);
        }
        ServiceInfo si = (ServiceInfo)this.getInfo(v);
        if (si == null) {
            return null;
        }
        return si.getToolTipText(tOnly);
    }

    @Override
    String getEdgeToolTip(ResourceGraph.Edge edge) {
        Pair<ResourceGraph.Vertex> p = this.getGraph().getEndpoints(edge);
        boolean edgeIsOrder = this.edgeIsOrderList.contains(edge);
        boolean edgeIsColocation = this.edgeIsColocationList.contains(edge);
        ResourceGraph.Vertex v = p.getSecond();
        ResourceGraph.Vertex parent = p.getFirst();
        ServiceInfo si = (ServiceInfo)this.getInfo(v);
        if (si == null) {
            return null;
        }
        ServiceInfo siP = (ServiceInfo)this.getInfo(parent);
        if (siP == null) {
            return null;
        }
        StringBuilder s = new StringBuilder(100);
        s.append(siP.toString());
        this.mHbConnectionReadLock.lock();
        HbConnectionInfo hbci = this.edgeToHbconnectionMap.get(edge);
        this.mHbConnectionReadLock.unlock();
        if (edgeIsOrder && hbci != null && !hbci.isOrdScoreNull(null, null)) {
            s.append(" is started before ");
        } else {
            s.append(" and ");
        }
        s.append(si.toString());
        if (!edgeIsOrder) {
            s.append(" are located");
        }
        if (edgeIsColocation) {
            HbConnectionInfo.ColScoreType colSType = hbci.getColocationScoreType(null, null);
            if (colSType == HbConnectionInfo.ColScoreType.NEGATIVE || colSType == HbConnectionInfo.ColScoreType.MINUS_INFINITY) {
                s.append(" not on the same host");
            } else {
                s.append(" on the same host");
            }
        } else {
            s.append(" not necessarily on the same host");
        }
        return s.toString();
    }

    @Override
    protected Color getVertexFillColor(ResourceGraph.Vertex v) {
        boolean tOnly = this.isTestOnly();
        if (this.vertexToHostMap.containsKey(v)) {
            return this.vertexToHostMap.get(v).getHost().getPmColors()[0];
        }
        if (this.vertexToConstraintPHMap.containsKey(v)) {
            if (this.vertexToConstraintPHMap.get(v).getService().isNew()) {
                return Tools.getDefaultColor("CRMGraph.FillPaintUnconfigured");
            }
            return Tools.getDefaultColor("CRMGraph.FillPaintPlaceHolder");
        }
        ServiceInfo si = (ServiceInfo)this.getInfo(v);
        if (si == null) {
            return null;
        }
        Set<ResourceGraph.Vertex> vipl = this.getVertexIsPresentList();
        this.putVertexIsPresentList();
        if (this.getClusterBrowser().allHostsDown()) {
            return Tools.getDefaultColor("CRMGraph.FillPaintUnknown");
        }
        if (si.getService().isOrphaned()) {
            return Tools.getDefaultColor("CRMGraph.FillPaintUnknown");
        }
        if (si.isFailed(tOnly)) {
            return Tools.getDefaultColor("CRMGraph.FillPaintFailed");
        }
        if (!si.isRunning(tOnly)) {
            return ClusterBrowser.FILL_PAINT_STOPPED;
        }
        if (this.getClusterBrowser().clStatusFailed()) {
            return Tools.getDefaultColor("CRMGraph.FillPaintUnknown");
        }
        if (vipl.contains(v) || tOnly) {
            List<Color> colors = si.getHostColors(tOnly);
            if (colors.size() >= 1) {
                return colors.get(0);
            }
            return Color.WHITE;
        }
        if (!si.getService().isNew()) {
            return Tools.getDefaultColor("CRMGraph.FillPaintRemoved");
        }
        return Tools.getDefaultColor("CRMGraph.FillPaintUnconfigured");
    }

    @Override
    protected String getLabelForEdgeStringer(ResourceGraph.Edge e) {
        boolean left;
        Object loc2;
        if (this.isTestEdge(e)) {
            return Tools.getString("CRMGraph.Simulate");
        }
        boolean edgeIsOrder = this.edgeIsOrderList.contains(e);
        boolean edgeIsColocation = this.edgeIsColocationList.contains(e);
        Pair<ResourceGraph.Vertex> p = this.getGraph().getEndpoints(e);
        if (p == null) {
            return "";
        }
        ServiceInfo s1 = (ServiceInfo)this.getInfo(p.getSecond());
        if (s1 == null) {
            return "";
        }
        ServiceInfo s2 = (ServiceInfo)this.getInfo(p.getFirst());
        if (s2 == null) {
            return "";
        }
        this.mHbConnectionReadLock.lock();
        HbConnectionInfo hbci = this.edgeToHbconnectionMap.get(e);
        this.mHbConnectionReadLock.unlock();
        if (hbci == null) {
            return "";
        }
        String colDesc = null;
        String ordDesc = null;
        String desc = null;
        String leftArrow = "\u2190 ";
        String rightArrow = " \u2192";
        HbConnectionInfo.ColScoreType colSType = hbci.getColocationScoreType(null, null);
        if (edgeIsColocation) {
            if (hbci.isColocationTwoDirections()) {
                leftArrow = "\u21ae ";
                rightArrow = "\u21ae ";
            } else if (colSType != HbConnectionInfo.ColScoreType.NEGATIVE && colSType != HbConnectionInfo.ColScoreType.MINUS_INFINITY) {
                if (colSType == HbConnectionInfo.ColScoreType.IS_NULL) {
                    leftArrow = "\u21e0 ";
                    rightArrow = " \u21e2";
                } else if (colSType == HbConnectionInfo.ColScoreType.MIXED) {
                    leftArrow = "\u219a ";
                    rightArrow = " \u219b";
                }
            }
        }
        String colScore = "";
        String ordScore = "";
        if (edgeIsColocation && colSType == HbConnectionInfo.ColScoreType.IS_NULL) {
            colScore = "0";
        }
        if (edgeIsOrder && hbci != null && hbci.isOrdScoreNull(null, null)) {
            ordScore = "0";
        }
        if (edgeIsOrder && edgeIsColocation) {
            colDesc = colSType == HbConnectionInfo.ColScoreType.NEGATIVE || colSType == HbConnectionInfo.ColScoreType.MINUS_INFINITY ? "repelled" : "col";
            ordDesc = "ord";
        } else if (edgeIsOrder) {
            ordDesc = "ordered";
        } else if (edgeIsColocation) {
            colDesc = colSType == HbConnectionInfo.ColScoreType.NEGATIVE || colSType == HbConnectionInfo.ColScoreType.MINUS_INFINITY ? "repelled" : "colocated";
        } else {
            desc = s1.getService().isNew() || s2.getService().isNew() ? Tools.getString("CRMGraph.Unconfigured") : Tools.getString("CRMGraph.Removing");
        }
        if (desc != null) {
            return desc;
        }
        ResourceGraph.Vertex v1 = p.getSecond();
        ResourceGraph.Vertex v2 = p.getFirst();
        double s1X = 0.0;
        double s2X = 0.0;
        Object loc1 = this.getLayout().transform((Object)v1);
        if (loc1 != null) {
            s1X = ((Point2D)loc1).getX();
        }
        if ((loc2 = this.getLayout().transform((Object)v2)) != null) {
            s2X = ((Point2D)loc2).getX();
        }
        StringBuilder sb = new StringBuilder(15);
        boolean upsideDown = s1X < s2X;
        boolean bl = left = hbci.isWithRsc(s2) && !e.isWrongColocation();
        if (edgeIsColocation) {
            if (left && !upsideDown || !left && upsideDown) {
                sb.append(leftArrow);
                sb.append(colScore);
                sb.append(' ');
                sb.append(colDesc);
                if (edgeIsOrder) {
                    sb.append('/');
                    sb.append(ordDesc);
                    sb.append(' ');
                    sb.append(ordScore);
                }
            } else if (!left && !upsideDown || left && upsideDown) {
                if (edgeIsOrder) {
                    sb.append(ordScore);
                    sb.append(' ');
                    sb.append(ordDesc);
                    sb.append('/');
                }
                sb.append(colDesc);
                sb.append(' ');
                sb.append(colScore);
                sb.append(rightArrow);
            }
        } else if (edgeIsOrder) {
            if (left && !upsideDown) {
                sb.append(ordDesc);
                sb.append(' ');
                sb.append(ordScore);
            } else {
                sb.append(ordScore);
                sb.append(' ');
                sb.append(ordDesc);
            }
        }
        return sb.toString();
    }

    @Override
    protected Paint getEdgeDrawPaint(ResourceGraph.Edge e) {
        this.mHbConnectionReadLock.lock();
        HbConnectionInfo hbci = this.edgeToHbconnectionMap.get(e);
        this.mHbConnectionReadLock.unlock();
        if (hbci != null && hbci.isNew()) {
            return Tools.getDefaultColor("ResourceGraph.EdgeDrawPaintNew");
        }
        if (this.edgeIsOrderList.contains(e) && this.edgeIsColocationList.contains(e)) {
            return super.getEdgeDrawPaint(e);
        }
        if (this.edgeIsOrderList.contains(e) || this.edgeIsColocationList.contains(e)) {
            return Tools.getDefaultColor("ResourceGraph.EdgeDrawPaintBrighter");
        }
        return Tools.getDefaultColor("ResourceGraph.EdgeDrawPaintRemoved");
    }

    @Override
    protected Paint getEdgePickedPaint(ResourceGraph.Edge e) {
        this.mHbConnectionReadLock.lock();
        HbConnectionInfo hbci = this.edgeToHbconnectionMap.get(e);
        this.mHbConnectionReadLock.unlock();
        if (hbci != null && hbci.isNew()) {
            return Tools.getDefaultColor("ResourceGraph.EdgePickedPaintNew");
        }
        if (this.edgeIsOrderList.contains(e) && this.edgeIsColocationList.contains(e)) {
            return super.getEdgePickedPaint(e);
        }
        if (this.edgeIsOrderList.contains(e) || this.edgeIsColocationList.contains(e)) {
            return Tools.getDefaultColor("ResourceGraph.EdgePickedPaintBrighter");
        }
        return Tools.getDefaultColor("ResourceGraph.EdgePickedPaintRemoved");
    }

    public void killRemovedEdges() {
        this.lockGraph();
        ArrayList<ResourceGraph.Edge> edges = new ArrayList<ResourceGraph.Edge>(this.getGraph().getEdges().size());
        for (ResourceGraph.Edge e : this.getGraph().getEdges()) {
            edges.add(e);
        }
        this.unlockGraph();
        boolean tOnly = this.isTestOnly();
        for (int i = 0; i < edges.size(); ++i) {
            HbConnectionInfo hbci;
            ServiceInfo s2;
            ResourceGraph.Edge e = (ResourceGraph.Edge)edges.get(i);
            Pair<ResourceGraph.Vertex> p = this.getGraph().getEndpoints(e);
            ServiceInfo s1 = (ServiceInfo)this.getInfo(p.getSecond());
            if (s1 == null || (s2 = (ServiceInfo)this.getInfo(p.getFirst())) == null) continue;
            if (!this.keepEdgeIsOrderList.contains(e)) {
                this.edgeIsOrderList.remove(e);
            }
            if (!this.keepEdgeIsColocationList.contains(e)) {
                this.edgeIsColocationList.remove(e);
            }
            if (s1.getService().isNew() && !s1.getService().isRemoved() || s2.getService().isNew() && !s2.getService().isRemoved()) continue;
            if (!this.keepEdgeIsOrderList.contains(e)) {
                this.mHbConnectionReadLock.lock();
                hbci = this.edgeToHbconnectionMap.get(e);
                this.mHbConnectionReadLock.unlock();
                if (hbci != null) {
                    hbci.removeOrders();
                }
            }
            if (!this.keepEdgeIsColocationList.contains(e)) {
                this.mHbConnectionReadLock.lock();
                hbci = this.edgeToHbconnectionMap.get(e);
                this.mHbConnectionReadLock.unlock();
                if (hbci != null) {
                    hbci.removeColocations();
                }
            }
            if (this.keepEdgeIsOrderList.contains(e) || this.keepEdgeIsColocationList.contains(e)) continue;
            this.removeEdge(e, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEdge(ResourceGraph.Edge e, boolean testOnly) {
        if (e == null) {
            return;
        }
        if (!this.edgeIsOrderList.contains(e) && !this.edgeIsColocationList.contains(e)) {
            e.reset();
            this.lockGraph();
            this.getGraph().removeEdge(e);
            this.unlockGraph();
            this.mHbConnectionWriteLock.lock();
            try {
                HbConnectionInfo hbci = this.edgeToHbconnectionMap.get(e);
                this.edgeToHbconnectionMap.remove(e);
                if (hbci != null) {
                    this.hbconnectionToEdgeMap.remove(hbci);
                    hbci.removeMyself(testOnly);
                }
            }
            finally {
                this.mHbConnectionWriteLock.unlock();
            }
        }
    }

    public void killRemovedVertices() {
        ArrayList<ResourceGraph.Vertex> vertices = new ArrayList<ResourceGraph.Vertex>();
        this.lockGraph();
        for (ResourceGraph.Vertex vo : this.getGraph().getVertices()) {
            vertices.add(vo);
        }
        this.unlockGraph();
        for (ResourceGraph.Vertex v : vertices) {
            ServiceInfo si;
            if (this.vertexToHostMap.containsKey(v)) continue;
            this.lockGraph();
            if (!this.getGraph().getInEdges(v).isEmpty() || !this.getGraph().getOutEdges(v).isEmpty()) {
                this.unlockGraph();
                continue;
            }
            this.unlockGraph();
            Set<ResourceGraph.Vertex> vipl = this.getVertexIsPresentList();
            this.putVertexIsPresentList();
            if (this.vertexToConstraintPHMap.containsKey(v)) {
                ConstraintPHInfo cphi = (ConstraintPHInfo)this.getInfo(v);
                if (cphi == null) continue;
                if (!vipl.contains(v)) {
                    cphi.setUpdated(false);
                    if (!this.getClusterBrowser().clStatusFailed() && cphi.getService().isRemoved()) {
                        this.getVertexLocations().put(v, null);
                        this.putVertexLocations();
                        this.lockGraph();
                        this.getGraph().removeVertex(v);
                        this.removeInfo(v);
                        this.removeVertex(cphi);
                        this.unlockGraph();
                        cphi.removeInfo();
                        this.getVertexToMenus().remove(v);
                        this.vertexToConstraintPHMap.remove(v);
                        this.constraintPHToVertexMap.remove(cphi);
                        this.somethingChanged();
                    } else {
                        cphi.getService().setNew(true);
                    }
                }
                cphi.resetRscSetConnectionData();
                continue;
            }
            if (vipl.contains(v) || (si = (ServiceInfo)this.getInfo(v)) == null || si.getService().isNew() || this.getClusterBrowser().clStatusFailed()) continue;
            si.setUpdated(false);
            this.getVertexLocations().put(v, null);
            this.putVertexLocations();
            this.lockGraph();
            this.getGraph().removeVertex(v);
            this.removeInfo(v);
            this.removeVertex(si);
            this.unlockGraph();
            si.removeInfo();
            this.getVertexToMenus().remove(v);
            this.vertexToAddServiceMap.remove(v);
            this.vertexToAddExistingServiceMap.remove(v);
            this.somethingChanged();
        }
    }

    @Override
    protected void removeInfo(Info i) {
        ResourceGraph.Vertex v = this.getVertex(i);
        this.lockGraph();
        for (ResourceGraph.Edge e : this.getGraph().getInEdges(v)) {
            this.edgeIsOrderList.remove(e);
            this.edgeIsColocationList.remove(e);
            this.keepEdgeIsOrderList.remove(e);
            this.keepEdgeIsColocationList.remove(e);
        }
        for (ResourceGraph.Edge e : this.getGraph().getOutEdges(v)) {
            this.edgeIsOrderList.remove(e);
            this.edgeIsColocationList.remove(e);
            this.keepEdgeIsOrderList.remove(e);
            this.keepEdgeIsColocationList.remove(e);
        }
        this.unlockGraph();
        this.getVertexIsPresentList().remove(v);
        this.putVertexIsPresentList();
        ((ServiceInfo)i).getService().setNew(false);
        this.resetSavedPosition(i);
    }

    Set<ResourceGraph.Vertex> getVertexIsPresentList() {
        this.mVertexIsPresentListLock.lock();
        return this.vertexIsPresentList;
    }

    void putVertexIsPresentList() {
        this.mVertexIsPresentListLock.unlock();
    }

    public void setServiceIsPresentList(List<ServiceInfo> sis) {
        HashSet<ResourceGraph.Vertex> vipl = new HashSet<ResourceGraph.Vertex>();
        for (ServiceInfo si : sis) {
            ResourceGraph.Vertex v = this.getVertex(si);
            if (v == null) continue;
            vipl.add(v);
        }
        this.mVertexIsPresentListLock.lock();
        this.vertexIsPresentList = vipl;
        this.mVertexIsPresentListLock.unlock();
    }

    @Override
    protected List<ImageIcon> getIconsForVertex(ResourceGraph.Vertex v, boolean testOnly) {
        ArrayList<ImageIcon> icons = new ArrayList<ImageIcon>();
        HostInfo hi = this.vertexToHostMap.get(v);
        if (hi != null) {
            if (hi.getHost().isClStatus()) {
                icons.add(HostBrowser.HOST_ON_ICON_LARGE);
            } else {
                icons.add(HostBrowser.HOST_ICON_LARGE);
            }
            if (hi.isStandby(testOnly)) {
                icons.add(HOST_STANDBY_ICON);
            }
            return icons;
        }
        if (this.vertexToConstraintPHMap.containsKey(v)) {
            return null;
        }
        ServiceInfo si = (ServiceInfo)this.getInfo(v);
        if (si == null) {
            return null;
        }
        if (si.isFailed(testOnly)) {
            if (si.isRunning(testOnly)) {
                icons.add(SERVICE_RUNNING_FAILED_ICON);
            } else {
                icons.add(SERVICE_STOPPED_FAILED_ICON);
            }
        } else if (si.isStopped(testOnly) || this.getClusterBrowser().allHostsDown()) {
            if (si.isRunning(testOnly)) {
                icons.add(SERVICE_STOPPING_ICON);
            } else {
                icons.add(SERVICE_STOPPED_ICON);
            }
        } else if (si.isRunning(testOnly)) {
            icons.add(SERVICE_RUNNING_ICON);
        } else {
            icons.add(SERVICE_STARTED_ICON);
        }
        if (!si.isManaged(testOnly) || si.getService().isOrphaned()) {
            icons.add(SERVICE_UNMANAGED_ICON);
        }
        if (si.getMigratedTo(testOnly) != null || si.getMigratedFrom(testOnly) != null) {
            icons.add(SERVICE_MIGRATED_ICON);
        }
        return icons;
    }

    @Override
    protected boolean showEdgeArrow(ResourceGraph.Edge e) {
        if (this.edgeIsOrderList.contains(e)) {
            this.mHbConnectionReadLock.lock();
            HbConnectionInfo hbci = this.edgeToHbconnectionMap.get(e);
            this.mHbConnectionReadLock.unlock();
            return hbci != null && !hbci.isOrderTwoDirections();
        }
        return false;
    }

    @Override
    protected boolean showHollowArrow(ResourceGraph.Edge e) {
        if (this.edgeIsOrderList.contains(e)) {
            this.mHbConnectionReadLock.lock();
            HbConnectionInfo hbci = this.edgeToHbconnectionMap.get(e);
            this.mHbConnectionReadLock.unlock();
            return hbci != null && hbci.isOrdScoreNull(null, null);
        }
        return false;
    }

    public void reloadServiceMenus() {
        this.lockGraph();
        for (ResourceGraph.Vertex v : this.getGraph().getVertices()) {
            JMenu existingServiceMenuItem = this.vertexToAddExistingServiceMap.get(v);
            this.reloadAddExistingServicePopup(existingServiceMenuItem, v);
        }
        this.unlockGraph();
    }

    @Override
    protected void oneEdgePressed(ResourceGraph.Edge e) {
        this.mHbConnectionReadLock.lock();
        HbConnectionInfo hbci = this.edgeToHbconnectionMap.get(e);
        this.mHbConnectionReadLock.unlock();
        if (hbci != null) {
            this.getClusterBrowser().setRightComponentInView(hbci);
        }
    }

    public void removeConnection(HbConnectionInfo hbci, Host dcHost, final boolean testOnly) {
        ServiceInfo siP = hbci.getLastServiceInfoParent();
        ServiceInfo siC = hbci.getLastServiceInfoChild();
        this.mHbConnectionReadLock.lock();
        final ResourceGraph.Edge edge = this.hbconnectionToEdgeMap.get(hbci);
        this.mHbConnectionReadLock.unlock();
        if (this.edgeIsOrderList.contains(edge)) {
            siC.removeOrder(siP, dcHost, testOnly);
        }
        ServiceInfo siRsc = hbci.getLastServiceInfoRsc();
        ServiceInfo siWithRsc = hbci.getLastServiceInfoWithRsc();
        if (this.edgeIsColocationList.contains(edge)) {
            if (!testOnly) {
                this.edgeIsOrderList.remove(edge);
                this.edgeIsColocationList.remove(edge);
                this.keepEdgeIsOrderList.remove(edge);
                this.keepEdgeIsColocationList.remove(edge);
            }
            siRsc.removeColocation(siWithRsc, dcHost, testOnly);
        } else if (!testOnly) {
            this.edgeIsOrderList.remove(edge);
            this.edgeIsColocationList.remove(edge);
            this.keepEdgeIsOrderList.remove(edge);
            this.keepEdgeIsColocationList.remove(edge);
        }
        if (testOnly) {
            this.addExistingTestEdge(edge);
        } else if (hbci.isNew()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CRMGraph.this.removeEdge(edge, testOnly);
                }
            });
        }
    }

    public void removeOrder(HbConnectionInfo hbci, Host dcHost, final boolean testOnly) {
        if (hbci == null) {
            return;
        }
        ServiceInfo siP = hbci.getLastServiceInfoParent();
        ServiceInfo siC = hbci.getLastServiceInfoChild();
        this.mHbConnectionReadLock.lock();
        final ResourceGraph.Edge edge = this.hbconnectionToEdgeMap.get(hbci);
        this.mHbConnectionReadLock.unlock();
        if (this.edgeIsOrderList.contains(edge)) {
            if (!testOnly) {
                this.edgeIsOrderList.remove(edge);
                this.keepEdgeIsOrderList.remove(edge);
            }
            siC.removeOrder(siP, dcHost, testOnly);
        }
        if (testOnly) {
            this.addExistingTestEdge(edge);
        } else if (hbci.isNew()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CRMGraph.this.removeEdge(edge, testOnly);
                }
            });
        }
    }

    public void addOrder(HbConnectionInfo hbConnectionInfo, Host dcHost, boolean testOnly) {
        ServiceInfo siRsc = hbConnectionInfo.getLastServiceInfoRsc();
        ServiceInfo siWithRsc = hbConnectionInfo.getLastServiceInfoWithRsc();
        if (siWithRsc != null && siWithRsc.getService() != null && siWithRsc.getService().isNew() || siRsc != null && siRsc.getService() != null && siRsc.getService().isNew()) {
            this.addOrder(null, siRsc, siWithRsc);
        } else {
            siWithRsc.addOrder(siRsc, dcHost, testOnly);
        }
        if (testOnly) {
            this.mHbConnectionReadLock.lock();
            ResourceGraph.Edge edge = this.hbconnectionToEdgeMap.get(hbConnectionInfo);
            this.mHbConnectionReadLock.unlock();
            this.addExistingTestEdge(edge);
        }
    }

    public void removeColocation(HbConnectionInfo hbci, Host dcHost, final boolean testOnly) {
        ServiceInfo siRsc = hbci.getLastServiceInfoRsc();
        ServiceInfo siWithRsc = hbci.getLastServiceInfoWithRsc();
        this.mHbConnectionReadLock.lock();
        final ResourceGraph.Edge edge = this.hbconnectionToEdgeMap.get(hbci);
        if (edge == null) {
            this.mHbConnectionReadLock.unlock();
            return;
        }
        this.mHbConnectionReadLock.unlock();
        if (this.edgeIsColocationList.contains(edge)) {
            if (!testOnly) {
                this.edgeIsColocationList.remove(edge);
                this.keepEdgeIsColocationList.remove(edge);
            }
            siRsc.removeColocation(siWithRsc, dcHost, testOnly);
        }
        if (testOnly) {
            this.addExistingTestEdge(edge);
        } else if (hbci.isNew()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CRMGraph.this.removeEdge(edge, testOnly);
                }
            });
        }
    }

    public void addColocation(HbConnectionInfo hbConnectionInfo, Host dcHost, boolean testOnly) {
        ServiceInfo siP = hbConnectionInfo.getLastServiceInfoParent();
        ServiceInfo siC = hbConnectionInfo.getLastServiceInfoChild();
        if (siC != null && siC.getService() != null && siC.getService().isNew()) {
            this.addColocation(null, siP, siC);
        } else {
            siP.addColocation(siC, dcHost, testOnly);
        }
        if (testOnly) {
            this.mHbConnectionReadLock.lock();
            ResourceGraph.Edge edge = this.hbconnectionToEdgeMap.get(hbConnectionInfo);
            this.mHbConnectionReadLock.unlock();
            this.addExistingTestEdge(edge);
        }
    }

    public boolean isOrder(HbConnectionInfo hbConnectionInfo) {
        this.mHbConnectionReadLock.lock();
        ResourceGraph.Edge edge = this.hbconnectionToEdgeMap.get(hbConnectionInfo);
        this.mHbConnectionReadLock.unlock();
        return this.edgeIsOrderList.contains(edge);
    }

    public boolean isColocation(HbConnectionInfo hbConnectionInfo) {
        this.mHbConnectionReadLock.lock();
        ResourceGraph.Edge edge = this.hbconnectionToEdgeMap.get(hbConnectionInfo);
        this.mHbConnectionReadLock.unlock();
        return this.edgeIsColocationList.contains(edge);
    }

    void addHost(HostInfo hostInfo) {
        ResourceGraph.Vertex v = super.getVertex(hostInfo);
        if (v == null) {
            v = new ResourceGraph.Vertex();
            this.lockGraph();
            this.getGraph().addVertex(v);
            this.unlockGraph();
            this.somethingChanged();
            this.putInfoToVertex(hostInfo, v);
            this.vertexToHostMap.put(v, hostInfo);
            this.hostToVertexMap.put(hostInfo, v);
            this.putVertexToInfo(v, hostInfo);
            Point2D hostPos = this.getSavedPosition(hostInfo);
            if (hostPos == null) {
                hostPos = new Point2D.Double(this.hostDefaultXPos, 40.0);
                this.hostDefaultXPos += 230;
            }
            this.getVertexLocations().put(v, hostPos);
            this.putVertexLocations();
        }
    }

    @Override
    protected String getIconText(ResourceGraph.Vertex v, boolean testOnly) {
        if (this.isTestOnlyAnimation()) {
            return Tools.getString("CRMGraph.Simulate");
        }
        if (this.vertexToHostMap.containsKey(v)) {
            return this.vertexToHostMap.get(v).getIconTextForGraph(testOnly);
        }
        if (this.vertexToConstraintPHMap.containsKey(v)) {
            return this.vertexToConstraintPHMap.get(v).getIconTextForGraph(testOnly);
        }
        ServiceInfo si = (ServiceInfo)this.getInfo(v);
        if (si == null) {
            return null;
        }
        return si.getIconTextForGraph(testOnly);
    }

    @Override
    protected Subtext getRightCornerText(ResourceGraph.Vertex v, boolean testOnly) {
        if (this.vertexToHostMap.containsKey(v)) {
            HostInfo hi = this.vertexToHostMap.get(v);
            return hi.getRightCornerTextForGraph(testOnly);
        }
        if (this.vertexToConstraintPHMap.containsKey(v)) {
            return null;
        }
        ServiceInfo si = (ServiceInfo)this.getInfo(v);
        if (si != null) {
            return si.getRightCornerTextForGraph(testOnly);
        }
        return null;
    }

    @Override
    protected Subtext[] getSubtexts(ResourceGraph.Vertex v, boolean testOnly) {
        if (this.vertexToHostMap.containsKey(v)) {
            return this.vertexToHostMap.get(v).getSubtextsForGraph(testOnly);
        }
        if (this.vertexToConstraintPHMap.containsKey(v)) {
            return this.vertexToConstraintPHMap.get(v).getSubtextsForGraph(testOnly);
        }
        ServiceInfo si = (ServiceInfo)this.getInfo(v);
        if (si == null) {
            return null;
        }
        return si.getSubtextsForGraph(testOnly);
    }

    protected int getUsed(ResourceGraph.Vertex v) {
        if (this.vertexToHostMap.containsKey(v)) {
            HostInfo hi = (HostInfo)this.getInfo(v);
            if (hi == null) {
                return 0;
            }
            return hi.getUsed();
        }
        ServiceInfo si = (ServiceInfo)this.getInfo(v);
        if (si == null) {
            return 0;
        }
        return si.getUsed();
    }

    @Override
    protected void drawInside(ResourceGraph.Vertex v, Graphics2D g2d, double x, double y, Shape shape) {
        boolean tOnly = this.isTestOnly();
        float height = (float)shape.getBounds().getHeight();
        float width = (float)shape.getBounds().getWidth();
        if (this.vertexToHostMap.containsKey(v)) {
            HostInfo hi = (HostInfo)this.getInfo(v);
            if (hi != null) {
                this.drawInsideVertex(g2d, v, hi.getHost().getPmColors(), x, y, height, width);
            }
        } else if (!this.vertexToConstraintPHMap.containsKey(v)) {
            double used;
            ServiceInfo si = (ServiceInfo)this.getInfo(v);
            if (si == null) {
                return;
            }
            List<Color> colors = si.getHostColors(tOnly);
            int number = colors.size();
            if (number > 1) {
                for (int i = 1; i < number; ++i) {
                    GradientPaint p = new GradientPaint((float)x + width / (float)number, (float)y, this.getVertexFillSecondaryColor(v), (float)x + width / (float)number, (float)y + height, colors.get(i), false);
                    g2d.setPaint(p);
                    RoundRectangle2D.Double s = new RoundRectangle2D.Double(x + (double)(width / (float)number * (float)i) - 5.0, y, width / (float)number + (float)(i < number - 1 ? 20 : 5), height, 20.0, 20.0);
                    g2d.fill(s);
                }
            }
            if ((used = (double)this.getUsed(v)) > 0.0) {
                double freeWidth = (double)width * (100.0 - used) / 100.0;
                RoundRectangle2D.Double freeShape = new RoundRectangle2D.Double(x + (double)width - freeWidth, y, freeWidth, height, 20.0, 20.0);
                g2d.setColor(new Color(255, 255, 255, 180));
                g2d.fill(freeShape);
            }
        }
        if (this.isPicked(v)) {
            if (tOnly) {
                g2d.setColor(Color.RED);
            } else {
                g2d.setColor(Color.BLACK);
            }
        } else {
            g2d.setColor(Color.WHITE);
        }
        g2d.setStroke(new BasicStroke(1.5f));
        g2d.draw(shape);
    }

    List<HbConnectionInfo> getAllHbConnections() {
        ArrayList<HbConnectionInfo> allConnections = new ArrayList<HbConnectionInfo>();
        this.mHbConnectionReadLock.lock();
        for (HbConnectionInfo hbci : this.hbconnectionToEdgeMap.keySet()) {
            allConnections.add(hbci);
        }
        this.mHbConnectionReadLock.unlock();
        return allConnections;
    }

    @Override
    public ResourceGraph.Vertex getVertex(Info i) {
        if (i == null) {
            return null;
        }
        if (this.hostToVertexMap.containsKey(i)) {
            return super.getVertex(i);
        }
        GroupInfo gi = ((ServiceInfo)i).getGroupInfo();
        if (gi == null) {
            return super.getVertex(i);
        }
        return super.getVertex(gi);
    }

    public void addConstraintPlaceholder(ConstraintPHInfo rsoi, Point2D pos, boolean testOnly) {
        if (testOnly) {
            return;
        }
        ResourceGraph.Vertex v = new ResourceGraph.Vertex();
        if (pos == null) {
            Point2D newPos = this.getSavedPosition(rsoi);
            if (newPos == null) {
                Point2D max = this.getLastPosition();
                float maxYPos = (float)max.getY();
                this.getVertexLocations().put(v, new Point2D.Float(15.0f, maxYPos + 40.0f));
                this.putVertexLocations();
            } else {
                this.getVertexLocations().put(v, newPos);
                this.putVertexLocations();
            }
        } else {
            this.getVertexLocations().put(v, pos);
            this.putVertexLocations();
        }
        this.lockGraph();
        this.getGraph().addVertex(v);
        this.unlockGraph();
        this.putInfoToVertex(rsoi, v);
        this.putVertexToInfo(v, rsoi);
        this.constraintPHToVertexMap.put(rsoi, v);
        this.vertexToConstraintPHMap.put(v, rsoi);
        this.somethingChanged();
    }

    @Override
    protected int getDefaultVertexHeight(ResourceGraph.Vertex v) {
        if (this.vertexToConstraintPHMap.containsKey(v)) {
            return 50;
        }
        return 50;
    }

    @Override
    protected int getDefaultVertexWidth(ResourceGraph.Vertex v) {
        if (this.vertexToConstraintPHMap.containsKey(v)) {
            return 50;
        }
        return super.getDefaultVertexWidth(v);
    }

    @Override
    protected void setVertexWidth(ResourceGraph.Vertex v, int size) {
        super.setVertexWidth(v, size);
    }

    @Override
    protected void setVertexHeight(ResourceGraph.Vertex v, int size) {
        super.setVertexHeight(v, size);
    }

    @Override
    protected void multiSelection() {
        ArrayList<Info> selectedInfos = new ArrayList<Info>();
        PickedState ps = this.getVisualizationViewer().getRenderContext().getPickedVertexState();
        for (ResourceGraph.Vertex v : ps.getPicked()) {
            selectedInfos.add(this.getInfo(v));
        }
        this.multiSelectionInfo = new PcmkMultiSelectionInfo(selectedInfos, (Browser)this.getClusterBrowser());
        this.getClusterBrowser().setRightComponentInView(this.multiSelectionInfo);
    }
}

