/*
 * Decompiled with CFR 0.152.
 */
package lcmc.data;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import lcmc.data.Host;
import lcmc.data.XML;
import lcmc.utilities.ConvertCmdCallback;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;
import lcmc.utilities.VIRSH;
import org.apache.commons.collections15.map.MultiKeyMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class VMSXML
extends XML {
    private final List<String> domainNames = new ArrayList<String>();
    private final Map<String, String> configsMap = new HashMap<String, String>();
    private final Map<String, String> namesConfigsMap = new HashMap<String, String>();
    private final Map<String, String> netConfigsMap = new HashMap<String, String>();
    private final Map<String, String> netNamesConfigsMap = new HashMap<String, String>();
    private final MultiKeyMap<String, String> parameterValues = new MultiKeyMap();
    private final Map<String, Integer> remotePorts = new HashMap<String, Integer>();
    private final Map<String, Boolean> autoports = new HashMap<String, Boolean>();
    private final Map<String, Boolean> runningMap = new HashMap<String, Boolean>();
    private final Map<String, Boolean> suspendedMap = new HashMap<String, Boolean>();
    private final Map<String, Map<String, DiskData>> disksMap = new LinkedHashMap<String, Map<String, DiskData>>();
    private final Map<String, Map<String, FilesystemData>> filesystemsMap = new LinkedHashMap<String, Map<String, FilesystemData>>();
    private final Map<String, Map<String, InterfaceData>> interfacesMap = new LinkedHashMap<String, Map<String, InterfaceData>>();
    private final Map<String, Map<String, InputDevData>> inputDevsMap = new LinkedHashMap<String, Map<String, InputDevData>>();
    private final Map<String, Map<String, GraphicsData>> graphicsDevsMap = new LinkedHashMap<String, Map<String, GraphicsData>>();
    private final Map<String, Map<String, SoundData>> soundsMap = new LinkedHashMap<String, Map<String, SoundData>>();
    private final Map<String, Map<String, SerialData>> serialsMap = new LinkedHashMap<String, Map<String, SerialData>>();
    private final Map<String, Map<String, ParallelData>> parallelsMap = new LinkedHashMap<String, Map<String, ParallelData>>();
    private final Map<String, Map<String, VideoData>> videosMap = new LinkedHashMap<String, Map<String, VideoData>>();
    private final Map<String, NetworkData> networkMap = new LinkedHashMap<String, NetworkData>();
    private final Set<String> sourceFileDirs = new TreeSet<String>();
    private static final Pattern DISPLAY_PATTERN = Pattern.compile(".*:(\\d+)$");
    private final Host host;
    public static final String VM_PARAM_NAME = "name";
    public static final String VM_PARAM_UUID = "uuid";
    public static final String VM_PARAM_DEFINED = "defined";
    public static final String VM_PARAM_STATUS = "status";
    public static final String VM_PARAM_DOMAIN_TYPE = "domain-type";
    public static final String VM_PARAM_VCPU = "vcpu";
    public static final String VM_PARAM_BOOTLOADER = "bootloader";
    public static final String VM_PARAM_CURRENTMEMORY = "currentMemory";
    public static final String VM_PARAM_MEMORY = "memory";
    public static final String OS_BOOT_NODE = "boot";
    public static final String OS_BOOT_NODE_DEV = "dev";
    public static final String VM_PARAM_BOOT = "boot";
    public static final String VM_PARAM_BOOT_2 = "boot2";
    public static final String VM_PARAM_LOADER = "loader";
    public static final String VM_PARAM_AUTOSTART = "autostart";
    public static final String VM_PARAM_VIRSH_OPTIONS = "virsh-options";
    public static final String VM_PARAM_TYPE = "type";
    public static final String VM_PARAM_INIT = "init";
    public static final String VM_PARAM_TYPE_ARCH = "arch";
    public static final String VM_PARAM_TYPE_MACHINE = "machine";
    public static final String VM_PARAM_ACPI = "acpi";
    public static final String VM_PARAM_APIC = "apic";
    public static final String VM_PARAM_PAE = "pae";
    public static final String VM_PARAM_HAP = "hap";
    public static final String VM_PARAM_CLOCK_OFFSET = "offset";
    public static final String VM_PARAM_CPU_MATCH = "match";
    public static final String VM_PARAM_CPUMATCH_MODEL = "model";
    public static final String VM_PARAM_CPUMATCH_VENDOR = "vendor";
    public static final String VM_PARAM_CPUMATCH_TOPOLOGY_SOCKETS = "sockets";
    public static final String VM_PARAM_CPUMATCH_TOPOLOGY_CORES = "cores";
    public static final String VM_PARAM_CPUMATCH_TOPOLOGY_THREADS = "threads";
    public static final String VM_PARAM_CPUMATCH_FEATURE_POLICY = "policy";
    public static final String VM_PARAM_CPUMATCH_FEATURES = "features";
    public static final String VM_PARAM_ON_POWEROFF = "on_poweroff";
    public static final String VM_PARAM_ON_REBOOT = "on_reboot";
    public static final String VM_PARAM_ON_CRASH = "on_crash";
    public static final String VM_PARAM_EMULATOR = "emulator";
    public static final String NET_PARAM_NAME = "name";
    public static final String NET_PARAM_UUID = "uuid";
    public static final String NET_PARAM_AUTOSTART = "autostart";
    public static final String HW_ADDRESS = "address";
    public static final Map<String, String> INTERFACE_TAG_MAP = new HashMap<String, String>();
    public static final Map<String, String> INTERFACE_ATTRIBUTE_MAP = new HashMap<String, String>();
    public static final Map<String, String> DISK_TAG_MAP = new HashMap<String, String>();
    public static final Map<String, String> DISK_ATTRIBUTE_MAP = new HashMap<String, String>();
    public static final Map<String, String> FILESYSTEM_TAG_MAP = new HashMap<String, String>();
    public static final Map<String, String> FILESYSTEM_ATTRIBUTE_MAP = new HashMap<String, String>();
    public static final Map<String, String> INPUTDEV_TAG_MAP = new HashMap<String, String>();
    public static final Map<String, String> INPUTDEV_ATTRIBUTE_MAP = new HashMap<String, String>();
    public static final Map<String, String> GRAPHICS_TAG_MAP = new HashMap<String, String>();
    public static final Map<String, String> GRAPHICS_ATTRIBUTE_MAP = new HashMap<String, String>();
    public static final Map<String, String> SOUND_TAG_MAP = new HashMap<String, String>();
    public static final Map<String, String> SOUND_ATTRIBUTE_MAP = new HashMap<String, String>();
    public static final Map<String, String> SERIAL_TAG_MAP = new HashMap<String, String>();
    public static final Map<String, String> SERIAL_ATTRIBUTE_MAP = new HashMap<String, String>();
    public static final Map<String, String> PARALLEL_TAG_MAP = new HashMap<String, String>();
    public static final Map<String, String> PARALLEL_ATTRIBUTE_MAP = new HashMap<String, String>();
    public static final Map<String, String> VIDEO_TAG_MAP = new HashMap<String, String>();
    public static final Map<String, String> VIDEO_ATTRIBUTE_MAP = new HashMap<String, String>();
    private final ReadWriteLock mXMLDocumentLock = new ReentrantReadWriteLock();
    private final Lock mXMLDocumentReadLock = this.mXMLDocumentLock.readLock();
    private final Lock mXMLDocumentWriteLock = this.mXMLDocumentLock.writeLock();
    private Document xmlDocument = null;

    public VMSXML(Host host) {
        this.host = host;
    }

    public Node getDomainNode(String domainName) {
        this.mXMLDocumentReadLock.lock();
        Document document = this.xmlDocument;
        this.mXMLDocumentReadLock.unlock();
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node domainNode = null;
        try {
            String path = "//vms/vm[@name='" + domainName + "']/config/domain";
            NodeList domainNodes = (NodeList)xpath.evaluate(path, document, XPathConstants.NODESET);
            if (domainNodes.getLength() != 1) {
                if (domainNodes.getLength() >= 1) {
                    Tools.appError(domainNodes.getLength() + " supposedly unique " + domainName + " configs.");
                    return null;
                }
                Tools.appWarning("could not find xml for " + domainName);
                return null;
            }
            domainNode = domainNodes.item(0);
        }
        catch (XPathExpressionException e) {
            Tools.appError("could not evaluate: ", e);
            return null;
        }
        return domainNode;
    }

    private void saveDomainXML(String configName, Node node, String defineCommand) {
        String xml = null;
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StreamResult res = new StreamResult(new StringWriter());
            DOMSource src = new DOMSource(node);
            transformer.transform(src, res);
            xml = res.getWriter().toString();
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return;
        }
        if (xml != null) {
            this.host.getSSH().scp(xml, configName, "0600", true, defineCommand, null, null);
        }
    }

    private Node getDevicesNode(XPath xpath, Node domainNode) {
        String devicesPath = "devices";
        try {
            NodeList devicesNodes = (NodeList)xpath.evaluate("devices", domainNode, XPathConstants.NODESET);
            if (devicesNodes.getLength() != 1) {
                Tools.appWarning("devices nodes: " + devicesNodes.getLength());
                return null;
            }
            return devicesNodes.item(0);
        }
        catch (XPathExpressionException e) {
            Tools.appError("could not evaluate: ", e);
            return null;
        }
    }

    private void addCPUMatchNode(Document doc, Node root, Map<String, String> parametersMap) {
        boolean isThreads;
        String vendor;
        String model;
        String cpuMatch = parametersMap.get(VM_PARAM_CPU_MATCH);
        Element cpuMatchNode = (Element)root.appendChild(doc.createElement("cpu"));
        if (!"".equals(cpuMatch)) {
            cpuMatchNode.setAttribute(VM_PARAM_CPU_MATCH, cpuMatch);
        }
        if (!"".equals(model = parametersMap.get(VM_PARAM_CPUMATCH_MODEL))) {
            Element modelNode = (Element)cpuMatchNode.appendChild(doc.createElement(VM_PARAM_CPUMATCH_MODEL));
            modelNode.appendChild(doc.createTextNode(model));
        }
        if (!"".equals(vendor = parametersMap.get(VM_PARAM_CPUMATCH_VENDOR))) {
            Element vendorNode = (Element)cpuMatchNode.appendChild(doc.createElement(VM_PARAM_CPUMATCH_VENDOR));
            vendorNode.appendChild(doc.createTextNode(vendor));
        }
        String sockets = parametersMap.get(VM_PARAM_CPUMATCH_TOPOLOGY_SOCKETS);
        String cores = parametersMap.get(VM_PARAM_CPUMATCH_TOPOLOGY_CORES);
        String threads = parametersMap.get(VM_PARAM_CPUMATCH_TOPOLOGY_THREADS);
        boolean isSockets = !"".equals(sockets);
        boolean isCores = !"".equals(cores);
        boolean bl = isThreads = !"".equals(threads);
        if (isSockets || isCores || isThreads) {
            Element topologyNode = (Element)cpuMatchNode.appendChild(doc.createElement("topology"));
            if (isSockets) {
                topologyNode.setAttribute(VM_PARAM_CPUMATCH_TOPOLOGY_SOCKETS, sockets);
            }
            if (isCores) {
                topologyNode.setAttribute(VM_PARAM_CPUMATCH_TOPOLOGY_CORES, cores);
            }
            if (isThreads) {
                topologyNode.setAttribute(VM_PARAM_CPUMATCH_TOPOLOGY_THREADS, threads);
            }
        }
        String policy = parametersMap.get(VM_PARAM_CPUMATCH_FEATURE_POLICY);
        String features = parametersMap.get(VM_PARAM_CPUMATCH_FEATURES);
        if (!"".equals(policy) && !"".equals(features)) {
            for (String feature : features.split("\\s+")) {
                Element featureNode = (Element)cpuMatchNode.appendChild(doc.createElement("feature"));
                featureNode.setAttribute(VM_PARAM_CPUMATCH_FEATURE_POLICY, policy);
                featureNode.setAttribute("name", feature);
            }
        }
        if (!cpuMatchNode.hasChildNodes()) {
            root.removeChild(cpuMatchNode);
        }
    }

    private void addFeatures(Document doc, Node root, Map<String, String> parametersMap) {
        boolean acpi = "True".equals(parametersMap.get(VM_PARAM_ACPI));
        boolean apic = "True".equals(parametersMap.get(VM_PARAM_APIC));
        boolean pae = "True".equals(parametersMap.get(VM_PARAM_PAE));
        boolean hap = "True".equals(parametersMap.get(VM_PARAM_HAP));
        if (acpi || apic || pae || hap) {
            Element featuresNode = (Element)root.appendChild(doc.createElement(VM_PARAM_CPUMATCH_FEATURES));
            if (acpi) {
                featuresNode.appendChild(doc.createElement(VM_PARAM_ACPI));
            }
            if (apic) {
                featuresNode.appendChild(doc.createElement(VM_PARAM_APIC));
            }
            if (pae) {
                featuresNode.appendChild(doc.createElement(VM_PARAM_PAE));
            }
            if (hap) {
                featuresNode.appendChild(doc.createElement(VM_PARAM_HAP));
            }
        }
    }

    private void addClockOffset(Document doc, Node root, Map<String, String> parametersMap) {
        Element clockNode = (Element)root.appendChild(doc.createElement("clock"));
        String offset = parametersMap.get(VM_PARAM_CLOCK_OFFSET);
        clockNode.setAttribute(VM_PARAM_CLOCK_OFFSET, offset);
        Element timer1 = (Element)clockNode.appendChild(doc.createElement("timer"));
        timer1.setAttribute("name", "pit");
        timer1.setAttribute("tickpolicy", "delay");
        Element timer2 = (Element)clockNode.appendChild(doc.createElement("timer"));
        timer2.setAttribute("name", "rtc");
        timer2.setAttribute("tickpolicy", "catchup");
        Element timer3 = (Element)clockNode.appendChild(doc.createElement("timer"));
        timer3.setAttribute("name", "hpet");
        timer3.setAttribute("present", "no");
    }

    private String getConfigName(String type, String domainName) {
        if ("xen".equals(type)) {
            return "/etc/xen/vm/" + domainName + ".xml";
        }
        if ("lxc".equals(type)) {
            return "/etc/libvirt/lxc/" + domainName + ".xml";
        }
        return "/etc/libvirt/qemu/" + domainName + ".xml";
    }

    public Node createDomainXML(String uuid, String domainName, Map<String, String> parametersMap, boolean needConsole) {
        String emulator;
        String onCrash;
        String onReboot;
        String bootloader;
        DocumentBuilder db;
        String type;
        block11: {
            type = parametersMap.get(VM_PARAM_DOMAIN_TYPE);
            String configName = this.getConfigName(type, domainName);
            this.namesConfigsMap.put(domainName, configName);
            String encoding = "UTF-8";
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            db = null;
            try {
                db = dbf.newDocumentBuilder();
            }
            catch (ParserConfigurationException pce) {
                if ($assertionsDisabled) break block11;
                throw new AssertionError();
            }
        }
        Document doc = db.newDocument();
        Element root = (Element)doc.appendChild(doc.createElement("domain"));
        root.setAttribute(VM_PARAM_TYPE, type);
        Element uuidNode = (Element)root.appendChild(doc.createElement("uuid"));
        uuidNode.appendChild(doc.createTextNode(uuid));
        Element nameNode = (Element)root.appendChild(doc.createElement("name"));
        nameNode.appendChild(doc.createTextNode(domainName));
        Element memoryNode = (Element)root.appendChild(doc.createElement(VM_PARAM_MEMORY));
        long mem = Tools.convertToKilobytes(parametersMap.get(VM_PARAM_MEMORY));
        memoryNode.appendChild(doc.createTextNode(Long.toString(mem)));
        Element curMemoryNode = (Element)root.appendChild(doc.createElement(VM_PARAM_CURRENTMEMORY));
        long curMem = Tools.convertToKilobytes(parametersMap.get(VM_PARAM_CURRENTMEMORY));
        curMemoryNode.appendChild(doc.createTextNode(Long.toString(curMem)));
        String vcpu = parametersMap.get(VM_PARAM_VCPU);
        if (vcpu != null) {
            Element vcpuNode = (Element)root.appendChild(doc.createElement(VM_PARAM_VCPU));
            vcpuNode.appendChild(doc.createTextNode(vcpu));
        }
        if ((bootloader = parametersMap.get(VM_PARAM_BOOTLOADER)) != null) {
            Element bootloaderNode = (Element)root.appendChild(doc.createElement(VM_PARAM_BOOTLOADER));
            bootloaderNode.appendChild(doc.createTextNode(bootloader));
        }
        Element osNode = (Element)root.appendChild(doc.createElement("os"));
        Element typeNode = (Element)osNode.appendChild(doc.createElement(VM_PARAM_TYPE));
        typeNode.appendChild(doc.createTextNode(parametersMap.get(VM_PARAM_TYPE)));
        typeNode.setAttribute(VM_PARAM_TYPE_ARCH, parametersMap.get(VM_PARAM_TYPE_ARCH));
        typeNode.setAttribute(VM_PARAM_TYPE_MACHINE, parametersMap.get(VM_PARAM_TYPE_MACHINE));
        String init = parametersMap.get(VM_PARAM_INIT);
        if (init != null && !"".equals(init)) {
            Element initNode = (Element)osNode.appendChild(doc.createElement(VM_PARAM_INIT));
            initNode.appendChild(doc.createTextNode(init));
        }
        Element bootNode = (Element)osNode.appendChild(doc.createElement("boot"));
        bootNode.setAttribute(OS_BOOT_NODE_DEV, parametersMap.get("boot"));
        String bootDev2 = parametersMap.get(VM_PARAM_BOOT_2);
        if (bootDev2 != null && !"".equals(bootDev2)) {
            Element bootNode2 = (Element)osNode.appendChild(doc.createElement("boot"));
            bootNode2.setAttribute(OS_BOOT_NODE_DEV, parametersMap.get(VM_PARAM_BOOT_2));
        }
        Element loaderNode = (Element)osNode.appendChild(doc.createElement(VM_PARAM_LOADER));
        loaderNode.appendChild(doc.createTextNode(parametersMap.get(VM_PARAM_LOADER)));
        this.addFeatures(doc, root, parametersMap);
        this.addClockOffset(doc, root, parametersMap);
        this.addCPUMatchNode(doc, root, parametersMap);
        String onPoweroff = parametersMap.get(VM_PARAM_ON_POWEROFF);
        if (onPoweroff != null) {
            Element onPoweroffNode = (Element)root.appendChild(doc.createElement(VM_PARAM_ON_POWEROFF));
            onPoweroffNode.appendChild(doc.createTextNode(onPoweroff));
        }
        if ((onReboot = parametersMap.get(VM_PARAM_ON_REBOOT)) != null) {
            Element onRebootNode = (Element)root.appendChild(doc.createElement(VM_PARAM_ON_REBOOT));
            onRebootNode.appendChild(doc.createTextNode(onReboot));
        }
        if ((onCrash = parametersMap.get(VM_PARAM_ON_CRASH)) != null) {
            Element onCrashNode = (Element)root.appendChild(doc.createElement(VM_PARAM_ON_CRASH));
            onCrashNode.appendChild(doc.createTextNode(onCrash));
        }
        if ((emulator = parametersMap.get(VM_PARAM_EMULATOR)) != null || needConsole) {
            Element devicesNode = (Element)root.appendChild(doc.createElement("devices"));
            if (needConsole) {
                Element consoleNode = (Element)devicesNode.appendChild(doc.createElement("console"));
                consoleNode.setAttribute(VM_PARAM_TYPE, "pty");
            }
            Element emulatorNode = (Element)devicesNode.appendChild(doc.createElement(VM_PARAM_EMULATOR));
            emulatorNode.appendChild(doc.createTextNode(emulator));
        }
        return root;
    }

    public Node modifyDomainXML(String domainName, Map<String, String> parametersMap) {
        String configName = this.namesConfigsMap.get(domainName);
        if (configName == null) {
            return null;
        }
        Node domainNode = this.getDomainNode(domainName);
        if (domainNode == null) {
            return null;
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        HashMap<String, String> paths = new HashMap<String, String>();
        paths.put(VM_PARAM_MEMORY, VM_PARAM_MEMORY);
        paths.put(VM_PARAM_CURRENTMEMORY, VM_PARAM_CURRENTMEMORY);
        paths.put(VM_PARAM_VCPU, VM_PARAM_VCPU);
        paths.put(VM_PARAM_BOOTLOADER, VM_PARAM_BOOTLOADER);
        paths.put("boot", "os/boot");
        paths.put(VM_PARAM_BOOT_2, "os/boot");
        paths.put(VM_PARAM_TYPE, "os/type");
        paths.put(VM_PARAM_TYPE_ARCH, "os/type");
        paths.put(VM_PARAM_TYPE_MACHINE, "os/type");
        paths.put(VM_PARAM_INIT, "os/init");
        paths.put(VM_PARAM_LOADER, "os/loader");
        paths.put(VM_PARAM_CPU_MATCH, "cpu");
        paths.put(VM_PARAM_ACPI, VM_PARAM_CPUMATCH_FEATURES);
        paths.put(VM_PARAM_APIC, VM_PARAM_CPUMATCH_FEATURES);
        paths.put(VM_PARAM_PAE, VM_PARAM_CPUMATCH_FEATURES);
        paths.put(VM_PARAM_HAP, VM_PARAM_CPUMATCH_FEATURES);
        paths.put(VM_PARAM_CLOCK_OFFSET, "clock");
        paths.put(VM_PARAM_ON_POWEROFF, VM_PARAM_ON_POWEROFF);
        paths.put(VM_PARAM_ON_REBOOT, VM_PARAM_ON_REBOOT);
        paths.put(VM_PARAM_ON_CRASH, VM_PARAM_ON_CRASH);
        paths.put(VM_PARAM_EMULATOR, "devices/emulator");
        Document doc = domainNode.getOwnerDocument();
        try {
            for (String param : parametersMap.keySet()) {
                NodeList nodes;
                Element node;
                String path = (String)paths.get(param);
                if (path == null || (node = (Element)(nodes = (NodeList)xpath.evaluate(path, domainNode, XPathConstants.NODESET)).item(0)) == null) continue;
                if (VM_PARAM_BOOT_2.equals(param)) {
                    node = nodes.getLength() > 1 ? (Element)nodes.item(1) : (Element)node.getParentNode().appendChild(doc.createElement("boot"));
                }
                String value = parametersMap.get(param);
                if (VM_PARAM_MEMORY.equals(param) || VM_PARAM_CURRENTMEMORY.equals(param)) {
                    value = Long.toString(Tools.convertToKilobytes(value));
                }
                if (VM_PARAM_CPU_MATCH.equals(param) || VM_PARAM_CLOCK_OFFSET.equals(param) || VM_PARAM_ACPI.equals(param) || VM_PARAM_APIC.equals(param) || VM_PARAM_PAE.equals(param) || VM_PARAM_HAP.equals(param)) {
                    domainNode.removeChild(node);
                    continue;
                }
                if ("boot".equals(param)) {
                    node.setAttribute(OS_BOOT_NODE_DEV, value);
                    continue;
                }
                if (VM_PARAM_BOOT_2.equals(param)) {
                    if (value == null || "".equals(value)) {
                        node.getParentNode().removeChild(node);
                        continue;
                    }
                    node.setAttribute(OS_BOOT_NODE_DEV, value);
                    continue;
                }
                if (VM_PARAM_TYPE_ARCH.equals(param)) {
                    node.setAttribute(VM_PARAM_TYPE_ARCH, value);
                    continue;
                }
                if (VM_PARAM_TYPE_MACHINE.equals(param)) {
                    node.setAttribute(VM_PARAM_TYPE_MACHINE, value);
                    continue;
                }
                if (VM_PARAM_CPU_MATCH.equals(param)) {
                    if ("".equals(value)) {
                        node.getParentNode().removeChild(node);
                        continue;
                    }
                    node.setAttribute(VM_PARAM_CPU_MATCH, value);
                    continue;
                }
                if (VM_PARAM_CPUMATCH_TOPOLOGY_THREADS.equals(param)) {
                    node.setAttribute(VM_PARAM_CPUMATCH_TOPOLOGY_THREADS, value);
                    continue;
                }
                Node n = this.getChildNode(node, "#text");
                if (n == null) {
                    node.appendChild(doc.createTextNode(value));
                    continue;
                }
                n.setNodeValue(value);
            }
            this.addCPUMatchNode(doc, domainNode, parametersMap);
            this.addFeatures(doc, domainNode, parametersMap);
            this.addClockOffset(doc, domainNode, parametersMap);
        }
        catch (XPathExpressionException e) {
            Tools.appError("could not evaluate: ", e);
            return null;
        }
        return domainNode;
    }

    private void modifyXML(Node domainNode, String domainName, Map<String, String> tagMap, Map<String, String> attributeMap, Map<String, String> parametersMap, String path, String elementName, VirtualHardwareComparator vhc) {
        String configName = this.namesConfigsMap.get(domainName);
        if (configName == null) {
            return;
        }
        if (domainNode == null) {
            return;
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node devicesNode = this.getDevicesNode(xpath, domainNode);
        if (devicesNode == null) {
            return;
        }
        try {
            NodeList nodes = (NodeList)xpath.evaluate(path, domainNode, XPathConstants.NODESET);
            Element hwNode = vhc.getElement(nodes, parametersMap);
            if (hwNode == null) {
                hwNode = (Element)devicesNode.appendChild(domainNode.getOwnerDocument().createElement(elementName));
            }
            for (String param : parametersMap.keySet()) {
                String value = parametersMap.get(param);
                if (!tagMap.containsKey(param) && attributeMap.containsKey(param)) {
                    Node attributeNode = hwNode.getAttributes().getNamedItem(attributeMap.get(param));
                    if (attributeNode == null) {
                        if (value == null || "".equals(value)) continue;
                        hwNode.setAttribute(attributeMap.get(param), value);
                        continue;
                    }
                    if (value == null || "".equals(value)) {
                        hwNode.removeAttribute(attributeMap.get(param));
                        continue;
                    }
                    attributeNode.setNodeValue(value);
                    continue;
                }
                Element node = (Element)this.getChildNode(hwNode, tagMap.get(param));
                if ((attributeMap.containsKey(param) || "True".equals(value)) && node == null) {
                    node = (Element)hwNode.appendChild(domainNode.getOwnerDocument().createElement(tagMap.get(param)));
                } else if (node != null && !attributeMap.containsKey(param) && (value == null || "".equals(value))) {
                    hwNode.removeChild(node);
                }
                if (!attributeMap.containsKey(param)) continue;
                Node attributeNode = node.getAttributes().getNamedItem(attributeMap.get(param));
                if (attributeNode == null) {
                    if (value == null || "".equals(value)) continue;
                    node.setAttribute(attributeMap.get(param), value);
                    continue;
                }
                if (value == null || "".equals(value)) {
                    node.removeAttribute(attributeMap.get(param));
                    continue;
                }
                attributeNode.setNodeValue(value);
            }
            Element hwAddressNode = (Element)this.getChildNode(hwNode, HW_ADDRESS);
            if (hwAddressNode != null) {
                hwNode.removeChild(hwAddressNode);
            }
        }
        catch (XPathExpressionException e) {
            Tools.appError("could not evaluate: ", e);
            return;
        }
    }

    private void removeXML(String domainName, Map<String, String> parametersMap, String path, VirtualHardwareComparator vhc, String virshOptions) {
        String configName = this.namesConfigsMap.get(domainName);
        if (configName == null) {
            return;
        }
        Node domainNode = this.getDomainNode(domainName);
        if (domainNode == null) {
            return;
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            NodeList nodes = (NodeList)xpath.evaluate(path, domainNode, XPathConstants.NODESET);
            Element hwNode = vhc.getElement(nodes, parametersMap);
            if (hwNode != null) {
                hwNode.getParentNode().removeChild(hwNode);
            }
        }
        catch (XPathExpressionException e) {
            Tools.appError("could not evaluate: ", e);
            return;
        }
        this.saveAndDefine(domainNode, domainName, virshOptions);
    }

    public void modifyDiskXML(Node domainNode, String domainName, Map<String, String> parametersMap) {
        this.modifyXML(domainNode, domainName, DISK_TAG_MAP, DISK_ATTRIBUTE_MAP, parametersMap, "devices/disk", "disk", this.getDiskDataComparator());
    }

    public void modifyFilesystemXML(Node domainNode, String domainName, Map<String, String> parametersMap) {
        this.modifyXML(domainNode, domainName, FILESYSTEM_TAG_MAP, FILESYSTEM_ATTRIBUTE_MAP, parametersMap, "devices/filesystem", "filesystem", this.getFilesystemDataComparator());
    }

    public void saveAndDefine(Node domainNode, String domainName, String virshOptions) {
        String configName = this.namesConfigsMap.get(domainName);
        String defineCommand = VIRSH.getDefineCommand(this.host, configName + ".new" + " && rm " + configName + ".new", virshOptions);
        this.saveDomainXML(configName, domainNode, defineCommand);
        this.host.setVMInfoMD5(null);
    }

    public void modifyInterfaceXML(Node domainNode, String domainName, Map<String, String> parametersMap) {
        this.modifyXML(domainNode, domainName, INTERFACE_TAG_MAP, INTERFACE_ATTRIBUTE_MAP, parametersMap, "devices/interface", "interface", this.getInterfaceDataComparator());
    }

    public void modifyInputDevXML(Node domainNode, String domainName, Map<String, String> parametersMap) {
        this.modifyXML(domainNode, domainName, INPUTDEV_TAG_MAP, INPUTDEV_ATTRIBUTE_MAP, parametersMap, "devices/input", "input", this.getInputDevDataComparator());
    }

    public void modifyGraphicsXML(Node domainNode, String domainName, Map<String, String> parametersMap) {
        this.modifyXML(domainNode, domainName, GRAPHICS_TAG_MAP, GRAPHICS_ATTRIBUTE_MAP, parametersMap, "devices/graphics", "graphics", this.getGraphicsDataComparator());
    }

    public void modifySoundXML(Node domainNode, String domainName, Map<String, String> parametersMap) {
        this.modifyXML(domainNode, domainName, SOUND_TAG_MAP, SOUND_ATTRIBUTE_MAP, parametersMap, "devices/sound", "sound", this.getSoundDataComparator());
    }

    public void modifySerialXML(Node domainNode, String domainName, Map<String, String> parametersMap) {
        this.modifyXML(domainNode, domainName, SERIAL_TAG_MAP, SERIAL_ATTRIBUTE_MAP, parametersMap, "devices/serial", "serial", this.getSerialDataComparator());
    }

    public void modifyParallelXML(Node domainNode, String domainName, Map<String, String> parametersMap) {
        this.modifyXML(domainNode, domainName, PARALLEL_TAG_MAP, PARALLEL_ATTRIBUTE_MAP, parametersMap, "devices/parallel", "parallel", this.getParallelDataComparator());
    }

    public void modifyVideoXML(Node domainNode, String domainName, Map<String, String> parametersMap) {
        this.modifyXML(domainNode, domainName, VIDEO_TAG_MAP, VIDEO_ATTRIBUTE_MAP, parametersMap, "devices/video", "video", this.getVideoDataComparator());
    }

    public void removeDiskXML(String domainName, Map<String, String> parametersMap, String virshOptions) {
        this.removeXML(domainName, parametersMap, "devices/disk", this.getDiskDataComparator(), virshOptions);
    }

    public void removeFilesystemXML(String domainName, Map<String, String> parametersMap, String virshOptions) {
        this.removeXML(domainName, parametersMap, "devices/filesystem", this.getFilesystemDataComparator(), virshOptions);
    }

    public void removeInterfaceXML(String domainName, Map<String, String> parametersMap, String virshOptions) {
        this.removeXML(domainName, parametersMap, "devices/interface", this.getInterfaceDataComparator(), virshOptions);
    }

    public void removeInputDevXML(String domainName, Map<String, String> parametersMap, String virshOptions) {
        this.removeXML(domainName, parametersMap, "devices/input", this.getInputDevDataComparator(), virshOptions);
    }

    public void removeGraphicsXML(String domainName, Map<String, String> parametersMap, String virshOptions) {
        this.removeXML(domainName, parametersMap, "devices/graphics", this.getGraphicsDataComparator(), virshOptions);
    }

    public void removeSoundXML(String domainName, Map<String, String> parametersMap, String virshOptions) {
        this.removeXML(domainName, parametersMap, "devices/sound", this.getSoundDataComparator(), virshOptions);
    }

    public void removeSerialXML(String domainName, Map<String, String> parametersMap, String virshOptions) {
        this.removeXML(domainName, parametersMap, "devices/serial", this.getSerialDataComparator(), virshOptions);
    }

    public void removeParallelXML(String domainName, Map<String, String> parametersMap, String virshOptions) {
        this.removeXML(domainName, parametersMap, "devices/parallel", this.getParallelDataComparator(), virshOptions);
    }

    public void removeVideoXML(String domainName, Map<String, String> parametersMap, String virshOptions) {
        this.removeXML(domainName, parametersMap, "devices/video", this.getVideoDataComparator(), virshOptions);
    }

    public boolean update() {
        String command = this.host.getDistCommand("VMSXML.GetData", (ConvertCmdCallback)null);
        SSH.SSHOutput ret = Tools.execCommand(this.host, command, null, false, SSH.DEFAULT_COMMAND_TIMEOUT);
        if (ret.getExitCode() != 0) {
            return false;
        }
        String output = ret.getOutput();
        if (output == null) {
            return false;
        }
        return this.update(output);
    }

    public boolean update(String output) {
        Document document = this.getXMLDocument(output);
        this.mXMLDocumentWriteLock.lock();
        this.xmlDocument = document;
        this.mXMLDocumentWriteLock.unlock();
        if (document == null) {
            return false;
        }
        Node vmsNode = this.getChildNode(document, "vms");
        String md5 = this.getAttribute(vmsNode, "md5");
        if (md5 == null || md5.equals(this.host.getVMInfoMD5())) {
            return false;
        }
        this.host.setVMInfoMD5(md5);
        NodeList vms = vmsNode.getChildNodes();
        for (int i = 0; i < vms.getLength(); ++i) {
            Node node = vms.item(i);
            if ("net".equals(node.getNodeName())) {
                this.updateNetworks(node);
                continue;
            }
            if ("vm".equals(node.getNodeName())) {
                this.updateVM(node);
                continue;
            }
            if (!"version".equals(node.getNodeName())) continue;
            this.host.setLibvirtVersion(this.getText(node));
        }
        return true;
    }

    private void updateNetworks(Node netNode) {
        if (netNode == null) {
            return;
        }
        String name = this.getAttribute(netNode, "name");
        String config = this.getAttribute(netNode, "config");
        this.netConfigsMap.put(config, name);
        this.netNamesConfigsMap.put(name, config);
        String autostartString = this.getAttribute(netNode, "autostart");
        this.parseNetConfig(this.getChildNode(netNode, "network"), name, autostartString);
    }

    private void parseNetConfig(Node networkNode, String nameInFilename, String autostartString) {
        if (networkNode == null) {
            return;
        }
        boolean autostart = false;
        if (autostartString != null && "true".equals(autostartString)) {
            autostart = true;
        }
        NodeList options = networkNode.getChildNodes();
        String name = null;
        String uuid = null;
        String forwardMode = null;
        String bridgeName = null;
        String bridgeSTP = null;
        String bridgeDelay = null;
        String bridgeForwardDelay = null;
        for (int i = 0; i < options.getLength(); ++i) {
            Node optionNode = options.item(i);
            String nodeName = optionNode.getNodeName();
            if ("name".equals(nodeName)) {
                name = this.getText(optionNode);
                if (name.equals(nameInFilename)) continue;
                Tools.appWarning("unexpected name: " + name + " != " + nameInFilename);
                return;
            }
            if ("uuid".equals(nodeName)) {
                uuid = this.getText(optionNode);
                continue;
            }
            if ("forward".equals(nodeName)) {
                forwardMode = this.getAttribute(optionNode, "mode");
                continue;
            }
            if ("bridge".equals(nodeName)) {
                bridgeName = this.getAttribute(optionNode, "name");
                bridgeSTP = this.getAttribute(optionNode, "stp");
                bridgeDelay = this.getAttribute(optionNode, "delay");
                bridgeForwardDelay = this.getAttribute(optionNode, "forwardDelay");
                continue;
            }
            if ("mac".equals(nodeName) || "ip".equals(nodeName) || "#text".equals(nodeName)) continue;
            Tools.appWarning("unknown network option: " + nodeName);
        }
        if (name != null) {
            NetworkData networkData = new NetworkData(name, uuid, autostart, forwardMode, bridgeName, bridgeSTP, bridgeDelay, bridgeForwardDelay);
            this.networkMap.put(name, networkData);
        }
    }

    private String parseConfig(Node configNode, String nameInFilename) {
        if (configNode == null) {
            return null;
        }
        Node domainNode = this.getChildNode(configNode, "domain");
        if (domainNode == null) {
            return null;
        }
        String domainType = this.getAttribute(domainNode, VM_PARAM_TYPE);
        NodeList options = domainNode.getChildNodes();
        boolean tabletOk = false;
        String name = null;
        for (int i = 0; i < options.getLength(); ++i) {
            Node option = options.item(i);
            if ("name".equals(option.getNodeName())) {
                name = this.getText(option);
                if (!this.domainNames.contains(name)) {
                    this.domainNames.add(name);
                }
                this.parameterValues.put(name, "name", name);
                this.parameterValues.put(name, VM_PARAM_DOMAIN_TYPE, domainType);
                if (name.equals(nameInFilename)) continue;
                Tools.appWarning("unexpected name: " + name + " != " + nameInFilename);
                return domainType;
            }
            if ("uuid".equals(option.getNodeName())) {
                this.parameterValues.put(name, "uuid", this.getText(option));
                continue;
            }
            if (VM_PARAM_VCPU.equals(option.getNodeName())) {
                this.parameterValues.put(name, VM_PARAM_VCPU, this.getText(option));
                continue;
            }
            if (VM_PARAM_BOOTLOADER.equals(option.getNodeName())) {
                this.parameterValues.put(name, VM_PARAM_BOOTLOADER, this.getText(option));
                continue;
            }
            if (VM_PARAM_CURRENTMEMORY.equals(option.getNodeName())) {
                this.parameterValues.put(name, VM_PARAM_CURRENTMEMORY, Tools.convertKilobytes(this.getText(option)));
                continue;
            }
            if (VM_PARAM_MEMORY.equals(option.getNodeName())) {
                this.parameterValues.put(name, VM_PARAM_MEMORY, Tools.convertKilobytes(this.getText(option)));
                continue;
            }
            if ("os".equals(option.getNodeName())) {
                NodeList osOptions = option.getChildNodes();
                int bootOption = 0;
                for (int j = 0; j < osOptions.getLength(); ++j) {
                    Node osOption = osOptions.item(j);
                    if ("boot".equals(osOption.getNodeName())) {
                        if (bootOption == 0) {
                            this.parameterValues.put(name, "boot", this.getAttribute(osOption, OS_BOOT_NODE_DEV));
                        } else {
                            this.parameterValues.put(name, VM_PARAM_BOOT_2, this.getAttribute(osOption, OS_BOOT_NODE_DEV));
                        }
                        ++bootOption;
                        continue;
                    }
                    if (VM_PARAM_LOADER.equals(osOption.getNodeName())) {
                        this.parameterValues.put(name, VM_PARAM_LOADER, this.getText(osOption));
                        continue;
                    }
                    if (VM_PARAM_TYPE.equals(osOption.getNodeName())) {
                        this.parameterValues.put(name, VM_PARAM_TYPE, this.getText(osOption));
                        this.parameterValues.put(name, VM_PARAM_TYPE_ARCH, this.getAttribute(osOption, VM_PARAM_TYPE_ARCH));
                        this.parameterValues.put(name, VM_PARAM_TYPE_MACHINE, this.getAttribute(osOption, VM_PARAM_TYPE_MACHINE));
                        continue;
                    }
                    if (VM_PARAM_INIT.equals(osOption.getNodeName())) {
                        this.parameterValues.put(name, VM_PARAM_INIT, this.getText(osOption));
                        continue;
                    }
                    this.parameterValues.put(name, osOption.getNodeName(), this.getText(osOption));
                }
                continue;
            }
            if (VM_PARAM_CPUMATCH_FEATURES.equals(option.getNodeName())) {
                NodeList ftrOptions = option.getChildNodes();
                for (int j = 0; j < ftrOptions.getLength(); ++j) {
                    Node ftrOption = ftrOptions.item(j);
                    if (VM_PARAM_ACPI.equals(ftrOption.getNodeName())) {
                        this.parameterValues.put(name, VM_PARAM_ACPI, "True");
                        continue;
                    }
                    if (VM_PARAM_APIC.equals(ftrOption.getNodeName())) {
                        this.parameterValues.put(name, VM_PARAM_APIC, "True");
                        continue;
                    }
                    if (VM_PARAM_PAE.equals(ftrOption.getNodeName())) {
                        this.parameterValues.put(name, VM_PARAM_PAE, "True");
                        continue;
                    }
                    if (!VM_PARAM_HAP.equals(ftrOption.getNodeName())) continue;
                    this.parameterValues.put(name, VM_PARAM_HAP, "True");
                }
                continue;
            }
            if ("clock".equals(option.getNodeName())) {
                String offset = this.getAttribute(option, VM_PARAM_CLOCK_OFFSET);
                this.parameterValues.put(name, VM_PARAM_CLOCK_OFFSET, offset);
                continue;
            }
            if ("cpu".equals(option.getNodeName())) {
                String match = this.getAttribute(option, VM_PARAM_CPU_MATCH);
                if ("".equals(match)) continue;
                this.parameterValues.put(name, VM_PARAM_CPU_MATCH, match);
                NodeList cpuMatchOptions = option.getChildNodes();
                String policy = "";
                ArrayList<String> features = new ArrayList<String>();
                for (int j = 0; j < cpuMatchOptions.getLength(); ++j) {
                    Node cpuMatchOption = cpuMatchOptions.item(j);
                    String op = cpuMatchOption.getNodeName();
                    if ("topology".equals(op)) {
                        this.parameterValues.put(name, VM_PARAM_CPUMATCH_TOPOLOGY_SOCKETS, this.getAttribute(cpuMatchOption, VM_PARAM_CPUMATCH_TOPOLOGY_SOCKETS));
                        this.parameterValues.put(name, VM_PARAM_CPUMATCH_TOPOLOGY_CORES, this.getAttribute(cpuMatchOption, VM_PARAM_CPUMATCH_TOPOLOGY_CORES));
                        this.parameterValues.put(name, VM_PARAM_CPUMATCH_TOPOLOGY_THREADS, this.getAttribute(cpuMatchOption, VM_PARAM_CPUMATCH_TOPOLOGY_THREADS));
                        continue;
                    }
                    if ("feature".equals(op)) {
                        policy = this.getAttribute(cpuMatchOption, VM_PARAM_CPUMATCH_FEATURE_POLICY);
                        features.add(this.getAttribute(cpuMatchOption, "name"));
                        continue;
                    }
                    this.parameterValues.put(name, op, this.getText(cpuMatchOption));
                }
                if ("".equals(policy) || features.isEmpty()) continue;
                this.parameterValues.put(name, VM_PARAM_CPUMATCH_FEATURE_POLICY, policy);
                this.parameterValues.put(name, VM_PARAM_CPUMATCH_FEATURES, Tools.join(" ", features));
                continue;
            }
            if (VM_PARAM_ON_POWEROFF.equals(option.getNodeName())) {
                this.parameterValues.put(name, VM_PARAM_ON_POWEROFF, this.getText(option));
                continue;
            }
            if (VM_PARAM_ON_REBOOT.equals(option.getNodeName())) {
                this.parameterValues.put(name, VM_PARAM_ON_REBOOT, this.getText(option));
                continue;
            }
            if (VM_PARAM_ON_CRASH.equals(option.getNodeName())) {
                this.parameterValues.put(name, VM_PARAM_ON_CRASH, this.getText(option));
                continue;
            }
            if (!"devices".equals(option.getNodeName())) continue;
            LinkedHashMap<String, DiskData> devMap = new LinkedHashMap<String, DiskData>();
            LinkedHashMap<String, FilesystemData> fsMap = new LinkedHashMap<String, FilesystemData>();
            LinkedHashMap<String, InterfaceData> macMap = new LinkedHashMap<String, InterfaceData>();
            LinkedHashMap<String, InputDevData> inputMap = new LinkedHashMap<String, InputDevData>();
            LinkedHashMap<String, GraphicsData> graphicsMap = new LinkedHashMap<String, GraphicsData>();
            LinkedHashMap<String, SoundData> soundMap = new LinkedHashMap<String, SoundData>();
            LinkedHashMap<String, SerialData> serialMap = new LinkedHashMap<String, SerialData>();
            LinkedHashMap<String, ParallelData> parallelMap = new LinkedHashMap<String, ParallelData>();
            LinkedHashMap<String, VideoData> videoMap = new LinkedHashMap<String, VideoData>();
            NodeList devices = option.getChildNodes();
            for (int j = 0; j < devices.getLength(); ++j) {
                String sourceMode;
                String nodeName;
                int k;
                String protocolType;
                String connectSourceHost;
                String connectSourceMode;
                String bindSourceMode;
                NodeList opts;
                String type;
                Node deviceNode = devices.item(j);
                if (VM_PARAM_EMULATOR.equals(deviceNode.getNodeName())) {
                    this.parameterValues.put(name, VM_PARAM_EMULATOR, this.getText(deviceNode));
                    continue;
                }
                if ("input".equals(deviceNode.getNodeName())) {
                    type = this.getAttribute(deviceNode, VM_PARAM_TYPE);
                    String bus = this.getAttribute(deviceNode, "bus");
                    if ("tablet".equals(type)) {
                        tabletOk = true;
                    }
                    InputDevData inputDevData = new InputDevData(type, bus);
                    inputMap.put(type + " : " + bus, inputDevData);
                    continue;
                }
                if ("graphics".equals(deviceNode.getNodeName())) {
                    type = this.getAttribute(deviceNode, VM_PARAM_TYPE);
                    String port = this.getAttribute(deviceNode, "port");
                    String autoport = this.getAttribute(deviceNode, "autoport");
                    String listen = this.getAttribute(deviceNode, "listen");
                    String passwd = this.getAttribute(deviceNode, "passwd");
                    String keymap = this.getAttribute(deviceNode, "keymap");
                    String display = this.getAttribute(deviceNode, "display");
                    String xauth = this.getAttribute(deviceNode, "xauth");
                    Tools.debug(this, "type: " + type, 2);
                    Tools.debug(this, "port: " + port, 2);
                    Tools.debug(this, "autoport: " + autoport, 2);
                    if ("vnc".equals(type)) {
                        if (port != null && Tools.isNumber(port)) {
                            this.remotePorts.put(name, Integer.parseInt(port));
                        }
                        if ("yes".equals(autoport)) {
                            this.autoports.put(name, true);
                        } else {
                            this.autoports.put(name, false);
                        }
                    }
                    GraphicsData graphicsData = new GraphicsData(type, port, listen, passwd, keymap, display, xauth);
                    graphicsMap.put(VMSXML.graphicsDisplayName(type, port, display), graphicsData);
                    continue;
                }
                if ("disk".equals(deviceNode.getNodeName())) {
                    type = this.getAttribute(deviceNode, VM_PARAM_TYPE);
                    String device = this.getAttribute(deviceNode, "device");
                    NodeList opts2 = deviceNode.getChildNodes();
                    String sourceFile = null;
                    String sourceDev = null;
                    String targetDev = null;
                    String targetBus = null;
                    String driverName = null;
                    String driverType = null;
                    String driverCache = null;
                    boolean readonly = false;
                    boolean shareable = false;
                    for (int k2 = 0; k2 < opts2.getLength(); ++k2) {
                        Node optionNode = opts2.item(k2);
                        String nodeName2 = optionNode.getNodeName();
                        if ("source".equals(nodeName2)) {
                            sourceFile = this.getAttribute(optionNode, "file");
                            String dir = Tools.getDirectoryPart(sourceFile);
                            if (dir != null) {
                                this.sourceFileDirs.add(dir);
                            }
                            sourceDev = this.getAttribute(optionNode, OS_BOOT_NODE_DEV);
                            continue;
                        }
                        if ("target".equals(nodeName2)) {
                            targetDev = this.getAttribute(optionNode, OS_BOOT_NODE_DEV);
                            targetBus = this.getAttribute(optionNode, "bus");
                            continue;
                        }
                        if ("driver".equals(nodeName2)) {
                            driverName = this.getAttribute(optionNode, "name");
                            driverType = this.getAttribute(optionNode, VM_PARAM_TYPE);
                            driverCache = this.getAttribute(optionNode, "cache");
                            continue;
                        }
                        if ("readonly".equals(nodeName2)) {
                            readonly = true;
                            continue;
                        }
                        if ("shareable".equals(nodeName2)) {
                            shareable = true;
                            continue;
                        }
                        if (HW_ADDRESS.equals(nodeName2) || "#text".equals(nodeName2)) continue;
                        Tools.appWarning("unknown disk option: " + nodeName2);
                    }
                    if (targetDev == null) continue;
                    DiskData diskData = new DiskData(type, targetDev, sourceFile, sourceDev, targetBus + "/" + device, driverName, driverType, driverCache, readonly, shareable);
                    devMap.put(targetDev, diskData);
                    continue;
                }
                if ("filesystem".equals(deviceNode.getNodeName())) {
                    type = this.getAttribute(deviceNode, VM_PARAM_TYPE);
                    opts = deviceNode.getChildNodes();
                    String sourceDir = null;
                    String sourceName = null;
                    String targetDir = null;
                    for (int k3 = 0; k3 < opts.getLength(); ++k3) {
                        Node optionNode = opts.item(k3);
                        String nodeName3 = optionNode.getNodeName();
                        if ("source".equals(nodeName3)) {
                            sourceDir = this.getAttribute(optionNode, "dir");
                            sourceName = this.getAttribute(optionNode, "name");
                            continue;
                        }
                        if ("target".equals(nodeName3)) {
                            targetDir = this.getAttribute(optionNode, "dir");
                            continue;
                        }
                        if ("#text".equals(nodeName3)) continue;
                        Tools.appWarning("unknown fs option: " + nodeName3);
                    }
                    if (targetDir == null) continue;
                    FilesystemData filesystemData = new FilesystemData(type, sourceDir, sourceName, targetDir);
                    fsMap.put(targetDir, filesystemData);
                    continue;
                }
                if ("interface".equals(deviceNode.getNodeName())) {
                    type = this.getAttribute(deviceNode, VM_PARAM_TYPE);
                    String macAddress = null;
                    String sourceNetwork = null;
                    String sourceBridge = null;
                    String targetDev = null;
                    String modelType = null;
                    String scriptPath = null;
                    NodeList opts3 = deviceNode.getChildNodes();
                    for (int k4 = 0; k4 < opts3.getLength(); ++k4) {
                        Node optionNode = opts3.item(k4);
                        String nodeName4 = optionNode.getNodeName();
                        if ("source".equals(nodeName4)) {
                            sourceBridge = this.getAttribute(optionNode, "bridge");
                            sourceNetwork = this.getAttribute(optionNode, "network");
                            continue;
                        }
                        if ("target".equals(nodeName4)) {
                            targetDev = this.getAttribute(optionNode, OS_BOOT_NODE_DEV);
                            continue;
                        }
                        if ("mac".equals(nodeName4)) {
                            macAddress = this.getAttribute(optionNode, HW_ADDRESS);
                            continue;
                        }
                        if (VM_PARAM_CPUMATCH_MODEL.equals(nodeName4)) {
                            modelType = this.getAttribute(optionNode, VM_PARAM_TYPE);
                            continue;
                        }
                        if ("script".equals(nodeName4)) {
                            scriptPath = this.getAttribute(optionNode, "path");
                            continue;
                        }
                        if (HW_ADDRESS.equals(nodeName4) || "#text".equals(nodeName4)) continue;
                        Tools.appWarning("unknown interface option: " + nodeName4);
                    }
                    if (macAddress == null) continue;
                    InterfaceData interfaceData = new InterfaceData(type, macAddress, sourceNetwork, sourceBridge, targetDev, modelType, scriptPath);
                    macMap.put(macAddress, interfaceData);
                    continue;
                }
                if ("sound".equals(deviceNode.getNodeName())) {
                    String model = this.getAttribute(deviceNode, VM_PARAM_CPUMATCH_MODEL);
                    opts = deviceNode.getChildNodes();
                    for (int k5 = 0; k5 < opts.getLength(); ++k5) {
                        Node optionNode = opts.item(k5);
                        String nodeName5 = optionNode.getNodeName();
                        if (HW_ADDRESS.equals(nodeName5) || "#text".equals(nodeName5)) continue;
                        Tools.appWarning("unknown sound option: " + nodeName5);
                    }
                    if (model == null) continue;
                    SoundData soundData = new SoundData(model);
                    soundMap.put(model, soundData);
                    continue;
                }
                if ("serial".equals(deviceNode.getNodeName())) {
                    type = this.getAttribute(deviceNode, VM_PARAM_TYPE);
                    opts = deviceNode.getChildNodes();
                    String sourcePath = null;
                    bindSourceMode = null;
                    String bindSourceHost = null;
                    String bindSourceService = null;
                    connectSourceMode = null;
                    connectSourceHost = null;
                    String connectSourceService = null;
                    protocolType = null;
                    String targetPort = null;
                    for (k = 0; k < opts.getLength(); ++k) {
                        Node optionNode = opts.item(k);
                        nodeName = optionNode.getNodeName();
                        if ("source".equals(nodeName)) {
                            sourcePath = this.getAttribute(optionNode, "path");
                            sourceMode = this.getAttribute(optionNode, "mode");
                            if ("bind".equals(sourceMode)) {
                                bindSourceMode = sourceMode;
                                bindSourceHost = this.getAttribute(optionNode, "host");
                                bindSourceService = this.getAttribute(optionNode, "service");
                                continue;
                            }
                            if ("connect".equals(sourceMode)) {
                                connectSourceMode = sourceMode;
                                connectSourceHost = this.getAttribute(optionNode, "host");
                                connectSourceService = this.getAttribute(optionNode, "service");
                                continue;
                            }
                            Tools.appWarning("uknown source mode: " + sourceMode);
                            continue;
                        }
                        if ("protocol".equals(nodeName)) {
                            protocolType = this.getAttribute(optionNode, VM_PARAM_TYPE);
                            continue;
                        }
                        if ("target".equals(nodeName)) {
                            targetPort = this.getAttribute(optionNode, "port");
                            continue;
                        }
                        if (HW_ADDRESS.equals(nodeName) || "#text".equals(nodeName)) continue;
                        Tools.appWarning("unknown serial option: " + nodeName);
                    }
                    if (type == null) continue;
                    SerialData serialData = new SerialData(type, sourcePath, bindSourceMode, bindSourceHost, bindSourceService, connectSourceMode, connectSourceHost, connectSourceService, protocolType, targetPort);
                    serialMap.put("serial " + targetPort + " / " + type, serialData);
                    continue;
                }
                if ("parallel".equals(deviceNode.getNodeName())) {
                    type = this.getAttribute(deviceNode, VM_PARAM_TYPE);
                    opts = deviceNode.getChildNodes();
                    String sourcePath = null;
                    bindSourceMode = null;
                    String bindSourceHost = null;
                    String bindSourceService = null;
                    connectSourceMode = null;
                    connectSourceHost = null;
                    String connectSourceService = null;
                    protocolType = null;
                    String targetPort = null;
                    for (k = 0; k < opts.getLength(); ++k) {
                        Node optionNode = opts.item(k);
                        nodeName = optionNode.getNodeName();
                        if ("source".equals(nodeName)) {
                            sourcePath = this.getAttribute(optionNode, "path");
                            sourceMode = this.getAttribute(optionNode, "mode");
                            if ("bind".equals(sourceMode)) {
                                bindSourceMode = sourceMode;
                                bindSourceHost = this.getAttribute(optionNode, "host");
                                bindSourceService = this.getAttribute(optionNode, "service");
                                continue;
                            }
                            if ("connect".equals(sourceMode)) {
                                connectSourceMode = sourceMode;
                                connectSourceHost = this.getAttribute(optionNode, "host");
                                connectSourceService = this.getAttribute(optionNode, "service");
                                continue;
                            }
                            Tools.appWarning("uknown source mode: " + sourceMode);
                            continue;
                        }
                        if ("protocol".equals(nodeName)) {
                            protocolType = this.getAttribute(optionNode, VM_PARAM_TYPE);
                            continue;
                        }
                        if ("target".equals(nodeName)) {
                            targetPort = this.getAttribute(optionNode, "port");
                            continue;
                        }
                        if (HW_ADDRESS.equals(nodeName) || "#text".equals(nodeName)) continue;
                        Tools.appWarning("unknown parallel option: " + nodeName);
                    }
                    if (type == null) continue;
                    ParallelData parallelData = new ParallelData(type, sourcePath, bindSourceMode, bindSourceHost, bindSourceService, connectSourceMode, connectSourceHost, connectSourceService, protocolType, targetPort);
                    parallelMap.put("parallel " + targetPort + " / " + type, parallelData);
                    continue;
                }
                if ("video".equals(deviceNode.getNodeName())) {
                    NodeList opts4 = deviceNode.getChildNodes();
                    String modelType = null;
                    String modelVRAM = null;
                    String modelHeads = null;
                    for (int k6 = 0; k6 < opts4.getLength(); ++k6) {
                        Node optionNode = opts4.item(k6);
                        String nodeName6 = optionNode.getNodeName();
                        if (VM_PARAM_CPUMATCH_MODEL.equals(nodeName6)) {
                            modelType = this.getAttribute(optionNode, VM_PARAM_TYPE);
                            modelVRAM = this.getAttribute(optionNode, "vram");
                            modelHeads = this.getAttribute(optionNode, "heads");
                            continue;
                        }
                        if (HW_ADDRESS.equals(nodeName6) || "#text".equals(nodeName6)) continue;
                        Tools.appWarning("unknown video option: " + nodeName6);
                    }
                    if (modelType == null) continue;
                    VideoData videoData = new VideoData(modelType, modelVRAM, modelHeads);
                    videoMap.put(modelType, videoData);
                    continue;
                }
                if ("controller".equals(deviceNode.getNodeName()) || "memballoon".equals(deviceNode.getNodeName()) || "#text".equals(deviceNode.getNodeName())) continue;
                Tools.appWarning("unknown device: " + deviceNode.getNodeName());
            }
            this.disksMap.put(name, devMap);
            this.filesystemsMap.put(name, fsMap);
            this.interfacesMap.put(name, macMap);
            this.inputDevsMap.put(name, inputMap);
            this.graphicsDevsMap.put(name, graphicsMap);
            this.soundsMap.put(name, soundMap);
            this.serialsMap.put(name, serialMap);
            this.parallelsMap.put(name, parallelMap);
            this.videosMap.put(name, videoMap);
        }
        if (!tabletOk) {
            Tools.appWarning("you should enable input type tablet for " + name);
        }
        return domainType;
    }

    private void updateVM(Node vmNode) {
        String vncdisplay;
        Matcher m;
        if (vmNode == null) {
            return;
        }
        Node infoNode = this.getChildNode(vmNode, "info");
        String domainName = this.getAttribute(vmNode, "name");
        String autostart = this.getAttribute(vmNode, "autostart");
        String virshOptions = this.getAttribute(vmNode, VM_PARAM_VIRSH_OPTIONS);
        this.parameterValues.put(domainName, VM_PARAM_VIRSH_OPTIONS, virshOptions);
        if (autostart != null && "True".equals(autostart)) {
            this.parameterValues.put(domainName, "autostart", this.host.getName());
        } else {
            this.parameterValues.put(domainName, "autostart", null);
        }
        if (infoNode != null) {
            this.parseInfo(domainName, this.getText(infoNode));
        }
        Node vncdisplayNode = this.getChildNode(vmNode, "vncdisplay");
        this.remotePorts.put(domainName, -1);
        if (vncdisplayNode != null && (m = DISPLAY_PATTERN.matcher(vncdisplay = this.getText(vncdisplayNode).trim())).matches()) {
            this.remotePorts.put(domainName, Integer.parseInt(m.group(1)) + 5900);
        }
        Node configNode = this.getChildNode(vmNode, "config");
        String type = this.parseConfig(configNode, domainName);
        String configName = this.getConfigName(type, domainName);
        this.configsMap.put(configName, domainName);
        this.namesConfigsMap.put(domainName, configName);
    }

    void parseInfo(String name, String info) {
        if (info != null) {
            boolean running = false;
            boolean suspended = false;
            for (String line : info.split("\n")) {
                String[] optionValue = line.split(":");
                if (optionValue.length != 2) continue;
                String option = optionValue[0].trim();
                String value = optionValue[1].trim();
                if (!"State".equals(option)) continue;
                if ("running".equals(value) || "idle".equals(value)) {
                    running = true;
                    suspended = false;
                    continue;
                }
                if (!"paused".equals(value)) continue;
                running = true;
                suspended = true;
            }
            this.runningMap.put(name, running);
            this.suspendedMap.put(name, suspended);
        }
    }

    public List<String> getDomainNames() {
        return this.domainNames;
    }

    public boolean isRunning(String name) {
        Boolean r = this.runningMap.get(name);
        if (r != null) {
            return r;
        }
        return false;
    }

    public boolean isSuspended(String name) {
        Boolean s = this.suspendedMap.get(name);
        if (s != null) {
            return s;
        }
        return false;
    }

    public int getRemotePort(String name) {
        return this.remotePorts.get(name);
    }

    public Host getHost() {
        return this.host;
    }

    public Set<String> getConfigs() {
        return this.configsMap.keySet();
    }

    public String getNameFromConfig(String config) {
        return this.configsMap.get(config);
    }

    public String getValue(String name, String param) {
        return this.parameterValues.get((K[])new String[]{name, param});
    }

    public Map<String, DiskData> getDisks(String name) {
        return this.disksMap.get(name);
    }

    public Map<String, FilesystemData> getFilesystems(String name) {
        return this.filesystemsMap.get(name);
    }

    public Map<String, InterfaceData> getInterfaces(String name) {
        return this.interfacesMap.get(name);
    }

    public List<String> getNetworks() {
        return new ArrayList<String>(this.networkMap.keySet());
    }

    public Map<String, InputDevData> getInputDevs(String name) {
        return this.inputDevsMap.get(name);
    }

    public Map<String, GraphicsData> getGraphicDisplays(String name) {
        return this.graphicsDevsMap.get(name);
    }

    public Map<String, SoundData> getSounds(String name) {
        return this.soundsMap.get(name);
    }

    public Map<String, SerialData> getSerials(String name) {
        return this.serialsMap.get(name);
    }

    public Map<String, ParallelData> getParallels(String name) {
        return this.parallelsMap.get(name);
    }

    public Map<String, VideoData> getVideos(String name) {
        return this.videosMap.get(name);
    }

    protected VirtualHardwareComparator getDiskDataComparator() {
        return new VirtualHardwareComparator(){

            @Override
            public Element getElement(NodeList nodes, Map<String, String> parameters) {
                Element el = null;
                String targetDev = parameters.get("saved_target_device");
                if (targetDev != null) {
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node mn = VMSXML.this.getChildNode(nodes.item(i), "target");
                        if (!targetDev.equals(VMSXML.this.getAttribute(mn, VMSXML.OS_BOOT_NODE_DEV))) continue;
                        el = (Element)nodes.item(i);
                    }
                }
                return el;
            }
        };
    }

    protected VirtualHardwareComparator getFilesystemDataComparator() {
        return new VirtualHardwareComparator(){

            @Override
            public Element getElement(NodeList nodes, Map<String, String> parameters) {
                Element el = null;
                String targetDev = parameters.get("saved_target_dir");
                if (targetDev != null) {
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node mn = VMSXML.this.getChildNode(nodes.item(i), "target");
                        if (!targetDev.equals(VMSXML.this.getAttribute(mn, "dir"))) continue;
                        el = (Element)nodes.item(i);
                    }
                }
                return el;
            }
        };
    }

    protected VirtualHardwareComparator getInterfaceDataComparator() {
        return new VirtualHardwareComparator(){

            @Override
            public Element getElement(NodeList nodes, Map<String, String> parameters) {
                String macAddress = parameters.get("saved_mac_address");
                Element el = null;
                if (macAddress != null) {
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node mn = VMSXML.this.getChildNode(nodes.item(i), "mac");
                        if (!macAddress.equals(VMSXML.this.getAttribute(mn, VMSXML.HW_ADDRESS))) continue;
                        el = (Element)nodes.item(i);
                        break;
                    }
                }
                return el;
            }
        };
    }

    protected VirtualHardwareComparator getInputDevDataComparator() {
        return new VirtualHardwareComparator(){

            @Override
            public Element getElement(NodeList nodes, Map<String, String> parameters) {
                String type = parameters.get("saved_type");
                String bus = parameters.get("saved_bus");
                Element el = null;
                if (type != null && bus != null) {
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node mn = nodes.item(i);
                        if (!type.equals(VMSXML.this.getAttribute(mn, VMSXML.VM_PARAM_TYPE)) || !bus.equals(VMSXML.this.getAttribute(mn, "bus"))) continue;
                        el = (Element)nodes.item(i);
                        break;
                    }
                }
                return el;
            }
        };
    }

    protected VirtualHardwareComparator getGraphicsDataComparator() {
        return new VirtualHardwareComparator(){

            @Override
            public Element getElement(NodeList nodes, Map<String, String> parameters) {
                String type = parameters.get("saved_type");
                Element el = null;
                if (type != null) {
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node mn = nodes.item(i);
                        if (!type.equals(VMSXML.this.getAttribute(mn, VMSXML.VM_PARAM_TYPE))) continue;
                        el = (Element)nodes.item(i);
                        break;
                    }
                }
                return el;
            }
        };
    }

    protected VirtualHardwareComparator getSoundDataComparator() {
        return new VirtualHardwareComparator(){

            @Override
            public Element getElement(NodeList nodes, Map<String, String> parameters) {
                String model = parameters.get("saved_model");
                Element el = null;
                if (model != null) {
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node mn = nodes.item(i);
                        if (!model.equals(VMSXML.this.getAttribute(mn, VMSXML.VM_PARAM_CPUMATCH_MODEL))) continue;
                        el = (Element)nodes.item(i);
                        break;
                    }
                }
                return el;
            }
        };
    }

    protected VirtualHardwareComparator getSerialDataComparator() {
        return new VirtualHardwareComparator(){

            @Override
            public Element getElement(NodeList nodes, Map<String, String> parameters) {
                String type = parameters.get("saved_type");
                Element el = null;
                if (type != null) {
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node mn = nodes.item(i);
                        if (!type.equals(VMSXML.this.getAttribute(mn, VMSXML.VM_PARAM_TYPE))) continue;
                        el = (Element)nodes.item(i);
                        break;
                    }
                }
                return el;
            }
        };
    }

    protected VirtualHardwareComparator getParallelDataComparator() {
        return new VirtualHardwareComparator(){

            @Override
            public Element getElement(NodeList nodes, Map<String, String> parameters) {
                String type = parameters.get("saved_type");
                Element el = null;
                if (type != null) {
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node mn = nodes.item(i);
                        if (!type.equals(VMSXML.this.getAttribute(mn, VMSXML.VM_PARAM_TYPE))) continue;
                        el = (Element)nodes.item(i);
                        break;
                    }
                }
                return el;
            }
        };
    }

    protected VirtualHardwareComparator getVideoDataComparator() {
        return new VirtualHardwareComparator(){

            @Override
            public Element getElement(NodeList nodes, Map<String, String> parameters) {
                Element el = null;
                String modelType = parameters.get("saved_model_type");
                if (modelType != null) {
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node mn = VMSXML.this.getChildNode(nodes.item(i), VMSXML.VM_PARAM_CPUMATCH_MODEL);
                        if (!modelType.equals(VMSXML.this.getAttribute(mn, VMSXML.VM_PARAM_TYPE))) continue;
                        el = (Element)nodes.item(i);
                    }
                }
                return el;
            }
        };
    }

    static String portString(String port) {
        if ("-1".equals(port)) {
            return "auto";
        }
        return port;
    }

    public static String graphicsDisplayName(String type, String port, String display) {
        if ("vnc".equals(type)) {
            return type + " : " + VMSXML.portString(port);
        }
        if ("sdl".equals(type)) {
            return type + " (" + display + ")";
        }
        return "unknown";
    }

    public Set<String> getsourceFileDirs() {
        return this.sourceFileDirs;
    }

    static {
        INTERFACE_ATTRIBUTE_MAP.put(VM_PARAM_TYPE, VM_PARAM_TYPE);
        INTERFACE_TAG_MAP.put("mac_address", "mac");
        INTERFACE_ATTRIBUTE_MAP.put("mac_address", HW_ADDRESS);
        INTERFACE_TAG_MAP.put("source_network", "source");
        INTERFACE_ATTRIBUTE_MAP.put("source_network", "network");
        INTERFACE_TAG_MAP.put("source_bridge", "source");
        INTERFACE_ATTRIBUTE_MAP.put("source_bridge", "bridge");
        INTERFACE_TAG_MAP.put("target_dev", "target");
        INTERFACE_ATTRIBUTE_MAP.put("target_dev", OS_BOOT_NODE_DEV);
        INTERFACE_TAG_MAP.put("model_type", VM_PARAM_CPUMATCH_MODEL);
        INTERFACE_ATTRIBUTE_MAP.put("model_type", VM_PARAM_TYPE);
        INTERFACE_TAG_MAP.put("script_path", "script");
        INTERFACE_ATTRIBUTE_MAP.put("script_path", "path");
        DISK_ATTRIBUTE_MAP.put(VM_PARAM_TYPE, VM_PARAM_TYPE);
        DISK_TAG_MAP.put("target_device", "target");
        DISK_ATTRIBUTE_MAP.put("target_device", OS_BOOT_NODE_DEV);
        DISK_TAG_MAP.put("source_file", "source");
        DISK_ATTRIBUTE_MAP.put("source_file", "file");
        DISK_TAG_MAP.put("source_dev", "source");
        DISK_ATTRIBUTE_MAP.put("source_dev", OS_BOOT_NODE_DEV);
        DISK_TAG_MAP.put("target_bus", "target");
        DISK_ATTRIBUTE_MAP.put("target_bus", "bus");
        DISK_TAG_MAP.put("driver_name", "driver");
        DISK_ATTRIBUTE_MAP.put("driver_name", "name");
        DISK_TAG_MAP.put("driver_type", "driver");
        DISK_ATTRIBUTE_MAP.put("driver_type", VM_PARAM_TYPE);
        DISK_TAG_MAP.put("driver_cache", "driver");
        DISK_ATTRIBUTE_MAP.put("driver_cache", "cache");
        DISK_ATTRIBUTE_MAP.put("target_type", "device");
        DISK_TAG_MAP.put("readonly", "readonly");
        DISK_TAG_MAP.put("shareable", "shareable");
        FILESYSTEM_ATTRIBUTE_MAP.put(VM_PARAM_TYPE, VM_PARAM_TYPE);
        FILESYSTEM_TAG_MAP.put("source_dir", "source");
        FILESYSTEM_ATTRIBUTE_MAP.put("source_dir", "dir");
        FILESYSTEM_TAG_MAP.put("source_name", "source");
        FILESYSTEM_ATTRIBUTE_MAP.put("source_name", "name");
        FILESYSTEM_TAG_MAP.put("target_dir", "target");
        FILESYSTEM_ATTRIBUTE_MAP.put("target_dir", "dir");
        INPUTDEV_ATTRIBUTE_MAP.put(VM_PARAM_TYPE, VM_PARAM_TYPE);
        INPUTDEV_ATTRIBUTE_MAP.put("bus", "bus");
        GRAPHICS_ATTRIBUTE_MAP.put(VM_PARAM_TYPE, VM_PARAM_TYPE);
        GRAPHICS_ATTRIBUTE_MAP.put("port", "port");
        GRAPHICS_ATTRIBUTE_MAP.put("autoport", "autoport");
        GRAPHICS_ATTRIBUTE_MAP.put("listen", "listen");
        GRAPHICS_ATTRIBUTE_MAP.put("passwd", "passwd");
        GRAPHICS_ATTRIBUTE_MAP.put("keymap", "keymap");
        GRAPHICS_ATTRIBUTE_MAP.put("display", "display");
        GRAPHICS_ATTRIBUTE_MAP.put("xauth", "xauth");
        SOUND_ATTRIBUTE_MAP.put(VM_PARAM_CPUMATCH_MODEL, VM_PARAM_CPUMATCH_MODEL);
        SERIAL_ATTRIBUTE_MAP.put(VM_PARAM_TYPE, VM_PARAM_TYPE);
        SERIAL_TAG_MAP.put("source_path", "source");
        SERIAL_ATTRIBUTE_MAP.put("source_path", "path");
        SERIAL_TAG_MAP.put("bind_source_mode", "source");
        SERIAL_ATTRIBUTE_MAP.put("bind_source_mode", "mode");
        SERIAL_TAG_MAP.put("bind_source_host", "source");
        SERIAL_ATTRIBUTE_MAP.put("bind_source_host", "host");
        SERIAL_TAG_MAP.put("bind_source_service", "source");
        SERIAL_ATTRIBUTE_MAP.put("bind_source_service", "service");
        SERIAL_TAG_MAP.put("bind_source_mode", "source");
        SERIAL_ATTRIBUTE_MAP.put("bind_source_mode", "mode");
        SERIAL_TAG_MAP.put("connect_source_host", "source");
        SERIAL_ATTRIBUTE_MAP.put("connect_source_host", "host");
        SERIAL_TAG_MAP.put("connect_source_service", "source");
        SERIAL_ATTRIBUTE_MAP.put("connect_source_service", "service");
        SERIAL_TAG_MAP.put("protocol_type", "protocol");
        SERIAL_ATTRIBUTE_MAP.put("protocol_type", VM_PARAM_TYPE);
        SERIAL_TAG_MAP.put("target_port", "target");
        SERIAL_ATTRIBUTE_MAP.put("target_port", "port");
        PARALLEL_ATTRIBUTE_MAP.put(VM_PARAM_TYPE, VM_PARAM_TYPE);
        PARALLEL_TAG_MAP.put("source_path", "source");
        PARALLEL_ATTRIBUTE_MAP.put("source_path", "path");
        PARALLEL_TAG_MAP.put("bind_source_mode", "source");
        PARALLEL_ATTRIBUTE_MAP.put("bind_source_mode", "mode");
        PARALLEL_TAG_MAP.put("bind_source_host", "source");
        PARALLEL_ATTRIBUTE_MAP.put("bind_source_host", "host");
        PARALLEL_TAG_MAP.put("bind_source_service", "source");
        PARALLEL_ATTRIBUTE_MAP.put("bind_source_service", "service");
        PARALLEL_TAG_MAP.put("bind_source_mode", "source");
        PARALLEL_ATTRIBUTE_MAP.put("bind_source_mode", "mode");
        PARALLEL_TAG_MAP.put("connect_source_host", "source");
        PARALLEL_ATTRIBUTE_MAP.put("connect_source_host", "host");
        PARALLEL_TAG_MAP.put("connect_source_service", "source");
        PARALLEL_ATTRIBUTE_MAP.put("connect_source_service", "service");
        PARALLEL_TAG_MAP.put("protocol_type", "protocol");
        PARALLEL_ATTRIBUTE_MAP.put("protocol_type", VM_PARAM_TYPE);
        PARALLEL_TAG_MAP.put("target_port", "target");
        PARALLEL_ATTRIBUTE_MAP.put("target_port", "port");
        VIDEO_TAG_MAP.put("model_type", VM_PARAM_CPUMATCH_MODEL);
        VIDEO_ATTRIBUTE_MAP.put("model_type", VM_PARAM_TYPE);
        VIDEO_TAG_MAP.put("model_vram", VM_PARAM_CPUMATCH_MODEL);
        VIDEO_ATTRIBUTE_MAP.put("model_vram", "vram");
        VIDEO_TAG_MAP.put("model_heads", VM_PARAM_CPUMATCH_MODEL);
        VIDEO_ATTRIBUTE_MAP.put("model_heads", "heads");
    }

    private static interface VirtualHardwareComparator {
        public Element getElement(NodeList var1, Map<String, String> var2);
    }

    public static final class VideoData
    extends HardwareData {
        private final String modelType;
        public static final String MODEL_TYPE = "model_type";
        public static final String SAVED_MODEL_TYPE = "saved_model_type";
        public static final String MODEL_VRAM = "model_vram";
        public static final String MODEL_HEADS = "model_heads";

        public VideoData(String modelType, String modelVRAM, String modelHeads) {
            this.modelType = modelType;
            this.setValue(MODEL_TYPE, modelType);
            this.setValue(MODEL_VRAM, modelVRAM);
            this.setValue(MODEL_HEADS, modelHeads);
        }

        public String getModelType() {
            return this.modelType;
        }
    }

    public static final class ParallelData
    extends ParallelSerialData {
        public ParallelData(String type, String sourcePath, String bindSourceMode, String bindSourceHost, String bindSourceService, String connectSourceMode, String connectSourceHost, String connectSourceService, String protocolType, String targetPort) {
            super(type, sourcePath, bindSourceMode, bindSourceHost, bindSourceService, connectSourceMode, connectSourceHost, connectSourceService, protocolType, targetPort);
        }
    }

    public static final class SerialData
    extends ParallelSerialData {
        public SerialData(String type, String sourcePath, String bindSourceMode, String bindSourceHost, String bindSourceService, String connectSourceMode, String connectSourceHost, String connectSourceService, String protocolType, String targetPort) {
            super(type, sourcePath, bindSourceMode, bindSourceHost, bindSourceService, connectSourceMode, connectSourceHost, connectSourceService, protocolType, targetPort);
        }
    }

    public static abstract class ParallelSerialData
    extends HardwareData {
        private final String type;
        public static final String TYPE = "type";
        public static final String SAVED_TYPE = "saved_type";
        public static final String SOURCE_PATH = "source_path";
        public static final String SOURCE_MODE = "source_mode";
        public static final String BIND_SOURCE_MODE = "bind_source_mode";
        public static final String BIND_SOURCE_HOST = "bind_source_host";
        public static final String BIND_SOURCE_SERVICE = "bind_source_service";
        public static final String CONNECT_SOURCE_MODE = "bind_source_mode";
        public static final String CONNECT_SOURCE_HOST = "connect_source_host";
        public static final String CONNECT_SOURCE_SERVICE = "connect_source_service";
        public static final String PROTOCOL_TYPE = "protocol_type";
        public static final String TARGET_PORT = "target_port";

        public ParallelSerialData(String type, String sourcePath, String bindSourceMode, String bindSourceHost, String bindSourceService, String connectSourceMode, String connectSourceHost, String connectSourceService, String protocolType, String targetPort) {
            this.type = type;
            this.setValue("type", type);
            this.setValue(SOURCE_PATH, sourcePath);
            this.setValue("bind_source_mode", bindSourceMode);
            this.setValue(BIND_SOURCE_HOST, bindSourceHost);
            this.setValue(BIND_SOURCE_SERVICE, bindSourceService);
            this.setValue("bind_source_mode", connectSourceMode);
            this.setValue(CONNECT_SOURCE_HOST, connectSourceHost);
            this.setValue(CONNECT_SOURCE_SERVICE, connectSourceService);
            this.setValue(PROTOCOL_TYPE, protocolType);
            this.setValue(TARGET_PORT, targetPort);
        }

        public final String getType() {
            return this.type;
        }
    }

    public static final class SoundData
    extends HardwareData {
        private final String model;
        public static final String MODEL = "model";
        public static final String SAVED_MODEL = "saved_model";

        public SoundData(String model) {
            this.model = model;
            this.setValue("model", model);
        }

        public String getModel() {
            return this.model;
        }
    }

    public static final class GraphicsData
    extends HardwareData {
        private final String type;
        public static final String TYPE = "type";
        public static final String SAVED_TYPE = "saved_type";
        public static final String AUTOPORT = "autoport";
        public static final String PORT = "port";
        public static final String LISTEN = "listen";
        public static final String PASSWD = "passwd";
        public static final String KEYMAP = "keymap";
        public static final String DISPLAY = "display";
        public static final String XAUTH = "xauth";

        public GraphicsData(String type, String port, String listen, String passwd, String keymap, String display, String xauth) {
            this.type = type;
            this.setValue("type", type);
            this.setValue(PORT, port);
            this.setValue(LISTEN, listen);
            this.setValue(PASSWD, passwd);
            this.setValue(KEYMAP, keymap);
            this.setValue(DISPLAY, display);
            this.setValue(XAUTH, xauth);
        }

        public String getType() {
            return this.type;
        }
    }

    public static final class InputDevData
    extends HardwareData {
        private final String type;
        private final String bus;
        public static final String TYPE = "type";
        public static final String BUS = "bus";
        public static final String SAVED_TYPE = "saved_type";
        public static final String SAVED_BUS = "saved_bus";

        public InputDevData(String type, String bus) {
            this.type = type;
            this.setValue("type", type);
            this.bus = bus;
            this.setValue(BUS, bus);
        }

        public String getType() {
            return this.type;
        }

        public String getBus() {
            return this.bus;
        }
    }

    public static final class InterfaceData
    extends HardwareData {
        private final String type;
        private final String sourceNetwork;
        private final String sourceBridge;
        private final String targetDev;
        public static final String TYPE = "type";
        public static final String MAC_ADDRESS = "mac_address";
        public static final String SAVED_MAC_ADDRESS = "saved_mac_address";
        public static final String SOURCE_NETWORK = "source_network";
        public static final String SOURCE_BRIDGE = "source_bridge";
        public static final String SCRIPT_PATH = "script_path";
        public static final String TARGET_DEV = "target_dev";
        public static final String MODEL_TYPE = "model_type";

        public InterfaceData(String type, String macAddress, String sourceNetwork, String sourceBridge, String targetDev, String modelType, String scriptPath) {
            this.type = type;
            this.setValue("type", type);
            this.setValue(MAC_ADDRESS, macAddress);
            this.sourceNetwork = sourceNetwork;
            this.setValue(SOURCE_NETWORK, sourceNetwork);
            this.sourceBridge = sourceBridge;
            this.setValue(SOURCE_BRIDGE, sourceBridge);
            this.targetDev = targetDev;
            this.setValue(TARGET_DEV, targetDev);
            this.setValue(MODEL_TYPE, modelType);
            this.setValue(SCRIPT_PATH, scriptPath);
        }

        public String getType() {
            return this.type;
        }

        public String getSourceNetwork() {
            return this.sourceNetwork;
        }

        public String getSourceBridge() {
            return this.sourceBridge;
        }

        public String getTargetDev() {
            return this.targetDev;
        }
    }

    private static abstract class HardwareData {
        private final Map<String, String> valueMap = new HashMap<String, String>();

        private HardwareData() {
        }

        final void setValue(String param, String value) {
            this.valueMap.put(param, value);
        }

        public final String getValue(String param) {
            return this.valueMap.get(param);
        }
    }

    public static final class FilesystemData
    extends HardwareData {
        private final String type;
        private final String sourceDir;
        private final String sourceName;
        private final String targetDir;
        public static final String TYPE = "type";
        public static final String SOURCE_DIR = "source_dir";
        public static final String SOURCE_NAME = "source_name";
        public static final String TARGET_DIR = "target_dir";
        public static final String SAVED_TARGET_DIR = "saved_target_dir";

        public FilesystemData(String type, String sourceDir, String sourceName, String targetDir) {
            this.type = type;
            this.setValue("type", type);
            this.sourceDir = sourceDir;
            this.setValue(SOURCE_DIR, sourceDir);
            this.sourceName = sourceName;
            this.setValue(SOURCE_NAME, sourceName);
            this.targetDir = targetDir;
            this.setValue(TARGET_DIR, targetDir);
        }

        public String getType() {
            return this.type;
        }

        public String getSourceDir() {
            return this.sourceDir;
        }

        public String getSourceName() {
            return this.sourceName;
        }

        public String getTargetDir() {
            return this.targetDir;
        }
    }

    public static final class DiskData
    extends HardwareData {
        private final String type;
        private final String targetDev;
        private final String sourceFile;
        private final String sourceDev;
        private final String targetBusType;
        private final String driverName;
        private final String driverType;
        private final String driverCache;
        private final boolean readonly;
        private final boolean shareable;
        public static final String TYPE = "type";
        public static final String TARGET_DEVICE = "target_device";
        public static final String SAVED_TARGET_DEVICE = "saved_target_device";
        public static final String SOURCE_FILE = "source_file";
        public static final String SOURCE_DEVICE = "source_dev";
        public static final String TARGET_BUS_TYPE = "target_bus_type";
        public static final String TARGET_BUS = "target_bus";
        public static final String TARGET_TYPE = "target_type";
        public static final String DRIVER_NAME = "driver_name";
        public static final String DRIVER_TYPE = "driver_type";
        public static final String DRIVER_CACHE = "driver_cache";
        public static final String READONLY = "readonly";
        public static final String SHAREABLE = "shareable";

        public DiskData(String type, String targetDev, String sourceFile, String sourceDev, String targetBusType, String driverName, String driverType, String driverCache, boolean readonly, boolean shareable) {
            this.type = type;
            this.setValue("type", type);
            this.targetDev = targetDev;
            this.setValue(TARGET_DEVICE, targetDev);
            this.sourceFile = sourceFile;
            this.setValue(SOURCE_FILE, sourceFile);
            this.sourceDev = sourceDev;
            this.setValue(SOURCE_DEVICE, sourceDev);
            this.targetBusType = targetBusType;
            this.setValue(TARGET_BUS_TYPE, targetBusType);
            this.driverName = driverName;
            this.setValue(DRIVER_NAME, driverName);
            this.driverType = driverType;
            this.setValue(DRIVER_TYPE, driverType);
            this.driverCache = driverCache;
            this.setValue(DRIVER_CACHE, driverCache);
            this.readonly = readonly;
            if (readonly) {
                this.setValue(READONLY, "True");
            } else {
                this.setValue(READONLY, "False");
            }
            this.shareable = shareable;
            if (shareable) {
                this.setValue(SHAREABLE, "True");
            } else {
                this.setValue(SHAREABLE, "False");
            }
        }

        public String getType() {
            return this.type;
        }

        public String getTargetDev() {
            return this.targetDev;
        }

        public String getSourceFile() {
            return this.sourceFile;
        }

        public String getSourceDev() {
            return this.sourceDev;
        }

        public String getTargetBusType() {
            return this.targetBusType;
        }

        String getDriverName() {
            return this.driverName;
        }

        String getDriverType() {
            return this.driverType;
        }

        String getDriverCache() {
            return this.driverCache;
        }

        boolean isReadonly() {
            return this.readonly;
        }

        boolean isShareable() {
            return this.shareable;
        }
    }

    static final class NetworkData
    extends HardwareData {
        private final String name;
        private final String uuid;
        private final boolean autostart;
        private final String forwardMode;
        private final String bridgeName;
        private final String bridgeSTP;
        private final String bridgeDelay;
        private final String bridgeForwardDelay;
        static final String AUTOSTART = "autostart";
        static final String FORWARD_MODE = "forward_mode";
        static final String BRIDGE_NAME = "bridge_name";
        static final String BRIDGE_STP = "bridge_stp";
        static final String BRIDGE_DELAY = "bridge_delay";
        static final String BRIDGE_FORWARD_DELAY = "bridge_forward_delay";

        NetworkData(String name, String uuid, boolean autostart, String forwardMode, String bridgeName, String bridgeSTP, String bridgeDelay, String bridgeForwardDelay) {
            this.name = name;
            this.uuid = uuid;
            this.autostart = autostart;
            if (autostart) {
                this.setValue("autostart", "true");
            } else {
                this.setValue("autostart", "false");
            }
            this.forwardMode = forwardMode;
            this.setValue(FORWARD_MODE, forwardMode);
            this.bridgeName = bridgeName;
            this.setValue(BRIDGE_NAME, bridgeName);
            this.bridgeSTP = bridgeSTP;
            this.setValue(BRIDGE_STP, bridgeSTP);
            this.bridgeDelay = bridgeDelay;
            this.setValue(BRIDGE_DELAY, bridgeDelay);
            this.bridgeForwardDelay = bridgeForwardDelay;
            this.setValue(BRIDGE_FORWARD_DELAY, bridgeForwardDelay);
        }

        boolean isAutostart() {
            return this.autostart;
        }

        String getForwardMode() {
            return this.forwardMode;
        }

        String getBridgeName() {
            return this.bridgeName;
        }

        String getBridgeSTP() {
            return this.bridgeSTP;
        }

        String getBridgeDelay() {
            return this.bridgeDelay;
        }

        String getBridgeForwardDelay() {
            return this.bridgeForwardDelay;
        }
    }
}

