/*
 * Decompiled with CFR 0.152.
 */
import EDU.oswego.cs.dl.util.concurrent.FJTask;
import EDU.oswego.cs.dl.util.concurrent.FJTaskRunnerGroup;

class NQueens
extends FJTask {
    static int boardSize;
    static final Result result;
    final int[] sofar;

    public static void main(String[] args) {
        try {
            int procs;
            try {
                procs = Integer.parseInt(args[0]);
                boardSize = Integer.parseInt(args[1]);
            }
            catch (Exception e) {
                System.out.println("Usage: java NQueens <threads> <boardSize>");
                return;
            }
            if (boardSize <= 3) {
                System.out.println("There is no solution for board size <= 3");
                return;
            }
            FJTaskRunnerGroup g = new FJTaskRunnerGroup(procs);
            NQueens f = new NQueens(new int[0]);
            g.execute(f);
            int[] board = result.await();
            g.stats();
            System.out.print("Result:");
            for (int i = 0; i < board.length; ++i) {
                System.out.print(" " + board[i]);
            }
            System.out.println();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    NQueens(int[] a) {
        this.sofar = a;
    }

    @Override
    public void run() {
        if (result.get() == null) {
            int row = this.sofar.length;
            if (row >= boardSize) {
                result.set(this.sofar);
            } else {
                for (int q = 0; q < boardSize; ++q) {
                    boolean attacked = false;
                    for (int i = 0; i < row; ++i) {
                        int p = this.sofar[i];
                        if (q != p && q != p - (row - i) && q != p + (row - i)) continue;
                        attacked = true;
                        break;
                    }
                    if (attacked) continue;
                    int[] next = new int[row + 1];
                    for (int k = 0; k < row; ++k) {
                        next[k] = this.sofar[k];
                    }
                    next[row] = q;
                    new NQueens(next).fork();
                }
            }
        }
    }

    static {
        result = new Result();
    }

    static final class Result {
        private int[] board = null;

        Result() {
        }

        synchronized int[] get() {
            return this.board;
        }

        synchronized void set(int[] b) {
            if (this.board == null) {
                this.board = b;
                this.notifyAll();
            }
        }

        synchronized int[] await() throws InterruptedException {
            while (this.board == null) {
                this.wait();
            }
            return this.board;
        }
    }
}

