/*
 * Decompiled with CFR 0.152.
 */
import EDU.oswego.cs.dl.util.concurrent.FJTask;
import EDU.oswego.cs.dl.util.concurrent.FJTaskRunnerGroup;
import java.util.Random;

class MSort {
    static final int MERGE_SIZE = 2048;
    static final int QUICK_SIZE = 2048;
    static final int INSERTION_SIZE = 20;

    MSort() {
    }

    public static void main(String[] args) {
        try {
            int n = 262144;
            int p = 2;
            try {
                p = Integer.parseInt(args[0]);
                n = Integer.parseInt(args[1]);
            }
            catch (Exception e) {
                System.out.println("Usage: java MSort <threads> <array size>");
                return;
            }
            int[] A = new int[n];
            Random rng = new Random();
            for (int i = 0; i < n; ++i) {
                A[i] = rng.nextInt();
            }
            int[] workSpace = new int[n];
            FJTaskRunnerGroup g = new FJTaskRunnerGroup(p);
            Sorter t = new Sorter(A, 0, workSpace, 0, n);
            g.invoke(t);
            g.stats();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static void checkSorted(int[] A, int n) {
        for (int i = 0; i < n - 1; ++i) {
            if (A[i] <= A[i + 1]) continue;
            throw new Error("Unsorted at " + i + ": " + A[i] + " / " + A[i + 1]);
        }
    }

    static class Merger
    extends FJTask {
        final int[] A;
        final int aLo;
        final int aSize;
        final int[] B;
        final int bLo;
        final int bSize;
        final int[] out;
        final int outLo;

        Merger(int[] A, int aLo, int aSize, int[] B, int bLo, int bSize, int[] out, int outLo) {
            this.out = out;
            this.outLo = outLo;
            if (aSize >= bSize) {
                this.A = A;
                this.aLo = aLo;
                this.aSize = aSize;
                this.B = B;
                this.bLo = bLo;
                this.bSize = bSize;
            } else {
                this.A = B;
                this.aLo = bLo;
                this.aSize = bSize;
                this.B = A;
                this.bLo = aLo;
                this.bSize = aSize;
            }
        }

        @Override
        public void run() {
            if (this.aSize <= 2048) {
                this.merge();
            } else {
                int aHalf = this.aSize / 2;
                int bSplit = this.findSplit(this.A[this.aLo + aHalf]);
                Merger.coInvoke(new Merger(this.A, this.aLo, aHalf, this.B, this.bLo, bSplit, this.out, this.outLo), new Merger(this.A, this.aLo + aHalf, this.aSize - aHalf, this.B, this.bLo + bSplit, this.bSize - bSplit, this.out, this.outLo + aHalf + bSplit));
            }
        }

        synchronized int findSplit(int value) {
            int low = 0;
            int high = this.bSize;
            while (low < high) {
                int middle = low + (high - low) / 2;
                if (value <= this.B[this.bLo + middle]) {
                    high = middle;
                    continue;
                }
                low = middle + 1;
            }
            return high;
        }

        synchronized void merge() {
            int a = this.aLo;
            int aFence = this.aLo + this.aSize;
            int b = this.bLo;
            int bFence = this.bLo + this.bSize;
            int k = this.outLo;
            while (a < aFence && b < bFence) {
                if (this.A[a] < this.B[b]) {
                    this.out[k++] = this.A[a++];
                    continue;
                }
                this.out[k++] = this.B[b++];
            }
            while (a < aFence) {
                this.out[k++] = this.A[a++];
            }
            while (b < bFence) {
                this.out[k++] = this.B[b++];
            }
        }
    }

    static class Sorter
    extends FJTask {
        final int[] A;
        final int aLo;
        final int[] W;
        final int wLo;
        final int n;

        Sorter(int[] A, int aLo, int[] W, int wLo, int n) {
            this.A = A;
            this.aLo = aLo;
            this.W = W;
            this.wLo = wLo;
            this.n = n;
        }

        @Override
        public void run() {
            if (this.n <= 2048) {
                this.qs();
            } else {
                int q = this.n / 4;
                Sorter.coInvoke(new FJTask.Seq(new FJTask.Par(new Sorter(this.A, this.aLo, this.W, this.wLo, q), new Sorter(this.A, this.aLo + q, this.W, this.wLo + q, q)), new Merger(this.A, this.aLo, q, this.A, this.aLo + q, q, this.W, this.wLo)), new FJTask.Seq(new FJTask.Par(new Sorter(this.A, this.aLo + q * 2, this.W, this.wLo + q * 2, q), new Sorter(this.A, this.aLo + q * 3, this.W, this.wLo + q * 3, this.n - q * 3)), new Merger(this.A, this.aLo + q * 2, q, this.A, this.aLo + q * 3, this.n - q * 3, this.W, this.wLo + q * 2)));
                Sorter.invoke(new Merger(this.W, this.wLo, q * 2, this.W, this.wLo + q * 2, this.n - q * 2, this.A, this.aLo));
            }
        }

        synchronized void qs() {
            this.quickSort(this.aLo, this.aLo + this.n - 1);
        }

        void quickSort(int lo, int hi) {
            int t;
            if ((long)(hi - lo) + 1L <= 20L) {
                for (int i = lo + 1; i <= hi; ++i) {
                    int t2 = this.A[i];
                    for (int j = i - 1; j >= lo && this.A[j] > t2; --j) {
                        this.A[j + 1] = this.A[j];
                    }
                    this.A[j + 1] = t2;
                }
                return;
            }
            int mid = (lo + hi) / 2;
            if (this.A[lo] > this.A[mid]) {
                t = this.A[lo];
                this.A[lo] = this.A[mid];
                this.A[mid] = t;
            }
            if (this.A[mid] > this.A[hi]) {
                t = this.A[mid];
                this.A[mid] = this.A[hi];
                this.A[hi] = t;
                if (this.A[lo] > this.A[mid]) {
                    t = this.A[lo];
                    this.A[lo] = this.A[mid];
                    this.A[mid] = t;
                }
            }
            int left = lo + 1;
            int right = hi - 1;
            int partition = this.A[mid];
            while (true) {
                if (this.A[right] > partition) {
                    --right;
                    continue;
                }
                while (left < right && this.A[left] <= partition) {
                    ++left;
                }
                if (left >= right) break;
                int t3 = this.A[left];
                this.A[left] = this.A[right];
                this.A[right] = t3;
                --right;
            }
            this.quickSort(lo, left);
            this.quickSort(left + 1, hi);
        }
    }
}

