/*
 * Decompiled with CFR 0.152.
 */
package JavaViewer;

import JavaViewer.AuthPanel;
import JavaViewer.ButtonPanel;
import JavaViewer.ClipboardFrame;
import JavaViewer.DH;
import JavaViewer.DesCipher;
import JavaViewer.FTPFrame;
import JavaViewer.OptionsFrame;
import JavaViewer.RecordingFrame;
import JavaViewer.RfbProto;
import JavaViewer.VncCanvas;
import java.applet.Applet;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import javax.swing.JOptionPane;
import lcmc.utilities.Tools;

public class VncViewer
extends Applet
implements Runnable,
WindowListener {
    boolean inAnApplet = true;
    boolean inSeparateFrame = false;
    boolean mslogon = false;
    String[] mainArgs;
    RfbProto rfb;
    Thread rfbThread;
    Frame vncFrame;
    Container vncContainer;
    ScrollPane desktopScrollPane;
    GridBagLayout gridbag;
    ButtonPanel buttonPanel;
    AuthPanel authenticator;
    VncCanvas vc;
    OptionsFrame options;
    ClipboardFrame clipboard;
    RecordingFrame rec;
    FTPFrame ftp;
    Object recordingSync;
    String sessionFileName;
    boolean recordingActive;
    boolean recordingStatusChanged;
    String cursorUpdatesDef;
    String eightBitColorsDef;
    String host;
    int port;
    String passwordParam;
    String encPasswordParam;
    boolean showControls;
    boolean showOfflineDesktop;
    int deferScreenUpdates;
    int deferCursorUpdates;
    int deferUpdateRequests;
    String usernameParam;
    String encUsernameParam;
    String dm;
    byte[] domain = new byte[256];
    byte[] user = new byte[256];
    byte[] passwd = new byte[32];
    int i;
    boolean disconnectRequested = false;

    public VncViewer(String[] mainArgs, boolean inAnApplet, boolean inSeparateFrame) {
        this.mainArgs = mainArgs;
        this.inAnApplet = inAnApplet;
        this.inSeparateFrame = inSeparateFrame;
    }

    public void join() {
        try {
            this.rfbThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void init() {
        this.readParameters();
        if (this.inSeparateFrame) {
            this.vncFrame = new Frame("Ultr@VNC");
            if (!this.inAnApplet) {
                this.vncFrame.add("Center", this);
            }
            this.vncContainer = this.vncFrame;
        } else {
            this.vncContainer = this;
        }
        this.recordingSync = new Object();
        this.options = new OptionsFrame(this);
        this.clipboard = new ClipboardFrame(this);
        if (RecordingFrame.checkSecurity()) {
            this.rec = new RecordingFrame(this);
        }
        this.sessionFileName = null;
        this.recordingActive = false;
        this.recordingStatusChanged = false;
        this.cursorUpdatesDef = null;
        this.eightBitColorsDef = null;
        if (this.inSeparateFrame) {
            this.vncFrame.addWindowListener(this);
        }
        this.ftp = new FTPFrame(this);
        this.rfbThread = new Thread(this);
        this.rfbThread.start();
    }

    @Override
    public void update(Graphics g) {
    }

    @Override
    public void run() {
        this.gridbag = new GridBagLayout();
        this.vncContainer.setLayout(this.gridbag);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        if (this.showControls) {
            this.buttonPanel = new ButtonPanel(this);
            this.gridbag.setConstraints(this.buttonPanel, gbc);
            this.vncContainer.add(this.buttonPanel);
        }
        try {
            this.connectAndAuthenticate();
            this.doProtocolInitialisation();
            this.vc = new VncCanvas(this);
            Tools.hideMousePointer(this.vc);
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            Panel canvasPanel = new Panel();
            canvasPanel.setLayout(new FlowLayout(0, 0, 0));
            canvasPanel.add(this.vc);
            this.desktopScrollPane = new ScrollPane(0);
            gbc.fill = 1;
            this.gridbag.setConstraints(this.desktopScrollPane, gbc);
            this.desktopScrollPane.add(canvasPanel);
            if (this.inSeparateFrame) {
                this.vncFrame.add(this.desktopScrollPane);
                this.vncFrame.setTitle(this.rfb.desktopName);
                this.vncFrame.pack();
                this.vc.resizeDesktopFrame();
            } else {
                this.gridbag.setConstraints(this.desktopScrollPane, gbc);
                this.add(this.desktopScrollPane);
                this.validate();
            }
            if (this.showControls) {
                this.buttonPanel.enableButtons();
            }
            this.moveFocusToDesktop();
            this.vc.processNormalProtocol();
        }
        catch (NoRouteToHostException e) {
            e.printStackTrace();
            this.fatalError("Network error: no route to server: " + this.host);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            this.fatalError("Network error: server name unknown: " + this.host);
        }
        catch (ConnectException e) {
            e.printStackTrace();
            this.fatalError("Network error: could not connect to server: " + this.host + ":" + this.port);
        }
        catch (EOFException e) {
            e.printStackTrace();
            if (this.showOfflineDesktop) {
                System.out.println("Network error: remote side closed connection");
                if (this.vc != null) {
                    this.vc.enableInput(false);
                }
                if (this.inSeparateFrame) {
                    this.vncFrame.setTitle(this.rfb.desktopName + " [disconnected]");
                }
                if (this.rfb != null) {
                    this.rfb.close();
                    this.rfb = null;
                }
                if (this.showControls && this.buttonPanel != null) {
                    this.buttonPanel.disableButtonsOnDisconnect();
                    if (this.inSeparateFrame) {
                        this.vncFrame.pack();
                    } else {
                        this.validate();
                    }
                }
            } else {
                this.fatalError("Network error: remote side closed connection");
            }
        }
        catch (IOException e) {
            String str = e.getMessage();
            e.printStackTrace();
            if (str != null && str.length() != 0) {
                this.fatalError("Network Error: " + str);
            } else {
                this.fatalError(e.toString());
            }
        }
        catch (Exception e) {
            String str = e.getMessage();
            e.printStackTrace();
            if (str != null && str.length() != 0) {
                this.fatalError("Error: " + str);
            }
            this.fatalError(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectAndAuthenticate() throws Exception {
        if (this.encPasswordParam != null) {
            byte[] pw = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
            int len = this.encPasswordParam.length() / 2;
            if (len > 8) {
                len = 8;
            }
            for (int i = 0; i < len; ++i) {
                String hex = this.encPasswordParam.substring(i * 2, i * 2 + 2);
                Integer x = new Integer(Integer.parseInt(hex, 16));
                pw[i] = x.byteValue();
            }
            byte[] key = new byte[]{23, 82, 107, 6, 35, 78, 88, 7};
            DesCipher des = new DesCipher(key);
            des.decrypt(pw, 0, pw, 0);
            this.passwordParam = new String(pw);
        }
        if (this.passwordParam != null) {
            if (this.inSeparateFrame) {
                this.vncFrame.pack();
                this.vncFrame.show();
            } else {
                this.validate();
            }
            if (!this.tryAuthenticate(this.usernameParam, this.passwordParam)) {
                throw new Exception("VNC authentication failed");
            }
            return;
        }
        this.prologueDetectAuthProtocol();
        this.authenticator = new AuthPanel(this.mslogon);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.ipadx = 100;
        gbc.ipady = 50;
        this.gridbag.setConstraints(this.authenticator, gbc);
        this.vncContainer.add(this.authenticator);
        if (this.inSeparateFrame) {
            this.vncFrame.pack();
            this.vncFrame.show();
        } else {
            this.validate();
            this.authenticator.moveFocusToUsernameField();
        }
        while (true) {
            AuthPanel len = this.authenticator;
            synchronized (len) {
                try {
                    this.authenticator.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            String us = this.mslogon ? this.authenticator.username.getText() : "";
            if (this.tryAuthenticate(us, this.authenticator.password.getText())) break;
            this.authenticator.retry();
        }
        this.vncContainer.remove(this.authenticator);
    }

    void prologueDetectAuthProtocol() throws Exception {
        this.rfb = new RfbProto(this.host, this.port, this, null, 0);
        this.rfb.readVersionMsg();
        System.out.println("RFB server supports protocol version " + this.rfb.serverMajor + "." + this.rfb.serverMinor);
        if (this.rfb.serverMinor == 4) {
            this.mslogon = true;
            System.out.println("Ultr@VNC mslogon detected");
        }
        this.rfb.writeVersionMsg();
    }

    boolean tryAuthenticate(String us, String pw) throws Exception {
        this.rfb = new RfbProto(this.host, this.port, this, null, 0);
        this.rfb.readVersionMsg();
        System.out.println("RFB server supports protocol version " + this.rfb.serverMajor + "." + this.rfb.serverMinor);
        this.rfb.writeVersionMsg();
        int authScheme = this.rfb.readAuthScheme();
        authScheme = 1;
        block0 : switch (authScheme) {
            case 1: {
                System.out.println("No authentication needed");
                return true;
            }
            case 2: {
                int firstZero;
                if (this.mslogon) {
                    System.out.println("showing JOptionPane warning.");
                    int n = JOptionPane.showConfirmDialog(this.vncFrame, "The current authentication method does not transfer your password securely.Do you want to continue?", "Warning", 0);
                    if (n != 0) {
                        throw new Exception("User cancelled insecure MS-Logon");
                    }
                }
                byte[] challengems = new byte[64];
                if (this.mslogon) {
                    System.arraycopy(us.getBytes(), 0, this.user, 0, us.length());
                    if (us.length() < 256) {
                        this.i = us.length();
                        while (this.i < 256) {
                            this.user[this.i] = 0;
                            ++this.i;
                        }
                    }
                    this.dm = ".";
                    System.arraycopy(this.dm.getBytes(), 0, this.domain, 0, this.dm.length());
                    if (this.dm.length() < 256) {
                        this.i = this.dm.length();
                        while (this.i < 256) {
                            this.domain[this.i] = 0;
                            ++this.i;
                        }
                    }
                    System.arraycopy(pw.getBytes(), 0, this.passwd, 0, pw.length());
                    if (pw.length() < 32) {
                        this.i = pw.length();
                        while (this.i < 32) {
                            this.passwd[this.i] = 0;
                            ++this.i;
                        }
                    }
                    byte[] fixedkey = new byte[]{23, 82, 107, 6, 35, 78, 88, 7};
                    DesCipher desme = new DesCipher(fixedkey);
                    desme.encrypt(this.passwd, 0, this.passwd, 0);
                    this.rfb.is.readFully(challengems);
                }
                byte[] challenge = new byte[16];
                this.rfb.is.readFully(challenge);
                if (pw.length() > 8) {
                    pw = pw.substring(0, 8);
                }
                if ((firstZero = pw.indexOf(0)) != -1) {
                    pw = pw.substring(0, firstZero);
                }
                if (this.mslogon) {
                    this.i = 0;
                    while (this.i < 32) {
                        challengems[this.i] = (byte)(this.passwd[this.i] ^ challengems[this.i]);
                        ++this.i;
                    }
                    this.rfb.os.write(this.user);
                    this.rfb.os.write(this.domain);
                    this.rfb.os.write(challengems);
                }
                byte[] key = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
                System.arraycopy(pw.getBytes(), 0, key, 0, pw.length());
                DesCipher des = new DesCipher(key);
                des.encrypt(challenge, 0, challenge, 0);
                des.encrypt(challenge, 8, challenge, 8);
                this.rfb.os.write(challenge);
                int authResult = this.rfb.is.readInt();
                switch (authResult) {
                    case 0: {
                        System.out.println("VNC authentication succeeded");
                        return true;
                    }
                    case 1: {
                        System.out.println("VNC authentication failed");
                        break block0;
                    }
                    case 2: {
                        throw new Exception("VNC authentication failed - too many tries");
                    }
                }
                throw new Exception("Unknown VNC authentication result " + authResult);
            }
            case -6: {
                System.out.println("MS-Logon (DH) detected");
                if (!this.AuthMsLogon(us, pw)) break;
                return true;
            }
            default: {
                throw new Exception("Unknown VNC authentication scheme " + authScheme);
            }
        }
        return false;
    }

    boolean AuthMsLogon(String us, String pw) throws Exception {
        byte[] user = new byte[256];
        byte[] passwd = new byte[64];
        long gen = this.rfb.is.readLong();
        long mod = this.rfb.is.readLong();
        long resp = this.rfb.is.readLong();
        DH dh = new DH(gen, mod);
        long pub = dh.createInterKey();
        this.rfb.os.write(DH.longToBytes(pub));
        long key = dh.createEncryptionKey(resp);
        System.out.println("gen=" + gen + ", mod=" + mod + ", pub=" + pub + ", key=" + key);
        DesCipher des = new DesCipher(DH.longToBytes(key));
        System.arraycopy(us.getBytes(), 0, user, 0, us.length());
        if (us.length() < 256) {
            this.i = us.length();
            while (this.i < 256) {
                user[this.i] = 0;
                ++this.i;
            }
        }
        System.arraycopy(pw.getBytes(), 0, passwd, 0, pw.length());
        if (pw.length() < 32) {
            this.i = pw.length();
            while (this.i < 32) {
                passwd[this.i] = 0;
                ++this.i;
            }
        }
        des.encryptText(user, user, DH.longToBytes(key));
        des.encryptText(passwd, passwd, DH.longToBytes(key));
        this.rfb.os.write(user);
        this.rfb.os.write(passwd);
        int authResult = this.rfb.is.readInt();
        switch (authResult) {
            case 0: {
                System.out.println("MS-Logon (DH) authentication succeeded");
                return true;
            }
            case 1: {
                System.out.println("MS-Logon (DH) authentication failed");
                break;
            }
            case 2: {
                throw new Exception("MS-Logon (DH) authentication failed - too many tries");
            }
            default: {
                throw new Exception("Unknown MS-Logon (DH) authentication result " + authResult);
            }
        }
        return false;
    }

    void doProtocolInitialisation() throws IOException {
        this.rfb.writeClientInit();
        this.rfb.readServerInit();
        System.out.println("Desktop name is " + this.rfb.desktopName);
        System.out.println("Desktop size is " + this.rfb.framebufferWidth + " x " + this.rfb.framebufferHeight);
        this.setEncodings();
    }

    void setEncodings() {
        try {
            if (this.rfb != null && this.rfb.inNormalProtocol) {
                this.rfb.writeSetEncodings(this.options.encodings, this.options.nEncodings);
                if (this.vc != null) {
                    this.vc.softCursorFree();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void setCutText(String text) {
        try {
            if (this.rfb != null && this.rfb.inNormalProtocol) {
                this.rfb.writeClientCutText(text);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRecordingStatus(String fname) {
        Object object = this.recordingSync;
        synchronized (object) {
            this.sessionFileName = fname;
            this.recordingStatusChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkRecordingStatus() throws IOException {
        Object object = this.recordingSync;
        synchronized (object) {
            if (this.recordingStatusChanged) {
                this.recordingStatusChanged = false;
                if (this.sessionFileName != null) {
                    this.startRecording();
                    return true;
                }
                this.stopRecording();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startRecording() throws IOException {
        Object object = this.recordingSync;
        synchronized (object) {
            if (!this.recordingActive) {
                this.cursorUpdatesDef = this.options.choices[this.options.cursorUpdatesIndex].getSelectedItem();
                this.eightBitColorsDef = this.options.choices[this.options.eightBitColorsIndex].getSelectedItem();
                this.options.choices[this.options.cursorUpdatesIndex].select("Disable");
                this.options.choices[this.options.cursorUpdatesIndex].setEnabled(false);
                this.options.setEncodings();
                this.options.choices[this.options.eightBitColorsIndex].select("Full");
                this.options.choices[this.options.eightBitColorsIndex].setEnabled(false);
                this.options.setColorFormat();
            } else {
                this.rfb.closeSession();
            }
            System.out.println("Recording the session in " + this.sessionFileName);
            this.rfb.startSession(this.sessionFileName);
            this.recordingActive = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopRecording() throws IOException {
        Object object = this.recordingSync;
        synchronized (object) {
            if (this.recordingActive) {
                this.options.choices[this.options.cursorUpdatesIndex].select(this.cursorUpdatesDef);
                this.options.choices[this.options.cursorUpdatesIndex].setEnabled(true);
                this.options.setEncodings();
                this.options.choices[this.options.eightBitColorsIndex].select(this.eightBitColorsDef);
                this.options.choices[this.options.eightBitColorsIndex].setEnabled(true);
                this.options.setColorFormat();
                this.rfb.closeSession();
                System.out.println("Session recording stopped.");
            }
            this.sessionFileName = null;
            this.recordingActive = false;
        }
    }

    public void readParameters() {
        this.host = this.readParameter("HOST", !this.inAnApplet);
        if (this.host == null) {
            this.host = this.getCodeBase().getHost();
            if (this.host.equals("")) {
                this.fatalError("HOST parameter not specified");
            }
        }
        String str = this.readParameter("PORT", true);
        this.port = Integer.parseInt(str);
        if (this.inAnApplet && (str = this.readParameter("Open New Window", false)) != null && str.equalsIgnoreCase("Yes")) {
            this.inSeparateFrame = true;
        }
        this.encPasswordParam = this.readParameter("ENCPASSWORD", false);
        if (this.encPasswordParam == null) {
            this.passwordParam = this.readParameter("PASSWORD", false);
        }
        this.showControls = true;
        str = this.readParameter("Show Controls", false);
        if (str != null && str.equalsIgnoreCase("No")) {
            this.showControls = false;
        }
        this.showOfflineDesktop = false;
        str = this.readParameter("Show Offline Desktop", false);
        if (str != null && str.equalsIgnoreCase("Yes")) {
            this.showOfflineDesktop = true;
        }
        this.deferScreenUpdates = this.readIntParameter("Defer screen updates", 20);
        this.deferCursorUpdates = this.readIntParameter("Defer cursor updates", 10);
        this.deferUpdateRequests = this.readIntParameter("Defer update requests", 50);
    }

    public String readParameter(String name, boolean required) {
        if (this.inAnApplet) {
            String s = this.getParameter(name);
            if (s == null && required) {
                this.fatalError(name + " parameter not specified");
            }
            return s;
        }
        for (int i = 0; i < this.mainArgs.length; i += 2) {
            if (!this.mainArgs[i].equalsIgnoreCase(name)) continue;
            try {
                return this.mainArgs[i + 1];
            }
            catch (Exception e) {
                if (required) {
                    this.fatalError(name + " parameter not specified");
                }
                return null;
            }
        }
        if (required) {
            this.fatalError(name + " parameter not specified");
        }
        return null;
    }

    int readIntParameter(String name, int defaultValue) {
        String str = this.readParameter(name, false);
        int result = defaultValue;
        if (str != null) {
            try {
                result = Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return result;
    }

    void moveFocusToDesktop() {
        if (this.vncContainer != null) {
            if (this.vc != null && this.vncContainer.isAncestorOf(this.vc)) {
                this.vc.requestFocus();
            } else if (this.vncContainer.isAncestorOf(this.authenticator)) {
                this.authenticator.moveFocusToPasswordField();
            }
        }
    }

    public synchronized void disconnect() {
        this.disconnectRequested = true;
        if (this.rfb != null) {
            this.rfb.close();
            this.rfb = null;
        }
        System.out.println("Disconnect");
        this.options.dispose();
        this.clipboard.dispose();
        if (this.rec != null) {
            this.rec.dispose();
        }
        if (this.inAnApplet) {
            this.vncContainer.removeAll();
            Label errLabel = new Label("Disconnected");
            errLabel.setFont(new Font("Helvetica", 0, 12));
            this.vncContainer.setLayout(new FlowLayout(0, 30, 30));
            this.vncContainer.add(errLabel);
            if (this.inSeparateFrame) {
                this.vncFrame.pack();
            } else {
                this.validate();
            }
            this.rfbThread.stop();
        }
    }

    public synchronized void fatalError(String str) {
        if (this.rfb != null) {
            this.rfb.close();
            this.rfb = null;
        }
        System.out.println(str);
        if (this.disconnectRequested) {
            this.disconnectRequested = false;
            return;
        }
        if (this.inAnApplet) {
            this.vncContainer.removeAll();
            Label errLabel = new Label(str);
            errLabel.setFont(new Font("Helvetica", 0, 12));
            this.vncContainer.setLayout(new FlowLayout(0, 30, 30));
            this.vncContainer.add(errLabel);
            if (this.inSeparateFrame) {
                this.vncFrame.pack();
            } else {
                this.validate();
            }
            Thread.currentThread().stop();
        }
    }

    @Override
    public void destroy() {
        this.vncContainer.removeAll();
        this.options.dispose();
        this.clipboard.dispose();
        if (this.ftp != null) {
            this.ftp.dispose();
        }
        if (this.rec != null) {
            this.rec.dispose();
        }
        if (this.rfb != null) {
            this.rfb.close();
        }
        if (this.inSeparateFrame) {
            this.vncFrame.dispose();
        }
    }

    @Override
    public void windowClosing(WindowEvent evt) {
        if (this.rfb != null) {
            this.disconnect();
        }
        this.vncFrame.dispose();
        if (!this.inAnApplet) {
            // empty if block
        }
    }

    @Override
    public void windowActivated(WindowEvent evt) {
        if (this.vncFrame.isAncestorOf(this.authenticator)) {
            this.authenticator.moveFocusToPasswordField();
        }
    }

    @Override
    public void windowDeactivated(WindowEvent evt) {
    }

    @Override
    public void windowOpened(WindowEvent evt) {
    }

    @Override
    public void windowClosed(WindowEvent evt) {
    }

    @Override
    public void windowIconified(WindowEvent evt) {
    }

    @Override
    public void windowDeiconified(WindowEvent evt) {
    }
}

