/*
 * Decompiled with CFR 0.152.
 */
package JavaViewer;

import JavaViewer.VncViewer;
import java.awt.Button;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

class ClipboardFrame
extends Frame
implements WindowListener,
ActionListener {
    TextArea textArea;
    Button clearButton;
    Button closeButton;
    String selection;
    VncViewer viewer;

    ClipboardFrame(VncViewer v) {
        super("Ultr@VNC Clipboard");
        this.viewer = v;
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.textArea = new TextArea(5, 40);
        gridbag.setConstraints(this.textArea, gbc);
        this.add(this.textArea);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        this.clearButton = new Button("Clear");
        gridbag.setConstraints(this.clearButton, gbc);
        this.add(this.clearButton);
        this.clearButton.addActionListener(this);
        this.closeButton = new Button("Close");
        gridbag.setConstraints(this.closeButton, gbc);
        this.add(this.closeButton);
        this.closeButton.addActionListener(this);
        this.pack();
        this.addWindowListener(this);
    }

    void setCutText(String text) {
        this.selection = text;
        this.textArea.setText(text);
        if (this.isVisible()) {
            this.textArea.selectAll();
        }
    }

    @Override
    public void windowDeactivated(WindowEvent evt) {
        if (this.selection != null && !this.selection.equals(this.textArea.getText())) {
            this.selection = this.textArea.getText();
            this.viewer.setCutText(this.selection);
        }
    }

    @Override
    public void windowClosing(WindowEvent evt) {
        this.setVisible(false);
    }

    @Override
    public void windowActivated(WindowEvent evt) {
    }

    @Override
    public void windowOpened(WindowEvent evt) {
    }

    @Override
    public void windowClosed(WindowEvent evt) {
    }

    @Override
    public void windowIconified(WindowEvent evt) {
    }

    @Override
    public void windowDeiconified(WindowEvent evt) {
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.clearButton) {
            this.textArea.setText("");
        } else if (evt.getSource() == this.closeButton) {
            this.setVisible(false);
        }
    }
}

