/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jzlib;

import com.jcraft.jzlib.Deflater;
import com.jcraft.jzlib.DeflaterOutputStream;
import com.jcraft.jzlib.GZIPException;
import java.io.IOException;
import java.io.OutputStream;

public class GZIPOutputStream
extends DeflaterOutputStream {
    public GZIPOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, 512);
    }

    public GZIPOutputStream(OutputStream outputStream, int n) throws IOException {
        this(outputStream, n, true);
    }

    public GZIPOutputStream(OutputStream outputStream, int n, boolean bl) throws IOException {
        this(outputStream, new Deflater(-1, 31), n, bl);
        this.mydeflater = true;
    }

    public GZIPOutputStream(OutputStream outputStream, Deflater deflater, int n, boolean bl) throws IOException {
        super(outputStream, deflater, n, bl);
    }

    private void check() throws GZIPException {
        if (this.deflater.dstate.status != 42) {
            throw new GZIPException("header is already written.");
        }
    }

    public void setModifiedTime(long l) throws GZIPException {
        this.check();
        this.deflater.dstate.getGZIPHeader().setModifiedTime(l);
    }

    public void setOS(int n) throws GZIPException {
        this.check();
        this.deflater.dstate.getGZIPHeader().setOS(n);
    }

    public void setName(String string) throws GZIPException {
        this.check();
        this.deflater.dstate.getGZIPHeader().setName(string);
    }

    public void setComment(String string) throws GZIPException {
        this.check();
        this.deflater.dstate.getGZIPHeader().setComment(string);
    }

    public long getCRC() throws GZIPException {
        if (this.deflater.dstate.status != 666) {
            throw new GZIPException("checksum is not calculated yet.");
        }
        return this.deflater.dstate.getGZIPHeader().getCRC();
    }
}

