/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.expectation;

import java.util.Enumeration;
import java.util.Hashtable;
import org.jmock.core.Verifiable;
import org.jmock.expectation.AssertMo;
import org.jmock.expectation.MockObject;
import org.jmock.expectation.Null;

public class ReturnObjectMap
extends MockObject {
    private final Hashtable returnValues = new Hashtable();
    private final String name;

    public ReturnObjectMap(String string) {
        this.name = string;
    }

    public Object getValue(Object object) {
        if (object == null) {
            object = Null.NULL;
        }
        AssertMo.assertTrue((String)(this.name + " does not contain " + object.toString()), (boolean)this.returnValues.containsKey(object));
        return ((CallCounter)this.returnValues.get(object)).getValue();
    }

    public Object getValue(short s) {
        return this.getValue(new Short(s));
    }

    public void putReturnValue(Object object, Object object2) {
        this.returnValues.put(object != null ? object : Null.NULL, new CallCounter(object, object2));
    }

    public void putReturnValue(Object object, int n) {
        this.putReturnValue(object, (Object)new Integer(n));
    }

    public void putReturnValue(short s, Object object) {
        this.putReturnValue((Object)new Short(s), object);
    }

    public void putReturnValue(Object object, boolean bl) {
        this.putReturnValue(object, (Object)new Boolean(bl));
    }

    public int getIntValue(Object object) {
        return (Integer)this.getValue(object);
    }

    public boolean getBooleanValue(String string) {
        return (Boolean)this.getValue(string);
    }

    @Override
    public void verify() {
        super.verify();
        Enumeration enumeration = this.returnValues.elements();
        while (enumeration.hasMoreElements()) {
            ((Verifiable)enumeration.nextElement()).verify();
        }
    }

    private class CallCounter
    implements Verifiable {
        private int count = 0;
        private final Object value;
        private final Object key;

        public CallCounter(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        public Object getValue() {
            ++this.count;
            return this.value;
        }

        @Override
        public void verify() {
            AssertMo.assertTrue((String)("Object never called for key: " + this.key), (this.count > 0 ? 1 : 0) != 0);
        }
    }
}

