/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.expectation;

import junit.framework.Assert;
import org.jmock.core.Verifiable;
import org.jmock.expectation.Expectation;

public abstract class AbstractExpectation
implements Verifiable,
Expectation {
    protected boolean myFailureModeIsImmediate = true;
    protected String myName;
    private boolean myHasExpectations = false;

    public AbstractExpectation(String string) {
        this.myName = string;
    }

    protected void assertEquals(String string, int n, int n2) {
        this.assertEquals(string, new Integer(n), new Integer(n2));
    }

    protected void assertEquals(String string, Object object, Object object2) {
        if (!this.myHasExpectations) {
            return;
        }
        if (object == null && object2 == null) {
            return;
        }
        if (object != null && object.equals(object2)) {
            return;
        }
        Assert.fail((String)(this.myName + " " + string + "\nExpected: " + object + "\nReceived: " + object2));
    }

    public abstract void clearActual();

    @Override
    public boolean hasExpectations() {
        return this.myHasExpectations;
    }

    @Override
    public void setFailOnVerify() {
        this.myFailureModeIsImmediate = false;
    }

    protected void setHasExpectations() {
        this.clearActual();
        this.myHasExpectations = true;
    }

    protected boolean shouldCheckImmediately() {
        return this.myFailureModeIsImmediate && this.myHasExpectations;
    }

    @Override
    public abstract void verify();
}

