/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks.resolver;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.tasks.DNSTask;

public abstract class DNSResolverTask
extends DNSTask {
    private static Logger logger = Logger.getLogger(DNSResolverTask.class.getName());
    protected int _count = 0;

    public DNSResolverTask(JmDNSImpl jmDNSImpl) {
        super(jmDNSImpl);
    }

    @Override
    public String toString() {
        return super.toString() + " count: " + this._count;
    }

    @Override
    public void start(Timer timer) {
        if (!this.getDns().isCanceling() && !this.getDns().isCanceled()) {
            timer.schedule((TimerTask)this, 225L, 225L);
        }
    }

    @Override
    public void run() {
        try {
            if (this.getDns().isCanceling() || this.getDns().isCanceled()) {
                this.cancel();
            } else if (this._count++ < 3) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(this.getName() + ".run() JmDNS " + this.description());
                }
                DNSOutgoing dNSOutgoing = new DNSOutgoing(0);
                dNSOutgoing = this.addQuestions(dNSOutgoing);
                if (this.getDns().isAnnounced()) {
                    dNSOutgoing = this.addAnswers(dNSOutgoing);
                }
                if (!dNSOutgoing.isEmpty()) {
                    this.getDns().send(dNSOutgoing);
                }
            } else {
                this.cancel();
            }
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, this.getName() + ".run() exception ", throwable);
            this.getDns().recover();
        }
    }

    protected abstract DNSOutgoing addQuestions(DNSOutgoing var1) throws IOException;

    protected abstract DNSOutgoing addAnswers(DNSOutgoing var1) throws IOException;

    protected abstract String description();
}

