/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.ice4j.socket.MultiplexingSocket;
import org.jitsi.impl.neomedia.RTPConnectorOutputStream;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.service.packetlogging.PacketLoggingService;

public class RTPConnectorTCPOutputStream
extends RTPConnectorOutputStream {
    private final Socket socket;

    public RTPConnectorTCPOutputStream(Socket socket) {
        this.socket = socket;
    }

    @Override
    protected void sendToTarget(RawPacket packet, InetSocketAddress target) throws IOException {
        this.socket.getOutputStream().write(packet.getBuffer(), packet.getOffset(), packet.getLength());
    }

    @Override
    protected void doLogPacket(RawPacket packet, InetSocketAddress target) {
        if (this.socket instanceof MultiplexingSocket) {
            return;
        }
        PacketLoggingService pktLogging = this.getPacketLoggingService();
        if (pktLogging != null) {
            pktLogging.logPacket(PacketLoggingService.ProtocolName.RTP, this.socket.getLocalAddress().getAddress(), this.socket.getLocalPort(), target.getAddress().getAddress(), target.getPort(), PacketLoggingService.TransportName.TCP, true, packet.getBuffer(), packet.getOffset(), packet.getLength());
        }
    }

    @Override
    protected boolean isSocketValid() {
        return this.socket != null;
    }
}

