/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import javax.media.rtp.OutputDataStream;
import org.jitsi.impl.neomedia.rtp.translator.Payload;

public class RTCPFeedbackMessagePacket
implements Payload {
    private int fmt;
    private byte pt;
    private long senderSSRC;
    private long sourceSSRC;
    private int seqNr;

    public RTCPFeedbackMessagePacket(int fmt, byte pt, long senderSSRC, long sourceSSRC) {
        this.setFeedbackMessageType(fmt);
        this.setPayloadType(pt);
        this.setSenderSSRC(senderSSRC);
        this.setSourceSSRC(sourceSSRC);
    }

    public int getFeedbackMessageType() {
        return this.fmt;
    }

    public byte getPayloadType() {
        return this.pt;
    }

    public long getSenderSSRC() {
        return this.senderSSRC;
    }

    public int getSequenceNumber() {
        return this.seqNr;
    }

    public long getSourceSSRC() {
        return this.sourceSSRC;
    }

    public void setFeedbackMessageType(int fmt) {
        this.fmt = fmt;
    }

    public void setPayloadType(byte pt) {
        this.pt = pt;
    }

    public void setSenderSSRC(long senderSSRC) {
        this.senderSSRC = senderSSRC;
    }

    public void setSequenceNumber(int seqNr) {
        this.seqNr = seqNr;
    }

    public void setSourceSSRC(long sourceSSRC) {
        this.sourceSSRC = sourceSSRC;
    }

    public static void writeSSRC(long ssrc, byte[] buf, int off) {
        buf[off++] = (byte)(ssrc >> 24);
        buf[off++] = (byte)(ssrc >> 16 & 0xFFL);
        buf[off++] = (byte)(ssrc >> 8 & 0xFFL);
        buf[off] = (byte)(ssrc & 0xFFL);
    }

    @Override
    public void writeTo(OutputDataStream out) {
        int fmt = this.getFeedbackMessageType();
        int rtcpPacketLength = 2;
        if (fmt == 4) {
            rtcpPacketLength += 2;
        }
        int len = (rtcpPacketLength + 1) * 4;
        byte[] buf = new byte[len];
        int off = 0;
        buf[off++] = (byte)(0x80 | fmt & 0x1F);
        buf[off++] = this.getPayloadType();
        buf[off++] = (byte)((rtcpPacketLength & 0xFF00) >> 8);
        buf[off++] = (byte)(rtcpPacketLength & 0xFF);
        RTCPFeedbackMessagePacket.writeSSRC(this.getSenderSSRC(), buf, off);
        long sourceSSRC = this.getSourceSSRC();
        RTCPFeedbackMessagePacket.writeSSRC(fmt == 4 ? 0L : sourceSSRC, buf, off += 4);
        off += 4;
        if (fmt == 4) {
            RTCPFeedbackMessagePacket.writeSSRC(sourceSSRC, buf, off);
            off += 4;
            buf[off++] = (byte)(this.getSequenceNumber() % 256);
            buf[off++] = 0;
            buf[off++] = 0;
            buf[off++] = 0;
        }
        out.write(buf, 0, len);
    }
}

