/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.notificationconfiguration;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import net.java.sip.communicator.plugin.notificationconfiguration.NotificationEntry;
import net.java.sip.communicator.plugin.notificationconfiguration.NotificationsTable;
import net.java.sip.communicator.plugin.notificationconfiguration.Resources;

class StringTableRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 0L;

    StringTableRenderer() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof NotificationEntry) {
            NotificationEntry entry = (NotificationEntry)value;
            this.setForeground(entry.getEnabled() ? Color.BLACK : Color.GRAY);
            this.setHorizontalAlignment(2);
            this.setIcon(null);
            this.setText(Resources.getString("plugin.notificationconfig.event." + entry.getEvent()));
        } else if (value instanceof String) {
            String stringValue = (String)value;
            if (stringValue.equals("Enabled")) {
                this.setHorizontalAlignment(0);
                this.setIcon(NotificationsTable.getColumnIconValue(column));
                this.setText(null);
            } else if (stringValue.equals("Disabled")) {
                this.setIcon(null);
                this.setText(null);
            }
        }
        if (isSelected) {
            this.setBackground(new Color(209, 212, 225));
            this.setOpaque(true);
        } else {
            this.setBackground(Color.WHITE);
        }
        return this;
    }
}

