/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.MiscTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.ExtraInfoBlock;
import net.kano.joscar.snaccmd.ShortCapabilityBlock;
import net.kano.joscar.snaccmd.WarningLevel;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullUserInfo
implements LiveWritable {
    public static final int MASK_UNCONFIRMED = 1;
    public static final int MASK_ADMIN = 2;
    public static final int MASK_AOL = 4;
    public static final int MASK_FREE = 16;
    public static final int MASK_WIRELESS = 128;
    public static final int MASK_AB = 1024;
    public static final int MASK_AWAY = 32;
    public static final long MASK_ALL = 0xFFFFFFFFL;
    public static final long ICQSTATUS_INVISIBLE = 256L;
    public static final long ICQSTATUS_DND = 2L;
    public static final long ICQSTATUS_OCCUPIED = 16L;
    public static final long ICQSTATUS_NA = 4L;
    public static final long ICQSTATUS_AWAY = 1L;
    public static final long ICQSTATUS_DEFAULT = 0L;
    public static final long ICQSTATUS_FFC = 32L;
    private static final int TYPE_USER_FLAG = 1;
    private static final int TYPE_ACCT_CREATED = 2;
    private static final int TYPE_ON_SINCE = 3;
    private static final int TYPE_IDLE_MINS = 4;
    private static final int TYPE_MEMBER_SINCE = 5;
    private static final int TYPE_CAPS = 13;
    private static final int TYPE_SESS_LEN_AIM = 15;
    private static final int TYPE_SESS_LEN_AOL = 16;
    private static final int TYPE_EXTRA_INFO = 29;
    private static final int TYPE_CERT_HASH = 27;
    private static final int TYPE_SHORT_CAPS = 25;
    private static final int TYPE_ICQSTATUS = 6;
    private final String sn;
    private final int totalSize;
    private final WarningLevel warningLevel;
    private final int flags;
    private final Date accountCreated;
    private final Date memberSince;
    private final long sessionLengthAIM;
    private final long sessionLengthAOL;
    private final Date onSince;
    private final int idleMins;
    private final List<CapabilityBlock> capabilityBlocks;
    private final Boolean away;
    private final List<ExtraInfoBlock> extraInfos;
    private final ByteBlock certInfoHash;
    private final List<ShortCapabilityBlock> shortCaps;
    private final long icqstatus;
    private final ImmutableTlvChain extraTlvs;

    @Nullable
    public static FullUserInfo readUserInfo(ByteBlock origBlock) {
        DefensiveTools.checkNull(origBlock, "block");
        int start = origBlock.getOffset();
        StringBlock snInfo = OscarTools.readScreenname(origBlock);
        if (snInfo == null) {
            return null;
        }
        String sn = snInfo.getString();
        int snLength = snInfo.getTotalSize();
        if (origBlock.getLength() < snLength + 2) {
            return new FullUserInfo(sn, snLength);
        }
        ByteBlock block = origBlock.subBlock(snLength);
        int warnval = BinaryTools.getUShort(block, 0);
        WarningLevel warningLevel = WarningLevel.getInstanceFromX10(warnval);
        if ((block = block.subBlock(2)).getLength() < 2) {
            return new FullUserInfo(sn, warningLevel, snLength + 2);
        }
        int tlvCount = BinaryTools.getUShort(block, 0);
        block = block.subBlock(2);
        ImmutableTlvChain chain = TlvTools.readChain(block, tlvCount);
        Tlv userFlagTlv = chain.getLastTlv(1);
        Tlv accountCreationTlv = chain.getLastTlv(2);
        Tlv onSinceTlv = chain.getLastTlv(3);
        Tlv idleTimeTlv = chain.getLastTlv(4);
        Tlv memberSinceTlv = chain.getLastTlv(5);
        Tlv capTlv = chain.getLastTlv(13);
        Tlv sessionLengthAIM = chain.getLastTlv(15);
        Tlv sessionLengthAOL = chain.getLastTlv(16);
        Tlv extraInfoTlv = chain.getLastTlv(29);
        Tlv certHashTlv = chain.getLastTlv(27);
        Tlv shortCapTlv = chain.getLastTlv(25);
        Tlv statusTlv = chain.getLastTlv(6);
        MutableTlvChain extras = TlvTools.getMutableCopy(chain);
        extras.removeTlvs(1, 2, 3, 4, 5, 13, 15, 16, 29, 27, 25, 6);
        Boolean away = null;
        int flags = -1;
        if (userFlagTlv != null) {
            flags = userFlagTlv.getDataAsUShort();
            away = (flags & 0x20) != 0;
        }
        Date accountCreated = null;
        if (accountCreationTlv != null) {
            accountCreated = new Date(accountCreationTlv.getDataAsUInt() * 1000L);
        }
        Date memberSince = null;
        if (memberSinceTlv != null) {
            memberSince = new Date(memberSinceTlv.getDataAsUInt() * 1000L);
        }
        long sessLengthAIM = -1L;
        if (sessionLengthAIM != null) {
            sessLengthAIM = sessionLengthAIM.getDataAsUInt();
        }
        long sessLengthAOL = -1L;
        if (sessionLengthAOL != null) {
            sessLengthAOL = sessionLengthAOL.getDataAsUInt();
        }
        Date onSince = null;
        if (onSinceTlv != null) {
            onSince = new Date(onSinceTlv.getDataAsUInt() * 1000L);
        }
        int idleMins = -1;
        if (idleTimeTlv != null) {
            idleMins = idleTimeTlv.getDataAsUShort();
        }
        List<CapabilityBlock> capabilityBlocks = null;
        if (capTlv != null) {
            capabilityBlocks = CapabilityBlock.getCapabilityBlocks(capTlv.getData());
        }
        List<ExtraInfoBlock> extraInfos = null;
        if (extraInfoTlv != null) {
            ByteBlock extraBlocks = extraInfoTlv.getData();
            extraInfos = ExtraInfoBlock.readExtraInfoBlocks(extraBlocks);
        }
        ByteBlock certHash = null;
        if (certHashTlv != null) {
            certHash = certHashTlv.getData();
        }
        List<ShortCapabilityBlock> shortCaps = null;
        if (shortCapTlv != null) {
            ByteBlock shortCapData = shortCapTlv.getData();
            shortCaps = ShortCapabilityBlock.readShortCaps(shortCapData);
        }
        long status = -1L;
        if (statusTlv != null) {
            status = statusTlv.getDataAsUInt();
        }
        block = block.subBlock(chain.getTotalSize());
        int totalSize = block.getOffset() - start;
        ImmutableTlvChain extrasImmutable = TlvTools.getImmutableCopy(extras);
        return new FullUserInfo(sn, warningLevel, flags, accountCreated, memberSince, sessLengthAIM, sessLengthAOL, onSince, idleMins, capabilityBlocks, away, extraInfos, certHash, shortCaps, status, extrasImmutable, totalSize);
    }

    private FullUserInfo(String sn, int totalSize) {
        this(sn, null, totalSize);
    }

    private FullUserInfo(String sn, WarningLevel warningLevel, int totalSize) {
        this(sn, warningLevel, -1, null, null, -1L, -1L, null, -1, null, null, null, null, null, -1L, null, totalSize);
    }

    public FullUserInfo(String sn, WarningLevel warningLevel, int flags, Date accountCreated, Date memberSince, long sessAIM, long sessAOL, Date onSince, int idleMins, List<CapabilityBlock> capabilityBlocks, Boolean away, List<ExtraInfoBlock> extraInfos, ByteBlock certHash, List<ShortCapabilityBlock> shortCaps, long icqstatus) {
        this(sn, warningLevel, flags, accountCreated, memberSince, sessAIM, sessAOL, onSince, idleMins, capabilityBlocks, away, extraInfos, certHash, shortCaps, icqstatus, null);
    }

    public FullUserInfo(String sn, WarningLevel warningLevel, int flags, Date accountCreated, Date memberSince, long sessAIM, long sessAOL, Date onSince, int idleMins, List<CapabilityBlock> capabilityBlocks, Boolean away, List<ExtraInfoBlock> extraInfos, ByteBlock certHash, List<ShortCapabilityBlock> shortCaps, long icqstatus, ImmutableTlvChain extraTlvs) {
        this(sn, warningLevel, flags, accountCreated, memberSince, sessAIM, sessAOL, onSince, idleMins, capabilityBlocks, away, extraInfos, certHash, shortCaps, icqstatus, extraTlvs, -1);
    }

    private FullUserInfo(String sn, WarningLevel warningLevel, int flags, Date accountCreated, Date memberSince, long sessAIM, long sessAOL, Date onSince, int idleMins, List<CapabilityBlock> caps, Boolean away, List<ExtraInfoBlock> extraInfos, ByteBlock certHash, List<ShortCapabilityBlock> shortCaps, long icqstatus, ImmutableTlvChain extraTlvs, int totalSize) {
        DefensiveTools.checkNull(sn, "sn");
        DefensiveTools.checkRange(sessAIM, "sessAIM", -1L);
        DefensiveTools.checkRange(sessAOL, "sessAOL", -1L);
        DefensiveTools.checkRange(idleMins, "idleMins", -1);
        DefensiveTools.checkRange(totalSize, "totalSize", -1);
        List<CapabilityBlock> safeCaps = DefensiveTools.getSafeListCopy(caps, "caps");
        List<ExtraInfoBlock> safeExtraInfos = DefensiveTools.getSafeListCopy(extraInfos, "extraInfos");
        List<ShortCapabilityBlock> safeShortCaps = DefensiveTools.getSafeListCopy(shortCaps, "shortCaps");
        this.sn = sn;
        this.warningLevel = warningLevel;
        this.flags = flags;
        this.accountCreated = accountCreated;
        this.memberSince = memberSince;
        this.sessionLengthAIM = sessAIM;
        this.sessionLengthAOL = sessAOL;
        this.onSince = onSince;
        this.idleMins = idleMins;
        this.capabilityBlocks = safeCaps;
        this.away = away;
        this.extraInfos = safeExtraInfos;
        this.certInfoHash = certHash;
        this.shortCaps = safeShortCaps;
        this.icqstatus = icqstatus;
        this.extraTlvs = extraTlvs;
        this.totalSize = totalSize;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public final WarningLevel getWarningLevel() {
        return this.warningLevel;
    }

    public final int getFlags() {
        return this.flags;
    }

    public final Date getAccountCreated() {
        return this.accountCreated;
    }

    public final Date getMemberSince() {
        return this.memberSince;
    }

    public final long getSessionLengthAIM() {
        return this.sessionLengthAIM;
    }

    public final long getSessionLengthAOL() {
        return this.sessionLengthAOL;
    }

    public final Date getOnSince() {
        return this.onSince;
    }

    public final int getIdleMins() {
        return this.idleMins;
    }

    public final List<CapabilityBlock> getCapabilityBlocks() {
        return this.capabilityBlocks;
    }

    public final Boolean getAwayStatus() {
        return this.away;
    }

    public final List<ExtraInfoBlock> getExtraInfoBlocks() {
        return this.extraInfos;
    }

    public final ByteBlock getCertInfoHash() {
        return this.certInfoHash;
    }

    public List<ShortCapabilityBlock> getShortCapabilityBlocks() {
        return this.shortCaps;
    }

    public long getIcqStatus() {
        return this.icqstatus;
    }

    public final ImmutableTlvChain getExtraTlvs() {
        return this.extraTlvs;
    }

    public final int getTotalSize() {
        return this.totalSize;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        OscarTools.writeScreenname(out, this.sn);
        if (this.warningLevel == null) {
            return;
        }
        BinaryTools.writeUByte(out, this.warningLevel.getX10Value());
        MutableTlvChain chain = TlvTools.createMutableChain();
        if (this.flags != -1 || this.away != null) {
            int flags;
            int n = flags = this.flags == -1 ? 0 : this.flags;
            if (this.away != null) {
                flags = this.away.booleanValue() ? (flags |= 0x20) : (flags &= 0xFFFFFFDF);
            }
            chain.addTlv(Tlv.getUShortInstance(1, flags));
        }
        if (this.accountCreated != null) {
            long unixtime = this.accountCreated.getTime() / 1000L;
            chain.addTlv(Tlv.getUIntInstance(2, unixtime));
        }
        if (this.memberSince != null) {
            long unixtime = this.memberSince.getTime() / 1000L;
            chain.addTlv(Tlv.getUIntInstance(5, unixtime));
        }
        if (this.sessionLengthAIM != -1L) {
            chain.addTlv(Tlv.getUIntInstance(15, this.sessionLengthAIM));
        }
        if (this.sessionLengthAOL != -1L) {
            chain.addTlv(Tlv.getUIntInstance(16, this.sessionLengthAOL));
        }
        if (this.onSince != null) {
            long unixtime = this.onSince.getTime() / 1000L;
            chain.addTlv(Tlv.getUIntInstance(3, unixtime));
        }
        if (this.idleMins != -1) {
            chain.addTlv(Tlv.getUShortInstance(4, this.idleMins));
        }
        if (this.capabilityBlocks != null) {
            chain.addTlv(new Tlv(13, ByteBlock.wrap(CapabilityBlock.convertToBytes(this.capabilityBlocks))));
        }
        if (this.extraInfos != null) {
            chain.addTlv(new Tlv(29, ByteBlock.createByteBlock(this.extraInfos)));
        }
        if (this.certInfoHash != null) {
            chain.addTlv(new Tlv(27, this.certInfoHash));
        }
        if (this.icqstatus != -1L) {
            chain.addTlv(Tlv.getUIntInstance(6, this.icqstatus));
        }
        if (this.extraTlvs != null) {
            chain.addAll(this.extraTlvs);
        }
        chain.write(out);
    }

    public String toString() {
        return "UserInfo for " + this.sn + (this.warningLevel != null && this.warningLevel.intValue() != 0 ? " <" + this.warningLevel.floatValue() + "%>" : "") + ": flags=0x" + Integer.toHexString(this.flags) + " (" + MiscTools.getFlagFieldsString(FullUserInfo.class, this.flags, "MASK_.*") + ")" + (this.icqstatus == -1L ? "" : ", ICQ status=" + MiscTools.getFlagFieldsString(FullUserInfo.class, this.icqstatus, "ICQSTATUS_.*")) + (this.accountCreated != null ? ", acctCrtd=" + this.accountCreated : "") + (this.memberSince != null ? ", memberSince=" + this.memberSince : "") + (this.sessionLengthAIM != -1L ? ", sessLenAim=" + this.sessionLengthAIM / 60L + "min" : "") + (this.sessionLengthAOL != -1L ? ", sessLenAol=" + this.sessionLengthAOL / 60L + "min" : "") + (this.onSince != null ? ", onSince=" + this.onSince : "") + (this.idleMins > 0 ? ", idleMins=" + this.idleMins : "") + (this.away != false ? ", away" : "") + (this.extraInfos != null ? ", extraInfos=" + this.extraInfos : "") + (this.certInfoHash != null ? ", encInfo=" + this.certInfoHash : "") + (this.extraTlvs != null && this.extraTlvs.getTlvCount() > 0 ? ", extraTlvs=" + this.extraTlvs.getTlvs() : "") + (this.shortCaps != null ? ", shortcaps: " + this.shortCaps : "") + (this.capabilityBlocks != null ? ", longcaps: " + this.capabilityBlocks : "");
    }
}

