/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snac;

import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flap.FlapPacketEvent;
import net.kano.joscar.flap.FlapProcessor;
import net.kano.joscar.flap.VetoableFlapPacketListener;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacFlapCmd;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.logging.Logger;
import net.kano.joscar.logging.LoggingSystem;
import net.kano.joscar.net.ConnProcessor;
import net.kano.joscar.snac.CmdFactoryMgr;
import net.kano.joscar.snac.MutableSnacPacket;
import net.kano.joscar.snac.SnacPacketEvent;
import net.kano.joscar.snac.SnacPacketListener;
import net.kano.joscar.snac.SnacPreprocessor;
import net.kano.joscar.snac.VetoableSnacPacketListener;

public abstract class AbstractSnacProcessor {
    public static final ConnProcessor.ErrorType ERRTYPE_SNAC_PACKET_PREPROCESSOR = new ConnProcessor.ErrorType("ERRTYPE_SNAC_PACKET_PREPROCESSOR");
    public static final ConnProcessor.ErrorType ERRTYPE_SNAC_PACKET_LISTENER = new ConnProcessor.ErrorType("ERRTYPE_SNAC_PACKET_LISTENER");
    private static final Logger logger = LoggingSystem.getLogger("net.kano.joscar.snac");
    private boolean attached = false;
    private FlapProcessor flapProcessor;
    private final Object readLock = new Object();
    private final CmdFactoryMgr factories = new CmdFactoryMgr();
    private final CopyOnWriteArrayList<SnacPreprocessor> preprocessors = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<VetoableSnacPacketListener> vetoableListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<SnacPacketListener> packetListeners = new CopyOnWriteArrayList();
    private VetoableFlapPacketListener flapPacketListener = new VetoableFlapPacketListener(){

        public VetoableFlapPacketListener.VetoResult handlePacket(FlapPacketEvent e) {
            if (e.getFlapCommand() instanceof SnacFlapCmd) {
                if (logger.logFinerEnabled()) {
                    logger.logFiner("SnacProcessor intercepted channel-2 snac command");
                }
                AbstractSnacProcessor.this.processPacket(e);
                return VetoableFlapPacketListener.VetoResult.STOP_PROCESSING_LISTENERS;
            }
            return VetoableFlapPacketListener.VetoResult.CONTINUE_PROCESSING;
        }
    };

    protected AbstractSnacProcessor(FlapProcessor flapProcessor) {
        DefensiveTools.checkNull(flapProcessor, "flapProcessor");
        this.flapProcessor = flapProcessor;
        this.attached = true;
        this.setupFlapProcessor();
    }

    private void setupFlapProcessor() {
        this.getFlapProcessor().addVetoablePacketListener(this.flapPacketListener);
    }

    private void resetFlapProcessor() {
        this.getFlapProcessor().removeVetoablePacketListener(this.flapPacketListener);
    }

    protected synchronized void migrate(FlapProcessor processor) {
        DefensiveTools.checkNull(processor, "processor");
        if (!this.attached) {
            throw new IllegalStateException("cannot migrate when no longer attached");
        }
        this.resetFlapProcessor();
        this.flapProcessor = processor;
        this.setupFlapProcessor();
    }

    public final synchronized FlapProcessor getFlapProcessor() {
        return this.flapProcessor;
    }

    public final synchronized boolean isAttached() {
        return this.attached;
    }

    public synchronized void detach() {
        if (!this.attached) {
            return;
        }
        this.resetFlapProcessor();
        this.attached = false;
    }

    public final void addPacketListener(SnacPacketListener l) {
        DefensiveTools.checkNull(l, "l");
        this.packetListeners.addIfAbsent(l);
    }

    public final void removePacketListener(SnacPacketListener l) {
        DefensiveTools.checkNull(l, "l");
        this.packetListeners.remove(l);
    }

    public final void addVetoablePacketListener(VetoableSnacPacketListener l) {
        DefensiveTools.checkNull(l, "l");
        this.vetoableListeners.addIfAbsent(l);
    }

    public final void removeVetoablePacketListener(VetoableSnacPacketListener l) {
        DefensiveTools.checkNull(l, "l");
        this.vetoableListeners.remove(l);
    }

    public final void addPreprocessor(SnacPreprocessor p) {
        DefensiveTools.checkNull(p, "p");
        this.preprocessors.addIfAbsent(p);
    }

    public final void removePreprocessor(SnacPreprocessor p) {
        DefensiveTools.checkNull(p, "p");
        this.preprocessors.remove(p);
    }

    public final CmdFactoryMgr getCmdFactoryMgr() {
        return this.factories;
    }

    protected boolean continueHandling(SnacPacketEvent event) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPacket(FlapPacketEvent e) {
        FlapProcessor processor;
        boolean logFine = logger.logFineEnabled();
        boolean logFiner = logger.logFinerEnabled();
        AbstractSnacProcessor abstractSnacProcessor = this;
        synchronized (abstractSnacProcessor) {
            if (!this.attached) {
                return;
            }
            processor = this.flapProcessor;
        }
        SnacFlapCmd flapCmd = (SnacFlapCmd)e.getFlapCommand();
        SnacPacket snacPacket = flapCmd.getSnacPacket();
        Object object = this.readLock;
        synchronized (object) {
            SnacPacketEvent event;
            MutableSnacPacket mutablePacket = null;
            for (SnacPreprocessor preprocessor : this.preprocessors) {
                if (mutablePacket == null) {
                    mutablePacket = new MutableSnacPacket(snacPacket);
                }
                if (logFiner) {
                    logger.logFiner("Running snac preprocessor " + preprocessor);
                }
                try {
                    preprocessor.process(mutablePacket);
                }
                catch (Throwable t) {
                    if (logFiner) {
                        logger.logFiner("Preprocessor " + preprocessor + " threw exception " + t);
                    }
                    processor.handleException(ERRTYPE_SNAC_PACKET_PREPROCESSOR, t, preprocessor);
                }
            }
            if (mutablePacket != null && mutablePacket.isChanged()) {
                snacPacket = mutablePacket.toSnacPacket();
            }
            SnacCommand cmd = this.factories.generateSnacCommand(snacPacket);
            if (logFine) {
                logger.logFine("Converted Snac packet " + snacPacket + " to " + cmd);
            }
            if (!this.continueHandling(event = new SnacPacketEvent(e, this, snacPacket, cmd))) {
                return;
            }
            for (VetoableSnacPacketListener vetoableSnacPacketListener : this.vetoableListeners) {
                Object result;
                if (logFiner) {
                    logger.logFiner("Running vetoable Snac packet listener " + vetoableSnacPacketListener);
                }
                try {
                    result = vetoableSnacPacketListener.handlePacket(event);
                }
                catch (Throwable t) {
                    processor.handleException(ERRTYPE_SNAC_PACKET_LISTENER, t, vetoableSnacPacketListener);
                    continue;
                }
                if (result == VetoableSnacPacketListener.CONTINUE_PROCESSING) continue;
                return;
            }
            for (SnacPacketListener snacPacketListener : this.packetListeners) {
                if (logFiner) {
                    logger.logFiner("Running Snac packet listener " + snacPacketListener);
                }
                try {
                    snacPacketListener.handleSnacPacket(event);
                }
                catch (Throwable t) {
                    processor.handleException(ERRTYPE_SNAC_PACKET_LISTENER, t, snacPacketListener);
                }
            }
            if (logFiner) {
                logger.logFiner("Finished processing Snac");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void sendSnac(long reqid, SnacCommand cmd) {
        FlapProcessor flapProcessor;
        AbstractSnacProcessor abstractSnacProcessor = this;
        synchronized (abstractSnacProcessor) {
            if (!this.attached) {
                return;
            }
            flapProcessor = this.getFlapProcessor();
        }
        flapProcessor.sendFlap(new SnacFlapCmd(reqid, cmd));
    }
}

