/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.icq;

import java.util.Date;
import java.util.EventObject;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import net.java.sip.communicator.impl.protocol.icq.AimStatusEnum;
import net.java.sip.communicator.impl.protocol.icq.ContactIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.MessageIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.OperationSetPersistentPresenceIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.ProtocolProviderServiceIcqImpl;
import net.java.sip.communicator.service.protocol.AbstractOperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.MessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.MessageReceivedEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.service.protocol.icqconstants.IcqStatusEnum;
import net.java.sip.communicator.util.Logger;
import net.kano.joscar.OscarTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.snac.SnacRequest;
import net.kano.joscar.snac.SnacRequestAdapter;
import net.kano.joscar.snac.SnacResponseEvent;
import net.kano.joscar.snaccmd.error.SnacError;
import net.kano.joscar.snaccmd.icq.OfflineMsgDoneCmd;
import net.kano.joscar.snaccmd.icq.OfflineMsgIcqAckCmd;
import net.kano.joscar.snaccmd.icq.OfflineMsgIcqCmd;
import net.kano.joscar.snaccmd.icq.OfflineMsgIcqRequest;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.oscar.service.icbm.Conversation;
import net.kano.joustsim.oscar.oscar.service.icbm.ConversationEventInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.IcbmBuddyInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.IcbmListener;
import net.kano.joustsim.oscar.oscar.service.icbm.IcbmService;
import net.kano.joustsim.oscar.oscar.service.icbm.ImConversation;
import net.kano.joustsim.oscar.oscar.service.icbm.ImConversationListener;
import net.kano.joustsim.oscar.oscar.service.icbm.Message;
import net.kano.joustsim.oscar.oscar.service.icbm.MessageInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.MissedImInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.SimpleMessage;
import net.kano.joustsim.oscar.oscar.service.icbm.TypingInfo;

public class OperationSetBasicInstantMessagingIcqImpl
extends AbstractOperationSetBasicInstantMessaging {
    private static final Logger logger = Logger.getLogger(OperationSetBasicInstantMessagingIcqImpl.class);
    private ProtocolProviderServiceIcqImpl icqProvider = null;
    private RegistrationStateListener providerRegListener = new RegistrationStateListener();
    private JoustSimIcbmListener joustSimIcbmListener = new JoustSimIcbmListener();
    private JoustSimConversationListener joustSimConversationListener = new JoustSimConversationListener();
    private OperationSetPersistentPresenceIcqImpl opSetPersPresence = null;
    private static final int MAX_MSG_LEN = 2047;
    private static final long KEEPALIVE_INTERVAL = 180000L;
    private static final long KEEPALIVE_WAIT = 20000L;
    private static final String HTML_START_TAG = "<HTML><BODY>";
    private static final String HTML_END_TAG = "</BODY></HTML>";
    private KeepAliveSendTask keepAliveSendTask = null;
    private Timer keepAliveTimer = null;
    private final LinkedList<String> receivedKeepAlivePackets = new LinkedList();
    private static String SYS_MSG_PREFIX_TEST = "SIP COMMUNICATOR SYSTEM MESSAGE!";
    private static int offlineMessageRequestID = 0;

    OperationSetBasicInstantMessagingIcqImpl(ProtocolProviderServiceIcqImpl icqProvider) {
        this.icqProvider = icqProvider;
        icqProvider.addRegistrationStateChangeListener(this.providerRegListener);
    }

    public net.java.sip.communicator.service.protocol.Message createMessage(String content, String contentType, String encoding, String subject) {
        return new MessageIcqImpl(content, contentType, encoding, subject);
    }

    public void sendInstantMessage(Contact to, net.java.sip.communicator.service.protocol.Message message) throws IllegalStateException, IllegalArgumentException {
        this.assertConnected();
        if (!(to instanceof ContactIcqImpl)) {
            throw new IllegalArgumentException("The specified contact is not a Icq contact." + to);
        }
        ImConversation imConversation = this.icqProvider.getAimConnection().getIcbmService().getImConversation(new Screenname(to.getAddress()));
        String messageContent = message.getContentType().equals("text/html") && !message.getContent().startsWith(HTML_START_TAG) ? HTML_START_TAG + message.getContent() + HTML_END_TAG : message.getContent();
        MessageDeliveredEvent msgDeliveryPendingEvt = new MessageDeliveredEvent(message, to);
        MessageDeliveredEvent[] msgDeliveryPendingEvts = this.messageDeliveryPendingTransform(msgDeliveryPendingEvt);
        if (msgDeliveryPendingEvts == null || msgDeliveryPendingEvts.length == 0) {
            return;
        }
        for (MessageDeliveredEvent pendingEvt : msgDeliveryPendingEvts) {
            String transformedContent = pendingEvt.getSourceMessage().getContent();
            if (to.getPresenceStatus().isOnline()) {
                imConversation.sendMessage(new SimpleMessage(transformedContent));
            } else {
                imConversation.sendMessage(new SimpleMessage(transformedContent), true);
            }
            MessageDeliveredEvent msgDeliveredEvt = new MessageDeliveredEvent(message, to);
            if (msgDeliveredEvt == null) continue;
            this.fireMessageEvent((EventObject)msgDeliveredEvt);
        }
    }

    private void retreiveOfflineMessages() {
        int requestID = offlineMessageRequestID++;
        OfflineMsgIcqRequest offlineMsgsReq = new OfflineMsgIcqRequest(Long.parseLong(this.icqProvider.getAimSession().getScreenname().getNormal()), requestID);
        OfflineMessagesRetriever responseRetriever = new OfflineMessagesRetriever(requestID);
        SnacRequest snReq = new SnacRequest(offlineMsgsReq, responseRetriever);
        this.icqProvider.getAimConnection().getInfoService().getOscarConnection().sendSnacRequest(snReq);
    }

    private void assertConnected() throws IllegalStateException {
        if (this.icqProvider == null) {
            throw new IllegalStateException("The icq provider must be non-null and signed on the ICQ service before being able to communicate.");
        }
        if (!this.icqProvider.isRegistered()) {
            throw new IllegalStateException("The icq provider must be signed on the ICQ service before being able to communicate.");
        }
    }

    public boolean isOfflineMessagingSupported() {
        return this.icqProvider.USING_ICQ;
    }

    public boolean isContentTypeSupported(String contentType) {
        return contentType.equals("text/plain") || contentType.equals("text/html");
    }

    private class KeepAliveCheckTask
    extends TimerTask {
        private KeepAliveCheckTask() {
        }

        @Override
        public void run() {
            try {
                while (!this.checkFirstPacket()) {
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Exception occurred while retrieving keep alive packet.", (Throwable)ex);
                this.fireUnregistered();
            }
        }

        boolean checkFirstPacket() throws Exception {
            String receivedStr = (String)OperationSetBasicInstantMessagingIcqImpl.this.receivedKeepAlivePackets.removeLast();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Last keep alive message is: " + receivedStr));
            }
            receivedStr = receivedStr.replaceAll(SYS_MSG_PREFIX_TEST, "");
            String[] ss = receivedStr.split("&");
            String provHashStr = ss[0].split(":")[1];
            String opsetHashStr = ss[1].split(":")[1];
            return ((Object)((Object)OperationSetBasicInstantMessagingIcqImpl.this.icqProvider)).hashCode() == Integer.parseInt(provHashStr) && ((Object)((Object)OperationSetBasicInstantMessagingIcqImpl.this)).hashCode() == Integer.parseInt(opsetHashStr);
        }

        private void fireUnregistered() {
            OperationSetBasicInstantMessagingIcqImpl.this.icqProvider.fireRegistrationStateChanged(OperationSetBasicInstantMessagingIcqImpl.this.icqProvider.getRegistrationState(), RegistrationState.CONNECTION_FAILED, 6, "Did not receive last keep alive packet.");
            if (((OperationSetBasicInstantMessagingIcqImpl)OperationSetBasicInstantMessagingIcqImpl.this).icqProvider.USING_ICQ) {
                OperationSetBasicInstantMessagingIcqImpl.this.opSetPersPresence.fireProviderPresenceStatusChangeEvent(OperationSetBasicInstantMessagingIcqImpl.this.opSetPersPresence.getPresenceStatus().getStatus(), IcqStatusEnum.OFFLINE.getStatus());
            } else {
                OperationSetBasicInstantMessagingIcqImpl.this.opSetPersPresence.fireProviderPresenceStatusChangeEvent(OperationSetBasicInstantMessagingIcqImpl.this.opSetPersPresence.getPresenceStatus().getStatus(), AimStatusEnum.OFFLINE.getStatus());
            }
        }
    }

    private class KeepAliveSendTask
    extends TimerTask {
        private KeepAliveSendTask() {
        }

        @Override
        public void run() {
            try {
                if (!OperationSetBasicInstantMessagingIcqImpl.this.icqProvider.isRegistered()) {
                    return;
                }
                StringBuffer sysMsg = new StringBuffer(SYS_MSG_PREFIX_TEST);
                sysMsg.append("pp:").append(((Object)((Object)OperationSetBasicInstantMessagingIcqImpl.this.icqProvider)).hashCode()).append("&op:").append(((Object)((Object)OperationSetBasicInstantMessagingIcqImpl.this)).hashCode());
                ImConversation imConversation = OperationSetBasicInstantMessagingIcqImpl.this.icqProvider.getAimConnection().getIcbmService().getImConversation(new Screenname(OperationSetBasicInstantMessagingIcqImpl.this.icqProvider.getAccountID().getUserID()));
                OperationSetBasicInstantMessagingIcqImpl.this.keepAliveTimer.schedule((TimerTask)new KeepAliveCheckTask(), 20000L);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"send keepalive");
                }
                imConversation.sendMessage(new SimpleMessage(sysMsg.toString()));
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to start keep alive task.", (Throwable)ex);
            }
        }
    }

    private class JoustSimConversationListener
    implements ImConversationListener {
        private JoustSimConversationListener() {
        }

        @Override
        public void gotMessage(Conversation conversation, MessageInfo minfo) {
            String msgContentType;
            String msgContent;
            String msgBody = minfo.getMessage().getMessageBody();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Received from " + conversation.getBuddy() + " the message " + msgBody));
            }
            if (msgBody.startsWith(SYS_MSG_PREFIX_TEST) && conversation.getBuddy().getFormatted().equals(OperationSetBasicInstantMessagingIcqImpl.this.icqProvider.getAccountID().getUserID())) {
                OperationSetBasicInstantMessagingIcqImpl.this.receivedKeepAlivePackets.addLast(msgBody);
                return;
            }
            if (msgBody.startsWith(OperationSetBasicInstantMessagingIcqImpl.HTML_START_TAG)) {
                msgContent = msgBody.substring(msgBody.indexOf(OperationSetBasicInstantMessagingIcqImpl.HTML_START_TAG) + OperationSetBasicInstantMessagingIcqImpl.HTML_START_TAG.length(), msgBody.indexOf(OperationSetBasicInstantMessagingIcqImpl.HTML_END_TAG));
                msgContentType = "text/html";
            } else {
                msgContent = msgBody;
                msgContentType = "text/plain";
            }
            net.java.sip.communicator.service.protocol.Message newMessage = OperationSetBasicInstantMessagingIcqImpl.this.createMessage(msgContent, msgContentType, "UTF-8", null);
            Object sourceContact = OperationSetBasicInstantMessagingIcqImpl.this.opSetPersPresence.findContactByID(conversation.getBuddy().getFormatted());
            if (sourceContact == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("received a message from a unknown contact: " + conversation.getBuddy()));
                }
                sourceContact = OperationSetBasicInstantMessagingIcqImpl.this.opSetPersPresence.createVolatileContact(conversation.getBuddy().getFormatted());
            }
            Date current = new Date();
            Date msgDate = minfo.getTimestamp();
            GregorianCalendar tomorrow = new GregorianCalendar();
            tomorrow.setTime(current);
            tomorrow.set(5, tomorrow.get(5) + 1);
            if (tomorrow.after(msgDate)) {
                msgDate = current;
            }
            MessageReceivedEvent msgReceivedEvt = new MessageReceivedEvent(newMessage, sourceContact, msgDate);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("fire msg received for : " + newMessage));
            }
            OperationSetBasicInstantMessagingIcqImpl.this.fireMessageEvent((EventObject)msgReceivedEvt);
        }

        @Override
        public void sentOtherEvent(Conversation conversation, ConversationEventInfo event) {
        }

        @Override
        public void canSendMessageChanged(Conversation conv, boolean canSend) {
        }

        @Override
        public void conversationClosed(Conversation conv) {
        }

        @Override
        public void conversationOpened(Conversation conv) {
        }

        @Override
        public void gotOtherEvent(Conversation conversation, ConversationEventInfo event) {
        }

        @Override
        public void sentMessage(Conversation conv, MessageInfo minfo) {
        }

        @Override
        public void missedMessages(ImConversation conv, MissedImInfo info) {
        }

        @Override
        public void gotTypingState(Conversation conversation, TypingInfo typingInfo) {
        }
    }

    private class JoustSimIcbmListener
    implements IcbmListener {
        private JoustSimIcbmListener() {
        }

        @Override
        public void newConversation(IcbmService service, Conversation conv) {
            conv.addConversationListener(OperationSetBasicInstantMessagingIcqImpl.this.joustSimConversationListener);
        }

        @Override
        public void buddyInfoUpdated(IcbmService service, Screenname buddy, IcbmBuddyInfo info) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("buddy info pudated for " + buddy + " new info is: " + info));
            }
        }

        @Override
        public void sendAutomaticallyFailed(IcbmService service, Message message, Set<Conversation> triedConversations) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("sendAutomaticallyFailed message : " + message));
            }
        }
    }

    private class RegistrationStateListener
    implements RegistrationStateChangeListener {
        private RegistrationStateListener() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The ICQ provider changed state from: " + evt.getOldState() + " to: " + evt.getNewState()));
            }
            if (evt.getNewState() == RegistrationState.FINALIZING_REGISTRATION) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"adding a Bos Service Listener");
                }
                OperationSetBasicInstantMessagingIcqImpl.this.icqProvider.getAimConnection().getIcbmService().addIcbmListener(OperationSetBasicInstantMessagingIcqImpl.this.joustSimIcbmListener);
                OperationSetBasicInstantMessagingIcqImpl.this.opSetPersPresence = (OperationSetPersistentPresenceIcqImpl)OperationSetBasicInstantMessagingIcqImpl.this.icqProvider.getOperationSet(OperationSetPersistentPresence.class);
                return;
            } else {
                if (evt.getNewState() == RegistrationState.REGISTERED) {
                    if (((OperationSetBasicInstantMessagingIcqImpl)OperationSetBasicInstantMessagingIcqImpl.this).icqProvider.USING_ICQ) {
                        OperationSetBasicInstantMessagingIcqImpl.this.retreiveOfflineMessages();
                    }
                    String customMessageEncoding = null;
                    customMessageEncoding = System.getProperty("icq.custom.message.charset");
                    if (customMessageEncoding != null) {
                        OscarTools.setDefaultCharset(customMessageEncoding);
                    }
                    if (OperationSetBasicInstantMessagingIcqImpl.this.keepAliveSendTask != null) return;
                }
                if (evt.getNewState() != RegistrationState.UNREGISTERED || OperationSetBasicInstantMessagingIcqImpl.this.keepAliveSendTask == null) return;
                OperationSetBasicInstantMessagingIcqImpl.this.keepAliveSendTask.cancel();
                OperationSetBasicInstantMessagingIcqImpl.this.keepAliveTimer.cancel();
                OperationSetBasicInstantMessagingIcqImpl.this.keepAliveSendTask = null;
                OperationSetBasicInstantMessagingIcqImpl.this.keepAliveTimer = null;
            }
        }
    }

    private class OfflineMessagesRetriever
    extends SnacRequestAdapter {
        private int requestID;

        public OfflineMessagesRetriever(int requestID) {
            this.requestID = requestID;
        }

        @Override
        public void handleResponse(SnacResponseEvent evt) {
            SnacCommand snac = evt.getSnacCommand();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Received a response to our offline message request: " + snac));
            }
            if (snac instanceof OfflineMsgIcqCmd) {
                MessageReceivedEvent msgReceivedEvt;
                OfflineMsgIcqCmd offlineMsgCmd = (OfflineMsgIcqCmd)snac;
                String contactUIN = String.valueOf(offlineMsgCmd.getFromUIN());
                Object sourceContact = OperationSetBasicInstantMessagingIcqImpl.this.opSetPersPresence.findContactByID(contactUIN);
                if (sourceContact == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("received a message from a unknown contact: " + contactUIN));
                    }
                    sourceContact = OperationSetBasicInstantMessagingIcqImpl.this.opSetPersPresence.createVolatileContact(contactUIN);
                }
                Date current = new Date();
                Date msgDate = offlineMsgCmd.getDate();
                GregorianCalendar tomorrow = new GregorianCalendar();
                tomorrow.setTime(current);
                tomorrow.set(5, tomorrow.get(5) + 1);
                if (tomorrow.after(msgDate)) {
                    msgDate = current;
                }
                if ((msgReceivedEvt = new MessageReceivedEvent(OperationSetBasicInstantMessagingIcqImpl.this.createMessage(offlineMsgCmd.getContents()), sourceContact, msgDate)) != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("fire msg received for : " + offlineMsgCmd.getContents()));
                    }
                    OperationSetBasicInstantMessagingIcqImpl.this.fireMessageEvent((EventObject)msgReceivedEvt);
                }
            } else if (snac instanceof OfflineMsgDoneCmd) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"send ack to delete offline messages");
                }
                OfflineMsgIcqAckCmd offlineMsgDeleteReq = new OfflineMsgIcqAckCmd(Long.parseLong(OperationSetBasicInstantMessagingIcqImpl.this.icqProvider.getAimSession().getScreenname().getNormal()), this.requestID);
                OperationSetBasicInstantMessagingIcqImpl.this.icqProvider.getAimConnection().getInfoService().getOscarConnection().sendSnac(offlineMsgDeleteReq);
            } else if (snac instanceof SnacError && logger.isDebugEnabled()) {
                logger.debug((Object)"error receiving offline messages");
            }
        }
    }
}

