/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.customcontrols;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;

public class TitlePanel
extends TransparentPanel {
    private static final long serialVersionUID = 1L;
    private final JLabel titleLabel = new JLabel();
    private final Color gradientStartColor = new Color(255, 255, 255, 200);
    private final Color gradientEndColor = new Color(255, 255, 255, 50);

    public TitlePanel() {
        this(null);
    }

    public TitlePanel(String title) {
        super((LayoutManager)new FlowLayout(1));
        Font font = this.getFont();
        this.titleLabel.setFont(font.deriveFont(1, font.getSize() + 2));
        if (title != null) {
            this.setTitleText(title);
        } else {
            this.setPreferredSize(new Dimension(0, 30));
        }
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        AntialiasingManager.activateAntialiasing((Graphics)g2);
        int width = this.getWidth();
        int height = this.getHeight();
        GradientPaint p = new GradientPaint(width / 2, 0.0f, this.gradientStartColor, width / 2, height, this.gradientEndColor);
        g2.setPaint(p);
        g2.fillRoundRect(0, 0, width, height, 10, 10);
        super.paintComponent((Graphics)g2);
    }

    public void setTitleText(String title) {
        this.removeAll();
        this.titleLabel.setText(title);
        this.add(this.titleLabel);
    }
}

