/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import javax.sip.SipProvider;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.SipRegistrarConnection;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.RegistrationState;

public class SipRegistrarlessConnection
extends SipRegistrarConnection {
    private ProtocolProviderServiceSipImpl sipProvider = null;
    private String defaultTransport = null;
    private RegistrationState currentRegistrationState = RegistrationState.UNREGISTERED;

    public SipRegistrarlessConnection(ProtocolProviderServiceSipImpl sipProviderCallback, String defaultTransport) {
        this.sipProvider = sipProviderCallback;
        this.defaultTransport = defaultTransport;
    }

    @Override
    void register() throws OperationFailedException {
        this.setRegistrationState(RegistrationState.REGISTERED, 0, null);
    }

    @Override
    public void unregister() throws OperationFailedException {
        this.setRegistrationState(RegistrationState.UNREGISTERING, 0, "");
        this.setRegistrationState(RegistrationState.UNREGISTERED, 0, null);
    }

    @Override
    public RegistrationState getRegistrationState() {
        return this.currentRegistrationState;
    }

    @Override
    public void setRegistrationState(RegistrationState newState, int reasonCode, String reason) {
        if (this.currentRegistrationState.equals((Object)newState)) {
            return;
        }
        RegistrationState oldState = this.currentRegistrationState;
        this.currentRegistrationState = newState;
        this.sipProvider.fireRegistrationStateChanged(oldState, newState, reasonCode, reason);
    }

    @Override
    public SipProvider getJainSipProvider() {
        return this.sipProvider.getJainSipProvider(this.getTransport());
    }

    @Override
    public String getTransport() {
        return this.defaultTransport;
    }

    @Override
    public String toString() {
        String className = this.getClass().getName();
        try {
            className = className.substring(className.lastIndexOf(46) + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return className + "-[dn=" + this.sipProvider.getOurDisplayName() + " addr=" + this.sipProvider.getAccountID().getUserID() + "]";
    }

    @Override
    public boolean isRegistrarless() {
        return true;
    }
}

