/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import gov.nist.core.net.AddressResolver;
import gov.nist.javax.sip.stack.HopImpl;
import gov.nist.javax.sip.stack.MessageProcessor;
import java.net.InetSocketAddress;
import javax.sip.address.Hop;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.NetworkUtils;
import net.java.sip.communicator.util.SRVRecord;

public class AddressResolverImpl
implements AddressResolver {
    private static final Logger logger = Logger.getLogger(AddressResolverImpl.class);

    public Hop resolveAddress(Hop inputAddress) {
        Hop returnHop;
        block14: {
            try {
                String transport = inputAddress.getTransport();
                String hostAddress = inputAddress.getHost();
                if (transport == null) {
                    transport = "UDP";
                }
                String host = null;
                int port = 0;
                if (NetworkUtils.isValidIPAddress((String)hostAddress)) {
                    InetSocketAddress hostSocketAddress = new InetSocketAddress(NetworkUtils.getInetAddress((String)hostAddress), inputAddress.getPort());
                    return new HopImpl(hostSocketAddress.getHostName(), inputAddress.getPort(), transport);
                }
                if (transport.equalsIgnoreCase("TLS")) {
                    SRVRecord srvRecord = NetworkUtils.getSRVRecord((String)"sips", (String)"TCP", (String)hostAddress);
                    if (srvRecord != null) {
                        host = srvRecord.getTarget();
                        port = srvRecord.getPort();
                    }
                } else {
                    SRVRecord srvRecord = NetworkUtils.getSRVRecord((String)"sip", (String)transport, (String)hostAddress);
                    if (srvRecord != null) {
                        host = srvRecord.getTarget();
                        port = srvRecord.getPort();
                    }
                }
                if (host != null) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Returning hop as follows host= " + host + " port= " + port + " transport= " + transport));
                    }
                    return new HopImpl(host, port, transport);
                }
            }
            catch (Exception ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Domain " + inputAddress + " could not be resolved " + ex.getMessage()));
                }
                if (!logger.isTraceEnabled()) break block14;
                logger.trace((Object)"Printing SRV resolution stack trace", (Throwable)ex);
            }
        }
        if (inputAddress.getPort() != -1) {
            returnHop = inputAddress;
        } else {
            String transport = inputAddress.getTransport();
            returnHop = new HopImpl(inputAddress.getHost(), MessageProcessor.getDefaultPort((String)transport), transport);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning hop: " + returnHop));
        }
        return returnHop;
    }
}

