/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.Component;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JFileChooser;
import net.java.sip.communicator.plugin.desktoputil.SipCommFileChooser;
import net.java.sip.communicator.plugin.desktoputil.SipCommFileFilter;

public class SipCommFileChooserImpl
extends JFileChooser
implements SipCommFileChooser {
    private static final long serialVersionUID = 0L;
    private Component parent;

    public SipCommFileChooserImpl(String title, int operation) {
        this.setDialogTitle(title);
        this.setDialogType(operation);
    }

    public SipCommFileChooserImpl(Component parent, String path, String title, int operation) {
        this(title, operation);
        this.parent = parent;
        this.setStartPath(path);
    }

    @Override
    public File getApprovedFile() {
        return this.getSelectedFile();
    }

    @Override
    public void setStartPath(String path) {
        if (path == null) {
            return;
        }
        try {
            URL url = new URL(path);
            path = url.getPath();
        }
        catch (MalformedURLException url) {
            // empty catch block
        }
        File file = new File(path);
        this.setCurrentDirectory(file);
        if (file != null && !file.isDirectory()) {
            this.setSelectedFile(file);
        } else {
            this.setSelectedFile(null);
        }
    }

    @Override
    public File getFileFromDialog() {
        int choice = -1;
        choice = this.getDialogType() == 0 ? this.showOpenDialog(this.getParentComponent()) : this.showSaveDialog(this.getParentComponent());
        return choice == 0 ? this.getSelectedFile() : null;
    }

    public Component getParentComponent() {
        return this.parent;
    }

    @Override
    public void addFilter(SipCommFileFilter filter) {
        this.addChoosableFileFilter(filter);
    }

    @Override
    public void setFileFilter(SipCommFileFilter filter) {
        super.setFileFilter(filter);
    }

    @Override
    public SipCommFileFilter getUsedFilter() {
        return (SipCommFileFilter)this.getFileFilter();
    }

    @Override
    public void setSelectionMode(int mode) {
        super.setFileSelectionMode(mode);
    }
}

